/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3.kanji;

import com.nolanlawson.japanesenamegenerator.v3.kanji.KanjiResult;
import com.nolanlawson.japanesenamegenerator.v3.kanji.RegexRoomajiTransformer;
import com.nolanlawson.japanesenamegenerator.v3.kanji.ReplacementRoomajiTransformer;
import com.nolanlawson.japanesenamegenerator.v3.kanji.RoomajiTransformer;
import com.nolanlawson.japanesenamegenerator.v3.kanji.SubstringNode;
import com.nolanlawson.japanesenamegenerator.v3.util.StringUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KanjiGenerator {
    private static Pattern letterPattern = Pattern.compile("[a-zA-Z]");
    private Map<String, List<String>> roomajiToKanjiMap;
    private Map<String, List<String>> kanjiToEnglishMap;
    private static List<RoomajiTransformer> allRoomajiTransformers = KanjiGenerator.getRoomajiTransformers();

    public KanjiGenerator(InputStream kanjiDictionaryFileInputStream) {
        this.readInDictionary(kanjiDictionaryFileInputStream);
    }

    public List<List<KanjiResult>> generateKanji(String roomaji) {
        roomaji = roomaji.trim().toLowerCase();
        roomaji = this.normalizeRoomaji(roomaji);
        String[] tokens = StringUtil.quickSplit(roomaji, " ");
        ArrayList<KanjiResult> result = new ArrayList<KanjiResult>();
        for (String token : tokens) {
            List<KanjiResult> subResult = this.findExactMatchKanjiSequenceForToken(token);
            result.addAll(subResult);
        }
        return this.expandKanjiResults(result);
    }

    private void cleanKanjiResults(List<KanjiResult> kanjiResults) {
        for (int i = 1; i < kanjiResults.size(); ++i) {
            KanjiResult kanjiResult = kanjiResults.get(i);
            String roomaji = kanjiResult.getRoomaji();
            if (roomaji.length() != 1 || !StringUtil.isVowel(roomaji.charAt(0)) || !kanjiResults.get(i - 1).getRoomaji().endsWith(roomaji)) continue;
            kanjiResults.remove(i);
            --i;
        }
    }

    private List<List<KanjiResult>> expandKanjiResults(List<KanjiResult> kanjiResults) {
        ArrayList<List<KanjiResult>> expandedKanjiResultLists = new ArrayList<List<KanjiResult>>();
        for (KanjiResult kanjiResult : kanjiResults) {
            ArrayList<KanjiResult> expandedResults = new ArrayList<KanjiResult>();
            for (String kanji : this.roomajiToKanjiMap.get(kanjiResult.getRoomaji())) {
                String english = this.kanjiToEnglishMap.get(kanji).get(0);
                KanjiResult newResult = new KanjiResult();
                newResult.setKanji(kanji);
                newResult.setRoomaji(kanjiResult.getRoomaji());
                newResult.setEnglish(english);
                expandedResults.add(newResult);
            }
            expandedKanjiResultLists.add(expandedResults);
        }
        return expandedKanjiResultLists;
    }

    private List<KanjiResult> findExactMatchKanjiSequenceForToken(String roomaji) {
        List<KanjiResult> result = this.findExactMatchKanjiSequences(roomaji);
        if (result == null) {
            List<RoomajiTransformer> transformers = this.getPossibleTransformers(roomaji);
            for (int i = 0; i < transformers.size() && result == null; ++i) {
                RoomajiTransformer transformer = transformers.get(i);
                roomaji = transformer.apply(roomaji);
                result = this.findExactMatchKanjiSequences(roomaji);
            }
        }
        if (result == null) {
            return Collections.emptyList();
        }
        this.cleanKanjiResults(result);
        return result;
    }

    private List<KanjiResult> findExactMatchKanjiSequences(String roomaji) {
        List<List<String>> substringSequences = this.findExactMatchSubstringSequences(roomaji);
        Iterator<List<String>> i$ = substringSequences.iterator();
        if (i$.hasNext()) {
            List<String> substringSequence = i$.next();
            ArrayList<KanjiResult> kanjiAndEnglishStrings = new ArrayList<KanjiResult>();
            for (String substring : substringSequence) {
                String kanji = this.roomajiToKanjiMap.get(substring).get(0);
                String english = this.kanjiToEnglishMap.get(kanji).get(0);
                KanjiResult kanjiResult = new KanjiResult();
                kanjiResult.setKanji(kanji);
                kanjiResult.setEnglish(english);
                kanjiResult.setRoomaji(substring);
                kanjiAndEnglishStrings.add(kanjiResult);
            }
            return kanjiAndEnglishStrings;
        }
        return null;
    }

    private List<List<String>> findExactMatchSubstringSequences(String roomaji) {
        int i;
        ArrayList substringSequences = new ArrayList();
        substringSequences.add(new ArrayList());
        int limit = Math.min(4, roomaji.length());
        for (i = 1; i <= limit; ++i) {
            String substring = roomaji.substring(0, i);
            if (!this.roomajiToKanjiMap.containsKey(substring)) continue;
            SubstringNode substringNode = new SubstringNode();
            substringNode.setStr(substring);
            substringNode.setStartIndex(0);
            substringNode.setEndIndex(i);
            ((List)substringSequences.get(0)).add(substringNode);
        }
        if (((List)substringSequences.get(0)).isEmpty()) {
            return Collections.emptyList();
        }
        i = 1;
        while (true) {
            ArrayList<SubstringNode> currentSubtringNodes = new ArrayList<SubstringNode>();
            for (SubstringNode previousSubstringNode : (List)substringSequences.get(i - 1)) {
                int previousEndIndex = previousSubstringNode.getEndIndex();
                int maxEndIndex = Math.min(previousEndIndex + 4, roomaji.length());
                for (int j = previousEndIndex + 1; j <= maxEndIndex; ++j) {
                    String substring = roomaji.substring(previousEndIndex, j);
                    if (!this.roomajiToKanjiMap.containsKey(substring)) continue;
                    SubstringNode substringNode = new SubstringNode();
                    substringNode.setPrevious(previousSubstringNode);
                    substringNode.setStr(substring);
                    substringNode.setStartIndex(previousEndIndex);
                    substringNode.setEndIndex(j);
                    currentSubtringNodes.add(substringNode);
                }
            }
            if (currentSubtringNodes.isEmpty()) break;
            substringSequences.add(currentSubtringNodes);
            ++i;
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (List list : substringSequences) {
            for (SubstringNode finalSubstringNode : list) {
                if (finalSubstringNode.getEndIndex() != roomaji.length()) continue;
                ArrayList<String> substringSequenceAsStringList = new ArrayList<String>();
                for (SubstringNode currentSubstringNode = finalSubstringNode; currentSubstringNode != null; currentSubstringNode = currentSubstringNode.getPrevious()) {
                    substringSequenceAsStringList.add(currentSubstringNode.getStr());
                }
                Collections.reverse(substringSequenceAsStringList);
                result.add(substringSequenceAsStringList);
            }
        }
        return result;
    }

    private static List<RoomajiTransformer> getRoomajiTransformers() {
        ArrayList<RoomajiTransformer> result = new ArrayList<RoomajiTransformer>();
        result.add(new ReplacementRoomajiTransformer("ii", "i"));
        result.add(new ReplacementRoomajiTransformer("she", "shi"));
        result.add(new ReplacementRoomajiTransformer("ti", "chi"));
        result.add(new ReplacementRoomajiTransformer("tu", "chu"));
        result.add(new ReplacementRoomajiTransformer("du", "ju"));
        result.add(new ReplacementRoomajiTransformer("di", "ji"));
        result.add(new ReplacementRoomajiTransformer("che", "chi"));
        result.add(new ReplacementRoomajiTransformer("je", "ji"));
        result.add(new ReplacementRoomajiTransformer("we", "ue"));
        result.add(new ReplacementRoomajiTransformer("wi", "ui"));
        result.add(new ReplacementRoomajiTransformer("wo", "o"));
        result.add(new ReplacementRoomajiTransformer("wu", "u"));
        result.add(new ReplacementRoomajiTransformer("ye", "e"));
        result.add(new ReplacementRoomajiTransformer("yi", "i"));
        result.add(new ReplacementRoomajiTransformer("fe", "he"));
        result.add(new ReplacementRoomajiTransformer("fo", "ho"));
        result.add(new ReplacementRoomajiTransformer("fa", "ha"));
        result.add(new ReplacementRoomajiTransformer("fi", "hi"));
        result.add(new ReplacementRoomajiTransformer("'", ""));
        result.add(new ReplacementRoomajiTransformer("p", "b"));
        result.add(new RegexRoomajiTransformer("([^e]|^)e([^en]|$)", "$1ee$2"));
        result.add(new RegexRoomajiTransformer("([^o]|^)o([^on]|$)", "$1oo$2"));
        result.add(new RegexRoomajiTransformer("([^u]|^)u([^un]|$)", "$1uu$2"));
        result.add(new RegexRoomajiTransformer("([^e]|^)e([^e]|$)", "$1ee$2"));
        result.add(new RegexRoomajiTransformer("([^o]|^)o([^o]|$)", "$1oo$2"));
        result.add(new RegexRoomajiTransformer("([^u]|^)u([^u]|$)", "$1uu$2"));
        result.add(new ReplacementRoomajiTransformer("gy", "g"));
        result.add(new ReplacementRoomajiTransformer("ky", "k"));
        result.add(new ReplacementRoomajiTransformer("hy", "h"));
        result.add(new ReplacementRoomajiTransformer("py", "p"));
        result.add(new ReplacementRoomajiTransformer("by", "b"));
        result.add(new ReplacementRoomajiTransformer("my", "m"));
        result.add(new ReplacementRoomajiTransformer("ny", "n"));
        result.add(new ReplacementRoomajiTransformer("ry", "r"));
        result.add(new ReplacementRoomajiTransformer("ky", "k"));
        result.add(new RegexRoomajiTransformer("n([^aeiouy]|$)", "nu$1"));
        return result;
    }

    private String normalizeRoomaji(String roomaji) {
        roomaji = StringUtil.quickReplace(roomaji, "cc", "'c");
        roomaji = StringUtil.quickReplace(roomaji, "kk", "'k");
        roomaji = StringUtil.quickReplace(roomaji, "pp", "'p");
        roomaji = StringUtil.quickReplace(roomaji, "ss", "'s");
        roomaji = StringUtil.quickReplace(roomaji, "tt", "'t");
        roomaji = StringUtil.quickReplace(roomaji, "dd", "'d");
        roomaji = StringUtil.quickReplace(roomaji, "bb", "'b");
        return roomaji;
    }

    private void readInDictionary(InputStream kanjiDictionaryFileInputStream) {
        this.roomajiToKanjiMap = new HashMap<String, List<String>>();
        this.kanjiToEnglishMap = new HashMap<String, List<String>>();
        try {
            BufferedReader buff = new BufferedReader(new InputStreamReader(kanjiDictionaryFileInputStream, "UTF-8"));
            if (buff.ready()) {
                buff.readLine();
            }
            while (buff.ready()) {
                String line = buff.readLine();
                String[] splitLine = StringUtil.quickSplit(line, "\t");
                if (splitLine.length < 3 || splitLine[2].length() == 0) continue;
                String kanji = splitLine[0];
                String english = splitLine[1];
                String roomaji = splitLine[2];
                kanji = kanji.substring(1, kanji.length() - 1);
                english = english.substring(1, english.length() - 1);
                roomaji = roomaji.substring(1, roomaji.length() - 1);
                String[] englishStrings = StringUtil.quickSplit(english, ",");
                String[] roomajiStringArray = StringUtil.quickSplit(roomaji, ",");
                HashSet<String> roomajiStrings = new HashSet<String>();
                for (String roomajiString : roomajiStringArray) {
                    if (!letterPattern.matcher(roomajiString).find()) continue;
                    roomajiString = roomajiString.trim();
                    roomajiStrings.add(roomajiString);
                    if (!roomajiString.endsWith("tsu") || roomajiString.length() <= 3) continue;
                    roomajiStrings.add(StringUtil.quickReplace(roomajiString, "tsu", "'"));
                }
                List<Object> englishStringList = null;
                if (englishStrings.length > 1) {
                    englishStringList = new ArrayList();
                    for (String englishString : englishStrings) {
                        englishStringList.add(englishString.trim());
                    }
                } else if (englishStrings.length == 1) {
                    englishStringList = Collections.singletonList(englishStrings[0].trim());
                }
                this.kanjiToEnglishMap.put(kanji, englishStringList);
                for (String roomajiString : roomajiStrings) {
                    List<String> existingKanjis = this.roomajiToKanjiMap.get(roomajiString);
                    if (existingKanjis == null) {
                        existingKanjis = new ArrayList<String>();
                        this.roomajiToKanjiMap.put(roomajiString, existingKanjis);
                    }
                    existingKanjis.add(kanji);
                }
            }
            buff.close();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to read in file: " + kanjiDictionaryFileInputStream, t);
        }
    }

    private List<RoomajiTransformer> getPossibleTransformers(String roomaji) {
        ArrayList<RoomajiTransformer> result = new ArrayList<RoomajiTransformer>();
        for (RoomajiTransformer roomajiTransformer : allRoomajiTransformers) {
            if (!roomajiTransformer.appliesToString(roomaji)) continue;
            result.add(roomajiTransformer);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("kanji_dictionary.csv");
        KanjiGenerator kg = new KanjiGenerator(inputStream);
        System.out.println(kg.generateKanji("ramoona"));
    }
}

