/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3;

import com.nolanlawson.japanesenamegenerator.v3.ConversionException;
import com.nolanlawson.japanesenamegenerator.v3.JapaneseNameGenerator;
import com.nolanlawson.japanesenamegenerator.v3.data.Model;
import com.nolanlawson.japanesenamegenerator.v3.data.ModelMarshaller;
import com.nolanlawson.japanesenamegenerator.v3.data.XMLModelMarshaller;
import com.nolanlawson.japanesenamegenerator.v3.katakana.KatakanaConverter;
import com.nolanlawson.japanesenamegenerator.v3.util.Pair;
import com.nolanlawson.japanesenamegenerator.v3.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test {
    static Map<String, String> testData = new HashMap<String, String>(){
        {
            this.put("eustice", "yuusutisu");
            this.put("thompson", "tompuson");
            this.put("manning", "maningu");
            this.put("west", "wesuto");
            this.put("thea", "sia");
            this.put("maevis", "meebisu");
            this.put("stacia", "suteishia");
            this.put("hartleben", "haatoreben");
            this.put("lawson", "rooson");
            this.put("larson", "raason");
            this.put("smith", "sumisu");
            this.put("pound", "pondo");
            this.put("damon", "deemon");
            this.put("poolman", "puuruman");
            this.put("beal", "biiru");
            this.put("king", "kingu");
            this.put("potter", "pottaa");
            this.put("bellow", "beroo");
            this.put("melville", "merubiru");
            this.put("parker", "paakaa");
            this.put("walker", "wookaa");
            this.put("pope", "poopu");
            this.put("brubeck", "buruubekku");
            this.put("vorwaller", "boowaraa");
            this.put("lovitz", "robitsu");
            this.put("picard", "pikaado");
            this.put("lambert", "ranbaato");
            this.put("berzins", "baazinzu");
            this.put("hermann", "haaman");
            this.put("meliha", "meriha");
            this.put("anderson", "andaason");
            this.put("boyd", "boido");
            this.put("bardock", "baadokku");
            this.put("johnson", "jonson");
            this.put("clinton", "kurinton");
            this.put("sanders", "sandaazu");
            this.put("hanson", "hanson");
            this.put("bart", "baato");
            this.put("gerald", "jerarudo");
            this.put("perkowitz", "paakowitsu");
            this.put("ferrel", "fereru");
            this.put("butler", "batoraa");
            this.put("maynard", "meenaado");
            this.put("nancy", "nanshii");
            this.put("durup", "durupu");
            this.put("holly", "hoorii");
            this.put("eaton", "iiton");
            this.put("pittman", "pittoman");
        }
    };

    public static void main(String[] args) throws Exception {
        ArrayList<String> filenames = new ArrayList<String>();
        File dirFile = new File("/home/nolan/Desktop/old/models");
        for (File file : dirFile.listFiles()) {
            filenames.add(file.getPath());
        }
        Collections.sort(filenames);
        for (String filename : new String[]{"/home/nolan/Desktop/old/models/roomaji_model_20090128_pop1_3_3_min2_fewer_rules.txt"}) {
            Test.test1(filename);
        }
    }

    private static void testJapaneseNameGenerator() {
        JapaneseNameGenerator japaneseNameGenerator = new JapaneseNameGenerator();
        List<String> names = Arrays.asList("Nolan Lawson", "JT", "J.T. Thompson", "DJ Manning", "Kevin Eustice", "Meliha Yetisgen Yildiz", "Pat Ferrel", "Mike Perkowitz", "Kenji Kawai", "Kanye West", "Thea Lawson", "Maevis Lawson", "Stacia Hartleben", "Shannon Welle", "Will Smith", "Ezra Pound", "Gabriel Damon", "Adam Poolman", "Justin Beal", "Stephen King", "Harry Potter", "Jesus Christ", "Saul Bellow", "D'Angelo Martin", "Gary Davis", "Herman Melville", "Tray Parker", "Matt Brubeck", "Marcus Vorwaller", "Jon Lovitz", "Matt Groening", "Mary Walker", "Kristi Pope", "Jean-Luc Picard", "Jean-Paul Jones", "Hannako Lambert", "Hunter Thompson");
        try {
            for (String name : names) {
                System.out.println(name + " -- > " + japaneseNameGenerator.convertToRomaajiAndKatakana(name));
            }
        }
        catch (ConversionException ex) {
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void test1(String filename) {
        Model model = ModelMarshaller.readFromFile(filename);
        int correct = 0;
        int incorrect = 0;
        int totalEditDistance = 0;
        for (Map.Entry<String, String> entry : testData.entrySet()) {
            String output = model.transformString(entry.getKey());
            totalEditDistance += Util.computeLevenshteinDistance(output, entry.getValue());
            if (output.equals(entry.getValue())) {
                ++correct;
                System.out.println(String.format("%s -> %s", entry.getKey(), output, entry.getValue()));
                continue;
            }
            System.out.println(String.format("%s -> %s (gold: %s)", entry.getKey(), output, entry.getValue()));
            ++incorrect;
        }
        System.out.println("\n" + filename.replaceAll("^.*/", ""));
        System.out.println("Accuracy: " + 1.0 * (double)correct / (double)(correct + incorrect));
        System.out.println("Total edit distance: " + totalEditDistance + "\n");
    }

    private static void test2() {
        Model model = XMLModelMarshaller.readFromXmlSystemResource("romaaji_model_20090118_1.ser");
        KatakanaConverter katakanaConverter = new KatakanaConverter();
        for (String name : Test.getTestData()) {
            try {
                String romaaji = model.transformString(name);
                String katakana = katakanaConverter.convertToKatakana(romaaji);
                System.out.println(name + " --> " + katakana);
            }
            catch (Exception e) {
                System.out.println("couldn't process name: " + name);
                e.printStackTrace();
            }
        }
    }

    private static List<String> getTestData() {
        return Arrays.asList("nolan", "shannon", "bruce", "adam", "raymond", "antoine", "timothy", "thea", "maevis", "bartz", "mozart", "jason", "jared", "jill", "kanye", "yeshiva", "stacia", "lawson", "larson", "larsen", "anderson", "buddy", "kevin", "meliha", "kenji", "cory", "danielle", "daniel");
    }

    private static List<Pair<String, String>> getLargeTrainingData(String dataFilename, int limit) {
        try {
            List<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(dataFilename);
            BufferedReader buff = new BufferedReader(new InputStreamReader(inputStream));
            while (buff.ready()) {
                String line = buff.readLine();
                String[] strPair = line.split("\\s+");
                result.add(Pair.create(strPair[0], strPair[1]));
            }
            if (result.size() > limit) {
                result = result.subList(0, limit);
            }
            return result;
        }
        catch (Throwable t) {
            throw new RuntimeException("failed to read in file", t);
        }
    }
}

