/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3;

import com.nolanlawson.japanesenamegenerator.v3.ConversionException;
import com.nolanlawson.japanesenamegenerator.v3.data.Model;
import com.nolanlawson.japanesenamegenerator.v3.data.ModelMarshaller;
import com.nolanlawson.japanesenamegenerator.v3.katakana.KatakanaConverter;
import com.nolanlawson.japanesenamegenerator.v3.katakana.KatakanaParseException;
import com.nolanlawson.japanesenamegenerator.v3.katakana.RomaajiMassager;
import com.nolanlawson.japanesenamegenerator.v3.util.Pair;
import com.nolanlawson.japanesenamegenerator.v3.util.StringUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapaneseNameGenerator {
    private static final String ROMAAJI_MODEL_FILENAME = "romaaji_model_20090125_all1_2_2_min2_truncated2.txt";
    private static final String DIRECT_LOOKUP_FILENAME = "all_names.txt";
    private static Map<Character, String> lettersInJapanese = new HashMap<Character, String>(){
        {
            this.put(Character.valueOf('a'), "ee");
            this.put(Character.valueOf('b'), "bii");
            this.put(Character.valueOf('c'), "shii");
            this.put(Character.valueOf('d'), "dii");
            this.put(Character.valueOf('e'), "ii");
            this.put(Character.valueOf('f'), "efu");
            this.put(Character.valueOf('g'), "jii");
            this.put(Character.valueOf('h'), "ecchi");
            this.put(Character.valueOf('i'), "ai");
            this.put(Character.valueOf('j'), "jee");
            this.put(Character.valueOf('k'), "kee");
            this.put(Character.valueOf('l'), "eru");
            this.put(Character.valueOf('m'), "emu");
            this.put(Character.valueOf('n'), "enu");
            this.put(Character.valueOf('o'), "oo");
            this.put(Character.valueOf('p'), "pii");
            this.put(Character.valueOf('q'), "kyuu");
            this.put(Character.valueOf('r'), "aaru");
            this.put(Character.valueOf('s'), "esu");
            this.put(Character.valueOf('t'), "tii");
            this.put(Character.valueOf('u'), "yuu");
            this.put(Character.valueOf('v'), "bui");
            this.put(Character.valueOf('w'), "daburu");
            this.put(Character.valueOf('x'), "ekkusu");
            this.put(Character.valueOf('y'), "wai");
            this.put(Character.valueOf('z'), "zetto");
        }
    };
    private static Pattern initialsPattern = Pattern.compile("([bcdfghjklmnpqrstvwxyz]{2}|([a-z]\\.){1,2})");
    private static Pattern nonlettersPattern = Pattern.compile("[^a-zA-Z]");
    private Model model;
    private Map<String, String> directLookupNames;
    private KatakanaConverter katakanaConverter = new KatakanaConverter();
    private RomaajiMassager romaajiMassager = new RomaajiMassager();

    public JapaneseNameGenerator() {
        this.model = ModelMarshaller.readFromSystemResource(ROMAAJI_MODEL_FILENAME);
        this.directLookupNames = this.loadDirectLookupNames();
    }

    public JapaneseNameGenerator(InputStream romaajiModelInputStream, InputStream directLookupNamesInputStream) {
        this.model = ModelMarshaller.readFromInputStream(romaajiModelInputStream);
        this.directLookupNames = this.loadDirectLookupNamesFromInputStream(directLookupNamesInputStream);
    }

    public Pair<String, String> convertToRomaajiAndKatakana(String english) throws ConversionException {
        if (english == null || english.trim().equals("")) {
            throw new ConversionException("String is null or empty");
        }
        english = english.trim().toLowerCase();
        String[] tokens = StringUtil.quickSplit(english, " ");
        StringBuilder romaaji = new StringBuilder();
        StringBuilder katakana = new StringBuilder();
        for (String token : tokens) {
            Pair<String, String> convertedPair = this.convertEnglishToken(token);
            romaaji.append(convertedPair.getFirst()).append(" ");
            katakana.append(convertedPair.getSecond()).append(" ");
        }
        String katakanaResult = katakana.substring(0, katakana.length() - 1);
        String romaajiResult = romaaji.substring(0, romaaji.length() - 1);
        return Pair.create(romaajiResult, katakanaResult);
    }

    private Pair<String, String> convertEnglishToken(String token) throws ConversionException {
        String katakana;
        String romaaji;
        Matcher matcher = initialsPattern.matcher(token);
        if (matcher.matches()) {
            romaaji = this.convertInitials(token);
        } else if (this.directLookupNames.containsKey(token)) {
            romaaji = this.directLookupNames.get(token);
        } else {
            if ((token = nonlettersPattern.matcher(token).replaceAll("")).endsWith("th") && token.length() > 3) {
                token = token.substring(0, token.length() - 2) + "s";
            }
            romaaji = this.model.transformString(token);
        }
        romaaji = this.romaajiMassager.massageMalformedRomaaji(romaaji);
        romaaji = this.normalizeRoomaji(romaaji);
        try {
            katakana = this.katakanaConverter.convertToKatakana(romaaji);
        }
        catch (KatakanaParseException ex) {
            throw new ConversionException("Could not parse romaaji: '" + romaaji + "'", ex);
        }
        return Pair.create(romaaji, katakana);
    }

    private String convertInitials(String token) {
        StringBuilder sb = new StringBuilder();
        for (char ch : token.toCharArray()) {
            if (!lettersInJapanese.containsKey(Character.valueOf(ch))) continue;
            sb.append(lettersInJapanese.get(Character.valueOf(ch)));
        }
        return sb.toString();
    }

    private Map<String, String> loadDirectLookupNames() {
        try {
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(DIRECT_LOOKUP_FILENAME);
            return this.loadDirectLookupNamesFromInputStream(inputStream);
        }
        catch (Throwable ex) {
            throw new RuntimeException("failed to load file: 'all_names.txt'", ex);
        }
    }

    private Map<String, String> loadDirectLookupNamesFromInputStream(InputStream inputStream) {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            BufferedReader buff = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while (buff.ready()) {
                String line = buff.readLine();
                String[] splitValues = StringUtil.quickSplit(line, " ");
                result.put(splitValues[0].toLowerCase(), splitValues[1].toLowerCase());
            }
            buff.close();
            return result;
        }
        catch (Throwable ex) {
            throw new RuntimeException("failed to load direct lookup names", ex);
        }
    }

    private String normalizeRoomaji(String romaaji) {
        romaaji = StringUtil.quickReplace(romaaji, "ei", "ee");
        romaaji = StringUtil.quickReplace(romaaji, "ou", "oo");
        romaaji = StringUtil.quickReplace(romaaji, "tch", "cch");
        romaaji = StringUtil.quickReplace(romaaji, "si", "shi");
        romaaji = StringUtil.quickReplace(romaaji, "zi", "ji");
        romaaji = StringUtil.quickReplace(romaaji, "mp", "np");
        romaaji = StringUtil.quickReplace(romaaji, "mb", "nb");
        return romaaji;
    }
}

