
/*
 * PackList is an open-source packing-list for Android
 *
 * Copyright (c) 2017 Nicolas Bossard and other contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * GUI related classes for PackList.
 *
 * @author Nicolas BOSSARD
 */
package com.nbossard.packlist.gui;

/*

============================== DIAGRAMS OF CLASS ==================================

// To generate graphics please use jar available at :
//     http://sourceforge.net/projects/plantuml/files/plantuml.jar/download
// syntax description can be found at :
//     http://plantuml.sourceforge.net/classes.html
//     http://www.linux-france.org/prj/edu/archinet/DA/fiche-uml-relations/fiche-uml-relations.html
@startuml
    package com.nbossard.packlist.gui #LightGreen {
        !include AboutActivity.java
        !include ChangeLogDialog.java
        !include HelpThirdPartyActivity.java
        !include IItemDetailFragmentActivity.java
        !include IMainActivity.java
        !include IMassImportFragmentActivity.java
        !include INewTripFragmentActivity.java
        !include ITripListFragmentActivity.java
        !include ItemAdapter.java
        !include ItemDetailFragment.java
        !include ITripDetailFragmentActivity.java
        !include MainActivity.java
        !include MassImportFragment.java
        !include MaterialColor.java
        !include NewTripFragment.java
        !include SettingsActivity.java
        !include SettingsFragment.java
        !include TripDeletionConfirmDialogFragment.java
        !include TripDetailFragment.java
        !include TripAdapter.java
        !include TripListFragment.java
    }
@enduml

*/
