package com.monead.games.android.sequence.event;

/**
 * Copyright 2011, David S. Read
 * 
 * This file is part of Sequence Hunt.
 *
 * Sequence Hunt is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sequence Hunt is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Sequence Hunt.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * A simple interface to support listening for user actions
 * related to playing the Sequence Hunt game.
 * 
 * @author David Read
 *
 */
public interface ColorChoiceListener {
    /**
     * Detect a color selection.
     * 
     * @param color  The selected color
     */
    void notifyColorChoice(int color);
    
    /**
     * Detect a deletion request.
     */
    void notifyDeleteChoice();
    
    /**
     * Detect a try submission request.
     */
    void notifyTry();
}
