package com.mobilepearls.sokoban;

import java.util.ArrayList;
import java.util.List;
public class SokobanLevels {
	public static final List<String[][]> levelMaps = new ArrayList<String[][]>();
	static {

		// level: Original
		levelMaps.add(new String[][] {
				{
					"'''###'''''"
					,
					"''## #'####"
					,
					"'##  ###  #"
					,
					"## $      #"
					,
					"#   @$ #  #"
					,
					"### $###  #"
					,
					"''#  #..  #"
					,
					"'## ##.# ##"
					,
					"'#      ##'"
					,
					"'#     ##''"
					,
					"'#######'''"
				}
				,
				{
					"'##'#####"
					,
					"##'## . #"
					,
					"#'## $. #"
					,
					"'## $   #"
					,
					"## $@ ###"
					,
					"# $  ##''"
					,
					"#.. ##'##"
					,
					"#   #'##'"
					,
					"#####'#''"
				}
				,
				{
					"'''''''''''#####"
					,
					"''''''''''##   #"
					,
					"''''''''''#    #"
					,
					"''''####''# $ ##"
					,
					"''''#  ####$ $#'"
					,
					"''''#     $ $ #'"
					,
					"'''## ## $ $ $#'"
					,
					"'''#  .#  $ $ #'"
					,
					"'''#  .#      #'"
					,
					"##### #########'"
					,
					"#.... @  #''''''"
					,
					"#....    #''''''"
					,
					"##  ######''''''"
					,
					"'####'''''''''''"
				}
				,
				{
					"''###########"
					,
					"'##     #  @#"
					,
					"### $ $$#   #"
					,
					"#'##$    $$ #"
					,
					"#''#  $ #   #"
					,
					"###### ######"
					,
					"#.. ..$ #*##'"
					,
					"# ..    ###''"
					,
					"#  ..#####'''"
					,
					"#########''''"
				}
				,
				{
					"''###########''"
					,
					"'##    #    ##'"
					,
					"### $ $#$ $ ###"
					,
					"# #$ $ # $ $# #"
					,
					"# $  ..#..  $ #"
					,
					"#  $...#...$  #"
					,
					"# $ .. * .. $ #"
					,
					"###### @ ######"
					,
					"# $ ..   .. $ #"
					,
					"#  $...#...$  #"
					,
					"# $  ..#..  $ #"
					,
					"# #$ $ # $ $# #"
					,
					"### $ $#$ $ ###"
					,
					"'##    #    ##'"
					,
					"''###########''"
				}
				,
				{
					"''###########''"
					,
					"###.  .$.  .###"
					,
					"'## $  $  $ ##'"
					,
					"''## ..$.. ##''"
					,
					"'''##$#$#$##'''"
					,
					"''''#.$ $.#''''"
					,
					"''''#  @  #''''"
					,
					"''''### ###''''"
					,
					"'''## $ $ ##'''"
					,
					"'''#.  $  .#'''"
					,
					"'''### . ###'''"
					,
					"'''''#####'''''"
				}
				,
				{
					"'''''''''''######''"
					,
					"''''####''##    #''"
					,
					"''###  #''#  ## ###"
					,
					"###    #### #   $ #"
					,
					"#  $ @ ...*..  $  #"
					,
					"# $ $  ## ###   ###"
					,
					"### ###   #'#####''"
					,
					"'#      ###''''''''"
					,
					"'#   ####''''''''''"
					,
					"'#####'''''''''''''"
				}
				,
				{
					"''''#######''"
					,
					"''''#     ##'"
					,
					"##### ###  ##"
					,
					"#       #  ##"
					,
					"#@$***. ##$ #"
					,
					"#  #    ## .#"
					,
					"##  ##  # $ #"
					,
					"'##  ####.$.#"
					,
					"''##        #"
					,
					"'''######  ##"
					,
					"''''''''####'"
				}
				,
				{
					"#########"
					,
					"#. .    #"
					,
					"#.$. .  #"
					,
					"## ###@ #"
					,
					"'#  $  ##"
					,
					"'# $$ ##'"
					,
					"'#  $ #''"
					,
					"'#  ###''"
					,
					"'####''''"
				}
				,
				{
					"''''''######''''''"
					,
					"''''''#    #''''''"
					,
					"''''''# @  ###''''"
					,
					"####''#      #''''"
					,
					"#  ####..#.#$#####"
					,
					"# $ $ ##...      #"
					,
					"#     .....#$$   #"
					,
					"###### ##$## #####"
					,
					"'''''#  $    #''''"
					,
					"'''''#### ####''''"
					,
					"'''''''#  #'''''''"
					,
					"'''''''#  #####'''"
					,
					"'''''### $    #'''"
					,
					"'''''#  $ $   #'''"
					,
					"'''''# #$# ####'''"
					,
					"'''''#     #''''''"
					,
					"'''''#######''''''"
				}
				,
				{
					"''####'''''"
					,
					"###  ####''"
					,
					"#   @   ##'"
					,
					"# #. .#.###"
					,
					"# $$$ $$$ #"
					,
					"###.#.#.# #"
					,
					"'##       #"
					,
					"''####  ###"
					,
					"'''''####''"
				}
				,
				{
					"''''''''''''''#####''''''''"
					,
					"''''''''''''''#   #''''''''"
					,
					"''''#####'''''#   #######''"
					,
					"''''#   #####'#   ..... #''"
					,
					"##### # ##  #'#     # # #''"
					,
					"# $ $ $ $ $ #'##   ## $ #''"
					,
					"# # ##......#### ### $$ ###"
					,
					"#      ## * #    #'#  $$  #"
					,
					"##########+$$   ##'#      #"
					,
					"'''''''''#.$ $# #''########"
					,
					"'''''''''#.##   #''''''''''"
					,
					"'''''''''########''''''''''"
				}
				,
				{
					"'''#######''"
					,
					"'###     ##'"
					,
					"'#   ###  #'"
					,
					"'#      # #'"
					,
					"###$#@  # #'"
					,
					"#   ##### #'"
					,
					"#   #  *. #'"
					,
					"##$$#  *.##'"
					,
					"'#     *..#'"
					,
					"'#### #...##"
					,
					"''''# #$$$ #"
					,
					"''''#   $  #"
					,
					"''''#####  #"
					,
					"''''''''####"
				}
				,
				{
					"'#######''"
					,
					"##     #'#"
					,
					"#  *.$.#''"
					,
					"#  *.#.###"
					,
					"# #$@$$  #"
					,
					"#   ## # #"
					,
					"######   #"
					,
					"'''''#####"
				}
				,
				{
					"'''####''''"
					,
					"'''#@ #''''"
					,
					"''##  ##'''"
					,
					"''# .$#####"
					,
					"''#$. #   #"
					,
					"###..$# # #"
					,
					"#  ..$  $ #"
					,
					"# $ $ # ###"
					,
					"##### # #''"
					,
					"''''#   #''"
					,
					"''''###.#''"
					,
					"''''''###''"
				}
				,
				{
					"''######'''''''"
					,
					"'##'#  ###'''''"
					,
					"##'#   #'##''''"
					,
					"#'#   $.#'#''''"
					,
					"##  $ $.#'#''''"
					,
					"# #####. ##''''"
					,
					"#     $. @#''''"
					,
					"#     $. ####''"
					,
					"### # #*# # ###"
					,
					"''#### .$     #"
					,
					"''''#  .$     #"
					,
					"''''## .##### #"
					,
					"''''#'#.$ $  ##"
					,
					"''''#'#.$   #'#"
					,
					"''''##'#   #'##"
					,
					"'''''###  #'##'"
					,
					"'''''''######''"
				}
				,
				{
					"''''###########''''''''"
					,
					"'''## . . . . ###''''''"
					,
					"'''#  $$ $ $ $  #''''''"
					,
					"'''#   ######## #'#####"
					,
					"'#### ##  $     #'#   #"
					,
					"'#    #  $ $ #  ### # #"
					,
					"##  # #   ####     $  #"
					,
					"#...  ##### $  #### ###"
					,
					"#... @     $     #    #"
					,
					"#...############ $  $ #"
					,
					"#####''''''''''#####  #"
					,
					"'''''''''''''''''''####"
				}
				,
				{
					"''''####"
					,
					"#####  #"
					,
					"#      #"
					,
					"#$ $ $ #"
					,
					"#.*.*.*#"
					,
					"#*.*.*.#"
					,
					"# $ $ $#"
					,
					"#......#"
					,
					"#.*.*.*#"
					,
					"#$ $ $ #"
					,
					"# $ $ $#"
					,
					"#$ $ $ #"
					,
					"#      #"
					,
					"#@ #####"
					,
					"####''''"
				}
				,
				{
					"#####''''''''''''''''''''"
					,
					"#   #######''''''''''''''"
					,
					"#  $      ##'''''''''''''"
					,
					"## ######  ##''''''''''''"
					,
					"'# #    # # ########'''''"
					,
					"'# # ##    $       ##''''"
					,
					"'# #.   #@###### $  ##'''"
					,
					"'# #.#  ###''''## $  ##''"
					,
					"'# #.    #''''''## $  ##'"
					,
					"'# #.#   #''##'''## $  ##"
					,
					"## #.#  ##''###'''## $  #"
					,
					"#  #.#   #''#*##'''##   #"
					,
					"#   .# # #''##*##'''#####"
					,
					"######   #''######'''''''"
					,
					"'''''#####'''''''''''''''"
				}
				,
				{
					"'''''####"
					,
					"'''''#  #"
					,
					"######$.#"
					,
					"#   $ $.#"
					,
					"# $@$...#"
					,
					"# $$$..##"
					,
					"#  $ ..#'"
					,
					"########'"
				}
				,
				{
					"#####'########'"
					,
					"#   ### . $  #'"
					,
					"#   $ *.. #$ ##"
					,
					"## $# ..* $  @#"
					,
					"'#  $ . ###   #"
					,
					"'########'#####"
				}
				,
				{
					"'''#####'####''"
					,
					"'''#@ .###  ###"
					,
					"####  $$ $    #"
					,
					"#   # . . ##  #"
					,
					"#  $ # . . ## #"
					,
					"## .  $ $$  # #"
					,
					"'# #  ###.  # #"
					,
					"'# #### ##### #"
					,
					"'#       #    #"
					,
					"'####### # ####"
					,
					"'''''''# .$ #''"
					,
					"'''''####   #''"
					,
					"'''''##'#####''"
					,
					"''''''###''''''"
				}
				,
				{
					"'''''#######'''''"
					,
					"######     ######"
					,
					"#  . ..$#$.. .  #"
					,
					"#  $ $  .  $ $  #"
					,
					"###$####@####$###"
					,
					"#  $ $  .  $ $  #"
					,
					"#  . ..$#$.. .  #"
					,
					"######     ######"
					,
					"'''''#######'''''"
				}
				,
				{
					"''''''''######"
					,
					"''''''''#   ##"
					,
					"''####### $  #"
					,
					"''# $ $ $ #$ #"
					,
					"''#   #. $   #"
					,
					"'####.#.# $###"
					,
					"'#   ..... #''"
					,
					"'#  $ ..##$#''"
					,
					"### ## ..  #''"
					,
					"#  $.#$ # $#''"
					,
					"#   $   #  #''"
					,
					"##@  #  ####''"
					,
					"'##  ####'''''"
					,
					"''####''''''''"
				}
				,
				{
					"'''''''''#####''''"
					,
					"'''''#####  #####'"
					,
					"'''''#  .#$   $ #'"
					,
					"'''''# #. $$$ @ ##"
					,
					"'''''#  .#$   $  #"
					,
					"'''''###.#  $ $  #"
					,
					"'''''''#.  ##$ ###"
					,
					"'#######*###.$ #''"
					,
					"'# $    ....####''"
					,
					"## #$#$$....#'''''"
					,
					"#  $ $   #..#'''''"
					,
					"#     $  #..#'''''"
					,
					"#  ##########'''''"
					,
					"#####'''''''''''''"
				}
				,
				{
					"'''''''''''####'''"
					,
					"'###########  #'''"
					,
					"'#  $ $ $ $   ##''"
					,
					"'#  # # # # #$##''"
					,
					"'##. . . . . .#'''"
					,
					"''#$# # # # #$####"
					,
					"###. . . . . .   #"
					,
					"###$# # # # # @  #"
					,
					"''#   $ $ $ $  ###"
					,
					"''#  ###########''"
					,
					"''####''''''''''''"
				}
				,
				{
					"''''''########''''''''''"
					,
					"'######      ##########'"
					,
					"## $     ###          ##"
					,
					"# $ $ ## #  #########  #"
					,
					"#  $  #              # #"
					,
					"# $ $ # #  ######### # #"
					,
					"#  $  #  # #. . . .  # #"
					,
					"# $ $ # #    . . . .## #"
					,
					"#  $  # # # . . . . #  #"
					,
					"##$ $## #  #### # #   ##"
					,
					"'#   #@ #       #  ####'"
					,
					"'######  #####  #  #''''"
					,
					"''''''##     #  #  #''''"
					,
					"'''''''#####  ##  ##''''"
					,
					"'''''''''''##    ##'''''"
					,
					"''''''''''''######''''''"
				}
				,
				{
					"'''''''######''''''''"
					,
					"'''''''#    ###''''''"
					,
					"'''##### $ $  #''''''"
					,
					"####   #.#    ##'''''"
					,
					"#  $ #$#.##$#####''''"
					,
					"# $$. .#.$      ##'''"
					,
					"#  $.#.#.#####  ####'"
					,
					"##  ....... @#     #'"
					,
					"'####$ #.### #$###$##"
					,
					"''## $  .  #  $ $ $ #"
					,
					"'''# $ ###          #"
					,
					"'''#   #'############"
					,
					"'''#####'''''''''''''"
				}
				,
				{
					"####''''''''''''''''''"
					,
					"#  #''''''''''''''####"
					,
					"#  ########'#######  #"
					,
					"#         ###  ##  $ #"
					,
					"##.###### ...     #. #"
					,
					"'#.#      # .#   # $ #"
					,
					"'#$$$$#$$$ #.#   ##. #"
					,
					"'#.# $   $ #..      ##"
					,
					"'#.#  $  $   # #   ##'"
					,
					"'#  #   $$ #   #####''"
					,
					"'#.  ##$  ######''''''"
					,
					"'#.   #  $.  #''''''''"
					,
					"##. @ ###.#$ #''''''''"
					,
					"#     #'#    #''''''''"
					,
					"#    ##'######''''''''"
					,
					"######''''''''''''''''"
				}
				,
				{
					"'''''#####''''''''''''''''"
					,
					"'''''#   #''''''''''''''''"
					,
					"'''''#   #''''''''######''"
					,
					"'''###  ##'#####''#    ###"
					,
					"'''#    #''''''''## #$$  #"
					,
					"''##$   ########## $  $  #"
					,
					"###  ## ..........$  #$$@#"
					,
					"#    # $$# ####### $     #"
					,
					"#   $  #...#'''''###  ####"
					,
					"#   #   $ ###'##'''####'''"
					,
					"########    #'''''''''''''"
					,
					"'''''''#    #'''''''''''''"
					,
					"'''''''#    #'''''''''''''"
					,
					"'''''''######'''''''''''''"
				}
				,
				{
					"'''#####'''''''''''''"
					,
					"'''#   #####'''''''''"
					,
					"'''# $$#   ######''''"
					,
					"'###.  . $ #''''#''''"
					,
					"'#  .##.#######'#''''"
					,
					"'# $.  . #    #'#''''"
					,
					"##.##$$$$#$$$ ######'"
					,
					"'#...    .    #    #'"
					,
					"'#..##.####.### ##@#'"
					,
					"'## # $ $ $ # $ $  #'"
					,
					"''# #       #     ###"
					,
					"''# #.##.#.######  #'"
					,
					"''#  $ # $.     $  #'"
					,
					"''#    ###.## ###$##'"
					,
					"''######'#        #''"
					,
					"'''''''''##########''"
				}
				,
				{
					"'''''''''''''''''''#####"
					,
					"'''''''''''''''''''#   #"
					,
					"'''''''''''######### $ #"
					,
					"''''######'#   #   #   #"
					,
					"''''#    #'# $     $ #@#"
					,
					"''### ## #### ### ## ###"
					,
					"''#   $  $     #   #   #"
					,
					"''#  $  $ # #$ # $$ $$ #"
					,
					"'######  $  #  #   #   #"
					,
					"##    ## ###############"
					,
					"#  .#   $ #''''#''''''''"
					,
					"#..    #  ######''''''''"
					,
					"#...####  #'''''''''''''"
					,
					"#....#'####'''''''''''''"
					,
					"#....#''''''''''''''''''"
					,
					"######''''''''''''''''''"
				}
				,
				{
					"'''#######'''''''''''''''"
					,
					"''##     ##''''''''''''''"
					,
					"''#  ###  #''''''''''''''"
					,
					"''# ## $  ####'''''''''''"
					,
					"''# # .#   $.####''''''''"
					,
					"''# # * *###.$  #''''''''"
					,
					"''# # *#   ### #####'''''"
					,
					"''# # @ * *  # #   #'''''"
					,
					"''# #  ### #*#  *  #'''''"
					,
					"''# ## #  * *.# # #######"
					,
					"''# #  #     ....$  $   #"
					,
					"''# # ## $# $####$      #"
					,
					"###*   *     #    #######"
					,
					"#   ########## ####''''''"
					,
					"#              #'''''''''"
					,
					"##  ############'''''''''"
					,
					"'####''''''''''''''''''''"
				}
				,
				{
					"''''''''''''#####'''''''''"
					,
					"''''''''''''# ..########''"
					,
					"''''''''''''# ......#  #''"
					,
					"''''''''''''#.. ##$$  $#''"
					,
					"'''''''''#####.##   $  #''"
					,
					"'''''''''#  ....# $  $$#''"
					,
					"#####'##'#  .. .#$  $  #''"
					,
					"#   #''''# ##.###  $$ $###"
					,
					"#   ###''# ## #  $  #    #"
					,
					"# @   #### #  # # ###$ # #"
					,
					"#             #  $    $  #"
					,
					"#   ####      ### ####$$##"
					,
					"#  ##''####     #       #'"
					,
					"#  #''''''##    ######  #'"
					,
					"####'''''''##     #'# $ #'"
					,
					"''''''''''''##    #'#   #'"
					,
					"'''''''''''''######'#####'"
				}
				,
				{
					"'#####''''''''''''''''''''"
					,
					"'#   #''''''''''''''''''''"
					,
					"## # #####''''''''''''''''"
					,
					"#    ##  #######''''''''''"
					,
					"# #     $      ####'''''''"
					,
					"#   #### $  $$ #  #'''''''"
					,
					"#####''# $$$ $ #$ #'''''''"
					,
					"'''''''# $  $ $ $ ######''"
					,
					"'''''###$   #$ $  $    #''"
					,
					"'''''# $ $$      ### @ ##'"
					,
					"'''''#  $ $$$$####...   #'"
					,
					"'''''#  $     $ #. .#...#'"
					,
					"'''''### $$$$   ......  #'"
					,
					"'''''''#      ##..#.....#'"
					,
					"'''''''###### ##.....####'"
					,
					"''''''''''''#   .....#'''#"
					,
					"''''''''''''##########''''"
				}
				,
				{
					"''''''''''''''''#####'''''''"
					,
					"''''####''''''''#   ######''"
					,
					"''''#  #''''''''# $    $ #''"
					,
					"''''#  ####'''''#  $##$  ###"
					,
					"''''#     #########  # $ $ #"
					,
					"''''#      ..........#   $ #"
					,
					"''###### ##....@###  # $$  #"
					,
					"''#    # #####.##'# ##   $ #"
					,
					"''#            #''#$  $$ $ #"
					,
					"'#### #  ##### #''#  $  #  #"
					,
					"'#    # #      #''###   ####"
					,
					"'#      #  #   #''''#####'''"
					,
					"'#   #     #####''''''''''''"
					,
					"'#####     #''''''''''''''''"
					,
					"'''''#######''''''''''''''''"
				}
				,
				{
					"''#####'''''''#########''''''"
					,
					"''#   #'''''''#       #''''''"
					,
					"### #$###'##### # # # #####''"
					,
					"# $. .  #'#    . . . .    #''"
					,
					"# # # #$### # # # # # # #$#''"
					,
					"#  . . . .  $ $ $ $  . .  #''"
					,
					"###$# # #$###########$# #$#''"
					,
					"''#  . .  ##''''''''#  .  #''"
					,
					"''###$# #$#######'#'#$# #$###"
					,
					"''''#  . .$ $ $ #'''#  . .  #"
					,
					"''''#$# # # # # #####$# # # #"
					,
					"''''#  . . . . .  $  . . .  #"
					,
					"''''### # # # # # # # # # # #"
					,
					"''''''# $ $. . .$ $ $ $ $ $ #"
					,
					"''''''##### # # #############"
					,
					"''''''''''#  @  #''''''''''''"
					,
					"''''''''''#######''''''''''''"
				}
				,
				{
					"''''''''''''''''''''''####"
					,
					"''####'''''''''########  #"
					,
					"###@ ##''''''''#      #  #"
					,
					"#     #''''''''# ### $ $ #"
					,
					"# ....##########   #  #..#"
					,
					"# . #  ## $   $ $# #  #..#"
					,
					"### #     $  $$$ # # $ $ #"
					,
					"''# ...# $  $$   # #  #  #"
					,
					"''#  ..# $   $ $ # # ##  #"
					,
					"''##...#  $ $$ $ #$# #####"
					,
					"'''#   ## $  $ $   # #''''"
					,
					"'''### ######  ### # ###''"
					,
					"'''# .   ##'#### .   . #''"
					,
					"''##   . #'''''# #.#.# #''"
					,
					"''#  .   #'#'#'#   #   #''"
					,
					"''# . ####'''''#########''"
					,
					"''#  ##'''''''''''''''''''"
					,
					"''####''''''''''''''''''''"
				}
				,
				{
					"'''####'''''''''''#####"
					,
					"'''#  #######''####   #"
					,
					"'''# @  $   ####   $  #"
					,
					"'''#  ###.#    #  $$  #"
					,
					"'###.## $ #$ #    #  ##"
					,
					"'#  ..# $ ...# ###  ##'"
					,
					"'# $ ...$##.##     ##''"
					,
					"'##.###$ $..   $$ ##'''"
					,
					"''#.  #. .### $ $ #''''"
					,
					"''#  $...##'## #  #''''"
					,
					"'## ######'''#   ##''''"
					,
					"##   ##''''''#####'''''"
					,
					"# $$  #''''''''''''''''"
					,
					"#   $ #''''''''''''''''"
					,
					"### $ #''''''''''''''''"
					,
					"''#  ##''''''''''''''''"
					,
					"''####'''''''''''''''''"
				}
				,
				{
					"'''''#######''''''''''''"
					,
					"####'#     #''''''''''''"
					,
					"#  ### $$$ #''''''''''''"
					,
					"#  ....$  #####'''''''''"
					,
					"#  ..# $  #  @#'''''''''"
					,
					"###$##$#### # ######''''"
					,
					"'#.*....$  $  ###  #####"
					,
					"'# ..#####  ##   $ $   #"
					,
					"'#....*.... #  $$  # $ #"
					,
					"'########## #$$ ## #   #"
					,
					"''''# $.###        $  ##"
					,
					"''''#       $###$# #  #'"
					,
					"''''#####   $    $ ####'"
					,
					"''''''''####    ####''''"
					,
					"'''''''''''######'''''''"
				}
				,
				{
					"'''#####''''''''''''''''"
					,
					"'''#'''#''''''''''''''''"
					,
					"'###'''########'''''''''"
					,
					"##''***''''#'#'#''''''''"
					,
					"'#''*'*''''##'#'#####'''"
					,
					"##''***'''##'#'##   ##''"
					,
					"'###'''####'#'#'#   #'''"
					,
					"'''#'''#'#'#'####$ $###'"
					,
					"''##'''##'#'##  $...$ ##"
					,
					"'''#####'#'##    .@.  #'"
					,
					"''''''''#'#'#   $...$ ##"
					,
					"'''''''''########$ $###'"
					,
					"''''''''''''''''#   #'''"
					,
					"''''''''''''''''#####'''"
				}
				,
				{
					"####'''''''''''''''"
					,
					"#  ######''''''''''"
					,
					"#       ####'''''''"
					,
					"# $ $   #  #####'''"
					,
					"##### ###    $ #'''"
					,
					"'#  #   $  #   #'''"
					,
					"'#      ##$######''"
					,
					"'# $###  # ...#'#''"
					,
					"'## #@#$ ##.#.#'#''"
					,
					"'#    #   #...#'#''"
					,
					"'# $ ##$ $#...#####"
					,
					"'### ##   #...    #"
					,
					"''#  #  $ $ $ # # #"
					,
					"''# $### ###### # #"
					,
					"''#             # #"
					,
					"''#############   #"
					,
					"''''''''''''''#####"
				}
				,
				{
					"'''####'''''''''''''''''''''''"
					,
					"''##  #############'''''''''''"
					,
					"'##    .......... #'''''''''''"
					,
					"##    #  ####$### ##''''''''''"
					,
					"#      # #      #  ##'''''''''"
					,
					"#     #  # $$$  # # #####'''''"
					,
					"#####  # . .# ### . . . ##''''"
					,
					"''''#   $. .#  # $$ $ $ @#''''"
					,
					"'''####### ### #   #######''''"
					,
					"'''# $   $   # ## ###'''''''''"
					,
					"'''#    $  $ #  # ##'#'####'''"
					,
					"'''# $### ####  # #'#'##  ####"
					,
					"'''#  $ $$$  # ## #''##      #"
					,
					"'''##        # ## #### $$$   #"
					,
					"''''## ####### .....     #####"
					,
					"''''#  $         ######  #''''"
					,
					"''''#   ######  ##''''####''''"
					,
					"''''#####''''####'''''''''''''"
				}
				,
				{
					"'#############''''''''''"
					,
					"##       #   ###''''''''"
					,
					"#  $ $$$$$     #''''''''"
					,
					"### $   $  ### #''''''''"
					,
					"''# $ $ $###'# #''''''''"
					,
					"''##   $ ##''# ###''''''"
					,
					"'''####   ####   #''''''"
					,
					"'''''###       # ###''''"
					,
					"'''####   ####     #''''"
					,
					"'''#@ $   ###  #.# #####"
					,
					"'''# $ $ ##'#  ....    #"
					,
					"'''# $$ ##''####.....  #"
					,
					"''## $  #'''''#..#.##  #"
					,
					"''# $ $ ##''''#......  #"
					,
					"''#  $ $ #''''# . ..# ##"
					,
					"''##  $  #''''## ##.# #'"
					,
					"'''#    ##'''''#      #'"
					,
					"'''######''''''########'"
				}
				,
				{
					"''####''''''########'''"
					,
					"''#  #####'##   #  #'''"
					,
					"''#    $ ### $  $  #'''"
					,
					"''#  $ # ##    $   ####"
					,
					"''###  #    # ###$##  #"
					,
					"#####  ###  ####   $  #"
					,
					"#   # $  $$## .. ##$  #"
					,
					"#  $$   # $          ##"
					,
					"##  # $##  #### # ####'"
					,
					"### #  ##$ ###..#..#'''"
					,
					"#   ###..  #  .....###'"
					,
					"#   #  *.### #  #..  #'"
					,
					"##$$#  *.##@ #  #    #'"
					,
					"'#     *. ####  ###  #'"
					,
					"'######   #''#       #'"
					,
					"''''''#####''##    ###'"
					,
					"''''''''''''''#  ###'''"
					,
					"''''''''''''''####'''''"
				}
				,
				{
					"''''''####'###################"
					,
					"''#####  ###            .$   #"
					,
					"###  $.       #####$####   # #"
					,
					"#    $.  #### #     .   ### .#"
					,
					"#  $ $.###'## # #### #  $.# $#"
					,
					"###  $.##'#'# # #  #  # $ #  #"
					,
					"''######'#'## #$ $ ##   #. # #"
					,
					"''''''''##### #.#.  #  ### # #"
					,
					"'#####''#   # ### ###   #    #"
					,
					"'##*##''#     .#  #   #$$*  ##"
					,
					"'#*###'### ## ## ## #  .#. ##'"
					,
					"'###*#'#  .$ .# $.$.## ### #''"
					,
					"'##*##'# #.####     # $.   ##'"
					,
					"'#*###'# $$   ### ###   ##  ##"
					,
					"'###*#'# #   . $@$  #######. #"
					,
					"'#####'# ### ####.#        $ #"
					,
					"'''''''#     #''###########  #"
					,
					"'''''''#######''''''''''''####"
				}
				,
				{
					"#########'''''''''''''"
					,
					"#       #''''######'''"
					,
					"#   $   ######    ###'"
					,
					"# #$#$ $ $  # $     #'"
					,
					"# $   $@$  $ $ $ $$ #'"
					,
					"# $ $# $ #     $$$  #'"
					,
					"#  $ $ #######   #####"
					,
					"##    ###....##### ..#"
					,
					"'###$$# $$$$ #...* ..#"
					,
					"''#         ##   #.. #"
					,
					"''#  #  #$###....##*##"
					,
					"''#   ##..$. ....    #"
					,
					"''### .*   .#....#   #"
					,
					"''''##################"
				}
				,
				{
					"'''####'####'''''''''''"
					,
					"''##  #'#  #''#######''"
					,
					"###   ###$ ##'#     ###"
					,
					"#  $      $ ###       #"
					,
					"# $ $ ###$   #  #     #"
					,
					"### ### #    #   #    #"
					,
					"#  $ #  ## ###    # ###"
					,
					"#    $   # #@        ##"
					,
					"# $# # ### ###   #   #'"
					,
					"#  $ # # $ $ #  #  # #'"
					,
					"##   #    $  # #.    #'"
					,
					"'##  # #   ##'#..  ###'"
					,
					"''## # #  ##'#... ##'''"
					,
					"'### # #### #....##''''"
					,
					"'#          $.*.##'''''"
					,
					"'############..##''''''"
					,
					"''''''''''''####'''''''"
				}
				,
				{
					"'#########################'"
					,
					"'#  #  #  #  #  #  #  #  #'"
					,
					"'# $#$ # $#$ # $#$ # $#$ #'"
					,
					"'#  #  #  #  #  #  #  #  #'"
					,
					"'## # ### # ### # ### # ##'"
					,
					"'#  #  #  #  #  #  #  #  #'"
					,
					"'#     #     #     #     #'"
					,
					"## ### # ### # ### # ### ##"
					,
					"#   #  #  #  #  #  #  #   #"
					,
					"#   #     #  @  #     #   #"
					,
					"##  # ### # ### # ### #  ##"
					,
					"'#  .  . . .   . . .  .  #'"
					,
					"'#########################'"
				}
				,
				{
					"'''#'#'#'#'#'#'#'#'#'#'#'#''"
					,
					"''# # # # # # # # # # # # #'"
					,
					"'#   .$    . $.  . $   .$  #"
					,
					"''# $# #$# # # #$# # # #  #'"
					,
					"'#  .  .    $.  .  .$ .  . #"
					,
					"''# #$# # # # #$#$ $# #$# #'"
					,
					"'# .     .$ .$    . $.  .  #"
					,
					"''# $# # # # #@# # # # #$ #'"
					,
					"'#  .  .$ .    $. $.     . #"
					,
					"''# #$# #$ $#$# # # # #$# #'"
					,
					"'# .  . $.  .  .$    .  .  #"
					,
					"''#  # # # #$# # # #$# #$ #'"
					,
					"'#  $.   $ .  .$ .    $.   #"
					,
					"''# # # # # # # # # # # # #'"
					,
					"'''#'#'#'#'#'#'#'#'#'#'#'#''"
				}
		});

		// level: Mas Sasquatch
		levelMaps.add(new String[][] {
				{
					"#####'''''"
					,
					"#   #####'"
					,
					"# $ $ $ #'"
					,
					"### # # #'"
					,
					"''# #   #'"
					,
					"'## ### ##"
					,
					"'# .....@#"
					,
					"'# $ $   #"
					,
					"'# ### ###"
					,
					"'#     #''"
					,
					"'#######''"
				}
				,
				{
					"'''''####'"
					,
					"######..#'"
					,
					"#     . #'"
					,
					"#  #  ..#'"
					,
					"#  ## ###'"
					,
					"#    $  ##"
					,
					"#  # #$ @#"
					,
					"#  # $ $ #"
					,
					"#  ## $ ##"
					,
					"#####   #'"
					,
					"''''#####'"
				}
				,
				{
					"''''''''''#####''"
					,
					"'''''''''##   ##'"
					,
					"'''''''''#     ##"
					,
					"'''''''''#    @ #"
					,
					"############ #. #"
					,
					"#            #.##"
					,
					"# ############.#'"
					,
					"#             .#'"
					,
					"##$#$#$#$#$#$#.#'"
					,
					"'#            .#'"
					,
					"'###############'"
				}
				,
				{
					"'''''''#####''''"
					,
					"'''''###   #''''"
					,
					"####'#  $$ ####'"
					,
					"#  ###  $  #  #'"
					,
					"#    ###$$  $ #'"
					,
					"# *#  @  ## # #'"
					,
					"## ##### #..# ##"
					,
					"'#    ## #..#  #"
					,
					"'##  $ # #..   #"
					,
					"#'## $ #  ..####"
					,
					"'#'##    #  #'''"
					,
					"''#'####   ##'''"
					,
					"'''#'''#####''''"
				}
				,
				{
					"'''''#####''"
					,
					"''####   #''"
					,
					"''#  . # ###"
					,
					"''# $. $ $ #"
					,
					"''# #.## $ #"
					,
					"###@#..#$  #"
					,
					"#   ##.#  ##"
					,
					"# $ $ .# $#'"
					,
					"## ###.## #'"
					,
					"'#        #'"
					,
					"'#####  ###'"
					,
					"'''''####'''"
				}
				,
				{
					"''''#####''''''''''"
					,
					"'''##   ######'''''"
					,
					"'''#  @   #  #'''''"
					,
					"'''#  #  $ * #'''''"
					,
					"####  ###$#. #'''''"
					,
					"#.....#    .##'''''"
					,
					"#.....# #$#. ###'''"
					,
					"###     . ##   #'''"
					,
					"'#  ## ##$ ### ####"
					,
					"'#   #  #  $  $   #"
					,
					"'#   $$$# #  $  $ #"
					,
					"'#####  # ######  #"
					,
					"'''''#$    #'''####"
					,
					"''''## $ # #'''''''"
					,
					"''''# $    #'''''''"
					,
					"''''#    ###'''''''"
					,
					"''''######'''''''''"
				}
				,
				{
					"'''''''''#####''''"
					,
					"##########   #''''"
					,
					"#. ........ .##'''"
					,
					"#  ####    #  ##''"
					,
					"## $   #    #  ##'"
					,
					"'# $  #'#    #  ##"
					,
					"'# $ $ # #    #  #"
					,
					"'# $  $   #    @ #"
					,
					"'# $ $$  #       #"
					,
					"'# $## ###########"
					,
					"'#  #  #''''''''''"
					,
					"'#    ##''''''''''"
					,
					"'######'''''''''''"
				}
				,
				{
					"'''''#########''"
					,
					"'#####       #''"
					,
					"##      #### #''"
					,
					"# $ #  @ *..*###"
					,
					"#  #  # #....  #"
					,
					"#  #$#  #....  #"
					,
					"# $# # ##$###  #"
					,
					"#    #$       ##"
					,
					"##  $  $#  ####'"
					,
					"'##  $  ####''''"
					,
					"''### $$ #'''#''"
					,
					"''''#    #'###''"
					,
					"''''######''''''"
				}
				,
				{
					"''''''''''''''####'''''''''''"
					,
					"'''''''''''####  ##'###''''''"
					,
					"''''''''####  $   #'#*#'####'"
					,
					"'########  $   $  #'###'#  #'"
					,
					"'#  $ $ $   $ ##  #'''''#  ##"
					,
					"## $     $ #### $ #######   #"
					,
					"#   $$ ##### $   ##      #  #"
					,
					"#  ## ##  $   $  #          #"
					,
					"#.#  $ # $ $  ####  ## ##   #"
					,
					"#.#  $ $ $ ####        #    #"
					,
					"#.#.#   $  #           #    #"
					,
					"#.#.  ###  #     ########   #"
					,
					"#.#.###@#### ##  #         ##"
					,
					"#.............   # ######  #'"
					,
					"#  .########### ## #''''####'"
					,
					"#####'''''''''#    #'''''''''"
					,
					"''''''''''''''######'''''''''"
				}
				,
				{
					"'''''''''''''####'''"
					,
					"'''#####'#####  ##''"
					,
					"''##   ###       ##'"
					,
					"'##   * * . $ # @ ##"
					,
					"'#  ## * ## ### #  #"
					,
					"'# ## *  #  # $  # #"
					,
					"'# # *  #  #     # #"
					,
					"## #   ## # # ###  #"
					,
					"#  ## #'#. $ .##  ##"
					,
					"# #.# ##'## #.#  ##'"
					,
					"# #  $  #. $ .$ ##''"
					,
					"#   #*  $.#  . ##'''"
					,
					"##### ## ## # ##''''"
					,
					"''''# # $  #  #'''''"
					,
					"''''# #    # ##'''''"
					,
					"''''#  #$##  #''''''"
					,
					"''''##      ##''''''"
					,
					"'''''########'''''''"
				}
				,
				{
					"''''####''''''''''''"
					,
					"''''#  ####'''''''''"
					,
					"''''# $   #########'"
					,
					"''''# .#    $ ##  #'"
					,
					"''''# $# .## $    ##"
					,
					"'#### .###   #$$   #"
					,
					"##  ## #  .. # $$  #"
					,
					"#  $      ...#   $ #"
					,
					"# $  #####... #   ##"
					,
					"#  $#   #  .**@####'"
					,
					"###   # #    # #''''"
					,
					"''#####  ####  #'#''"
					,
					"''''''##      ##''''"
					,
					"'''''''########'''''"
				}
				,
				{
					"#''###'''''"
					,
					"'##   ##'''"
					,
					"'#*.$  #'''"
					,
					"# .$.$ .##'"
					,
					"# $.$.$  #'"
					,
					"#  $.@.$  #"
					,
					"'#  $.$.$ #"
					,
					"'##. $.$. #"
					,
					"'''#  $.*#'"
					,
					"'''##   ##'"
					,
					"'''''###''#"
				}
				,
				{
					"''''#####''''''''"
					,
					"''''#   #####''''"
					,
					"''''# # #   #''''"
					,
					"''''#     # #''''"
					,
					"'#####.# ...#####"
					,
					"'#  .$$ ###$#   #"
					,
					"'# #.#     $. # #"
					,
					"'#  .# $$$  #   #"
					,
					"###  # $@$ #  ###"
					,
					"#   #  $$$ #.  #'"
					,
					"# # .$     #.# #'"
					,
					"#   #$### $$.  #'"
					,
					"#####... #.#####'"
					,
					"''''# #     #''''"
					,
					"''''#   # # #''''"
					,
					"''''#####   #''''"
					,
					"''''''''#####''''"
				}
				,
				{
					"''''#######'''"
					,
					"''''#     ###'"
					,
					"''''# ###$  ##"
					,
					"''''#....$   #"
					,
					"''### ## #   #"
					,
					"###@.$  #'# ##"
					,
					"# .*.$   ## #'"
					,
					"#  $.$  #.$$#'"
					,
					"#  ## ##    #'"
					,
					"#####   # ###'"
					,
					"''''###  $ #''"
					,
					"''''''##   #''"
					,
					"'''''''#####''"
				}
				,
				{
					"''#####''''''''''''''''''''"
					,
					"''#   #####''''''''''''''''"
					,
					"''# $$#   #####''''''''''''"
					,
					"''#   . $ #   #####''''''''"
					,
					"'### ##   . $ #   #####''''"
					,
					"'#   ##.### ....$ #   #####"
					,
					"'# $$#   ###.##.  # $ #   #"
					,
					"'#   # $ #  .##.###   .$$ #"
					,
					"### ##   .$$$#   ###.##   #"
					,
					"#   ##.###   #$$$.   ## ###"
					,
					"# $$.   ###.##.  # $ #   #'"
					,
					"#   # $ #  .##.###   #$$ #'"
					,
					"#####   # $.... ###.##   #'"
					,
					"''''#####   # $ .   ## ###'"
					,
					"''''''''#####   # $ .   #''"
					,
					"''''''''''''#####   #$$ #''"
					,
					"''''''''''''''''#####  @#''"
					,
					"''''''''''''''''''''#####''"
				}
				,
				{
					"#############"
					,
					"#           #"
					,
					"# .$.$.$.$. #"
					,
					"# $.$.$.$.$ #"
					,
					"# .$.$.$.$. #"
					,
					"# $.$.$.$.$ #"
					,
					"# .$.$@$.$. #"
					,
					"# $.$.$.$.$ #"
					,
					"# .$.$.$.$. #"
					,
					"# $.$.$.$.$ #"
					,
					"# .$.$.$.$. #"
					,
					"#           #"
					,
					"#############"
				}
				,
				{
					"#############################"
					,
					"#                           #"
					,
					"# .$.$.$.$.$.$.$.$.$.$.$.$. #"
					,
					"# $.$.$.$.$.$.$.$.$.$.$.$.$ #"
					,
					"# .$.$.$.$.$.$.$.$.$.$.$.$. #"
					,
					"# $.$.$.$.$.$.$.$.$.$.$.$.$ #"
					,
					"# .$.$.$.$.$.$.$.$.$.$.$.$. #"
					,
					"# $.$.$.$.$.$.$.$.$.$.$.$.$ #"
					,
					"# .$.$.$.$.$.$@$.$.$.$.$.$. #"
					,
					"# $.$.$.$.$.$.$.$.$.$.$.$.$ #"
					,
					"# .$.$.$.$.$.$.$.$.$.$.$.$. #"
					,
					"# $.$.$.$.$.$.$.$.$.$.$.$.$ #"
					,
					"# .$.$.$.$.$.$.$.$.$.$.$.$. #"
					,
					"# $.$.$.$.$.$.$.$.$.$.$.$.$ #"
					,
					"# .$.$.$.$.$.$.$.$.$.$.$.$. #"
					,
					"#                           #"
					,
					"#############################"
				}
				,
				{
					"''#####################''"
					,
					"'##        #     #    #''"
					,
					"'#  $ $ $  #$ $ $ $  $###"
					,
					"'# $##### $$  $## ## $  #"
					,
					"'#  #  ..#   # #    #   #"
					,
					"'##$   ... # #   ...#$ ##"
					,
					"##   $ ... #$ #  ...$  ##"
					,
					"#  $####..#    ##...##$ #"
					,
					"#    *.*..$$@$$..*.*    #"
					,
					"# $##...##    #..####$  #"
					,
					"##  $...  # $# ... $   ##"
					,
					"## $#...   # # ...   $##'"
					,
					"#   #    # #   #..  #  #'"
					,
					"#  $ ## ##$  $$ #####$ #'"
					,
					"###$  $ $ $ $#  $ $ $  #'"
					,
					"''#    #     #        ##'"
					,
					"''#####################''"
				}
				,
				{
					"'''''''#####''#####"
					,
					"'''''''#   #''#   #"
					,
					"'''''''# #.####.# #"
					,
					"'''''''# ..    .. #"
					,
					"#####''### #### ###"
					,
					"#   #''''# #    #''"
					,
					"# # ##'''# #@## #''"
					,
					"#  $ ##''# #  # ###"
					,
					"##  $ ##'# $  $.. #"
					,
					"'##  $ ### #  #.# #"
					,
					"''##  $ ## ## #   #"
					,
					"'''##  $ # #  #####"
					,
					"''''##  $  $ ##''''"
					,
					"'''''#####  ##'''''"
					,
					"'''''''''####''''''"
				}
				,
				{
					"''''''''''#########"
					,
					"'''''####'#       #"
					,
					"''####  #'# $     #"
					,
					"''#  #  ####.#    #"
					,
					"''#   $ $   .#### #"
					,
					"''#  $#$## #.#....#"
					,
					"### # $  # #.#....#"
					,
					"#  $ $  # #..*....#"
					,
					"# # ## $  # ####  #"
					,
					"#  $ # # $#      ##"
					,
					"##  $  #    ######'"
					,
					"'##  $ # $$$#''''''"
					,
					"''## $$@##  #''''''"
					,
					"'''##      ##''''''"
					,
					"''''########'''''''"
				}
				,
				{
					"'''#############'''"
					,
					"'''#     #     #'''"
					,
					"'''# $ $ $ $ $ #'''"
					,
					"'''### ##### ###'''"
					,
					"####.$   $   $.####"
					,
					"# ...# $ # $ #... #"
					,
					"#  $##*#.#.#*##$  #"
					,
					"##   . . @ . .   ##"
					,
					"#  $##*#.#.#*##$  #"
					,
					"# ...# $ # $ #... #"
					,
					"####.$   $   $.####"
					,
					"'''### ##### ###'''"
					,
					"'''# $ $ $ $ $ #'''"
					,
					"'''#     #     #'''"
					,
					"'''#############'''"
				}
				,
				{
					"'''##########''''''''"
					,
					"''##        #''''''''"
					,
					"'##    ###  #######''"
					,
					"'# $$ #    $#  #  #''"
					,
					"'#  ###  #$$      #''"
					,
					"'#    $$ #     #$$#''"
					,
					"'#  #   #### #$   #''"
					,
					"'## # ###.*. # ## #''"
					,
					"## *.*.#..*.##    ###"
					,
					"#  ***...**.### $$  #"
					,
					"# #....#...#  #   # #"
					,
					"#  ## ##.*. $ # ### #"
					,
					"##  # $ ..##   $  # #"
					,
					"'## # $$### $#$$  # #"
					,
					"''#  @  #   $    #  #"
					,
					"''#####   ##$####  ##"
					,
					"''''''######      ##'"
					,
					"'''''''''''########''"
				}
				,
				{
					"##############'#######''''''''"
					,
					"#             #       #'''''''"
					,
					"#.##########  #$#####  #''''''"
					,
					"#           #        #  #'''''"
					,
					"#*########  # ######  #  #''''"
					,
					"#         #         #  #  #'''"
					,
					"#*######  # #######  #  #  #''"
					,
					"#       #          #  #  #  #'"
					,
					"#*####  # ########  #  #  #  #"
					,
					"#     #           #  #  #  # #"
					,
					"#*##  # #########  #  #  # # #"
					,
					"#   #            #  #  # # # #"
					,
					"#$  # ##########  #  # # # # #"
					,
					"# #             #  # # # # # #"
					,
					"# # ###########  # # # # # # #"
					,
					"#. @           $ * * * * * . #"
					,
					"##############################"
				}
				,
				{
					"''''''''''''''''''''####'"
					,
					"''''''''''''''#######  #'"
					,
					"''''''''''''''#      $ ##"
					,
					"''''########''# ..## $  #"
					,
					"'''''''''''##'##.#  #   #"
					,
					"'''#######'''''#.# $ $###"
					,
					"'###     #######.#  # ##'"
					,
					"'#   ##    #   $.  $$  #'"
					,
					"'# ##  #.# #@# #.#  ## #'"
					,
					"'#  $$  .$   #    ##   #'"
					,
					"'## #  #.#######     ###'"
					,
					"###$ $ #.#'''''#######'''"
					,
					"#   #  #.##'##'''''''''''"
					,
					"#  $ ##.. #''########''''"
					,
					"## $      #''''''''''''''"
					,
					"'#  #######''''''''''''''"
					,
					"'####''''''''''''''''''''"
				}
				,
				{
					"''######'''''''''''''''"
					,
					"''##   ###########'''''"
					,
					"''# $ $  $  # *  ######"
					,
					"''# .*.#..*.# .$     ##"
					,
					"''# *  # $ $  * $#*.$ #"
					,
					"'## ####    # .  # *  #"
					,
					"'#  $ #########.## .$ #"
					,
					"'#.*.. *        #### ##"
					,
					"'#$ $ #$#.$$.*# #    #'"
					,
					"'#    # #*.$$.#$# $ $#'"
					,
					"## ####        * ..*.#'"
					,
					"# $. ##.######### $  #'"
					,
					"#  * #  . #    #### ##'"
					,
					"# $.*#$ *  $ $ # .$ #''"
					,
					"##     $. #.*..# * @#''"
					,
					"######  * #  $  *.$ #''"
					,
					"'''''###########   ##''"
					,
					"'''''''''''''''######''"
				}
				,
				{
					"######''''#######"
					,
					"#  ..#''''#  #  #"
					,
					"#  ..###### $#  #"
					,
					"## #.  $ ##  $  #"
					,
					"'#  $$$   # ##$##"
					,
					"'#.#. #$ $  #  #'"
					,
					"'#.#.## ##  $  #'"
					,
					"'#.#   $  # #  #'"
					,
					"'#. ##   @# ##$#'"
					,
					"'#.   ####     #'"
					,
					"'#.      $  $# #'"
					,
					"'#. ########   #'"
					,
					"'####''''''#####'"
				}
				,
				{
					"################"
					,
					"#   #   ##  #  #"
					,
					"# .$. $  # . . #"
					,
					"## ### #  $ #$ #"
					,
					"# . #  ### ##.##"
					,
					"#  $ .$  #. #  #"
					,
					"### ## #  $  $ #"
					,
					"##  #  ### ##  #"
					,
					"#  ## ###  #  ##"
					,
					"# $  $  # ## ###"
					,
					"#  # .#  $. $  #"
					,
					"##.## ###  # . #"
					,
					"# $# $  # ### ##"
					,
					"# . . #@ $ .$. #"
					,
					"#  #  ##   #   #"
					,
					"################"
				}
				,
				{
					"'##########'''''''''''''''''"
					,
					"'#    #   #'''''''''''''''''"
					,
					"'# $  #   #'''''####''#####'"
					,
					"'### $$   #######  ####   #'"
					,
					"## $  $  ###   ##  $      #'"
					,
					"# $   ###  # # ##  ##### ###"
					,
					"#  #$#       ..### ##  #   #"
					,
					"#    #  #.# #.. #   # $  $ #"
					,
					"### $ $ #.# #.. #   #  ## ##"
					,
					"''#  #  #.#  #### #### ##  #"
					,
					"'########.#         # $  $ #"
					,
					"'#  ..  #.# ######  #   #  #"
					,
					"'#.$$$$.#.# #'''#  #### ####"
					,
					"'#.$ @$.#.# #'#'#  $      #'"
					,
					"'#.$$$$.#.# #'''#  ####   #'"
					,
					"'#  ..   .  #'''####''#####'"
					,
					"'############'''''''''''''''"
				}
				,
				{
					"''''''''''''''''#####''''''"
					,
					"''''''''''#######   #'#####"
					,
					"'''''######       #.###   #"
					,
					"''''##      # ### #.    * #"
					,
					"''''#  ###### ##  #  ### ##"
					,
					"''''# ## $ ..$ # $   ##  #'"
					,
					"''''# #  $ *.$@##### #  ##'"
					,
					"''''# #    ..$ # $   # ##''"
					,
					"#####$#######$## # .   #'''"
					,
					"# $            . #### ####'"
					,
					"# $$# #########$##   .   #'"
					,
					"# # . .#      .  # $$*$$ #'"
					,
					"#   .  # $.$.#   #... ...#'"
					,
					"##### $ # ## ##### $$*$$ #'"
					,
					"''''#.#    #         .   #'"
					,
					"''''######################'"
				}
				,
				{
					"''''####'''''''''''"
					,
					"#####  ##########''"
					,
					"#      #  #     #''"
					,
					"# #  ..   ##   $###"
					,
					"# # ##.#.  # $$$@ #"
					,
					"#      #.  # $  # #"
					,
					"#   ######## $  # #"
					,
					"###    $       ## #"
					,
					"''#.############  #"
					,
					"''#.             ##"
					,
					"''################'"
				}
				,
				{
					"'#####''''''''''''"
					,
					"##   #'####'''''''"
					,
					"#    ###  #'''''''"
					,
					"#  # @#   #'''''''"
					,
					"##$####   ######''"
					,
					"# ...    ##    ##'"
					,
					"# ...  #    ##  #'"
					,
					"#### # #####  # ##"
					,
					"'''# #       $#  #"
					,
					"'''# # $ $ $$  # #"
					,
					"'''#  #####    # #"
					,
					"'''##      #   # #"
					,
					"''''######  ###  #"
					,
					"'''''''''##     ##"
					,
					"''''''''''#######'"
				}
				,
				{
					"''''''#''''''"
					,
					"''''## ##''''"
					,
					"''''#   #''''"
					,
					"'''# .$. #'''"
					,
					"'##  $.$  ##'"
					,
					"'# .$.$.$. #'"
					,
					"#  $.$+$.$  #"
					,
					"'# .$.$.$. #'"
					,
					"'##  $.$$ ##'"
					,
					"'''# .$.    #"
					,
					"''''#   # # #"
					,
					"''''## ##   #"
					,
					"''''''#''###'"
				}
				,
				{
					"#####'''''''''''''''''''"
					,
					"#   ##''''''''''''''''''"
					,
					"#  $ #####''''''''''''''"
					,
					"##  $ #  #''''''''''''''"
					,
					"'## $ # $###########''''"
					,
					"''##      $ $ $ $  #''''"
					,
					"'''#####$ # # #  # #''''"
					,
					"'''''''#      #    #''''"
					,
					"'''''''# #######$#######"
					,
					"''''''##         #@#   #"
					,
					"''''''#  # # ##  #     #"
					,
					"''''''#..*.*.*......   #"
					,
					"''''''##########    # ##"
					,
					"'''''''''''''''####   #'"
					,
					"''''''''''''''''''#####'"
				}
				,
				{
					"'#####''#####"
					,
					"'#   ####   #"
					,
					"## #$.*.$ # #"
					,
					"#   $.@.$   #"
					,
					"# # $.*.$# ##"
					,
					"#   ####   #'"
					,
					"#####''#####'"
				}
				,
				{
					"'''''''''#####'"
					,
					"##########   #'"
					,
					"#      $ $$$ #'"
					,
					"# $## #  # # #'"
					,
					"# $    # # # #'"
					,
					"##$## .#.    #'"
					,
					"'#   ..... # #'"
					,
					"'#$ ##.@.## $#'"
					,
					"'# # .....   #'"
					,
					"'#    .#. ##$##"
					,
					"'# # # #    $ #"
					,
					"'# # #  # ##$ #"
					,
					"'# $$$ $      #"
					,
					"'#   ##########"
					,
					"'#####'''''''''"
				}
				,
				{
					"'#######'#######'"
					,
					"##  .  ###     ##"
					,
					"# $$.$$ # .$.$. #"
					,
					"# $ . $ # $.$.$ #"
					,
					"#...#...  .$@$. #"
					,
					"# $ . $ # $.$.$ #"
					,
					"# $$.$$ # .$.$. #"
					,
					"##  .  ###     ##"
					,
					"'### ###'### ###'"
					,
					"##     ###     ##"
					,
					"# .$.$. # .$$$. #"
					,
					"# $.$.$ # $...$ #"
					,
					"# .$ $.   $.#.$ #"
					,
					"# $.$.$ # $...$ #"
					,
					"# .$.$. # .$$$. #"
					,
					"##     ###     ##"
					,
					"'#######'#######'"
				}
				,
				{
					"''''''''''''#####''''''''''''"
					,
					"''''''''#####   #####''''''''"
					,
					"''''#####   # $ #   #####''''"
					,
					"#####   # $$     $$ #   #####"
					,
					"#   #$$ .   ##$##   . $$#   #"
					,
					"# $$.   ##### . #####   .$$ #"
					,
					"#   #####   ##.##   #####   #"
					,
					"##$ #   #.... . ....#   # $##"
					,
					"'#  . $ .   # @ #   . $ .  #'"
					,
					"##$ #   #.... . ....#   # $##"
					,
					"#   #####   ##.##   #####   #"
					,
					"# $$.   ##### . #####   .$$ #"
					,
					"#   #$$ .   ##$##   . $$#   #"
					,
					"#####   # $$     $$ #   #####"
					,
					"''''#####   # $ #   #####''''"
					,
					"''''''''#####   #####''''''''"
					,
					"''''''''''''#####''''''''''''"
				}
				,
				{
					"#####'''''''''''''''''#####"
					,
					"#   ###################   #"
					,
					"# # $ $ $ $ $ $ $ $ $ $ # #"
					,
					"# $ #     #     #     # $ #"
					,
					"##  #.###.#.###.#.###.#  ##"
					,
					"'#$ #  .  #  *  #  .  # $#'"
					,
					"'#  .  #  .  #  .  #  .  #'"
					,
					"'#$###.#.###.@.###.#.###$#'"
					,
					"'#  .  #  .  #  .  #  .  #'"
					,
					"'#$ #  .  #  *  #  .  # $#'"
					,
					"##  #.###.#.###.#.###.#  ##"
					,
					"# $ #     #     #     # $ #"
					,
					"# # $ $ $ $ $ $ $ $ $ $ # #"
					,
					"#   ###################   #"
					,
					"#####'''''''''''''''''#####"
				}
				,
				{
					"'#################'"
					,
					"'#               #'"
					,
					"##$#.#.#.#.#.#.#$##"
					,
					"#  $.$.$.$.$.$.$  #"
					,
					"#  #$#$ $@$ $#$#  #"
					,
					"#  $.$.$.$.$.$.$  #"
					,
					"##$#.#.#.#.#.#.#$##"
					,
					"'#               #'"
					,
					"'#################'"
				}
				,
				{
					"''''''''''''''''#####'''''''''"
					,
					"''###############   ########''"
					,
					"'## $ $ $ $ $    $ $ $ $ $ ##'"
					,
					"###     #         #        ###"
					,
					"#  #.##.#.##.#.##.#.##.#.##  #"
					,
					"# $#  .$ $  $#  .$ $  $#  .$ #"
					,
					"#  .  #$  $ $.  #$  $ $.  #  #"
					,
					"# $##.#.##.#.##.#.##.#.##.#$ #"
					,
					"##      .  #   @  .  #      ##"
					,
					"##      #  .      #  .      ##"
					,
					"# $#.##.#.##.#.##.#.##.#.##$ #"
					,
					"#  #  .$ $  $#  .$ $  $#  .  #"
					,
					"# $.  #$  $ $.  #$  $ $.  #$ #"
					,
					"#  ##.#.##.#.##.#.##.#.##.#  #"
					,
					"###        #         #     ###"
					,
					"'## $ $ $ $ $    $ $ $ $ $ ##'"
					,
					"''########   ###############''"
					,
					"'''''''''#####''''''''''''''''"
				}
				,
				{
					"'###########'"
					,
					"##    #    ##"
					,
					"# $$*.$.*$$ #"
					,
					"#...     ...#"
					,
					"# $$*.$.*$$ #"
					,
					"##    *    ##"
					,
					"# $$*.$.*$$ #"
					,
					"#...  @  ...#"
					,
					"# $$*.$.*$$ #"
					,
					"##    #    ##"
					,
					"'###########'"
				}
				,
				{
					"###########''''''''''''"
					,
					"#         #''''''''''''"
					,
					"# $## ### ##'''#####'''"
					,
					"#  # $ $ $ #####   ###'"
					,
					"# $    #     # $. .  #'"
					,
					"#  ##$###$## # #...# #'"
					,
					"# $    #     # #. .# ##"
					,
					"## # $ $ $## # #...#  #"
					,
					"#  ## ### #. # #. . # #"
					,
					"# $       #    #    # #"
					,
					"# @######## ###     # #"
					,
					"####'''''#       ###  #"
					,
					"'''''''''# ####  #   ##"
					,
					"'''''''''#     ##  ###'"
					,
					"'''''''''#####    ##'''"
					,
					"'''''''''''''######''''"
				}
				,
				{
					"'''''''''#######''''''''''''''"
					,
					"''########  #. #''''''''''''''"
					,
					"''#        $ * #####''''''''''"
					,
					"''# ## ##   #. #   #''''''####"
					,
					"### # $ $$#$#. # # ########  #"
					,
					"#  $#   #  $ * #......       #"
					,
					"# $    ### $#.  #  ####      #"
					,
					"## # #$$ # $ .# #  #''##     #"
					,
					"'# #   $   @##  # ##'''##   ##"
					,
					"'#  ##  $$$ #  ## ###'''#####'"
					,
					"'##  #.##.###       #'''''''''"
					,
					"''## #*$.*...  ##   #'''''''''"
					,
					"'''#   #   ##  ##  ##'''''''''"
					,
					"'''###   ###########''''''''''"
					,
					"'''''#####''''''''''''''''''''"
				}
				,
				{
					"'''''#######'''''"
					,
					"'''''#  @  #'''''"
					,
					"###### ### ######"
					,
					"#   #   $   #   #"
					,
					"#   $   #   $   #"
					,
					"##$###*###*###$##"
					,
					"#   $   #   $   #"
					,
					"#   #   *   #   #"
					,
					"##$###*###*###$##"
					,
					"#   #   $   #   #"
					,
					"# ..*...#...*.. #"
					,
					"###### ### ######"
					,
					"'''''#     #'''''"
					,
					"'''''#######'''''"
				}
				,
				{
					"''''''''''''''####''''"
					,
					"'''''''''''#### .#''''"
					,
					"'''''####''#    .####'"
					,
					"'''###  ####  ##..  ##"
					,
					"'''#  $ #  #$ #...   #"
					,
					"'''# #  #  #  #...   #"
					,
					"'''# #$ # $ $ #      #"
					,
					"####  $    #  #    @##"
					,
					"#     # #$$#####   ##'"
					,
					"#   $ $ #  #'''#####''"
					,
					"######  #  #''''''''''"
					,
					"'''''####  #''''''''''"
					,
					"''''''''####''''''''''"
				}
				,
				{
					"'''''''''####'####''''''''''''"
					,
					"'''''''''#  ###  #''''''''''''"
					,
					"''''''#### $ $   #######''''''"
					,
					"''''''#   $   #$   ##  ####'''"
					,
					"''''''# ### ###        #  #'''"
					,
					"'''''##  $   ###### #     #'''"
					,
					"'''''#  $ # ##    #####   #'''"
					,
					"'''''# # #  #  # $$ # ## ###''"
					,
					"'''''# #    #$.## $        #''"
					,
					"'''''# ######   $  # ###   ##'"
					,
					"'''''#....*.**.# #   #'#   ##'"
					,
					"'''''####      # #####'#####''"
					,
					"'''''''##$## ###$#''''''''''''"
					,
					"''''''##  #   $  #''''''''''''"
					,
					"#######   # $    #############"
					,
					"# $      ###### ##         @ #"
					,
					"#        .........           #"
					,
					"##############################"
				}
				,
				{
					"''''''#####''''''"
					,
					"''''''# . #''''''"
					,
					"''##### . #####''"
					,
					"''#   $ . $   #''"
					,
					"''# $ ##.## $ #''"
					,
					"''#   # $ #   #''"
					,
					"###$##     ##$###"
					,
					"#   #  ***  #   #"
					,
					"#....$ *@* $....#"
					,
					"#   #  ***  #   #"
					,
					"###$##     ##$###"
					,
					"''#   # $ #   #''"
					,
					"''# $ ##.## $ #''"
					,
					"''#   $ . $   #''"
					,
					"''##### . #####''"
					,
					"''''''# . #''''''"
					,
					"''''''#####''''''"
				}
				,
				{
					"''''''''#''''''''"
					,
					"'''''''# #'''''''"
					,
					"'''''##   ##'''''"
					,
					"'''''# $.$ #'''''"
					,
					"''''#  . .  #''''"
					,
					"''## $.$.$.$ ##''"
					,
					"''#  . # # .  #''"
					,
					"'# $.$# $ #$.$ #'"
					,
					"#  . . $@$ . .  #"
					,
					"'# $.$# $ #$.$ #'"
					,
					"''#  . # # .  #''"
					,
					"''## $.$.$.$ ##''"
					,
					"''''#  . .  #''''"
					,
					"'''''# $.$ #'''''"
					,
					"'''''##   ##'''''"
					,
					"'''''''# #'''''''"
					,
					"''''''''#''''''''"
				}
				,
				{
					"''''####'''''''''''''''"
					,
					"''''#  ######''''''''''"
					,
					"''''#  $ $  ###''''####"
					,
					"''''#   $     #'''##  #"
					,
					"#####*#*#$$$  #''## $ #"
					,
					"#     $ $   $ #'##    #"
					,
					"#  #$    $ $##### $$ ##"
					,
					"## # ####  .....#   ##'"
					,
					"#      # $  **.## ###''"
					,
					"#   #  # $$ #.##.   #''"
					,
					"##     #    #.#+* # #''"
					,
					"'#     ######.##..$ #''"
					,
					"'#######'# $..##.####''"
					,
					"'''''''''# # *..*.#''''"
					,
					"'''''''''#   .#.  #''''"
					,
					"'''''''''######$# #''''"
					,
					"''''''''''''''#   #''''"
					,
					"''''''''''''''#####''''"
				}
				,
				{
					"#############################"
					,
					"#.      .   .   .   .      .#"
					,
					"# ##  # #   # # #   # #  ## #"
					,
					"# ##  $ # $ # $ # $ # $  ## #"
					,
					"#  ##$$$#$$$#$$$#$$$#$$$##  #"
					,
					"#   $...$...$...$...$...$   #"
					,
					"#  $$.#.$.#.$.#.$.#.$.#.$$  #"
					,
					"#   $...$...$...$...$...$   #"
					,
					"#.###$$$#$$$#$@$#$$$#$$$###.#"
					,
					"#   $...$...$...$...$...$   #"
					,
					"#  $$.#.$.#.$.#.$.#.$.#.$$  #"
					,
					"#   $...$...$...$...$...$   #"
					,
					"#  ##$$$#$$$#$$$#$$$#$$$##  #"
					,
					"# ##  $ # $ # $ # $ # $  ## #"
					,
					"# ##  # #   # # #   # #  ## #"
					,
					"#.      .   .   .   .      .#"
					,
					"#############################"
				}
		});

		// level: Sasquatch III
		levelMaps.add(new String[][] {
				{
					"'#######"
					,
					"'#  *  #"
					,
					"'#  @  #"
					,
					"'##$#.##"
					,
					"'#  #  #"
					,
					"'# $#. #"
					,
					"'#  #  #"
					,
					"## ## ##"
					,
					"#  * * #"
					,
					"#   *  #"
					,
					"###   ##"
					,
					"''#####'"
				}
				,
				{
					"''''''####'''"
					,
					"#######  #'''"
					,
					"#     * .##''"
					,
					"# $$#  *  ##'"
					,
					"# $@ #* *  ##"
					,
					"## $ # * *  #"
					,
					"'### #. * * #"
					,
					"'#   .  #  .#"
					,
					"'#   #  #####"
					,
					"'########''''"
				}
				,
				{
					"''''''''####'"
					,
					"#########  #'"
					,
					"#          #'"
					,
					"# #*### #  #'"
					,
					"#  $   #'# #'"
					,
					"#*#*##  #  #'"
					,
					"#  $  #  # #'"
					,
					"#  *#  # # #'"
					,
					"#  $ # # # ##"
					,
					"###$. . . . #"
					,
					"''#@####### #"
					,
					"''#         #"
					,
					"''###########"
				}
				,
				{
					"'''#############''"
					,
					"''##           #''"
					,
					"'##  #########@###"
					,
					"##  #         *  #"
					,
					"#  ## ########*# #"
					,
					"# #  $ $ $ $   # #"
					,
					"# #$.. . . ..$#  #"
					,
					"# # .#######. # ##"
					,
					"#  $.#######.$# #'"
					,
					"### . . . . . # #'"
					,
					"''# $ $ $ $ $ # #'"
					,
					"''######### ##  #'"
					,
					"''''''''''# $ $ #'"
					,
					"''''''''''#     #'"
					,
					"''''''''''#######'"
				}
				,
				{
					"'###########'''"
					,
					"##         #'''"
					,
					"#  #######$##''"
					,
					"# #       $ ###"
					,
					"# #...***.*.@ #"
					,
					"# #       $ # #"
					,
					"#  #######$#  #"
					,
					"##        $  ##"
					,
					"'########   ##'"
					,
					"''''''''#####''"
				}
				,
				{
					"'''''''''''''####''"
					,
					"'''''#########  ###"
					,
					"'''''#  . .   . . #"
					,
					"'''''# $$.$# #$.$ #"
					,
					"'''''## . .# #. . #"
					,
					"''''''# $ $#  $ $ #"
					,
					"''''''# $  #* #####"
					,
					"'''''##### # ##''''"
					,
					"'''''#   @   #'''''"
					,
					"''''## # #####'''''"
					,
					"##### *#  $ #''''''"
					,
					"# $ $  #$ $ #''''''"
					,
					"# . .# #. . ##'''''"
					,
					"# $.$# #$.$$ #'''''"
					,
					"# . .   . .  #'''''"
					,
					"###  #########'''''"
					,
					"''####'''''''''''''"
				}
				,
				{
					"''#####'''''"
					,
					"''#   #####'"
					,
					"### #     ##"
					,
					"#  * ####  #"
					,
					"#  * ##  # #"
					,
					"#  *  ** # #"
					,
					"#   #    # #"
					,
					"#@#** * ## #"
					,
					"###  #$  # #"
					,
					"'# .$ .* # #"
					,
					"'#   #  #  #"
					,
					"'##  #    ##"
					,
					"''#########'"
				}
				,
				{
					"'''''''####"
					,
					"########@ #"
					,
					"#   ...#$ #"
					,
					"# $ $ $ * #"
					,
					"#####   . #"
					,
					"'''##$#$. #"
					,
					"'###. # .##"
					,
					"'#  .$#$ #'"
					,
					"'#  .$   #'"
					,
					"'###.$#  #'"
					,
					"'''#  ####'"
					,
					"'''####''''"
				}
				,
				{
					"''''''''#''''"
					,
					"'###########'"
					,
					"'#   #  #  #'"
					,
					"'# $ #$ $  #'"
					,
					"'#$.*.*.#* #'"
					,
					"'# .    $. #'"
					,
					"'#$.$#.  .$#'"
					,
					"## .$   #* ##"
					,
					"#  .#.*##.  #"
					,
					"# $ $   $   #"
					,
					"### # # #####"
					,
					"''##@   #''''"
					,
					"'''######''''"
				}
				,
				{
					"'''''''''''#'''''"
					,
					"''''#'''''# #''''"
					,
					"'''# #''##   ##''"
					,
					"''# . #'# .$. #''"
					,
					"'# $.$ # .$ $. #'"
					,
					"#   *  @ $ * $  #"
					,
					"'# $.$ # .$ $. #'"
					,
					"''# . #'# .$. #''"
					,
					"'''# #''##   ##''"
					,
					"''''#'''''# #''''"
					,
					"'''''''''''#'''''"
				}
				,
				{
					"'''''''#'''''''''''''"
					,
					"''''''# #''''''''''''"
					,
					"''''##   ##''''''''''"
					,
					"''''#  .  #'''''#''''"
					,
					"''## $.$.$ ##''# #'''"
					,
					"''# $.$.$.$ #'# . #''"
					,
					"'#  .$.$.$.  # $.$ #'"
					,
					"#  .$.$@$.$.    *   #"
					,
					"'#  .$.$.$.  # $.$ #'"
					,
					"''# $.$.$.$ #'# . #''"
					,
					"''## $.$.$ ##''# #'''"
					,
					"''''#  .  #'''''#''''"
					,
					"''''##   ##''''''''''"
					,
					"''''''# #''''''''''''"
					,
					"'''''''#'''''''''''''"
				}
				,
				{
					"########''"
					,
					"#  . . #''"
					,
					"# $.$. #''"
					,
					"##$#$# ##'"
					,
					"'# . .  #'"
					,
					"'#$#$# @#'"
					,
					"'# . .  #'"
					,
					"##$#$# ##'"
					,
					"#  . . #''"
					,
					"# $#$# ###"
					,
					"##   . . #"
					,
					"'###$#$# #"
					,
					"'''# .   #"
					,
					"'''#$# ###"
					,
					"'''#   #''"
					,
					"'''#####''"
				}
				,
				{
					"'''''''####''"
					,
					"########  #''"
					,
					"#@ $ $ $$ ###"
					,
					"#  ....*.*  #"
					,
					"## ### ..*# #"
					,
					"'#$$  # .*  #"
					,
					"'# # $ #.*# #"
					,
					"'#   $ #..  #"
					,
					"'##  $    ###"
					,
					"''### #$#.#''"
					,
					"'''# $ $  #''"
					,
					"'''#     ##''"
					,
					"'''#######'''"
				}
				,
				{
					"''''''''''#####"
					,
					"''#########   #"
					,
					"### $ $ $ $.  #"
					,
					"#  .$.$ $.$.# #"
					,
					"# #.*..@..*.# #"
					,
					"# #.$.$ $.$.  #"
					,
					"#  .$ $ $ $ ###"
					,
					"#   #########''"
					,
					"#####''''''''''"
				}
				,
				{
					"'''''''''''#####'''''''"
					,
					"############   #######'"
					,
					"#     # # ## # # #   #'"
					,
					"# # #$  $  # .$  $ # ##"
					,
					"#  ..*.** *@* **.*..  #"
					,
					"## # $  $. #  $  $# # #"
					,
					"'#   # # # ## # #     #"
					,
					"'#######   ############"
					,
					"'''''''#####'''''''''''"
				}
				,
				{
					"'#########'"
					,
					"##   *   ##"
					,
					"#  # # #  #"
					,
					"# #.$.$.# #"
					,
					"#  $.$.$  #"
					,
					"#*#.$@$.#*#"
					,
					"#  $.$.$  #"
					,
					"# #.$.$.# #"
					,
					"#  # # #  #"
					,
					"##   *   ##"
					,
					"'#########'"
				}
				,
				{
					"'''''''''#'''''''"
					,
					"''''#''#####'''''"
					,
					"''#####    ####''"
					,
					"''#   ..$$ #  #''"
					,
					"''# $ $ .#@#$ ##'"
					,
					"'#### # *##   #''"
					,
					"'#   #  *  #$.#''"
					,
					"## $##  .    . #'"
					,
					"'# $.**.#.**.$ #'"
					,
					"'# .    .  ##$ ##"
					,
					"''#.$#  *  #   #'"
					,
					"''#   ##* # ####'"
					,
					"'## $# #. $ $ #''"
					,
					"''#  # $$..   #''"
					,
					"''####    #####''"
					,
					"'''''#####''#''''"
					,
					"'''''''#'''''''''"
				}
				,
				{
					"'#############'"
					,
					"##    #   #  ##"
					,
					"# .##$$  $  . #"
					,
					"#  ...#.#.#.# #"
					,
					"## # $ $   .# #"
					,
					"# $. # # #$.$ #"
					,
					"#  #  $ $  #$##"
					,
					"#  .$# @ #$.  #"
					,
					"##$#  $ $  #  #"
					,
					"# $.$# # # .$ #"
					,
					"# #.   $ $ # ##"
					,
					"# #.#.#.#...  #"
					,
					"# .  $  $$##. #"
					,
					"##  #   #    ##"
					,
					"'#############'"
				}
				,
				{
					"'#############'"
					,
					"##     *     ##"
					,
					"#  ##.# ##.#  #"
					,
					"# # $ $ $ $ # #"
					,
					"# .$. ##  .$# #"
					,
					"# #  # . #  . #"
					,
					"# #$  $.$ #$# #"
					,
					"#*  #..@..#  *#"
					,
					"# #$# $.$  $# #"
					,
					"# .  # . #  # #"
					,
					"# #$.  ## .$. #"
					,
					"# # $ $ $ $ # #"
					,
					"#  #.## #.##  #"
					,
					"##     *     ##"
					,
					"'#############'"
				}
				,
				{
					"'###'###'###'"
					,
					"##  # @ #  ##"
					,
					"#  $#$ $#$  #"
					,
					"# . . . . . #"
					,
					"'##$#$ $#$##'"
					,
					"# . . . . . #"
					,
					"#  $ $#$ $  #"
					,
					"# . . . . . #"
					,
					"'##$#$ $#$##'"
					,
					"# . . . . . #"
					,
					"#  $#$ $#$  #"
					,
					"##  #   #  ##"
					,
					"'###'###'###'"
				}
				,
				{
					"'''###'''###'''"
					,
					"'''#  ###  #'''"
					,
					"''#    #    #''"
					,
					"##  $$$.$$$  ##"
					,
					"#  .# . . #.  #"
					,
					"#  . # $ # .  #"
					,
					"'# .$ #.# $. #'"
					,
					"'##$ .$@$. $##'"
					,
					"'# .$ #.# $. #'"
					,
					"#  . # $ # .  #"
					,
					"#  .# . . #.  #"
					,
					"##  $$$.$$$  ##"
					,
					"''#    #    #''"
					,
					"'''#  ###  #'''"
					,
					"'''###'''###'''"
				}
				,
				{
					"'''###########'''"
					,
					"''#           #''"
					,
					"'##$####.####$##'"
					,
					"# $. $ $.$ $ .$ #"
					,
					"# # ...   ... # #"
					,
					"# #$.$ $.$ $.$# #"
					,
					"# # . *#.#* . # #"
					,
					"# #$ $# $ #$ $# #"
					,
					"# .. ..$@$.. .. #"
					,
					"# #$ $# $ #$ $# #"
					,
					"# # . *#.#* . # #"
					,
					"# #$.$ $.$ $.$# #"
					,
					"# # ...   ... # #"
					,
					"# $. $ $.$ $ .$ #"
					,
					"'##$####.####$##'"
					,
					"''#           #''"
					,
					"'''###########'''"
				}
				,
				{
					"'####'###'####'"
					,
					"#    #   #    #"
					,
					"# #  #   #  # #"
					,
					"#  **$***$**  #"
					,
					"#  * .   . *  #"
					,
					"'##$.## ##.$##'"
					,
					"#  * #   # *  #"
					,
					"#  *   @   *  #"
					,
					"#  * #   # *  #"
					,
					"'##$.## ##.$##'"
					,
					"#  * .   . *  #"
					,
					"#  **$***$**  #"
					,
					"# #  #   #  # #"
					,
					"#    #   #    #"
					,
					"'####'###'####'"
				}
				,
				{
					"'###############'"
					,
					"'#.  $  .  $  .#'"
					,
					"'# ##$# # #$## #'"
					,
					"'#  .* .#. *.  #'"
					,
					"'# #   *$*   # #'"
					,
					"##$$*   #   *$$##"
					,
					"#  #. $. .$ .#  #"
					,
					"#@   #* * *#    #"
					,
					"#  #. $. .$ .#  #"
					,
					"##$$*   #   *$$##"
					,
					"'# #   *$*   # #'"
					,
					"'#  .* .#. *.  #'"
					,
					"'# ##$# # #$## #'"
					,
					"'#.  $  .  $  .#'"
					,
					"'###############'"
				}
				,
				{
					"#'####''#''####'#"
					,
					"'#    #'''#    #'"
					,
					"# *.   ###   .* #"
					,
					"# $# $ $ $ $ #$ #"
					,
					"#   # .* *. #   #"
					,
					"#  . #  $  # .  #"
					,
					"'#  $ ##$## $  #'"
					,
					"''#.* # . # *.#''"
					,
					"#'#  ..$@$..  #'#"
					,
					"''#.* # . # *.#''"
					,
					"'#  $ ##$## $  #'"
					,
					"#  . #  $  # .  #"
					,
					"#   # .* *. #   #"
					,
					"# $# $ $ $ $ #$ #"
					,
					"# *.   ###   .* #"
					,
					"'#    #'''#    #'"
					,
					"#'####''#''####'#"
				}
				,
				{
					"'###############'"
					,
					"##      #      ##"
					,
					"# *$ $*$$$*$ $* #"
					,
					"# $...$...$...$ #"
					,
					"#  .$.$.$.$.$.  #"
					,
					"# $...$...$...$ #"
					,
					"# *$$$*$$$*$$$* #"
					,
					"# $...$...$...$ #"
					,
					"##$.$.$.@.$.$.$##"
					,
					"# $...$...$...$ #"
					,
					"# *$$$*$$$*$$$* #"
					,
					"# $...$...$...$ #"
					,
					"#  .$.$.$.$.$.  #"
					,
					"# $...$...$...$ #"
					,
					"# *$ $*$$$*$ $* #"
					,
					"##      #      ##"
					,
					"'###############'"
				}
				,
				{
					"''#############''"
					,
					"'## .   .   . ##'"
					,
					"## $.$ $.$ $.$ ##"
					,
					"# $ * $ * $ * $ #"
					,
					"#..*.*.*.*.*.*..#"
					,
					"# $ * $ * $ * $ #"
					,
					"#  $.$.$.$.$.$  #"
					,
					"# $ * $ * $ * $ #"
					,
					"#..*.*.*@*.*.*..#"
					,
					"# $ * $ * $ * $ #"
					,
					"#  $.$.$.$.$.$  #"
					,
					"# $ * $ * $ * $ #"
					,
					"#..*.*.*.*.*.*..#"
					,
					"# $ * $ * $ * $ #"
					,
					"## $.$ $.$ $.$ ##"
					,
					"'## .   .   . ##'"
					,
					"''#############''"
				}
				,
				{
					"''''''#####''''''"
					,
					"'''#### . ####'''"
					,
					"'''#'##$.$##'#'''"
					,
					"'####   .   ####'"
					,
					"'#'## $$.$$ ##'#'"
					,
					"'##  ## . ##  ##'"
					,
					"### $##$.$##$ ###"
					,
					"# $ $ $...$ $ $ #"
					,
					"#.......@.......#"
					,
					"# $ $ $...$ $ $ #"
					,
					"### $##$.$##$ ###"
					,
					"'##  ## . ##  ##'"
					,
					"'#'## $$.$$ ##'#'"
					,
					"'####   .   ####'"
					,
					"'''#'##$.$##'#'''"
					,
					"'''#### . ####'''"
					,
					"''''''#####''''''"
				}
				,
				{
					"#################''''''''''''"
					,
					"#  .    .    .  #''''''''''''"
					,
					"# ##$###$###$## #############"
					,
					"#.##  ##  ## ##.#  .     .  #"
					,
					"# $   *   *   $ # ##$###$## #"
					,
					"# ##  #   #   # #.##  ## ##.#"
					,
					"# ##*###*###*## # $   *   $ #"
					,
					"# #   #   #  ## # ##  #   # #"
					,
					"#.$   *   *   $.@ ##*###*## #"
					,
					"# ##  #   #   # # #   #  ## #"
					,
					"# ##*###*###*## # $   *   $ #"
					,
					"# #   #   #  ## #.## ##  ##.#"
					,
					"# $   *   *   $ # ##$###$## #"
					,
					"#.## ##  ##  ##.#  .     .  #"
					,
					"# ##$###$###$## #############"
					,
					"#  .    .    .  #''''''''''''"
					,
					"#################''''''''''''"
				}
				,
				{
					"'###############''''''''''''''"
					,
					"##             ##'''''''''''''"
					,
					"#  ##### #####  #'###########'"
					,
					"# # . . . . . # ###         ##"
					,
					"# #$ $ $ $ $ $#     ### ###  #"
					,
					"# # .#.#.#.#. # ## # . . . # #"
					,
					"# #$ $ $ $ $ $# ## #$ $ $ $# #"
					,
					"# # .#.#.#.#. # ## # .#.#. # #"
					,
					"#  $ $ $@$ $ $  ##  $ $ $ $  #"
					,
					"# # .#.#.#.#. # ## # .#.#. # #"
					,
					"# #$ $ $ $ $ $# ## #$ $ $ $# #"
					,
					"# # .#.#.#.#. # ## # . . . # #"
					,
					"# #$ $ $ $ $ $#     ### ###  #"
					,
					"# # . . . . . # ###         ##"
					,
					"#  ##### #####  #'###########'"
					,
					"##             ##'''''''''''''"
					,
					"'###############''''''''''''''"
				}
				,
				{
					"'''#####'#####'''''"
					,
					"'###    #  @ ####''"
					,
					"##    # $  #    ##'"
					,
					"#   #..*.#*...#  #'"
					,
					"# # . $# $ $# .  #'"
					,
					"#   .#    #  $.#  #"
					,
					"#  #.$  #$   #*   #"
					,
					"'#. * #  $ #  .$# #"
					,
					"# $ #$ $$#$$ $# $ #"
					,
					"# #$.  # $  # * .#'"
					,
					"#   *#   $#  $.#  #"
					,
					"#  #.$  #    #.   #"
					,
					"'#  . #$ $ #$ . # #"
					,
					"'#  #...*#.*..#   #"
					,
					"'##    #  $ #    ##"
					,
					"''####    #    ###'"
					,
					"'''''#####'#####'''"
				}
				,
				{
					"'''######''#####'''''"
					,
					"''##    ####   #'''''"
					,
					"''#  ##  $   # #'''''"
					,
					"''# # .# $# $  #'''''"
					,
					"''# #$.$  #   #######"
					,
					"''#  $. # ### #     #"
					,
					"''### .$. . # #.$.$ #"
					,
					"'''# $. ###$#$# ## ##"
					,
					"####  #$        #   #"
					,
					"#   # $ ###@###.    #"
					,
					"# $     #  #..  #..##"
					,
					"###### #    ..# .  #'"
					,
					"''''#   $$ #..## ..#'"
					,
					"''''#  $ $##     # #'"
					,
					"''''# $$       #   #'"
					,
					"''''#  #############'"
					,
					"''''####'''''''''''''"
				}
				,
				{
					"'''''''''####'''''"
					,
					"'''#######  ####''"
					,
					"'''#         $ ##'"
					,
					"####$  ###.###  ##"
					,
					"#   $ #  #.#  #  #"
					,
					"# # $ #   .  @ # #"
					,
					"# #   #..###   # #"
					,
					"# # $#....  #  # #"
					,
					"# #  #...#$  # # #"
					,
					"# #$ # ## $$ $ # #"
					,
					"# #  # .*    ##  #"
					,
					"# #$$## #  ##   ##"
					,
					"# #     ###   ###'"
					,
					"#  ####$    ###'''"
					,
					"##      #####'''''"
					,
					"'########'''''''''"
				}
				,
				{
					"''''''''''''####''''"
					,
					"''''#####'''#  #####"
					,
					"'''##   #'''#      #"
					,
					"'''#  # ##### # #  #"
					,
					"'''# # $ $ $ $ #  ##"
					,
					"'''# #       #  # #'"
					,
					"'''#  ######$## # #'"
					,
					"####  # *  #  # # #'"
					,
					"#   $ # .. $  # # #'"
					,
					"# # # #*...# #  # #'"
					,
					"# .***#. ..#   ## ##"
					,
					"##*....*.*  $ #    #"
					,
					"'##* ##.##### # $  #"
					,
					"''##  #     $  # # #"
					,
					"'''##@ #.#$ $ $ $# #"
					,
					"''''##    $ $  #   #"
					,
					"'''''##  ###########"
					,
					"''''''####''''''''''"
				}
				,
				{
					"''''''''''''''####"
					,
					"'####'''''''###  #"
					,
					"'#  #########  ..#"
					,
					"'#  $ @ $   $ #..#"
					,
					"'# $# $   # # #..#"
					,
					"'#  ##*##$#$#$#..#"
					,
					"'# $ #..#.      ##"
					,
					"'#   #*. .##$## #'"
					,
					"##$ $#..#.      #'"
					,
					"#    ##$#########'"
					,
					"#   $$ $ #''''''''"
					,
					"##       #''''''''"
					,
					"'#########''''''''"
				}
				,
				{
					"'''''''''''#####'''''''''''"
					,
					"''''''''''## . ##''''''''''"
					,
					"'''''''''##.$ $.##'''''''''"
					,
					"'''''''''# $ * $ #'''''''''"
					,
					"'''''''''#. * * .#'''''''''"
					,
					"'''''''''# $ * $ #'''''''''"
					,
					"'''''''''##.$ $.##'''''''''"
					,
					"'#######''## . ##''#######'"
					,
					"##     ##''## ##''##     ##"
					,
					"# .$.$. #'''# #'''# $.$.$ #"
					,
					"# $.$.$ ##### ##### .$.$. #"
					,
					"# .$ $.             $.@.$ #"
					,
					"# $.$.$ ########### .$.$. #"
					,
					"# .$.$. #'''''''''# $.$.$ #"
					,
					"##     ##''#####''##     ##"
					,
					"'#######'''#***#'''#######'"
					,
					"'''''''''''#####'''''''''''"
				}
				,
				{
					"#########'''''#######"
					,
					"#   #   #######  #  #"
					,
					"# .$. $       # . . #"
					,
					"## ### # # # $ $ #$ #"
					,
					"# . #  #.$ $.## ##.##"
					,
					"#  $ .$ .# #. #. #  #"
					,
					"### ## #.$ $.  $  $ #"
					,
					"##  #  ##$$ .## ##  #"
					,
					"#  ## ##. $$##  #  ##"
					,
					"# $  $  .$ $.# ## ###"
					,
					"#  # .# .# #. $. $  #"
					,
					"##.## ##.$ $.#  # . #"
					,
					"# $# $ $ # # # ### ##"
					,
					"# . . #   @   $ .$. #"
					,
					"#  #  #######   #   #"
					,
					"#######'''''#########"
				}
				,
				{
					"#####'''''''###'''"
					,
					"#  ###############"
					,
					"# $   * @ *  #   #"
					,
					"#  # * * * *     #"
					,
					"## #  * . *  # ###"
					,
					"'# # * * * * # #''"
					,
					"'# #  * . *  # #''"
					,
					"'# # * * * * # #''"
					,
					"## #  * . *  # ##'"
					,
					"## ###########  #'"
					,
					"# $           $ #'"
					,
					"#   ##########  #'"
					,
					"#####'''''''#####'"
				}
				,
				{
					"'''####'''####'''''"
					,
					"'''#  #####  ####''"
					,
					"#### $ $        ##'"
					,
					"#   $   ###  ##  ##"
					,
					"#@### # ###.#..#  #"
					,
					"#  $  # #      .# #"
					,
					"# $ # # #   #  .  #"
					,
					"## #  # ###########"
					,
					"'#   ## $ $ $ #''''"
					,
					"'###### #.#.#.###''"
					,
					"''''#     # #   #''"
					,
					"''''# # #.#.#.# #''"
					,
					"''''# # $ $ $ # #''"
					,
					"''''#  #  # # # #''"
					,
					"''''##  ###   # #''"
					,
					"'''''##    ###  #''"
					,
					"''''''####     ##''"
					,
					"'''''''''#######'''"
				}
				,
				{
					"''#######'##'#######'''''''''"
					,
					"''#     ######     ##''''''''"
					,
					"''#.###  ##  .  ##  ##'''''''"
					,
					"''# .  #  $*# .#  #  #'''''''"
					,
					"''# #.  ###.#  *$  # #######'"
					,
					"''# $ *    ###  .  #       ##"
					,
					"'###$# * $$  ##$ .########  #"
					,
					"##  $ # *  #  # # .   #   # #"
					,
					"#  $$  $#. .# @ #. .#$  $$  #"
					,
					"# #   #   . # #  #  * # $  ##"
					,
					"#  ########. $##  $$ * #$###'"
					,
					"##       #  .  ###    * $ #''"
					,
					"'####### #  $*  #.###  .# #''"
					,
					"'''''''#  #  #. #*$  #  . #''"
					,
					"'''''''##  ##  .  ##  ###.#''"
					,
					"''''''''##     ######     #''"
					,
					"'''''''''#######'##'#######''"
				}
				,
				{
					"##############################"
					,
					"#        .........           #"
					,
					"# $      ###### ##         @ #"
					,
					"#######   # $    #############"
					,
					"''''''##  #   $  #''''''''''''"
					,
					"'''''''##$## ###$#''''''''''''"
					,
					"'''''####    ..# #####'#####''"
					,
					"'''''#  ..*.**.# #   #'#   ##'"
					,
					"'''''# ######.. $  # ###$  ##'"
					,
					"'''''# #    #*. # $        #''"
					,
					"'''''# # #  #  # $$ # ## ###''"
					,
					"'''''#  $ # ##    #####   #'''"
					,
					"'''''##  $   ###### #     #'''"
					,
					"''''''# ### ###       $#  #'''"
					,
					"''''''#   $   #$ $ ##  ####'''"
					,
					"''''''#### $ $    ######''''''"
					,
					"'''''''''#  ####  #'''''''''''"
					,
					"'''''''''####''####'''''''''''"
				}
				,
				{
					"#########################"
					,
					"#   #   #   #   #   #   #"
					,
					"# $ # # # # # # # # # $ #"
					,
					"#  * * $ $ * * $ $ * *  #"
					,
					"### # # # # # # # # # ###"
					,
					"#  * *...... ......* *  #"
					,
					"# # # ###### ###### # # #"
					,
					"#  $ .#     $     #. $  #"
					,
					"### #$ $$$$ @ $$$$ $# ###"
					,
					"#  $ .#     $     #. $  #"
					,
					"# # # ###### ###### # # #"
					,
					"#  * *...... ......* *  #"
					,
					"### # # # # # # # # # ###"
					,
					"#  * * $ $ * * $ $ * *  #"
					,
					"# $ # # # # # # # # # $ #"
					,
					"#   #   #   #   #   #   #"
					,
					"#########################"
				}
				,
				{
					"''''####''''''''''"
					,
					"'''##  ####'''''''"
					,
					"'''# $   .########"
					,
					"'''# $ # .   $ $ #"
					,
					"#### ### .#### # #"
					,
					"#  ....#$.#  # # #"
					,
					"# #. $ # .#$ # # #"
					,
					"#  ##  $$$@$ # # #"
					,
					"##   ##  #   # # #"
					,
					"'###   #  ## # # #"
					,
					"'''### # ...     #"
					,
					"'''''# #$* *$#  ##"
					,
					"'''''# # ...$ ###'"
					,
					"'''''# $$ #   #'''"
					,
					"'''''#   ######'''"
					,
					"'''''#####''''''''"
				}
				,
				{
					"''''''#####''''''"
					,
					"'''''##   ##'''''"
					,
					"'''''#  $  #'''''"
					,
					"''''## $.$ ##''''"
					,
					"'''## $.*.$ ##'''"
					,
					"'### $.*.*.$ ###'"
					,
					"##  $.*.$.*.$  ##"
					,
					"#  $.*.$ $.*.$  #"
					,
					"# $.*.$   $.*.$ #"
					,
					"#  $.*.$ $.*.$  #"
					,
					"##  $.*.$.*.$  ##"
					,
					"'### $.*.*.$ ###'"
					,
					"'''## $.*.$ ##'''"
					,
					"''''## $.$ ##''''"
					,
					"'''''#  $  #'''''"
					,
					"'''''## @ ##'''''"
					,
					"''''''#####''''''"
				}
				,
				{
					"''''''#####''''''"
					,
					"''''''#   #''''''"
					,
					"'''''## $ ##'''''"
					,
					"'''### $.$ ###'''"
					,
					"'''#  $.*.$  #'''"
					,
					"''## $.*.*.$ ##''"
					,
					"### $.*.$.*.$ ###"
					,
					"#  $.*.$ $.*.$  #"
					,
					"# $.*.$   $.*.$ #"
					,
					"#  $.*.$ $.*.$  #"
					,
					"### $.*.$.*.$ ###"
					,
					"''## $.*.*.$ ##''"
					,
					"'''#  $.*.$  #'''"
					,
					"'''### $.$ ###'''"
					,
					"'''''## $ ##'''''"
					,
					"''''''# @ #''''''"
					,
					"''''''#####''''''"
				}
				,
				{
					"'''''''''''#####'''''''''''"
					,
					"'########### @ ###########'"
					,
					"'#   .   .   #     .     #'"
					,
					"'# $$*$$$*$$ # .$ $$$.$. #'"
					,
					"'#.....*.....#*$.$...*.$*#'"
					,
					"## $$*$$$*$$ # .$.$$$ $. ##"
					,
					"#    .   .   #     .      #"
					,
					"# ####################### #"
					,
					"#   .  .  .  #  . . . .   #"
					,
					"## $$* $$* $ # $.$.$.$.$ ##"
					,
					"'#.*.* * *.*.#*$$$ * $$$*#'"
					,
					"'# $ *$$ *$$ # $.$.$.$.$ #'"
					,
					"'#  .  .  .  #  . . . .  #'"
					,
					"'########### * ###########'"
					,
					"'''''''''''#####'''''''''''"
				}
				,
				{
					"'''''''''''#####'''''''''''"
					,
					"'########### @ ###########'"
					,
					"'#  .     .  #    .$.    #'"
					,
					"'# .$.$$$.$. #.$  $.$  $.#'"
					,
					"'#.$$$.*.$$$.#$.*** ***.$#'"
					,
					"## .$.$$$.$. #.$  $.$  $.##"
					,
					"#   .     .  #    .$.     #"
					,
					"# ####################### #"
					,
					"#   $.   .$  # $       .  #"
					,
					"##  * .$. *  # .**   **$ ##"
					,
					"'#  $.$*$.$  # *  ***  * #'"
					,
					"'#  * .$. *  # $**   **. #'"
					,
					"'#  $.   .$  # .       $ #'"
					,
					"'########### * ###########'"
					,
					"'''''''''''#####'''''''''''"
				}
				,
				{
					"'#########################'"
					,
					"'#  #  #  #  #  #  #  #  #'"
					,
					"'# $#$ # $#$ # $#$ # $#$ #'"
					,
					"'#  #  #  #  #  #  #  #  #'"
					,
					"'# $#$ # $#$ # $#$ # $#$ #'"
					,
					"'#  #  #  #  #  #  #  #  #'"
					,
					"'## # ### # ### # ### # ##'"
					,
					"'#  #  #  #  #  #  #  #  #'"
					,
					"'#  $  #  $  #  $  #  $  #'"
					,
					"## ### # ### # ### # ### ##"
					,
					"#   #  #  #  #  #  #  #   #"
					,
					"#   #  $  #  $  #  $  #   #"
					,
					"##  # ### # ### # ### #  ##"
					,
					"'#...........+...........#'"
					,
					"'#########   #   #########'"
					,
					"'''''''''#  ###  #'''''''''"
					,
					"'''''''''####'####'''''''''"
				}
				,
				{
					"''#########################''"
					,
					"''#           #           #''"
					,
					"###$$ $$ $$ $$.$$ $$ $$ $$###"
					,
					"# $+.$..$..$..$..$..$..$..$ #"
					,
					"# $..$..$..$..$..$..$..$..$ #"
					,
					"#  $$.$$.$$.$$.$$.$$.$$.$$  #"
					,
					"# $..$..$..$..$..$..$..$..$ #"
					,
					"# $..$..$..$..$..$..$..$..$ #"
					,
					"##.$$.$$.$$.$$ $$.$$.$$.$$.##"
					,
					"# $..$..$..$..$..$..$..$..$ #"
					,
					"# $..$..$..$..$..$..$..$..$ #"
					,
					"#  $$.$$.$$.$$.$$.$$.$$.$$  #"
					,
					"# $..$..$..$..$..$..$..$..$ #"
					,
					"# $..$..$..$..$..$..$..$..$ #"
					,
					"###$$ $$ $$ $$.$$ $$ $$ $$###"
					,
					"''#           #           #''"
					,
					"''#########################''"
				}
				,
				{
					"'####'''''''''''''''''''####'"
					,
					"'#  #####################  #'"
					,
					"'#    ....... @ .......    #'"
					,
					"'#  # .###############. #  #'"
					,
					"###  #.    #  #   #   .#  ###"
					,
					"'#     #   $  #   $  #     #'"
					,
					"'#     ##$##  ##$##  #     #'"
					,
					"'###   #  ##$##  #####   ###'"
					,
					"'#  #  #  $   $  $   #  #  #'"
					,
					"'#     #  #   #  #   #     #'"
					,
					"'#  #  #####$######$##  #  #'"
					,
					"'##   ##   #  #   #  ##   ##'"
					,
					"'#######   $  #   $  #######'"
					,
					"'''''''##$##  ##$##  #'''''''"
					,
					"######'#  #####  ##$##'######"
					,
					"#''''#'#  $   $  $   #'#''''#"
					,
					"######'#  #   #  #   #'######"
					,
					"'''''''###############'''''''"
				}
		});

		// level: Microban (easy)
		levelMaps.add(new String[][] {
				{
					"####''"
					,
					"# .#''"
					,
					"#  ###"
					,
					"#*@  #"
					,
					"#  $ #"
					,
					"#  ###"
					,
					"####''"
				}
				,
				{
					"######"
					,
					"#    #"
					,
					"# #@ #"
					,
					"# $* #"
					,
					"# .* #"
					,
					"#    #"
					,
					"######"
				}
				,
				{
					"''####'''"
					,
					"###  ####"
					,
					"#     $ #"
					,
					"# #  #$ #"
					,
					"# . .#@ #"
					,
					"#########"
				}
				,
				{
					"########"
					,
					"#      #"
					,
					"# .**$@#"
					,
					"#      #"
					,
					"#####  #"
					,
					"''''####"
				}
				,
				{
					"'#######"
					,
					"'#     #"
					,
					"'# .$. #"
					,
					"## $@$ #"
					,
					"#  .$. #"
					,
					"#      #"
					,
					"########"
				}
				,
				{
					"######'#####"
					,
					"#    ###   #"
					,
					"# $$     #@#"
					,
					"# $ #...   #"
					,
					"#   ########"
					,
					"#####'''''''"
				}
				,
				{
					"#######"
					,
					"#     #"
					,
					"# .$. #"
					,
					"# $.$ #"
					,
					"# .$. #"
					,
					"# $.$ #"
					,
					"#  @  #"
					,
					"#######"
				}
				,
				{
					"''######"
					,
					"''# ..@#"
					,
					"''# $$ #"
					,
					"''## ###"
					,
					"'''# #''"
					,
					"'''# #''"
					,
					"#### #''"
					,
					"#    ##'"
					,
					"# #   #'"
					,
					"#   # #'"
					,
					"###   #'"
					,
					"''#####'"
				}
				,
				{
					"#####'"
					,
					"#.  ##"
					,
					"#@$$ #"
					,
					"##   #"
					,
					"'##  #"
					,
					"''##.#"
					,
					"'''###"
				}
				,
				{
					"''''''#####"
					,
					"''''''#.  #"
					,
					"''''''#.# #"
					,
					"#######.# #"
					,
					"# @ $ $ $ #"
					,
					"# # # # ###"
					,
					"#       #''"
					,
					"#########''"
				}
				,
				{
					"''######'"
					,
					"''#    #'"
					,
					"''# ##@##"
					,
					"### # $ #"
					,
					"# ..# $ #"
					,
					"#       #"
					,
					"#  ######"
					,
					"####'''''"
				}
				,
				{
					"#####''''"
					,
					"#   ##'''"
					,
					"# $  #'''"
					,
					"## $ ####"
					,
					"'###@.  #"
					,
					"''#  .# #"
					,
					"''#     #"
					,
					"''#######"
				}
				,
				{
					"####'''"
					,
					"#. ##''"
					,
					"#.@ #''"
					,
					"#. $#''"
					,
					"##$ ###"
					,
					"'# $  #"
					,
					"'#    #"
					,
					"'#  ###"
					,
					"'####''"
				}
				,
				{
					"#######"
					,
					"#     #"
					,
					"# # # #"
					,
					"#. $*@#"
					,
					"#   ###"
					,
					"#####''"
				}
				,
				{
					"'''''###'"
					,
					"######@##"
					,
					"#    .* #"
					,
					"#   #   #"
					,
					"#####$# #"
					,
					"''''#   #"
					,
					"''''#####"
				}
				,
				{
					"'####'''''"
					,
					"'#  ####''"
					,
					"'#     ##'"
					,
					"## ##   #'"
					,
					"#. .# @$##"
					,
					"#   # $$ #"
					,
					"#  .#    #"
					,
					"##########"
				}
				,
				{
					"#####'"
					,
					"# @ #'"
					,
					"#...#'"
					,
					"#$$$##"
					,
					"#    #"
					,
					"#    #"
					,
					"######"
				}
				,
				{
					"#######"
					,
					"#     #"
					,
					"#. .  #"
					,
					"# ## ##"
					,
					"#  $ #'"
					,
					"###$ #'"
					,
					"''#@ #'"
					,
					"''#  #'"
					,
					"''####'"
				}
				,
				{
					"########"
					,
					"#   .. #"
					,
					"#  @$$ #"
					,
					"##### ##"
					,
					"'''#  #'"
					,
					"'''#  #'"
					,
					"'''#  #'"
					,
					"'''####'"
				}
				,
				{
					"#######''"
					,
					"#     ###"
					,
					"#  @$$..#"
					,
					"#### ## #"
					,
					"''#     #"
					,
					"''#  ####"
					,
					"''#  #'''"
					,
					"''####'''"
				}
				,
				{
					"####'''"
					,
					"#  ####"
					,
					"# . . #"
					,
					"# $$#@#"
					,
					"##    #"
					,
					"'######"
				}
				,
				{
					"#####''"
					,
					"#   ###"
					,
					"#. .  #"
					,
					"#   # #"
					,
					"## #  #"
					,
					"'#@$$ #"
					,
					"'#    #"
					,
					"'#  ###"
					,
					"'####''"
				}
				,
				{
					"#######"
					,
					"#  *  #"
					,
					"#     #"
					,
					"## # ##"
					,
					"'#$@.#'"
					,
					"'#   #'"
					,
					"'#####'"
				}
				,
				{
					"#'#####"
					,
					"''#   #"
					,
					"###$$@#"
					,
					"#   ###"
					,
					"#     #"
					,
					"# . . #"
					,
					"#######"
				}
				,
				{
					"'####''"
					,
					"'#  ###"
					,
					"'# $$ #"
					,
					"##... #"
					,
					"#  @$ #"
					,
					"#   ###"
					,
					"#####''"
				}
				,
				{
					"'#####"
					,
					"'# @ #"
					,
					"'#   #"
					,
					"###$ #"
					,
					"# ...#"
					,
					"# $$ #"
					,
					"###  #"
					,
					"''####"
				}
				,
				{
					"######'"
					,
					"#   .#'"
					,
					"# ## ##"
					,
					"#  $$@#"
					,
					"# #   #"
					,
					"#.  ###"
					,
					"#####''"
				}
				,
				{
					"#####''"
					,
					"#   #''"
					,
					"# @ #''"
					,
					"# $$###"
					,
					"##. . #"
					,
					"'#    #"
					,
					"'######"
				}
				,
				{
					"'''''#####'"
					,
					"'''''#   ##"
					,
					"'''''#    #"
					,
					"'######   #"
					,
					"##     #. #"
					,
					"# $ $ @  ##"
					,
					"# ######.#'"
					,
					"#        #'"
					,
					"##########'"
				}
				,
				{
					"####''"
					,
					"#  ###"
					,
					"# $$ #"
					,
					"#... #"
					,
					"# @$ #"
					,
					"#   ##"
					,
					"#####'"
				}
				,
				{
					"''####'"
					,
					"'##  #'"
					,
					"##@$.##"
					,
					"# $$  #"
					,
					"# . . #"
					,
					"###   #"
					,
					"''#####"
				}
				,
				{
					"'####''"
					,
					"##  ###"
					,
					"#     #"
					,
					"#.**$@#"
					,
					"#   ###"
					,
					"##  #''"
					,
					"'####''"
				}
				,
				{
					"#######"
					,
					"#. #  #"
					,
					"#  $  #"
					,
					"#. $#@#"
					,
					"#  $  #"
					,
					"#. #  #"
					,
					"#######"
				}
				,
				{
					"''####'''"
					,
					"###  ####"
					,
					"#       #"
					,
					"#@$***. #"
					,
					"#       #"
					,
					"#########"
				}
				,
				{
					"''####'"
					,
					"'##  #'"
					,
					"'#. $#'"
					,
					"'#.$ #'"
					,
					"'#.$ #'"
					,
					"'#.$ #'"
					,
					"'#. $##"
					,
					"'#   @#"
					,
					"'##   #"
					,
					"''#####"
				}
				,
				{
					"####'''''''''''"
					,
					"#  ############"
					,
					"# $ $ $ $ $ @ #"
					,
					"# .....       #"
					,
					"###############"
				}
				,
				{
					"''''''###"
					,
					"#####'#.#"
					,
					"#   ###.#"
					,
					"#   $ #.#"
					,
					"# $  $  #"
					,
					"#####@# #"
					,
					"''''#   #"
					,
					"''''#####"
				}
				,
				{
					"##########"
					,
					"#        #"
					,
					"# ##.### #"
					,
					"# # $$ . #"
					,
					"# . @$## #"
					,
					"#####    #"
					,
					"''''######"
				}
				,
				{
					"#####'''''"
					,
					"#   ####''"
					,
					"# # # .#''"
					,
					"#    $ ###"
					,
					"### #$.  #"
					,
					"#   #@   #"
					,
					"# # ######"
					,
					"#   #'''''"
					,
					"#####'''''"
				}
				,
				{
					"'#####'"
					,
					"'#   #'"
					,
					"##   ##"
					,
					"# $$$ #"
					,
					"# .+. #"
					,
					"#######"
				}
				,
				{
					"#######'"
					,
					"#     #'"
					,
					"#@$$$ ##"
					,
					"#  #...#"
					,
					"##    ##"
					,
					"'######'"
				}
				,
				{
					"'''####"
					,
					"'''#  #"
					,
					"'''#@ #"
					,
					"####$.#"
					,
					"#   $.#"
					,
					"# # $.#"
					,
					"#    ##"
					,
					"######'"
				}
				,
				{
					"'''''####"
					,
					"'''''# @#"
					,
					"'''''#  #"
					,
					"###### .#"
					,
					"#   $  .#"
					,
					"#  $$# .#"
					,
					"#    ####"
					,
					"###  #'''"
					,
					"''####'''"
				}
				,
				{
					"#####"
					,
					"#@$.#"
					,
					"#####"
				}
				,
				{
					"######"
					,
					"#... #"
					,
					"#  $ #"
					,
					"# #$##"
					,
					"#  $ #"
					,
					"#  @ #"
					,
					"######"
				}
				,
				{
					"'######"
					,
					"##    #"
					,
					"#  ## #"
					,
					"# # $ #"
					,
					"#  * .#"
					,
					"## #@##"
					,
					"'#   #'"
					,
					"'#####'"
				}
				,
				{
					"''#######''"
					,
					"###     #''"
					,
					"# $ $   #''"
					,
					"# ### #####"
					,
					"# @ . .   #"
					,
					"#   ###   #"
					,
					"#####'#####"
				}
				,
				{
					"######''"
					,
					"#  @ #''"
					,
					"#  # ##'"
					,
					"# .#  ##"
					,
					"# .$$$ #"
					,
					"# .#   #"
					,
					"####   #"
					,
					"'''#####"
				}
				,
				{
					"######''"
					,
					"# @  #''"
					,
					"# $# #''"
					,
					"# $  #''"
					,
					"# $ ##''"
					,
					"### ####"
					,
					"'#  #  #"
					,
					"'#...  #"
					,
					"'#     #"
					,
					"'#######"
				}
				,
				{
					"''####''''"
					,
					"###  #####"
					,
					"#  $  @..#"
					,
					"# $    # #"
					,
					"### #### #"
					,
					"''#      #"
					,
					"''########"
				}
				,
				{
					"####''''"
					,
					"#  ###''"
					,
					"#    ###"
					,
					"#  $*@ #"
					,
					"### .# #"
					,
					"''#    #"
					,
					"''######"
				}
				,
				{
					"''####"
					,
					"### @#"
					,
					"#  $ #"
					,
					"#  *.#"
					,
					"#  *.#"
					,
					"#  $ #"
					,
					"###  #"
					,
					"''####"
				}
				,
				{
					"'#####'"
					,
					"##. .##"
					,
					"# * * #"
					,
					"#  #  #"
					,
					"# $ $ #"
					,
					"## @ ##"
					,
					"'#####'"
				}
				,
				{
					"''''''######"
					,
					"''''''#    #"
					,
					"''##### .  #"
					,
					"###  ###.  #"
					,
					"# $  $  . ##"
					,
					"# @$$ # . #'"
					,
					"##    #####'"
					,
					"'######'''''"
				}
				,
				{
					"########''"
					,
					"# @ #  #''"
					,
					"#      #''"
					,
					"#####$ #''"
					,
					"''''#  ###"
					,
					"'##'#$ ..#"
					,
					"'##'#  ###"
					,
					"''''####''"
				}
				,
				{
					"#####''"
					,
					"#   ###"
					,
					"#  $  #"
					,
					"##* . #"
					,
					"'#   @#"
					,
					"'######"
				}
				,
				{
					"''####''"
					,
					"''#  #''"
					,
					"''#@ #''"
					,
					"''#  #''"
					,
					"### ####"
					,
					"#    * #"
					,
					"#  $   #"
					,
					"#####. #"
					,
					"''''####"
				}
				,
				{
					"####'''"
					,
					"#  ####"
					,
					"#.*$  #"
					,
					"# .$# #"
					,
					"## @  #"
					,
					"'#   ##"
					,
					"'#####'"
				}
				,
				{
					"############'"
					,
					"#          #'"
					,
					"# ####### @##"
					,
					"# #         #"
					,
					"# #  $   #  #"
					,
					"# $$ #####  #"
					,
					"###  #'# ...#"
					,
					"''####'#    #"
					,
					"'''''''######"
				}
				,
				{
					"'#########"
					,
					"'#       #"
					,
					"##@##### #"
					,
					"#  #   # #"
					,
					"#  #   $.#"
					,
					"#  ##$##.#"
					,
					"##$##  #.#"
					,
					"#   $  #.#"
					,
					"#   #  ###"
					,
					"########''"
				}
				,
				{
					"########'"
					,
					"#      #'"
					,
					"# #### #'"
					,
					"# #...@#'"
					,
					"# ###$###"
					,
					"# #     #"
					,
					"#  $$ $ #"
					,
					"####   ##"
					,
					"'''#.###'"
					,
					"'''###'''"
				}
				,
				{
					"'''##########"
					,
					"####    ##  #"
					,
					"#  $$$....$@#"
					,
					"#      ###  #"
					,
					"#   ####'####"
					,
					"#####''''''''"
				}
				,
				{
					"#####'''####'''''''"
					,
					"#   ##### .#'''''''"
					,
					"#       $  ########"
					,
					"###  #### .$    @ #"
					,
					"''#  #''#  ####   #"
					,
					"''####''####''#####"
				}
				,
				{
					"'######'''"
					,
					"##    #'''"
					,
					"#   $ #'''"
					,
					"#  $$ #'''"
					,
					"### .#####"
					,
					"''##.# @ #"
					,
					"'''#.  $ #"
					,
					"'''#. ####"
					,
					"'''####'''"
				}
				,
				{
					"''######'"
					,
					"''#    #'"
					,
					"''#  $ #'"
					,
					"'####$ #'"
					,
					"## $ $ #'"
					,
					"#....# ##"
					,
					"#     @ #"
					,
					"##  #   #"
					,
					"'########"
				}
				,
				{
					"'''###'''"
					,
					"'''#@#'''"
					,
					"'###$###'"
					,
					"##  .  ##"
					,
					"#  # #  #"
					,
					"# #   # #"
					,
					"# #   # #"
					,
					"# #   # #"
					,
					"#  # #  #"
					,
					"## $ $ ##"
					,
					"'##. .##'"
					,
					"''#   #''"
					,
					"''#   #''"
					,
					"''#####''"
				}
				,
				{
					"#####''"
					,
					"#   ##'"
					,
					"# #  #'"
					,
					"#@$*.##"
					,
					"##  . #"
					,
					"'# $# #"
					,
					"'##   #"
					,
					"''#####"
				}
				,
				{
					"'####'''''"
					,
					"'#  ######"
					,
					"##    $  #"
					,
					"# .# $   #"
					,
					"# .#$#####"
					,
					"# .@ #''''"
					,
					"######''''"
				}
				,
				{
					"####''####'"
					,
					"#  ####  #'"
					,
					"#  #  #  #'"
					,
					"#  #    $##"
					,
					"#  . .#$  #"
					,
					"#@ ## # $ #"
					,
					"#   . #   #"
					,
					"###########"
				}
				,
				{
					"#####'''"
					,
					"# @ ####"
					,
					"#      #"
					,
					"# $ $$ #"
					,
					"##$##  #"
					,
					"#   ####"
					,
					"# ..  #'"
					,
					"##..  #'"
					,
					"'###  #'"
					,
					"'''####'"
				}
				,
				{
					"###########''"
					,
					"#     #   ###"
					,
					"# $@$ # .  .#"
					,
					"# ## ### ## #"
					,
					"# #       # #"
					,
					"# #   #   # #"
					,
					"# ######### #"
					,
					"#           #"
					,
					"#############"
				}
				,
				{
					"''####''''"
					,
					"'##  #####"
					,
					"'#  $  @ #"
					,
					"'#  $#   #"
					,
					"#### #####"
					,
					"#  #   #''"
					,
					"#    $ #''"
					,
					"# ..#  #''"
					,
					"#  .####''"
					,
					"#  ##'''''"
					,
					"####''''''"
				}
				,
				{
					"####''''"
					,
					"#  #####"
					,
					"# $$ $ #"
					,
					"#      #"
					,
					"## ## ##"
					,
					"#...#@#'"
					,
					"# ### ##"
					,
					"#      #"
					,
					"#  #   #"
					,
					"########"
				}
				,
				{
					"'####''''''"
					,
					"'#  #######"
					,
					"'#$ @#   .#"
					,
					"## #$$   .#"
					,
					"#  $  ##..#"
					,
					"#   # #####"
					,
					"###   #''''"
					,
					"''#####''''"
				}
				,
				{
					"'#######''"
					,
					"## ....##'"
					,
					"#   ######"
					,
					"#   $ $ @#"
					,
					"###  $ $ #"
					,
					"''###    #"
					,
					"''''######"
				}
				,
				{
					"'#####''''"
					,
					"##   #''''"
					,
					"#    #####"
					,
					"#  #.#   #"
					,
					"#@ #.# $ #"
					,
					"#  #.#  ##"
					,
					"#    #  #'"
					,
					"##  ##$$#'"
					,
					"'##     #'"
					,
					"''#  ####'"
					,
					"''####''''"
				}
				,
				{
					"##########'"
					,
					"# @ .... #'"
					,
					"#   ####$##"
					,
					"## #  $ $ #"
					,
					"'# $      #"
					,
					"'#   ######"
					,
					"'#####'''''"
				}
				,
				{
					"'#######'''"
					,
					"##     ##''"
					,
					"#  $ $  #''"
					,
					"# $ $ $ #''"
					,
					"## ### ####"
					,
					"'#@  .....#"
					,
					"'##     ###"
					,
					"''#######''"
				}
				,
				{
					"'#########"
					,
					"'#    #  #"
					,
					"## $#$#  #"
					,
					"#  .$.@  #"
					,
					"#  .#    #"
					,
					"##########"
				}
				,
				{
					"####''''''"
					,
					"#  #######"
					,
					"#  . ## .#"
					,
					"# $#    .#"
					,
					"## ## # .#"
					,
					"'#    #  #"
					,
					"'#### #  #"
					,
					"''# @$ ###"
					,
					"''# $$ #''"
					,
					"''#    #''"
					,
					"''######''"
				}
				,
				{
					"'#####"
					,
					"'#   #"
					,
					"'# . #"
					,
					"## * #"
					,
					"#  *##"
					,
					"#  @##"
					,
					"## $ #"
					,
					"'#   #"
					,
					"'#####"
				}
				,
				{
					"#####'''"
					,
					"#   ###'"
					,
					"# .   ##"
					,
					"##*#$  #"
					,
					"# .# $ #"
					,
					"# @## ##"
					,
					"#     #'"
					,
					"#######'"
				}
				,
				{
					"######''"
					,
					"#    ##'"
					,
					"# $ $ ##"
					,
					"## $$  #"
					,
					"'# #   #"
					,
					"'# ## ##"
					,
					"'#  . .#"
					,
					"'# @. .#"
					,
					"'#  ####"
					,
					"'####'''"
				}
				,
				{
					"########''''"
					,
					"#  ... #''''"
					,
					"#  ### ##'''"
					,
					"#  # $  #'''"
					,
					"## #@$  #'''"
					,
					"'# # $  #'''"
					,
					"'# ### #####"
					,
					"'#         #"
					,
					"'#   ###   #"
					,
					"'#####'#####"
				}
				,
				{
					"'''''''####"
					,
					"'#######  #"
					,
					"'# $      #"
					,
					"'#   $ $  #"
					,
					"'# ########"
					,
					"## # .  #''"
					,
					"#  # #  #''"
					,
					"#  @ . ##''"
					,
					"## # # #'''"
					,
					"'#   . #'''"
					,
					"'#######'''"
				}
				,
				{
					"''''####'"
					,
					"''###  ##"
					,
					"'## $   #"
					,
					"## $  # #"
					,
					"# @#$$  #"
					,
					"# ..  ###"
					,
					"# ..###''"
					,
					"#####''''"
				}
				,
				{
					"'''''####"
					,
					"######  #"
					,
					"#       #"
					,
					"#  ... .#"
					,
					"##$######"
					,
					"# $  #'''"
					,
					"#   $###'"
					,
					"##  $  #'"
					,
					"'## @  #'"
					,
					"''######'"
				}
				,
				{
					"'''''####''"
					,
					"'#'###  #''"
					,
					"'#'#    #''"
					,
					"'#'#  # #''"
					,
					"'#'#$ #.#''"
					,
					"'#'#  # #'#"
					,
					"'#'#$ #.#'#"
					,
					"'''#  # #'#"
					,
					"####$ #.#'#"
					,
					"# @     #'#"
					,
					"#   #  ##'#"
					,
					"########'''"
				}
				,
				{
					"##########"
					,
					"#   ##   #"
					,
					"# $  $@# #"
					,
					"#### # $ #"
					,
					"'''#.#  ##"
					,
					"'#'#.# $#'"
					,
					"'#'#.   #'"
					,
					"'#'#.   #'"
					,
					"'''######'"
				}
				,
				{
					"'########'"
					,
					"'#  @   #'"
					,
					"'# $  $ #'"
					,
					"### ## ###"
					,
					"#  $..$  #"
					,
					"#   ..   #"
					,
					"##########"
				}
				,
				{
					"###########"
					,
					"#    .##  #"
					,
					"# $$@..$$ #"
					,
					"#   ##.   #"
					,
					"###########"
				}
				,
				{
					"''####'''''''''"
					,
					"''#  #''''#####"
					,
					"''#  #''''#   #"
					,
					"''#  ######.# #"
					,
					"####  $    .  #"
					,
					"#   $$# ###.# #"
					,
					"#   #   #'#   #"
					,
					"#########'#@ ##"
					,
					"''''''''''#  #'"
					,
					"''''''''''####'"
				}
				,
				{
					"'#########'"
					,
					"##   #   ##"
					,
					"#    #    #"
					,
					"#  $ # $  #"
					,
					"#   *.*   #"
					,
					"####.@.####"
					,
					"#   *.*   #"
					,
					"#  $ # $  #"
					,
					"#    #    #"
					,
					"##   #   ##"
					,
					"'#########'"
				}
				,
				{
					"#########"
					,
					"# @ #   #"
					,
					"# $ $   #"
					,
					"##$### ##"
					,
					"#  ...  #"
					,
					"#   #   #"
					,
					"######  #"
					,
					"'''''####"
				}
				,
				{
					"########"
					,
					"#@     #"
					,
					"# .$$. #"
					,
					"# $..$ #"
					,
					"# $..$ #"
					,
					"# .$$. #"
					,
					"#      #"
					,
					"########"
				}
				,
				{
					"''######'''"
					,
					"''#    #'''"
					,
					"''#    #'''"
					,
					"#####  #'''"
					,
					"#   #.#####"
					,
					"#   $@$   #"
					,
					"#####.#   #"
					,
					"'''## ## ##"
					,
					"'''#   $.#'"
					,
					"'''#   ###'"
					,
					"'''#####'''"
				}
				,
				{
					"'''####'''''''"
					,
					"'''#  ########"
					,
					"#### $ $.....#"
					,
					"#   $   ######"
					,
					"#@### ###'''''"
					,
					"#  $  #'''''''"
					,
					"# $ # #'''''''"
					,
					"## #  #'''''''"
					,
					"'#    #'''''''"
					,
					"'######'''''''"
				}
				,
				{
					"#####'''''''''''"
					,
					"#   ##'####'''''"
					,
					"#  $ ### .#'''''"
					,
					"# $   $  .#'''''"
					,
					"## $#####.#'####"
					,
					"# $  #'# .###  #"
					,
					"#    #'# .#  @ #"
					,
					"###  #'#       #"
					,
					"''####'##     ##"
					,
					"''''''''#######'"
				}
				,
				{
					"'''''''''''''''#####''"
					,
					"'''''''''''''''#   #''"
					,
					"#######''####### # #''"
					,
					"#     #''#  #      #''"
					,
					"#  @  ####  #     ####"
					,
					"#  #    ....## ####  #"
					,
					"#    ##### ## $$ $ $ #"
					,
					"######'''#           #"
					,
					"'''''''''#  ##########"
					,
					"'''''''''####'''''''''"
				}
				,
				{
					"#######'"
					,
					"# @#  #'"
					,
					"#.$   #'"
					,
					"#. # $##"
					,
					"#.$#   #"
					,
					"#. # $ #"
					,
					"#  #   #"
					,
					"########"
				}
				,
				{
					"''#####''''''"
					,
					"''#   #''''''"
					,
					"''# # #######"
					,
					"''#  *  #   #"
					,
					"''## ##   # #"
					,
					"''#     #*  #"
					,
					"### # # # ###"
					,
					"#  *#$+   #''"
					,
					"# #   ## ##''"
					,
					"#   #  *  #''"
					,
					"####### # #''"
					,
					"''''''#   #''"
					,
					"''''''#####''"
				}
				,
				{
					"###########"
					,
					"#....#    #"
					,
					"#  #   $$ #"
					,
					"#  @  ##  #"
					,
					"#     ##$ #"
					,
					"######  $ #"
					,
					"'''''#    #"
					,
					"'''''######"
				}
				,
				{
					"''#####'"
					,
					"''# . ##"
					,
					"### $  #"
					,
					"# . $#@#"
					,
					"# #$ . #"
					,
					"#  $ ###"
					,
					"## . #''"
					,
					"'#####''"
				}
				,
				{
					"''''#####"
					,
					"#####   #"
					,
					"#    $  #"
					,
					"#  $#$#@#"
					,
					"### #   #"
					,
					"''# ... #"
					,
					"''###  ##"
					,
					"''''#  #'"
					,
					"''''####'"
				}
				,
				{
					"'####'####'"
					,
					"##  ###  ##"
					,
					"#   # #   #"
					,
					"#  *. .*  #"
					,
					"###$   $###"
					,
					"'#   @   #'"
					,
					"###$   $###"
					,
					"#  *. .*  #"
					,
					"#   # #   #"
					,
					"##  ###  ##"
					,
					"'####'####'"
				}
				,
				{
					"'########'"
					,
					"'#      #'"
					,
					"'#@   $ #'"
					,
					"## ###$ #'"
					,
					"# .....###"
					,
					"# $ $ $  #"
					,
					"###### # #"
					,
					"'''''#   #"
					,
					"'''''#####"
				}
				,
				{
					"########"
					,
					"#      #"
					,
					"# $*** #"
					,
					"# *  * #"
					,
					"# *  * #"
					,
					"# ***. #"
					,
					"#     @#"
					,
					"########"
				}
				,
				{
					"####'''''#####'"
					,
					"#  ###'''#   ##"
					,
					"#    #'''#$ $ #"
					,
					"#..# ##### #  #"
					,
					"#  @    # $ $ #"
					,
					"#..#         ##"
					,
					"##   #########'"
					,
					"'#####'''''''''"
				}
				,
				{
					"''#######"
					,
					"#'#     #"
					,
					"#'# # # #"
					,
					"''# @ $ #"
					,
					"### ### #"
					,
					"#   ### #"
					,
					"# $  ##.#"
					,
					"## $  #.#"
					,
					"'## $  .#"
					,
					"#'## $#.#"
					,
					"##'## #.#"
					,
					"###'#   #"
					,
					"###'#####"
				}
				,
				{
					"''####'''"
					,
					"''#  #'''"
					,
					"''# $####"
					,
					"###. .  #"
					,
					"# $ # $ #"
					,
					"#  . .###"
					,
					"####$ #''"
					,
					"'''# @#''"
					,
					"'''####''"
				}
				,
				{
					"######'''"
					,
					"#    ####"
					,
					"#    ...#"
					,
					"#    ...#"
					,
					"######  #"
					,
					"''#  #  #"
					,
					"''# $$ ##"
					,
					"''# @$  #"
					,
					"''# $$  #"
					,
					"''## $# #"
					,
					"'''#    #"
					,
					"'''######"
				}
				,
				{
					"'#####''''"
					,
					"##   ####'"
					,
					"#  $$$  #'"
					,
					"# #   $ #'"
					,
					"#   $## ##"
					,
					"###  #.  #"
					,
					"''#  #   #"
					,
					"'##### ###"
					,
					"'#   # ##'"
					,
					"'# @....#'"
					,
					"'#      #'"
					,
					"'#   #  #'"
					,
					"'########'"
				}
				,
				{
					"'''#####''''''"
					,
					"''##   #''''''"
					,
					"###  # #''''''"
					,
					"#    . #''''''"
					,
					"#  ## #####'''"
					,
					"#  . . #  ##''"
					,
					"#  # @ $   ###"
					,
					"#####. #  $  #"
					,
					"''''####  $  #"
					,
					"'''''''## $ ##"
					,
					"''''''''#  ##'"
					,
					"''''''''#  #''"
					,
					"''''''''####''"
				}
				,
				{
					"######'''''"
					,
					"#    ###'''"
					,
					"#  # $ #'''"
					,
					"#  $ @ #'''"
					,
					"## ## #####"
					,
					"#  #......#"
					,
					"# $ $ $ $ #"
					,
					"##   ######"
					,
					"'#####'''''"
				}
				,
				{
					"''''#####'''"
					,
					"#####   ####"
					,
					"#     #    #"
					,
					"#  #.....  #"
					,
					"##  ## # ###"
					,
					"'#$$@$$$ #''"
					,
					"'#     ###''"
					,
					"'#######''''"
				}
				,
				{
					"'''''#####"
					,
					"'''###   #"
					,
					"####.....#"
					,
					"# @$$$$$ #"
					,
					"#     # ##"
					,
					"#####   #'"
					,
					"''''#####'"
				}
				,
				{
					"'####'####'"
					,
					"'#  ###  ##"
					,
					"'#      @ #"
					,
					"##..###   #"
					,
					"#      #  #"
					,
					"#...#$  # #"
					,
					"# ## $$ $ #"
					,
					"#  $    ###"
					,
					"####  ###''"
					,
					"'''####''''"
				}
				,
				{
					"'#####''''"
					,
					"##   ##'''"
					,
					"#  $  ##''"
					,
					"# $ $  ##'"
					,
					"###$# . ##"
					,
					"''# # .  #"
					,
					"'## ##.  #"
					,
					"'# @  . ##"
					,
					"'#   #  #'"
					,
					"'########'"
				}
				,
				{
					"''######'"
					,
					"''#    ##"
					,
					"'## ##  #"
					,
					"'# $$ # #"
					,
					"'# @$ # #"
					,
					"'#    # #"
					,
					"#### #  #"
					,
					"#  ... ##"
					,
					"#     ##'"
					,
					"#######''"
				}
				,
				{
					"''''''####'"
					,
					"#######  #'"
					,
					"# $      ##"
					,
					"# $#####  #"
					,
					"#  @#  #  #"
					,
					"## ##..   #"
					,
					"#  # ..####"
					,
					"# $  ###'''"
					,
					"# $###'''''"
					,
					"#  #'''''''"
					,
					"####'''''''"
				}
				,
				{
					"'######''''"
					,
					"'# .  #''''"
					,
					"##$.# #''''"
					,
					"#  *  #''''"
					,
					"# ..###''''"
					,
					"##$ #'#####"
					,
					"## ##'#   #"
					,
					"#  #### # #"
					,
					"#   @ $ $ #"
					,
					"##  #     #"
					,
					"'##########"
				}
				,
				{
					"#####''''''"
					,
					"#   ###''''"
					,
					"# #$  #''''"
					,
					"# $   #''''"
					,
					"# $ $ #''''"
					,
					"# $#  #''''"
					,
					"#  @###''''"
					,
					"## ########"
					,
					"#      ...#"
					,
					"#         #"
					,
					"########..#"
					,
					"'''''''####"
				}
				,
				{
					"########'''''''"
					,
					"#      #'''''''"
					,
					"# $ $$ ########"
					,
					"##### @##. .  #"
					,
					"''''#$  # .   #"
					,
					"''''#   #. . ##"
					,
					"''''#$# ## # #'"
					,
					"''''#        #'"
					,
					"''''#  ###  ##'"
					,
					"''''#  #'####''"
					,
					"''''####'''''''"
				}
				,
				{
					"##############"
					,
					"#      #     #"
					,
					"# $@$$ # . ..#"
					,
					"## ## ### ## #"
					,
					"'# #       # #"
					,
					"'# #   #   # #"
					,
					"'# ######### #"
					,
					"'#           #"
					,
					"'#############"
				}
				,
				{
					"''''''#####''"
					,
					"''''''#   ##'"
					,
					"''''''# $  #'"
					,
					"######## #@##"
					,
					"# .  # $ $  #"
					,
					"#        $# #"
					,
					"#...#####   #"
					,
					"#####'''#####"
				}
				,
				{
					"'###########"
					,
					"##.......  #"
					,
					"# $$$$$$$@ #"
					,
					"#   # # # ##"
					,
					"# # #     #'"
					,
					"#   #######'"
					,
					"#####'''''''"
				}
				,
				{
					"##'####'''"
					,
					"####  ####"
					,
					"'# $ $.  #"
					,
					"## #  .$ #"
					,
					"#   ##.###"
					,
					"#  $  . #'"
					,
					"# @ #   #'"
					,
					"#  ######'"
					,
					"####''''''"
				}
				,
				{
					"''#########"
					,
					"###   #   #"
					,
					"# * $ . . #"
					,
					"#   $ ## ##"
					,
					"####*#   #'"
					,
					"'#  @  ###'"
					,
					"'#   ###'''"
					,
					"'#####'''''"
				}
				,
				{
					"''#########"
					,
					"### @ #   #"
					,
					"# * $ *.. #"
					,
					"#   $ #   #"
					,
					"####*#  ###"
					,
					"'#     ##''"
					,
					"'#   ###'''"
					,
					"'#####'''''"
				}
				,
				{
					"#####''#####"
					,
					"#   ####.. #"
					,
					"# $$$      #"
					,
					"#   $#  .. #"
					,
					"### @#  ## #"
					,
					"''#  ##    #"
					,
					"''##########"
				}
				,
				{
					"#####''"
					,
					"#   #''"
					,
					"# . #''"
					,
					"#.@.###"
					,
					"##.#  #"
					,
					"#  $  #"
					,
					"# $   #"
					,
					"##$$  #"
					,
					"'#  ###"
					,
					"'#  #''"
					,
					"'####''"
				}
				,
				{
					"####''''''"
					,
					"# @###''''"
					,
					"#.*  #####"
					,
					"#..#$$ $ #"
					,
					"##       #"
					,
					"'# # ##  #"
					,
					"'#   #####"
					,
					"'#####''''"
				}
				,
				{
					"'#######''"
					,
					"'#  . .###"
					,
					"'# . . . #"
					,
					"### #### #"
					,
					"#  @$  $ #"
					,
					"#  $$  $ #"
					,
					"####   ###"
					,
					"'''#####''"
				}
				,
				{
					"''''''''####"
					,
					"#########  #"
					,
					"#   ## $   #"
					,
					"#  $   ##  #"
					,
					"### #. .# ##"
					,
					"''# #. .#$##"
					,
					"''# #   #  #"
					,
					"''# @ $    #"
					,
					"''#  #######"
					,
					"''####''''''"
				}
				,
				{
					"#######''''"
					,
					"#     #####"
					,
					"# $$#@##..#"
					,
					"# #       #"
					,
					"#  $ # #  #"
					,
					"#### $  ..#"
					,
					"'''########"
				}
				,
				{
					"'#######'"
					,
					"'#     #'"
					,
					"## ###$##"
					,
					"#.$   @ #"
					,
					"# .. #$ #"
					,
					"#.##  $ #"
					,
					"#    ####"
					,
					"######'''"
				}
				,
				{
					"'''''''####''"
					,
					"''''''##  ###"
					,
					"####''#  $  #"
					,
					"#  #### $ $ #"
					,
					"#   ..# #$  #"
					,
					"#  #   @  ###"
					,
					"## #..# ###''"
					,
					"'# ## # #''''"
					,
					"'#      #''''"
					,
					"'########''''"
				}
				,
				{
					"''####''''''"
					,
					"###  #''''''"
					,
					"#    ###''''"
					,
					"# # . .#''''"
					,
					"# @ ...####'"
					,
					"# # # #   ##"
					,
					"#   # $$   #"
					,
					"#####  $ $ #"
					,
					"''''##$ # ##"
					,
					"'''''#    #'"
					,
					"'''''######'"
				}
				,
				{
					"'####'''''''''''"
					,
					"##  ####''''''''"
					,
					"#   ...#''''''''"
					,
					"#   ...#''''''''"
					,
					"#   # ##''''''''"
					,
					"#   #@ ####'####"
					,
					"##### $   ###  #"
					,
					"''''#  ##$ $   #"
					,
					"'''###     $$  #"
					,
					"'''# $  ##   ###"
					,
					"'''#    ######''"
					,
					"'''######'''''''"
				}
				,
				{
					"########'#####"
					,
					"#  #   ###   #"
					,
					"#      ## $  #"
					,
					"#.# @ ## $  ##"
					,
					"#.#   # $  ##'"
					,
					"#.#    $  ##''"
					,
					"#. ## #####'''"
					,
					"##    #'''''''"
					,
					"'######'''''''"
				}
				,
				{
					"''########"
					,
					"''#  # . #"
					,
					"''#   .*.#"
					,
					"''#  # * #"
					,
					"####$##.##"
					,
					"#      $ #"
					,
					"# $ ## $ #"
					,
					"#   @#   #"
					,
					"##########"
				}
				,
				{
					"''####'''"
					,
					"''#  #'''"
					,
					"''#  ####"
					,
					"###$.$  #"
					,
					"#  .@.  #"
					,
					"#  $.$###"
					,
					"####  #''"
					,
					"'''#  #''"
					,
					"'''####''"
				}
				,
				{
					"####'''''"
					,
					"#  ####''"
					,
					"# $   #''"
					,
					"# .#  #''"
					,
					"# $# ##''"
					,
					"# .  #'''"
					,
					"#### #'''"
					,
					"'''# #'''"
					,
					"'### ###'"
					,
					"'#  $  #'"
					,
					"## #$# ##"
					,
					"# $ @ $ #"
					,
					"# ..#.. #"
					,
					"###   ###"
					,
					"''#####''"
				}
				,
				{
					"'''####'''''"
					,
					"'###  #####'"
					,
					"'# $$ #   #'"
					,
					"'# $ . .$$##"
					,
					"'# .. #. $ #"
					,
					"### #** .  #"
					,
					"#  . **# ###"
					,
					"# $ .# .. #'"
					,
					"##$$.@. $ #'"
					,
					"'#   # $$ #'"
					,
					"'#####  ###'"
					,
					"'''''####'''"
				}
				,
				{
					"'''#####'''"
					,
					"'''# @ #'''"
					,
					"''##   ##''"
					,
					"###.$$$.###"
					,
					"#  $...$  #"
					,
					"#  $.#.$  #"
					,
					"#  $...$  #"
					,
					"###.$$$.###"
					,
					"''##   ##''"
					,
					"'''#   #'''"
					,
					"'''#####'''"
				}
				,
				{
					"'#######'"
					,
					"##  .  ##"
					,
					"# .$$$. #"
					,
					"# $. .$ #"
					,
					"#.$ @ $.#"
					,
					"# $. .$ #"
					,
					"# .$$$. #"
					,
					"##  .  ##"
					,
					"'#######'"
				}
				,
				{
					"'''''''#####"
					,
					"########   #"
					,
					"#.   .  @#.#"
					,
					"#  ###     #"
					,
					"## $  #    #"
					,
					"'# $   #####"
					,
					"'# $#  #''''"
					,
					"'## #  #''''"
					,
					"''#   ##''''"
					,
					"''#####'''''"
				}
				,
				{
					"###########''''"
					,
					"#  .  #   #''''"
					,
					"# #.  @   #''''"
					,
					"#  #..# #######"
					,
					"##  ## $$ $ $ #"
					,
					"'##           #"
					,
					"''#############"
				}
				,
				{
					"'####'''''"
					,
					"##  ###'''"
					,
					"#@$   #'''"
					,
					"### $ #'''"
					,
					"'#  ######"
					,
					"'#  $....#"
					,
					"'#  # ####"
					,
					"'## # #'''"
					,
					"'# $# #'''"
					,
					"'#    #'''"
					,
					"'#  ###'''"
					,
					"'####'''''"
				}
				,
				{
					"'''''####''''''"
					,
					"'#####  #''''''"
					,
					"'#     $#######"
					,
					"## ## ..#  ...#"
					,
					"# $ $$#$  @   #"
					,
					"#        ###  #"
					,
					"#######  #'####"
					,
					"''''''####'''''"
				}
				,
				{
					"'''####'''''"
					,
					"'''#  #'''''"
					,
					"'###  #'''''"
					,
					"##  $ #'''''"
					,
					"#   # #'''''"
					,
					"# #$$ ######"
					,
					"# #   #   .#"
					,
					"#  $  @   .#"
					,
					"###  ####..#"
					,
					"''####''####"
				}
				,
				{
					"######'####''''"
					,
					"#     #    #'''"
					,
					"#.##  #$##  #''"
					,
					"#   #     #  #'"
					,
					"#$  # ###  #  #"
					,
					"# #      #  # #"
					,
					"# # ####  # # #"
					,
					"#. @    $ * . #"
					,
					"###############"
				}
				,
				{
					"#############"
					,
					"#.# @#  #   #"
					,
					"#.#$$   # $ #"
					,
					"#.#  # $#   #"
					,
					"#.# $#  # $##"
					,
					"#.#  # $#  #'"
					,
					"#.# $#  # $#'"
					,
					"#..  # $   #'"
					,
					"#..  #  #  #'"
					,
					"############'"
				}
				,
				{
					"'############################"
					,
					"'#                          #"
					,
					"'# ######################## #"
					,
					"'# #                      # #"
					,
					"'# # #################### # #"
					,
					"'# # #                  # # #"
					,
					"'# # # ################ # # #"
					,
					"'# # # #              # # # #"
					,
					"'# # # # ############ # # # #"
					,
					"'# # # # #            # # # #"
					,
					"'# # # # # ############ # # #"
					,
					"'# # # # #              # # #"
					,
					"'# # # # ################ # #"
					,
					"'# # # #                  # #"
					,
					"##$# # #################### #"
					,
					"#. @ #                      #"
					,
					"#############################"
				}
				,
				{
					"''''######'''''''''''''''####'"
					,
					"#####*#  #################  ##"
					,
					"#   ###                      #"
					,
					"#        ########  ####  ##  #"
					,
					"### ####     #  ####  ####  ##"
					,
					"#*# # .# # # #     #     #   #"
					,
					"#*# #  #     # ##  # ##  ##  #"
					,
					"###    ### ###  # ##  # ##  ##"
					,
					"'#   # #*#      #     # #    #"
					,
					"'#   # ###  #####  #### #    #"
					,
					"'#####   #####  ####### ######"
					,
					"'#   # # #**#               #'"
					,
					"## # #   #**#  #######  ##  #'"
					,
					"#    #########  #    ##### ###"
					,
					"# #             # $        #*#"
					,
					"#   #########  ### @#####  #*#"
					,
					"#####'''''''####'####'''######"
				}
		});

		// level: Sasquatch IV
		levelMaps.add(new String[][] {
				{
					"'''####''''"
					,
					"####  #''''"
					,
					"#     ####'"
					,
					"# $ #  . ##"
					,
					"#  #   .  #"
					,
					"## #$$#.  #"
					,
					"##    #####"
					,
					"# @ ###''''"
					,
					"#   #''''''"
					,
					"#####''''''"
				}
				,
				{
					"'''''#####"
					,
					"######   #"
					,
					"#  $     #"
					,
					"#  $### ##"
					,
					"##.$. . .#"
					,
					"'# $#    #"
					,
					"'# @######"
					,
					"'#  #'''''"
					,
					"'####'''''"
				}
				,
				{
					"''''#####"
					,
					"'####   #"
					,
					"'# @ $# #"
					,
					"'# #....#"
					,
					"##$ $ $ #"
					,
					"#  ### ##"
					,
					"#      #'"
					,
					"#####  #'"
					,
					"''''####'"
				}
				,
				{
					"''######'"
					,
					"''#  . ##"
					,
					"''# #*  #"
					,
					"''# $.$ #"
					,
					"''## *. #"
					,
					"'## $.@ #"
					,
					"## # .$ #"
					,
					"#  $$.# #"
					,
					"#      ##"
					,
					"########'"
				}
				,
				{
					"'####'''"
					,
					"'#  #'''"
					,
					"## .###'"
					,
					"#  .$ #'"
					,
					"#* *  ##"
					,
					"# $.$$ #"
					,
					"#  .   #"
					,
					"###*####"
					,
					"''#@#'''"
					,
					"''###'''"
				}
				,
				{
					"''####'''''''''''"
					,
					"###  #'''''''''''"
					,
					"#  ..#'#######'''"
					,
					"# #..#'#     ####"
					,
					"# #. ###   $    #"
					,
					"# #.   # $ $ $$ #"
					,
					"# #  @ ### $##  #"
					,
					"#           #####"
					,
					"##  #########''''"
					,
					"'####''''''''''''"
				}
				,
				{
					"'###############'"
					,
					"## $.       .$ ##"
					,
					"#  # ####### #  #"
					,
					"# #           # #"
					,
					"#  .***$#$***.  #"
					,
					"###     #     ###"
					,
					"''# ####@#### #''"
					,
					"''#           #''"
					,
					"''#############''"
				}
				,
				{
					"#######################"
					,
					"#      #   #   #      #"
					,
					"# $@$$ # $     # .. ..#"
					,
					"## ## ### ### ### ## ##"
					,
					"'# #       #       # #'"
					,
					"'# #   #   #   #   # #'"
					,
					"'# ################# #'"
					,
					"'#                   #'"
					,
					"'#####################'"
				}
				,
				{
					"###########'"
					,
					"#@  #  #  #'"
					,
					"#  $#$   $#'"
					,
					"##  #..#  #'"
					,
					"'#  #..#  #'"
					,
					"'#  #..#  ##"
					,
					"'#$   $#$  #"
					,
					"'#  #  #   #"
					,
					"'###########"
				}
				,
				{
					"######''"
					,
					"#    #''"
					,
					"# .$ #''"
					,
					"# ** #''"
					,
					"##$. #''"
					,
					"'#  ####"
					,
					"'# ##  #"
					,
					"'#  #  #"
					,
					"'#     #"
					,
					"'#.**$@#"
					,
					"'#  #  #"
					,
					"'#######"
				}
				,
				{
					"''########"
					,
					"'##.... @#"
					,
					"'#  # .  #"
					,
					"## #  # ##"
					,
					"#  #$ # #'"
					,
					"# $   # ##"
					,
					"###$ ##  #"
					,
					"''#   $$ #"
					,
					"''#   #  #"
					,
					"''########"
				}
				,
				{
					"'######'''"
					,
					"'#    #'''"
					,
					"'#    ###'"
					,
					"'##*#   #'"
					,
					"## . ## #'"
					,
					"#     # ##"
					,
					"# #.#  $ #"
					,
					"# $.###$ #"
					,
					"### ##   #"
					,
					"''#   $$@#"
					,
					"'##..##  #"
					,
					"'#   #####"
					,
					"'#   #''''"
					,
					"'#####''''"
				}
				,
				{
					"''''''####''"
					,
					"''#####  #''"
					,
					"###.  #$ ##'"
					,
					"#  *   .*.#'"
					,
					"# $.$ #$  #'"
					,
					"### ###   #'"
					,
					"'#   ### ###"
					,
					"'#  $# $.$ #"
					,
					"'#.*.@  *  #"
					,
					"'## $#  .###"
					,
					"''#  #####''"
					,
					"''####''''''"
				}
				,
				{
					"'######''''"
					,
					"'#    #####"
					,
					"'# $ *#   #"
					,
					"'#  * * $ #"
					,
					"###* . *  #"
					,
					"# * .@. * #"
					,
					"#  * . *###"
					,
					"# $ * *  #'"
					,
					"#   #* $ #'"
					,
					"#####    #'"
					,
					"''''######'"
				}
				,
				{
					"###########"
					,
					"#    *    #"
					,
					"# $$ ## $ #"
					,
					"#  $..#$$ #"
					,
					"# ##*.*.  #"
					,
					"#*#..@..#*#"
					,
					"#  .*.*## #"
					,
					"# $$#..$  #"
					,
					"# $ ## $$ #"
					,
					"#    *    #"
					,
					"###########"
				}
				,
				{
					"#############"
					,
					"#     $   . #"
					,
					"#.$ $### *$ #"
					,
					"# ** ## .*  #"
					,
					"#  .$#..$ $ #"
					,
					"# # .$.$### #"
					,
					"#$##..@..##$#"
					,
					"# ###$.$. # #"
					,
					"# $ $..#$.  #"
					,
					"#  *. ## ** #"
					,
					"# $* ###$ $.#"
					,
					"# .   $     #"
					,
					"#############"
				}
				,
				{
					"###############"
					,
					"#             #"
					,
					"# $.$.$.$.$.$ #"
					,
					"# .$.$.#.$.$. #"
					,
					"# $.$.$ $.$.$ #"
					,
					"# .$.$.#.$.$. #"
					,
					"# $.$.$ $.$.$ #"
					,
					"# .# # @ # #. #"
					,
					"# $.$.$ $.$.$ #"
					,
					"# .$.$.#.$.$. #"
					,
					"# $.$.$ $.$.$ #"
					,
					"# .$.$.#.$.$. #"
					,
					"# $.$.$.$.$.$ #"
					,
					"#             #"
					,
					"###############"
				}
				,
				{
					"'###############'"
					,
					"##  #   #   #  ##"
					,
					"#   **.. ..**   #"
					,
					"#  *   $$$   *  #"
					,
					"##* .### ###. *##"
					,
					"# * ## $@$ ## * #"
					,
					"# . #       # . #"
					,
					"# .$#$ ### $#$. #"
					,
					"## $   #'#   $ ##"
					,
					"# .$#$ ### $#$. #"
					,
					"# . #       # . #"
					,
					"# * ## $ $ ## * #"
					,
					"##* .### ###. *##"
					,
					"#  *   $$$   *  #"
					,
					"#   **.. ..**   #"
					,
					"##  #   #   #  ##"
					,
					"'###############'"
				}
				,
				{
					"'#########'"
					,
					"'#   *   #'"
					,
					"'# ## ## #'"
					,
					"'#  * *  #'"
					,
					"###  #  ###"
					,
					"#  .$#$.  #"
					,
					"# #  @  # #"
					,
					"#  .$#$.  #"
					,
					"###  #  ###"
					,
					"''#######''"
				}
				,
				{
					"####'''''''''"
					,
					"#  #########'"
					,
					"#    ##    #'"
					,
					"# $$$#     #'"
					,
					"##...# #$$$#'"
					,
					"'#...# #...#'"
					,
					"'#$$$  #...##"
					,
					"'#    ##$$$ #"
					,
					"'####### @  #"
					,
					"'''''''######"
				}
				,
				{
					"''#########''"
					,
					"'##   #   #''"
					,
					"## $# # #$###"
					,
					"#   #. .#   #"
					,
					"# $ *.@.* $ #"
					,
					"#   #. .#   #"
					,
					"###$# # #$ ##"
					,
					"''#   #   ##'"
					,
					"''#########''"
				}
				,
				{
					"''####''####''''"
					,
					"''#  ####  ####'"
					,
					"###     $ $   #'"
					,
					"#    # $  *...##"
					,
					"# $ #'#### #.. #"
					,
					"##   #         #"
					,
					"'# $$ $$@ #...##"
					,
					"'#   #  #######'"
					,
					"'####   #'#'''''"
					,
					"''''#####'''''''"
				}
				,
				{
					"'''''''####'"
					,
					"''######  #'"
					,
					"'##  $  $ #'"
					,
					"##  $ #$  #'"
					,
					"#  $ #   $#'"
					,
					"#   # ##  ##"
					,
					"###$  ..#  #"
					,
					"''#  #*...@#"
					,
					"''#   ..####"
					,
					"''#  ####'''"
					,
					"''####''''''"
				}
				,
				{
					"''''''''''####''"
					,
					"''''''''''#  ###"
					,
					"''''''''''#    #"
					,
					"'''########$$  #"
					,
					"'''#       $  ##"
					,
					"'''# #### $$ ##'"
					,
					"####....# $  #''"
					,
					"#   ...# $$  #''"
					,
					"#  #...# $ ###''"
					,
					"# @## ## $ #''''"
					,
					"#         ##''''"
					,
					"#  #  #####'''''"
					,
					"#######'''''''''"
				}
				,
				{
					"'###############'"
					,
					"##  ....#      ##"
					,
					"#  # #     ###  #"
					,
					"#   ....# #   # #"
					,
					"#      # $ $  # #"
					,
					"##     # $@$ #  #"
					,
					"'####### $ $ #  #"
					,
					"''##*#   $ $  # #"
					,
					"'''### ####   # #"
					,
					"''''##     ###  #"
					,
					"'''''#####     ##"
					,
					"'''''''''#######'"
				}
				,
				{
					"'''#####'#####"
					,
					"'''# @ ###   #"
					,
					"'''# # $     #"
					,
					"#### #$ $ ####"
					,
					"#    # $ $#'''"
					,
					"# ### $ $ #'''"
					,
					"#.......# ##''"
					,
					"#### ## #  #''"
					,
					"'''#    #  #''"
					,
					"'''######  #''"
					,
					"''''''''####''"
				}
				,
				{
					"''''####'''''"
					,
					"''###  ###'''"
					,
					"###      ##''"
					,
					"# $$#$$$@ ##'"
					,
					"#     #    #'"
					,
					"# ###  #$$$#'"
					,
					"#    #   # #'"
					,
					"####   .## #'"
					,
					"'''####.## ##"
					,
					"''''## .##  #"
					,
					"''''##...   #"
					,
					"''''#  .#####"
					,
					"''''#  .#''''"
					,
					"''''#####''''"
				}
				,
				{
					"'####''''''''''"
					,
					"'#  #####''''''"
					,
					"'#  $ $ #''''''"
					,
					"'#* . . #''''''"
					,
					"'#  ########'''"
					,
					"'#      #  #'''"
					,
					"'#### $    #'''"
					,
					"'#   #$### #'''"
					,
					"'# @$#   # ####"
					,
					"'# $$ $$   #  #"
					,
					"'#   # ## $ * #"
					,
					"## ###.....#. #"
					,
					"#...  ###$# . #"
					,
					"# $ $       . #"
					,
					"########  #####"
					,
					"'''''''####''''"
				}
				,
				{
					"'#'##'####''"
					,
					"##'#''#  ###"
					,
					"'''#'##$   #"
					,
					"####'# * # #"
					,
					"#''''# * # #"
					,
					"''#### * # #"
					,
					"###    . # #"
					,
					"#@#.****$# #"
					,
					"#        # #"
					,
					"# #####  # #"
					,
					"#      ##  #"
					,
					"######    ##"
					,
					"'''''######'"
				}
				,
				{
					"''''''#####''''''''''''"
					,
					"''''''#   #######''''''"
					,
					"''''''#    ##   ##'''''"
					,
					"''''''#.#       ###''''"
					,
					"''#####.#  # #######'''"
					,
					"'##  ##.####. ##   ##''"
					,
					"##     .....@.#  $ ###'"
					,
					"#   ###.#  #.#  $ $  ##"
					,
					"#     #. #  .# $ $ $  #"
					,
					"#   # #.  ## #$ $ $   #"
					,
					"##  # #.   # $ $ $ ####"
					,
					"'###  #.   #  $ $ ##'''"
					,
					"'''# #     # $ $  #''''"
					,
					"'''# #    ######$##''''"
					,
					"'''#  ####       #'''''"
					,
					"'''##      #######'''''"
					,
					"''''########'''''''''''"
				}
				,
				{
					"'#############'"
					,
					"'#     @     #'"
					,
					"'#**.*****.**#'"
					,
					"'#  $     $  #'"
					,
					"'#   # ###   #'"
					,
					"'#####   #####'"
					,
					"######## ######"
					,
					"#             #"
					,
					"#**.*******.**#"
					,
					"#  $       $  #"
					,
					"#   #######   #"
					,
					"#####'''''#####"
				}
				,
				{
					"'''''''''''####'''"
					,
					"'''''''''###  #'''"
					,
					"''######## $$ ##''"
					,
					"###   #   .*.$ #''"
					,
					"#  $$ # #....$ #''"
					,
					"# $.. # $ $    #''"
					,
					"##$*. ##  ######''"
					,
					"'# ..$## ###   #''"
					,
					"'## .  #    $# #''"
					,
					"''# #$   @#  . ##'"
					,
					"''#   ### ##$.. #'"
					,
					"''######  ## .*$##"
					,
					"''#    $ $ # ..$ #"
					,
					"''# $....# # $$  #"
					,
					"''# $.*.   #   ###"
					,
					"''## $$ ########''"
					,
					"'''#  ###'''''''''"
					,
					"'''####'''''''''''"
				}
				,
				{
					"''''''#######''''''"
					,
					"'''''##     ##'''''"
					,
					"'''''#  *.*  #'''''"
					,
					"'''''# #$ $# #'''''"
					,
					"'#####  *.*  #####'"
					,
					"##   ##     ##   ##"
					,
					"#  #  ###.###  #  #"
					,
					"# *$* # $*$ # *$* #"
					,
					"# . . ..$@$.. . . #"
					,
					"# *$* # $*$ # *$* #"
					,
					"#  #  ###.###  #  #"
					,
					"##   ##     ##   ##"
					,
					"'#####  *.*  #####'"
					,
					"'''''# #$ $# #'''''"
					,
					"'''''#  *.*  #'''''"
					,
					"'''''##     ##'''''"
					,
					"''''''#######''''''"
				}
				,
				{
					"'''''#####'''''"
					,
					"'''''# @ #'''''"
					,
					"'''''# $ #'''''"
					,
					"'''''# $ #'''''"
					,
					"''''## $ ##''''"
					,
					"#####.*.*.#####"
					,
					"#    *. .*    #"
					,
					"# $$$. # .$$$ #"
					,
					"#    *. .*    #"
					,
					"#####.*.*.#####"
					,
					"''''## $ ##''''"
					,
					"'''''# $ #'''''"
					,
					"'''''# $ #'''''"
					,
					"'''''#   #'''''"
					,
					"'''''#####'''''"
				}
				,
				{
					"''''''#####''''''"
					,
					"''''''#   #''''''"
					,
					"'''''## $ ##'''''"
					,
					"''''## $.$ ##''''"
					,
					"'''## $ * $ ##'''"
					,
					"''## $.*.*.$ ##''"
					,
					"### $.*.#.*.$ ###"
					,
					"#  $ *.#'#.* $  #"
					,
					"# $.*.#'''#.*.$ #"
					,
					"#  $ *.#'#.* $  #"
					,
					"### $.*.#.*.$ ###"
					,
					"''## $.*.*.$ ##''"
					,
					"'''## $ * $ ##'''"
					,
					"''''## $.$ ##''''"
					,
					"'''''## $ ##'''''"
					,
					"''''''# @ #''''''"
					,
					"''''''#####''''''"
				}
				,
				{
					"''''''#####''''''"
					,
					"'''''###  ##'''''"
					,
					"''''## $   ##''''"
					,
					"'''## $  *$ ##'''"
					,
					"''## $.#.$.$ ##''"
					,
					"'## $.$. .$.$ ##'"
					,
					"## $.$. . .$.$ ##"
					,
					"#  *$. * * .# $##"
					,
					"#   . . @ . .   #"
					,
					"##$ #. * * .$*  #"
					,
					"## $.$. . .$.$ ##"
					,
					"'## $.$. .$.$ ##'"
					,
					"''## $.$.#.$ ##''"
					,
					"'''## $*  $ ##'''"
					,
					"''''##   $ ##''''"
					,
					"'''''##  ###'''''"
					,
					"''''''#####''''''"
				}
				,
				{
					"'''##'##'''"
					,
					"'##  #  ##'"
					,
					"'##     ##'"
					,
					"#  *$#$*  #"
					,
					"#  $...$  #"
					,
					"'# #.@.# #'"
					,
					"#  $...$  #"
					,
					"#  *$#$*  #"
					,
					"'##     ##'"
					,
					"'##  #  ##'"
					,
					"'''##'##'''"
				}
				,
				{
					"''''##'##''''"
					,
					"''##  #  ##''"
					,
					"'#  .$ $.  #'"
					,
					"'#  *   *  #'"
					,
					"# .* #.# *. #"
					,
					"# $ # $ # $ #"
					,
					"'#  .$@$.  #'"
					,
					"# $ # $ # $ #"
					,
					"# .* #.# *. #"
					,
					"'#  *   *  #'"
					,
					"'#  .$ $.  #'"
					,
					"''##  #  ##''"
					,
					"''''##'##''''"
				}
				,
				{
					"''#####'#'#####''"
					,
					"'## # ##### # ##'"
					,
					"'#  #   #   #  #'"
					,
					"## $* $   $ *$ ##"
					,
					"#   ..*# #*..   #"
					,
					"###*..  #  ..*###"
					,
					"'# $ *$ # $* $ #'"
					,
					"'#   #  *  #   #'"
					,
					"### ###* *### ###"
					,
					"'#   #  *  #   #'"
					,
					"'# $ *$ # $* $ #'"
					,
					"###*..  #  ..*###"
					,
					"#   ..*#@#*..   #"
					,
					"## $* $   $ *$ ##"
					,
					"'#  #   #   #  #'"
					,
					"'## # ##### # ##'"
					,
					"''#####'#'#####''"
				}
				,
				{
					"'''''''''''''###'''''''''''''"
					,
					"''''''#################''''''"
					,
					"''######   ##   ##   ######''"
					,
					"####   # $$   #   $$ #   ####"
					,
					"#  #$$     #.. ..#     $$#  #"
					,
					"#      ### #.###.# ###      #"
					,
					"#* ##### ### #*# ### ##### *#"
					,
					"#           ..@..           #"
					,
					"#* ##### ### #*# ### ##### *#"
					,
					"#      ### #.###.# ###      #"
					,
					"#  #$$     #.. ..#     $$#  #"
					,
					"####   # $$   #   $$ #   ####"
					,
					"''######   ##   ##   ######''"
					,
					"''''''#################''''''"
					,
					"'''''''''''''###'''''''''''''"
				}
				,
				{
					"###############"
					,
					"#  ..  .   .  #"
					,
					"# $##$ # $$##.#"
					,
					"#  #  ###  #  #"
					,
					"#.##  # # ##$ #"
					,
					"# $   $ $   $ #"
					,
					"#.##  # #  #  #"
					,
					"#.##  #@# ###.#"
					,
					"# $ # ### # #.#"
					,
					"# $         $ #"
					,
					"#.### ### # # #"
					,
					"#  #  #   ###.#"
					,
					"# $#$$###$# # #"
					,
					"#  .   .  . . #"
					,
					"###############"
				}
				,
				{
					"####'''#####'''####"
					,
					"#  ##''#   #####  #"
					,
					"# $.#''# $     $  #"
					,
					"#  .#''#   #####  #"
					,
					"## .#### ###  ##$##"
					,
					"'#$. $     #  $   #"
					,
					"'# ..###   #  #   #"
					,
					"'#*..@#######$#####"
					,
					"'# ..####   #  #'''"
					,
					"'#$. $      #  #'''"
					,
					"## .######$##  #'''"
					,
					"#  .#'''#  ##$##'''"
					,
					"# $.#'''#  $   #'''"
					,
					"#  ##'''#  #   #'''"
					,
					"####''''########'''"
				}
				,
				{
					"'################''''''''"
					,
					"##              ##'''''''"
					,
					"#  ############  #'''''''"
					,
					"# #            # #'''''''"
					,
					"# # $$$ $ $   @# #'''''''"
					,
					"#  #   ###   $$# ##''''''"
					,
					"## $ ##   #   $ $ #''''''"
					,
					"'##   # #  ####   #''''''"
					,
					"''###..  #     #  ###''''"
					,
					"''''##    .. # .# $ ####'"
					,
					"'''''# #### ## .# #.#  #'"
					,
					"'''''#    # ###* $ .#  ##"
					,
					"'''''#### #    .# #.    #"
					,
					"''''''''#   ## .###.##  #"
					,
					"''''''''######          #"
					,
					"'''''''''''''#   #  #   #"
					,
					"'''''''''''''############"
				}
				,
				{
					"###############################"
					,
					"#  .  .  .  .  .  .  .  .  .  #"
					,
					"# $ $ # $ $ # $ $ # $ $ # $ $ #"
					,
					"###.#####.#####.#####.#####.###"
					,
					"# $ $ # $ $ # $ $ # $ $ # $ $ #"
					,
					"#     .     .   # .     .     #"
					,
					"###.#####.###########.#####.###"
					,
					"#  $  #  $  . *@# #  *  *  $  #"
					,
					"#  $  *  *  # # * .  $  #  $  #"
					,
					"###.#####.###########.#####.###"
					,
					"#     .     . #   .     .     #"
					,
					"# $ $ # $ $ # $ $ # $ $ # $ $ #"
					,
					"###.#####.#####.#####.#####.###"
					,
					"# $ $ # $ $ # $ $ # $ $ # $ $ #"
					,
					"#  .  .  .  .  .  .  .  .  .  #"
					,
					"###############################"
				}
				,
				{
					"'#####################'"
					,
					"##   #   #   #   #   ##"
					,
					"# * * * * * * * * * * #"
					,
					"#  # # # # # # # # #  #"
					,
					"# $.$ $.$ $.$ $.$ $.$ #"
					,
					"##. .#. .#. .#. .#. .##"
					,
					"# $.$ $.$ $.$ $.$ $.$ #"
					,
					"#  # # # # # # # # #  #"
					,
					"# $.$ $.$ $.$ $.$ $.$ #"
					,
					"##. .#. .#.@.#. .#. .##"
					,
					"# $.$ $.$ $.$ $.$ $.$ #"
					,
					"#  # # # # # # # # #  #"
					,
					"# * * * * * * * * * * #"
					,
					"##   #   #   #   #   ##"
					,
					"'#####################'"
				}
				,
				{
					"'''#''''#''''#''''#''''#'''"
					,
					"'''#####################'''"
					,
					"''##    #    #    #    ##''"
					,
					"### .$$. .$$. .$$. .$$. ###"
					,
					"'# .*  *.*  *.*  *.*  *. #'"
					,
					"'# $ ## $ ## $ ## $ ## $ #'"
					,
					"'# $ ## $ ## $ ## $ ## $ #'"
					,
					"'# .*  *.*  *.*  *.*  *. #'"
					,
					"### .$$. .$$.@.$$. .$$. ###"
					,
					"'# .*  *.*  *.*  *.*  *. #'"
					,
					"'# $ ## $ ## $ ## $ ## $ #'"
					,
					"'# $ ## $ ## $ ## $ ## $ #'"
					,
					"'# .*  *.*  *.*  *.*  *. #'"
					,
					"### .$$. .$$. .$$. .$$. ###"
					,
					"''##    #    #    #    ##''"
					,
					"'''#####################'''"
					,
					"'''#''''#''''#''''#''''#'''"
				}
				,
				{
					"''''''''''''#####''''''''''''"
					,
					"'############ @ ############'"
					,
					"'#            #            #'"
					,
					"'#$.$  .$.$.$.#**.**$$$*.**#'"
					,
					"'#.$.$.$.$.$.$#  $. ..$.$  #'"
					,
					"'#$.$.$.$.$.$.#  $.$.. .$  #'"
					,
					"##.$.$.$.  $.$#**.*$$$**.**##"
					,
					"#             #             #"
					,
					"# ######################### #"
					,
					"#    ..  ..   # $ . $. $ .  #"
					,
					"## $*$*$$$$*$ #  $ $.$. .  ##"
					,
					"'# *. .. .$.$ #.$.$.  $.$.$#'"
					,
					"'# $.$. .. .* #$.$.$  .$.$.#'"
					,
					"'# $*$$$$*$*$ #  . .$.$ $  #'"
					,
					"'#   ..  ..   # . $ .$ . $ #'"
					,
					"'############ * ############'"
					,
					"''''''''''''#####''''''''''''"
				}
				,
				{
					"#############################"
					,
					"#   #   #   #   #   #   #   #"
					,
					"# # #   #   #   #   #   # # #"
					,
					"#   .$*$.$*$.$*$.$*$.$*$.   #"
					,
					"###.# # # # # # # # # # #.###"
					,
					"#  $  . . . . . . . . .  $  #"
					,
					"#  *# #$#$#$#$#$#$#$#$# #*  #"
					,
					"#  $  * . . . . . . . *  $  #"
					,
					"###*..$ #$#$#$@$#$#$# $..*###"
					,
					"#  $  * . . . . . . . *  $  #"
					,
					"#  *# #$#$#$#$#$#$#$#$# #*  #"
					,
					"#  $  . . . . . . . . .  $  #"
					,
					"###.# # # # # # # # # # #.###"
					,
					"#   .$*$.$*$.$*$.$*$.$*$.   #"
					,
					"# # #   #   #   #   #   # # #"
					,
					"#   #   #   #   #   #   #   #"
					,
					"#############################"
				}
				,
				{
					"'#############################'"
					,
					"'#         *   *   *         #'"
					,
					"'#  $ ### $  #####  $ ### $  #'"
					,
					"'# $ $ ### $  ###  $ ### $ $ #'"
					,
					"'#*#  $ ### $  #  $ ### $  #*#'"
					,
					"'# ## .*.*.*.*.$.*.*.*.*. ## #'"
					,
					"'# ###$ $ $ $ $.$ $ $ $ $### #'"
					,
					"## ..*.....*...$...*.....*.. ##"
					,
					"##  $ $ $ $ $ *@* $ $ $ $ $  ##"
					,
					"## ..*.....*...$...*.....*.. ##"
					,
					"'# ###$ $ $ $ $.$ $ $ $ $### #'"
					,
					"'# ## .*.*.*.*.$.*.*.*.*. ## #'"
					,
					"'#*#  $ ### $  #  $ ### $  #*#'"
					,
					"'# $ $ ### $  ###  $ ### $ $ #'"
					,
					"'#  $ ### $  #####  $ ### $  #'"
					,
					"'#         *   *   *         #'"
					,
					"'#############################'"
				}
		});
	}
}
