"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = require("@babel/helper-plugin-utils");

  _helperPluginUtils = function () {
    return data;
  };

  return data;
}

function _pluginSyntaxExportDefaultFrom() {
  const data = _interopRequireDefault(require("@babel/plugin-syntax-export-default-from"));

  _pluginSyntaxExportDefaultFrom = function () {
    return data;
  };

  return data;
}

function _core() {
  const data = require("@babel/core");

  _core = function () {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = (0, _helperPluginUtils().declare)(api => {
  api.assertVersion(7);
  return {
    name: "proposal-export-default-from",
    inherits: _pluginSyntaxExportDefaultFrom().default,
    visitor: {
      ExportNamedDeclaration(path) {
        const {
          node,
          scope
        } = path;
        const {
          specifiers
        } = node;
        if (!_core().types.isExportDefaultSpecifier(specifiers[0])) return;
        const specifier = specifiers.shift();
        const {
          exported
        } = specifier;
        const uid = scope.generateUidIdentifier(exported.name);
        const nodes = [_core().types.importDeclaration([_core().types.importDefaultSpecifier(uid)], _core().types.cloneNode(node.source)), _core().types.exportNamedDeclaration(null, [_core().types.exportSpecifier(_core().types.cloneNode(uid), exported)])];

        if (specifiers.length >= 1) {
          nodes.push(node);
        }

        const [importDeclaration] = path.replaceWithMultiple(nodes);
        path.scope.registerDeclaration(importDeclaration);
      }

    }
  };
});

exports.default = _default;