/*
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

#import "RCTMaskedView.h"

#import <React/UIView+React.h>

@implementation RCTMaskedView

- (void)didUpdateReactSubviews
{
  // RCTMaskedView expects that the first subview rendered is the mask.
  UIView *maskView = [self.reactSubviews firstObject];
  self.maskView = maskView;

  // Add the other subviews to the view hierarchy
  for (NSUInteger i = 1; i < self.reactSubviews.count; i++) {
    UIView *subview = [self.reactSubviews objectAtIndex:i];
    [self addSubview:subview];
  }
}

- (void)displayLayer:(__unused CALayer *)layer
{
  // RCTView uses displayLayer to do border rendering.
  // We don't need to do that in RCTMaskedView, so we
  // stub this method and override the default implementation.
}

@end
