"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const default_renderer_1 = require("../renderer/default.renderer");
const silent_renderer_1 = require("../renderer/silent.renderer");
const verbose_renderer_1 = require("../renderer/verbose.renderer");
const test_renderer_1 = require("./../renderer/test.renderer");
const renderers = {
    default: default_renderer_1.MultiLineRenderer,
    verbose: verbose_renderer_1.VerboseRenderer,
    silent: silent_renderer_1.SilentRenderer,
    test: test_renderer_1.TestRenderer
};
function isRendererSupported(renderer) {
    return process.stdout.isTTY === true || renderer.nonTTY === true;
}
function getRendererClass(renderer) {
    if (typeof renderer === 'string') {
        return renderers[renderer] || renderers.default;
    }
    return typeof renderer === 'function' ? renderer : renderers.default;
}
function getRenderer(renderer, fallbackRenderer) {
    let ret = getRendererClass(renderer);
    if (!isRendererSupported(ret)) {
        ret = getRendererClass(fallbackRenderer);
    }
    return ret;
}
exports.getRenderer = getRenderer;
//# sourceMappingURL=renderer.js.map