"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../utils/logger");
class VerboseRenderer {
    constructor(tasks, options) {
        this.tasks = tasks;
        this.options = options;
        this.logger = new logger_1.Logger();
    }
    render() {
        this.verboseRenderer(this.tasks);
    }
    end() { }
    verboseRenderer(tasks) {
        return tasks === null || tasks === void 0 ? void 0 : tasks.forEach((task) => {
            task.subscribe((event) => {
                if (task.isEnabled()) {
                    if (event.type === 'SUBTASK' && task.hasSubtasks()) {
                        this.verboseRenderer(task.subtasks);
                    }
                    else if (event.type === 'STATE') {
                        const taskTitle = task.hasTitle() ? task.title : 'Task without title.';
                        if (task.isPending()) {
                            this.logger.start(taskTitle);
                        }
                        else if (task.isCompleted()) {
                            this.logger.success(taskTitle);
                        }
                    }
                    else if (event.type === 'DATA') {
                        if (task.hasFailed()) {
                            this.logger.fail(String(event.data));
                        }
                        else if (task.isSkipped()) {
                            this.logger.skip(String(event.data));
                        }
                        else {
                            this.logger.data(String(event.data));
                        }
                    }
                }
            }, (err) => {
                this.logger.fail(err);
            });
        });
    }
}
exports.VerboseRenderer = VerboseRenderer;
VerboseRenderer.nonTTY = true;
//# sourceMappingURL=verbose.renderer.js.map