import { ListrContext, ListrOptions, ListrTask } from './interfaces/listr.interface';
import { Listr } from './listr';
export declare class Manager<InjectCtx = ListrContext> {
    options: ListrOptions<InjectCtx>;
    private tasks;
    constructor(options?: ListrOptions<InjectCtx>);
    set ctx(ctx: InjectCtx);
    add<Ctx = InjectCtx>(tasks: ListrTask<Ctx>[] | ((ctx?: Ctx) => ListrTask<Ctx>[]), options?: ListrOptions<Ctx>): void;
    runAll<Ctx = InjectCtx>(options?: ListrOptions<Ctx>): Promise<Ctx>;
    newListr<Ctx = InjectCtx>(tasks: ListrTask<Ctx>[], options?: ListrOptions<Ctx>): Listr<Ctx>;
    indent<Ctx = InjectCtx>(tasks: ListrTask<Ctx>[] | ((ctx?: Ctx) => ListrTask<Ctx>[]), options?: ListrOptions<Ctx>, taskOptions?: Omit<ListrTask, 'task'>): ListrTask<Ctx>;
    run<Ctx = InjectCtx>(tasks: ListrTask<Ctx>[], options?: ListrOptions<Ctx>): Promise<Ctx>;
    getRuntime(pipetime: number): string;
}
