"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const stream_to_observable_1 = __importDefault(require("@samverschueren/stream-to-observable"));
const rxjs_1 = require("rxjs");
const stream_1 = require("stream");
const uuid_1 = require("uuid");
const state_constants_1 = require("../constants/state.constants");
const listr_interface_1 = require("../interfaces/listr.interface");
const renderer_1 = require("../utils/renderer");
const listr_1 = require("./../listr");
class Task extends rxjs_1.Subject {
    constructor(listr, tasks, injectedOptions) {
        var _a, _b, _c, _d, _e, _f;
        super();
        this.listr = listr;
        this.tasks = tasks;
        this.injectedOptions = injectedOptions;
        this.id = uuid_1.v4();
        this.title = (_a = this.tasks) === null || _a === void 0 ? void 0 : _a.title;
        this.task = this.tasks.task;
        this.options = Object.assign({ persistentOutput: (_b = this.tasks) === null || _b === void 0 ? void 0 : _b.persistentOutput, bottomBar: (_c = this.tasks) === null || _c === void 0 ? void 0 : _c.bottomBar }, this.injectedOptions);
        this.skip = ((_d = this.tasks) === null || _d === void 0 ? void 0 : _d.skip) || (() => false);
        this.skip = ((_e = this.tasks) === null || _e === void 0 ? void 0 : _e.skip) || (() => false);
        this.enabledFn = ((_f = this.tasks) === null || _f === void 0 ? void 0 : _f.enabled) || (() => true);
    }
    set state$(state) {
        this.state = state;
        this.next({
            type: 'STATE',
            data: state
        });
    }
    async check(ctx) {
        if (this.state === undefined) {
            if (typeof this.enabledFn === 'function') {
                this.enabled = await this.enabledFn(ctx);
            }
            else {
                this.enabled = this.enabledFn;
            }
            this.next({
                type: 'ENABLED',
                data: this.enabled
            });
        }
    }
    hasSubtasks() {
        var _a;
        return ((_a = this.subtasks) === null || _a === void 0 ? void 0 : _a.length) > 0;
    }
    isPending() {
        return this.state === state_constants_1.stateConstants.PENDING;
    }
    isSkipped() {
        return this.state === state_constants_1.stateConstants.SKIPPED;
    }
    isCompleted() {
        return this.state === state_constants_1.stateConstants.COMPLETED;
    }
    hasFailed() {
        return this.state === state_constants_1.stateConstants.FAILED;
    }
    isEnabled() {
        return this.enabled;
    }
    isBottomBar() {
        if (typeof (this === null || this === void 0 ? void 0 : this.options.bottomBar) === 'number' || typeof this.options.bottomBar === 'boolean') {
            return true;
        }
    }
    haspersistentOutput() {
        if (this.options.persistentOutput === true) {
            return true;
        }
    }
    hasTitle() {
        return typeof (this === null || this === void 0 ? void 0 : this.title) === 'string';
    }
    isPrompt() {
        if (this.prompt) {
            return true;
        }
        else {
            return false;
        }
    }
    async run(context, wrapper) {
        const handleResult = (result) => {
            if (result instanceof listr_1.Listr) {
                result.options = Object.assign(this.options, result.options);
                result.rendererClass = renderer_1.getRenderer('silent');
                this.subtasks = result.tasks;
                this.next({ type: 'SUBTASK' });
                result = result.run(context);
            }
            else if (this.isPrompt()) {
            }
            else if (result instanceof Promise) {
                result = result.then(handleResult);
            }
            else if (result instanceof stream_1.Stream.Readable) {
                result = stream_to_observable_1.default(result);
            }
            else if (result instanceof rxjs_1.Observable) {
                result = new Promise((resolve, reject) => {
                    result.subscribe({
                        next: (data) => {
                            this.output = data;
                            this.next({
                                type: 'DATA',
                                data
                            });
                        },
                        error: reject,
                        complete: resolve
                    });
                });
            }
            return result;
        };
        this.state$ = state_constants_1.stateConstants.PENDING;
        const skipped = this.skip(context);
        if (skipped) {
            if (typeof skipped === 'string') {
                this.output = skipped;
            }
            else if (this.hasTitle()) {
                this.output = this.title;
            }
            this.state$ = state_constants_1.stateConstants.SKIPPED;
            return;
        }
        try {
            await handleResult(this.task(context, wrapper));
            if (this.isPending()) {
                this.state$ = state_constants_1.stateConstants.COMPLETED;
            }
        }
        catch (error) {
            this.state$ = state_constants_1.stateConstants.FAILED;
            if (this.prompt instanceof listr_interface_1.PromptError) {
                error = new Error('Cancelled the prompt.');
            }
            if (error instanceof listr_interface_1.ListrError) {
                wrapper.report(error);
                return;
            }
            if (!this.hasSubtasks()) {
                this.title = error.message;
            }
            wrapper.report(error);
            if (this.listr.options.exitOnError !== false) {
                throw error;
            }
        }
        finally {
            this.complete();
        }
    }
}
exports.Task = Task;
//# sourceMappingURL=task.js.map