import { Subject } from 'rxjs';
import { ListrContext, ListrEvent, ListrOptions, ListrTask, ListrTaskObject, ListrTaskWrapper, PromptError, StateConstants } from '../interfaces/listr.interface';
import { Listr } from './../listr';
export declare class Task<Ctx> extends Subject<ListrEvent> implements ListrTaskObject<ListrContext> {
    listr: Listr<Ctx>;
    tasks: ListrTask;
    injectedOptions: ListrOptions;
    id: ListrTaskObject<Ctx>['id'];
    title: ListrTaskObject<Ctx>['title'];
    task: ListrTaskObject<Ctx>['task'];
    skip: ListrTaskObject<Ctx>['skip'];
    subtasks: ListrTaskObject<Ctx>['subtasks'];
    state: ListrTaskObject<Ctx>['state'];
    output: ListrTaskObject<Ctx>['output'];
    prompt: boolean | PromptError;
    options: ListrTaskObject<Ctx>['options'];
    exitOnError: boolean;
    private enabled;
    private enabledFn;
    constructor(listr: Listr<Ctx>, tasks: ListrTask, injectedOptions: ListrOptions);
    set state$(state: StateConstants);
    check(ctx: Ctx): Promise<void>;
    hasSubtasks(): boolean;
    isPending(): boolean;
    isSkipped(): boolean;
    isCompleted(): boolean;
    hasFailed(): boolean;
    isEnabled(): boolean;
    isBottomBar(): boolean;
    haspersistentOutput(): boolean;
    hasTitle(): boolean;
    isPrompt(): boolean;
    run(context: Ctx, wrapper: ListrTaskWrapper<Ctx>): Promise<void>;
}
