import { ListrError, ListrOptions, ListrTask, ListrTaskWrapper, StateConstants } from '../interfaces/listr.interface';
import { Listr } from '../listr';
import { PromptOptionsType, PromptTypes } from '../utils/prompt.interface';
import { Task } from './task';
export declare class TaskWrapper<Ctx> implements ListrTaskWrapper {
    task: Task<Ctx>;
    errors: ListrError[];
    constructor(task: Task<Ctx>, errors: ListrError[]);
    set title(title: string);
    get title(): string;
    set output(data: string);
    get output(): string;
    set state(data: StateConstants);
    newListr<Ctx>(task: ListrTask<Ctx>[], options?: ListrOptions): Listr<Ctx>;
    report(error: Error | ListrError): void;
    skip(message: string): void;
    prompt<T = any, P extends PromptTypes = PromptTypes>(type: P, options: PromptOptionsType<P>): Promise<T>;
    run(ctx: Ctx): Promise<void>;
}
