
package com.matt.outfield

import android.os.Bundle
import android.view.WindowManager
import android.widget.TextView
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.Observer

public val ARG_HOSTNAME = "hostname"
public val ARG_PASSWORD = "password"

public class RemoteActivity : AppCompatActivity() {

    private val viewModel : RemoteViewModel by viewModels()

    private lateinit var connectionStatus : TextView

    override protected fun onCreate(savedInstanceState : Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.remote)

        val intent = getIntent()
        val hostname = intent.getStringExtra(ARG_HOSTNAME)
        val password = intent.getStringExtra(ARG_PASSWORD)

        viewModel.hostname = hostname
        viewModel.password = password

        window.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON)
    }

    override protected fun onResume() {
        super.onResume()

        connectionStatus = findViewById(R.id.connection_status) as TextView

        viewModel.connectionStatus.observe(
            this,
            Observer<RemoteViewModel.ConnectionStatus> {
                onUpdateConnectionStatus(it)
            }
        )

        viewModel.connect()
    }

    private fun
    onUpdateConnectionStatus(status : RemoteViewModel.ConnectionStatus) {

        val typeText = when (status.state) {
            RemoteViewModel.ConnectionState.CONNECTED ->
                getResources().getString(R.string.connected)
            RemoteViewModel.ConnectionState.DISCONNECTED ->
                getResources().getString(R.string.connected)
            RemoteViewModel.ConnectionState.FAILED ->
                getResources().getString(R.string.connection_failed)
            RemoteViewModel.ConnectionState.CONNECT_ERROR ->
                getResources().getString(R.string.connection_error)
        }
        connectionStatus.setText(
            if (status.message == null) {
                typeText
            } else {
                getResources().getString(
                    R.string.connection_status_format_with_message,
                    typeText, status.message
                )
            }
        )
    }

    override protected fun onPause() {
        super.onPause()
        viewModel.disconnect()
    }

}
