/*
 * Decompiled with CFR 0.152.
 */
package de.keyboardsurfer.android.widget.crouton;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.FrameLayout;
import de.keyboardsurfer.android.widget.crouton.Crouton;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

final class Manager
extends Handler {
    private static Manager INSTANCE;
    private Queue<Crouton> croutonQueue = new LinkedBlockingQueue<Crouton>();

    private Manager() {
    }

    static synchronized Manager getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new Manager();
        }
        return INSTANCE;
    }

    void add(Crouton crouton) {
        this.croutonQueue.add(crouton);
        this.displayCrouton();
    }

    private void displayCrouton() {
        if (this.croutonQueue.isEmpty()) {
            return;
        }
        Crouton currentCrouton = this.croutonQueue.peek();
        if (null == currentCrouton.getActivity()) {
            this.croutonQueue.poll();
        }
        if (!currentCrouton.isShowing()) {
            this.sendMessage(currentCrouton, -1040157475);
            if (null != currentCrouton.getLifecycleCallback()) {
                currentCrouton.getLifecycleCallback().onDisplayed();
            }
        } else {
            this.sendMessageDelayed(currentCrouton, 794631, this.calculateCroutonDuration(currentCrouton));
        }
    }

    private long calculateCroutonDuration(Crouton crouton) {
        long croutonDuration = crouton.getConfiguration().durationInMilliseconds;
        croutonDuration += crouton.getInAnimation().getDuration();
        return croutonDuration += crouton.getOutAnimation().getDuration();
    }

    private void sendMessage(Crouton crouton, int messageId) {
        Message message = this.obtainMessage(messageId);
        message.obj = crouton;
        this.sendMessage(message);
    }

    private void sendMessageDelayed(Crouton crouton, int messageId, long delay) {
        Message message = this.obtainMessage(messageId);
        message.obj = crouton;
        this.sendMessageDelayed(message, delay);
    }

    public void handleMessage(Message message) {
        Crouton crouton = (Crouton)message.obj;
        switch (message.what) {
            case 794631: {
                this.displayCrouton();
                break;
            }
            case -1040157475: {
                this.addCroutonToView(crouton);
                break;
            }
            case -1040155167: {
                this.removeCrouton(crouton);
                if (null == crouton.getLifecycleCallback()) break;
                crouton.getLifecycleCallback().onRemoved();
                break;
            }
            default: {
                super.handleMessage(message);
            }
        }
    }

    private void addCroutonToView(final Crouton crouton) {
        if (crouton.isShowing()) {
            return;
        }
        final View croutonView = crouton.getView();
        if (null == croutonView.getParent()) {
            ViewGroup.LayoutParams params = croutonView.getLayoutParams();
            if (null == params) {
                params = new ViewGroup.LayoutParams(-1, -2);
            }
            if (null != crouton.getViewGroup()) {
                if (crouton.getViewGroup() instanceof FrameLayout) {
                    crouton.getViewGroup().addView(croutonView, params);
                } else {
                    crouton.getViewGroup().addView(croutonView, 0, params);
                }
            } else {
                Activity activity = crouton.getActivity();
                if (null == activity || activity.isFinishing()) {
                    return;
                }
                activity.addContentView(croutonView, params);
            }
        }
        croutonView.requestLayout();
        croutonView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    croutonView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    croutonView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                croutonView.startAnimation(crouton.getInAnimation());
                Manager.announceForAccessibilityCompat((Context)crouton.getActivity(), crouton.getText());
                if (-1 != crouton.getConfiguration().durationInMilliseconds) {
                    Manager.this.sendMessageDelayed(crouton, -1040155167, (long)crouton.getConfiguration().durationInMilliseconds + crouton.getInAnimation().getDuration());
                }
            }
        });
    }

    protected void removeCrouton(Crouton crouton) {
        View croutonView = crouton.getView();
        ViewGroup croutonParentView = (ViewGroup)croutonView.getParent();
        if (null != croutonParentView) {
            croutonView.startAnimation(crouton.getOutAnimation());
            Crouton removed = this.croutonQueue.poll();
            croutonParentView.removeView(croutonView);
            if (null != removed) {
                removed.detachActivity();
                removed.detachViewGroup();
                if (null != removed.getLifecycleCallback()) {
                    removed.getLifecycleCallback().onRemoved();
                }
                removed.detachLifecycleCallback();
            }
            this.sendMessageDelayed(crouton, 794631, crouton.getOutAnimation().getDuration());
        }
    }

    void removeCroutonImmediately(Crouton crouton) {
        if (null != crouton.getActivity() && null != crouton.getView() && null != crouton.getView().getParent()) {
            ((ViewGroup)crouton.getView().getParent()).removeView(crouton.getView());
            this.removeAllMessagesForCrouton(crouton);
        }
        if (null != this.croutonQueue) {
            Iterator croutonIterator = this.croutonQueue.iterator();
            while (croutonIterator.hasNext()) {
                Crouton c = (Crouton)croutonIterator.next();
                if (!c.equals(crouton) || null == c.getActivity()) continue;
                if (crouton.isShowing()) {
                    ((ViewGroup)c.getView().getParent()).removeView(c.getView());
                }
                this.removeAllMessagesForCrouton(c);
                croutonIterator.remove();
                break;
            }
        }
    }

    void clearCroutonQueue() {
        this.removeAllMessages();
        if (null != this.croutonQueue) {
            for (Crouton crouton : this.croutonQueue) {
                if (!crouton.isShowing()) continue;
                ((ViewGroup)crouton.getView().getParent()).removeView(crouton.getView());
            }
            this.croutonQueue.clear();
        }
    }

    void clearCroutonsForActivity(Activity activity) {
        if (null != this.croutonQueue) {
            Iterator croutonIterator = this.croutonQueue.iterator();
            while (croutonIterator.hasNext()) {
                Crouton crouton = (Crouton)croutonIterator.next();
                if (null == crouton.getActivity() || !crouton.getActivity().equals(activity)) continue;
                if (crouton.isShowing()) {
                    ((ViewGroup)crouton.getView().getParent()).removeView(crouton.getView());
                }
                this.removeAllMessagesForCrouton(crouton);
                croutonIterator.remove();
            }
        }
    }

    private void removeAllMessages() {
        this.removeMessages(-1040157475);
        this.removeMessages(794631);
        this.removeMessages(-1040155167);
    }

    private void removeAllMessagesForCrouton(Crouton crouton) {
        this.removeMessages(-1040157475, crouton);
        this.removeMessages(794631, crouton);
        this.removeMessages(-1040155167, crouton);
    }

    public static void announceForAccessibilityCompat(Context context, CharSequence text) {
        if (Build.VERSION.SDK_INT >= 4) {
            AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
            if (!accessibilityManager.isEnabled()) {
                return;
            }
            int eventType = Build.VERSION.SDK_INT < 16 ? 8 : 16384;
            AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
            event.getText().add(text);
            event.setClassName((CharSequence)Manager.class.getName());
            event.setPackageName((CharSequence)context.getPackageName());
            accessibilityManager.sendAccessibilityEvent(event);
        }
    }

    public String toString() {
        return "Manager{croutonQueue=" + this.croutonQueue + '}';
    }

    private static final class Messages {
        public static final int DISPLAY_CROUTON = 794631;
        public static final int ADD_CROUTON_TO_VIEW = -1040157475;
        public static final int REMOVE_CROUTON = -1040155167;

        private Messages() {
        }
    }
}

