package com.hardcodecoder.pulsemusic.tag;

import android.content.Context;
import android.net.Uri;

import androidx.annotation.NonNull;

import com.hardcodecoder.pulsemusic.TaskRunner;
import com.hardcodecoder.pulsemusic.TaskRunner.Callback;
import com.hardcodecoder.pulsemusic.model.AudioFileModel;
import com.hardcodecoder.pulsemusic.model.MusicModel;
import com.hardcodecoder.pulsemusic.utils.StorageUtil;

import java.io.File;

public final class TagEditorUtils {

    private TagEditorUtils() {
    }

    public static void getTagFromTrack(@NonNull Context context,
                                       @NonNull MusicModel track,
                                       @NonNull Callback<AudioFileModel> callback) {
        TaskRunner.executeAsync(new AudioTagReader(context, track.getId()), callback);
    }

    public static void writeTagToTrack(@NonNull AudioFileModel audioFile, @NonNull Callback<Boolean> callback) {
        TaskRunner.executeAsync(new AudioTagWriter(audioFile), callback);
    }

    public static void getArtworkFromUri(@NonNull Context context, @NonNull Uri uri, @NonNull Callback<Boolean> callback) {
        TaskRunner.executeAsync(new AudioArtworkReader(context, uri), callback);
    }

    public static void updateAudioTrack(@NonNull Context context, @NonNull AudioFileModel audioFile, @NonNull Callback<Boolean> callback) {
        TaskRunner.executeAsync(new AudioFileUpdateTask(context, audioFile), callback);
    }

    public static void deleteTempFiles(@NonNull Context context) {
        // Delete the temp file only if they exists;
        TaskRunner.executeAsync(() -> {
            String path = TagUtils.getWorkingDirectoryPath(context);
            if (null == path) return;
            File workingDir = new File(path);
            File[] files = workingDir.listFiles();
            if (null == files || files.length == 0) return;
            for (File file : files) {
                StorageUtil.deleteFile(file);
            }
            StorageUtil.deleteFile(workingDir);
        });
    }
}