package com.hardcodecoder.pulsemusic.loaders;

import android.annotation.SuppressLint;
import android.content.Context;
import android.provider.MediaStore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.hardcodecoder.pulsemusic.providers.ProviderManager;
import com.hardcodecoder.pulsemusic.utils.AppSettings;

import java.util.List;

public class MasterListLoader extends BaseMasterListLoader {

    private List<String> mIgnoreFolderList;
    private int mIgnoreListSize;

    public MasterListLoader(@NonNull Context context,
                            @Nullable SortOrder sortOrder,
                            @Nullable String selection,
                            @Nullable String[] selectionArgs) {
        super(context, sortOrder, selection, selectionArgs);
    }

    @Override
    public void onReady(@NonNull Context context) {
        mIgnoreFolderList = ProviderManager.getIgnoredListProvider().getIgnoredList();
        mIgnoreListSize = (mIgnoreFolderList == null) ? 0 : mIgnoreFolderList.size();
    }

    @Override
    public boolean excludeItem(int id) {
        // Our ignore logic is build into the query selection string
        // So we return false
        return false;
    }

    @SuppressLint("InlinedApi")
    @Nullable
    @Override
    public String getSelection(@NonNull Context context, @Nullable String baseSelection) {
        StringBuilder completeSelection = new StringBuilder(
                baseSelection == null || baseSelection.trim().equals("") ? "" : baseSelection + " AND ");

        // Append duration filter
        completeSelection.append(MediaStore.Audio.Media.DURATION).append(" >= ?");

        // Append ignored folders selection
        if (mIgnoreListSize > 0) {
            String ignoredFolderSelection = getIgnoreFolderSelection();
            completeSelection.append(ignoredFolderSelection);
        }
        return completeSelection.toString();
    }

    @Nullable
    @Override
    public String[] getSelectionArgs(@NonNull Context context, @Nullable String[] baseSelectionArgs) {
        if (baseSelectionArgs == null) baseSelectionArgs = new String[0];
        final int completeArgsLength = baseSelectionArgs.length + 1 + mIgnoreListSize;
        String[] completeSelectionArgs = new String[completeArgsLength];

        // Copy the existing selection args
        System.arraycopy(baseSelectionArgs, 0, completeSelectionArgs, 0, baseSelectionArgs.length);

        // Copy args for duration filter
        int durationFilter = AppSettings.getFilterDuration(context);
        completeSelectionArgs[baseSelectionArgs.length] = String.valueOf(durationFilter * 1000 /*Must be in mills*/);

        if (mIgnoreFolderList != null && mIgnoreListSize > 0) {
            // Copy args for ignore folders
            String[] ignoredFolderArgs = getIgnoreFolderSelectionArgs(mIgnoreFolderList);
            System.arraycopy(ignoredFolderArgs, 0, completeSelectionArgs, baseSelectionArgs.length + 1, ignoredFolderArgs.length);
        }
        return completeSelectionArgs;
    }


    @NonNull
    private String getIgnoreFolderSelection() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < mIgnoreListSize; i++) {
            builder.append(" AND ").append(MediaStore.Audio.Media.DATA).append(" NOT LIKE ?");
        }
        return builder.toString();
    }

    @NonNull
    private String[] getIgnoreFolderSelectionArgs(@NonNull List<String> list) {
        String[] selectionArgs = new String[list.size()];
        for (int i = 0; i < selectionArgs.length; i++)
            selectionArgs[i] = "%".concat(list.get(i)).concat("%");
        return selectionArgs;
    }
}