package com.hardcodecoder.pulsemusic.glide;

import android.content.Context;

import androidx.annotation.NonNull;

import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;

import java.io.InputStream;

public class MediaArtworkLoaderFactory implements ModelLoaderFactory<MediaArtwork, InputStream> {

    private final Context mContext;
    private MediaArtworkLoader mLoader;

    public MediaArtworkLoaderFactory(@NonNull Context context) {
        mContext = context;
    }

    @NonNull
    @Override
    public ModelLoader<MediaArtwork, InputStream> build(@NonNull MultiModelLoaderFactory multiFactory) {
        if (null != mLoader) mLoader.cleanup();
        mLoader = new MediaArtworkLoader(mContext);
        return mLoader;
    }

    @Override
    public void teardown() {
        mLoader.cleanup();
    }
}