/*
 * Decompiled with CFR 0.152.
 */
package roboguice.config;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.Application;
import android.app.KeyguardManager;
import android.app.NotificationManager;
import android.app.SearchManager;
import android.app.Service;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.hardware.SensorManager;
import android.location.LocationManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.view.LayoutInflater;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import roboguice.activity.RoboActivity;
import roboguice.event.EventManager;
import roboguice.event.ObservesTypeListener;
import roboguice.event.eventListener.factory.EventListenerThreadingDecorator;
import roboguice.inject.AccountManagerProvider;
import roboguice.inject.AssetManagerProvider;
import roboguice.inject.ContentResolverProvider;
import roboguice.inject.ContextScope;
import roboguice.inject.ContextScopedSystemServiceProvider;
import roboguice.inject.ContextSingleton;
import roboguice.inject.ExtrasListener;
import roboguice.inject.FragmentManagerProvider;
import roboguice.inject.HandlerProvider;
import roboguice.inject.NullProvider;
import roboguice.inject.PreferenceListener;
import roboguice.inject.ResourceListener;
import roboguice.inject.ResourcesProvider;
import roboguice.inject.SharedPreferencesProvider;
import roboguice.inject.SystemServiceProvider;
import roboguice.inject.ViewListener;
import roboguice.service.RoboService;
import roboguice.util.Ln;
import roboguice.util.Strings;

public class DefaultRoboModule
extends AbstractModule {
    protected static final Class fragmentManagerClass;
    protected static final Class accountManagerClass;
    protected Application application;
    protected ContextScope contextScope;
    protected ResourceListener resourceListener;
    protected ViewListener viewListener;

    public DefaultRoboModule(Application application, ContextScope contextScope, ViewListener viewListener, ResourceListener resourceListener) {
        this.application = application;
        this.contextScope = contextScope;
        this.viewListener = viewListener;
        this.resourceListener = resourceListener;
    }

    protected void configure() {
        Provider contextProvider = this.getProvider(Context.class);
        ExtrasListener extrasListener = new ExtrasListener((Provider<Context>)contextProvider);
        PreferenceListener preferenceListener = new PreferenceListener((Provider<Context>)contextProvider, this.application, this.contextScope);
        EventListenerThreadingDecorator observerThreadingDecorator = new EventListenerThreadingDecorator();
        String androidId = Settings.Secure.getString((ContentResolver)this.application.getContentResolver(), (String)"android_id");
        try {
            PackageInfo info = this.application.getPackageManager().getPackageInfo(this.application.getPackageName(), 0);
            this.bind(PackageInfo.class).toInstance((Object)info);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (Strings.notEmpty(androidId)) {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"android_id")).to(androidId);
        }
        this.bind(ViewListener.class).toInstance((Object)this.viewListener);
        this.bind(PreferenceListener.class).toInstance((Object)preferenceListener);
        this.bindScope(ContextSingleton.class, this.contextScope);
        this.bind(ContextScope.class).toInstance((Object)this.contextScope);
        this.bind(AssetManager.class).toProvider(AssetManagerProvider.class);
        this.bind(Context.class).toProvider(Key.get((TypeLiteral)new TypeLiteral<NullProvider<Context>>(){})).in(ContextSingleton.class);
        this.bind(Activity.class).toProvider(Key.get((TypeLiteral)new TypeLiteral<NullProvider<Activity>>(){})).in(ContextSingleton.class);
        this.bind(RoboActivity.class).toProvider(Key.get((TypeLiteral)new TypeLiteral<NullProvider<RoboActivity>>(){})).in(ContextSingleton.class);
        this.bind(Service.class).toProvider(Key.get((TypeLiteral)new TypeLiteral<NullProvider<Service>>(){})).in(ContextSingleton.class);
        this.bind(RoboService.class).toProvider(Key.get((TypeLiteral)new TypeLiteral<NullProvider<RoboService>>(){})).in(ContextSingleton.class);
        this.bind(SharedPreferences.class).toProvider(SharedPreferencesProvider.class);
        this.bind(Resources.class).toProvider(ResourcesProvider.class);
        this.bind(ContentResolver.class).toProvider(ContentResolverProvider.class);
        this.bind(Application.class).toInstance((Object)this.application);
        this.bind(EventListenerThreadingDecorator.class).toInstance((Object)observerThreadingDecorator);
        this.bind(Handler.class).toProvider(HandlerProvider.class);
        this.bind(LocationManager.class).toProvider(new SystemServiceProvider("location"));
        this.bind(WindowManager.class).toProvider(new SystemServiceProvider("window"));
        this.bind(ActivityManager.class).toProvider(new SystemServiceProvider("activity"));
        this.bind(PowerManager.class).toProvider(new SystemServiceProvider("power"));
        this.bind(AlarmManager.class).toProvider(new SystemServiceProvider("alarm"));
        this.bind(NotificationManager.class).toProvider(new SystemServiceProvider("notification"));
        this.bind(KeyguardManager.class).toProvider(new SystemServiceProvider("keyguard"));
        this.bind(SearchManager.class).toProvider(new SystemServiceProvider("search"));
        this.bind(Vibrator.class).toProvider(new SystemServiceProvider("vibrator"));
        this.bind(ConnectivityManager.class).toProvider(new SystemServiceProvider("connectivity"));
        this.bind(WifiManager.class).toProvider(new SystemServiceProvider("wifi"));
        this.bind(InputMethodManager.class).toProvider(new SystemServiceProvider("input_method"));
        this.bind(SensorManager.class).toProvider(new SystemServiceProvider("sensor"));
        this.bind(TelephonyManager.class).toProvider(new SystemServiceProvider("phone"));
        this.bind(AudioManager.class).toProvider(new SystemServiceProvider("audio"));
        this.bind(LayoutInflater.class).toProvider(new ContextScopedSystemServiceProvider((Provider<Context>)contextProvider, "layout_inflater"));
        this.bindListener(Matchers.any(), this.resourceListener);
        this.bindListener(Matchers.any(), extrasListener);
        this.bindListener(Matchers.any(), this.viewListener);
        this.bindListener(Matchers.any(), preferenceListener);
        this.bindListener(Matchers.any(), new ObservesTypeListener((Provider<EventManager>)this.getProvider(EventManager.class), observerThreadingDecorator));
        this.requestInjection(observerThreadingDecorator);
        this.requestStaticInjection(new Class[]{Ln.class});
        if (fragmentManagerClass != null) {
            this.bind(fragmentManagerClass).toProvider(FragmentManagerProvider.class);
        }
        if (Build.VERSION.SDK_INT >= 5) {
            this.bind(accountManagerClass).toProvider(AccountManagerProvider.class);
        }
    }

    static {
        Class<?> c = null;
        try {
            c = Class.forName("android.support.v4.app.FragmentManager");
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        fragmentManagerClass = c;
        c = null;
        try {
            c = Class.forName("android.accounts.AccountManager");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        accountManagerClass = c;
    }
}

