# temperature-android

Simple Android application that shows hardware temperatures from /sys/class/thermal and BatteryManager.

Supported languages: English, Indonesian and Czech ([see below](#contribute))

[<img src="https://f-droid.org/badge/get-it-on.png"
     alt="Get it on F-Droid"
     height="80">](https://f-droid.org/packages/com.gmail.jiwopene.temperature/)

## Features
- Reading temperatures from /sys/class/thermal directory (it can use it even if you don't have permission to read contents of directory)
- Reading temperatures using Android API – BatteryManager class
- Configurable interval of reading sensor data (from 0.1 to 10 seconds)
- Logging temperatures (configurable interval from 1 to 60 minutes)
- Log can be exported as CSV

## Changelog
See [Tags page](../tags)

## Contribute
### Help translate to other languages
You can translate the app to other languages. Just download one of strings.xml files ([English](app/src/main/res/values/strings.xml), [Czech](app/src/main/res/values-cs/strings.xml), [Indonesian](app/src/main/res/values-in/strings.xml)) and translate the text between `>` and `<`. Please delete lines containing `translatable="false"` from your translation. Then submit [merge request](https://gitlab.com/jiwopene/temperature-android/merge_requests/new) or [issue](https://gitlab.com/jiwopene/temperature-android/issues/new) with translated file. When using merge requests, always adjust the language (directory `values-cs` for Czech, `values-fr` for French, etc.).

#### Example of one line from `strings.xml`
    Original
    <string name="refresh_sensors">Refresh sensor list</string>

    Translated
    <string name="refresh_sensors">Prohledat čidla</string>

#### Status of translations
<table>
 <tr>
  <th>Language</th>
  <th>
   State (Needs check/Good/Bad)
  </th>
  <th>
   Complete
  </th>
 </tr>
 <tr>
  <td>English</td>
  <td>Good</td>
  <td>Yes</td>
 </tr>
 <tr>
  <td>Czech</td>
  <td>Good</td>
  <td>Yes</td>
 </tr>
 <tr>
  <td>Indonesian</td>
  <td>Good</td>
  <td>No (4 strings remaining)</td>
 </tr>
</table>
