/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.speech.tts;

import android.os.Bundle;
import android.support.v4.speech.tts.VoiceInfo;

public final class RequestConfig {
    private final VoiceInfo mCurrentVoiceInfo;
    private final Bundle mVoiceParams;
    private final Bundle mAudioParams;

    RequestConfig(VoiceInfo voiceInfo, Bundle voiceParams, Bundle audioParams) {
        this.mCurrentVoiceInfo = voiceInfo;
        this.mVoiceParams = voiceParams;
        this.mAudioParams = audioParams;
    }

    public VoiceInfo getVoice() {
        return this.mCurrentVoiceInfo;
    }

    public Bundle getAudioParams() {
        return this.mAudioParams;
    }

    public Bundle getVoiceParams() {
        return this.mVoiceParams;
    }

    public static final class Builder {
        private VoiceInfo mCurrentVoiceInfo;
        private Bundle mVoiceParams;
        private Bundle mAudioParams;

        Builder(VoiceInfo currentVoiceInfo, Bundle voiceParams, Bundle audioParams) {
            this.mCurrentVoiceInfo = currentVoiceInfo;
            this.mVoiceParams = voiceParams;
            this.mAudioParams = audioParams;
        }

        public static Builder newBuilder() {
            return new Builder(null, new Bundle(), new Bundle());
        }

        public static Builder newBuilder(RequestConfig prototype) {
            return new Builder(prototype.mCurrentVoiceInfo, (Bundle)prototype.mVoiceParams.clone(), (Bundle)prototype.mAudioParams.clone());
        }

        public Builder setVoice(VoiceInfo voice) {
            this.mCurrentVoiceInfo = voice;
            this.mVoiceParams = (Bundle)voice.getParamsWithDefaults().clone();
            return this;
        }

        public Builder setVoiceParam(String paramName, Object value) {
            if (this.mCurrentVoiceInfo == null) {
                throw new IllegalStateException("Couldn't set voice parameter, no voice is set");
            }
            Object defaultValue = this.mCurrentVoiceInfo.getParamsWithDefaults().get(paramName);
            if (defaultValue == null) {
                throw new IllegalArgumentException("Parameter \"" + paramName + "\" is not available in set voice with " + "name: " + this.mCurrentVoiceInfo.getName());
            }
            if (value instanceof VoiceInfo) {
                value = ((VoiceInfo)value).getName();
            }
            if (!defaultValue.getClass().equals(value.getClass())) {
                throw new IllegalArgumentException("Parameter \"" + paramName + "\" is of different type. Value passed has " + "type " + value.getClass().getSimpleName() + " but should have " + "type " + defaultValue.getClass().getSimpleName());
            }
            this.setParam(this.mVoiceParams, paramName, value);
            return this;
        }

        public Builder setAudioParam(String paramName, Object value) {
            this.setParam(this.mAudioParams, paramName, value);
            return this;
        }

        public void setAudioParamStream(int streamId) {
            this.setAudioParam("streamType", streamId);
        }

        public void setAudioParamVolume(float volume) {
            this.setAudioParam("volume", Float.valueOf(volume));
        }

        public void setAudioParamPan(float pan) {
            this.setAudioParam("pan", Float.valueOf(pan));
        }

        private void setParam(Bundle bundle, String featureName, Object value) {
            if (value instanceof String) {
                bundle.putString(featureName, (String)value);
            } else if (value instanceof byte[]) {
                bundle.putByteArray(featureName, (byte[])value);
            } else if (value instanceof Integer) {
                bundle.putInt(featureName, ((Integer)value).intValue());
            } else if (value instanceof Float) {
                bundle.putFloat(featureName, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                bundle.putFloat(featureName, ((Float)value).floatValue());
            } else if (value instanceof Boolean) {
                bundle.putBoolean(featureName, ((Boolean)value).booleanValue());
            } else {
                throw new IllegalArgumentException("Illegal type of object");
            }
        }

        public RequestConfig build() {
            RequestConfig config = new RequestConfig(this.mCurrentVoiceInfo, this.mVoiceParams, this.mAudioParams);
            return config;
        }
    }
}

