/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics.drawable;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.BitmapCompat;
import android.support.v4.view.GravityCompat;
import android.util.DisplayMetrics;
import android.util.Log;
import java.io.InputStream;

public class RoundedBitmapDrawable
extends Drawable {
    private static final String TAG = "RoundedBitmapDrawable";
    private static final int DEFAULT_PAINT_FLAGS = 6;
    private Bitmap mBitmap;
    private int mTargetDensity = 160;
    private int mGravity = 119;
    private Paint mPaint = new Paint(6);
    private BitmapShader mBitmapShader;
    private float mCornerRadius;
    private final Rect mDstRect = new Rect();
    private final RectF mDstRectF = new RectF();
    private boolean mApplyGravity = true;
    private int mBitmapWidth;
    private int mBitmapHeight;

    public static RoundedBitmapDrawable createRoundedBitmapDrawable(Resources res, Bitmap bitmap) {
        return new RoundedBitmapDrawable(res, bitmap);
    }

    public static RoundedBitmapDrawable createRoundedBitmapDrawable(Resources res, String filepath) {
        RoundedBitmapDrawable drawable = RoundedBitmapDrawable.createRoundedBitmapDrawable(res, BitmapFactory.decodeFile((String)filepath));
        if (drawable.mBitmap == null) {
            Log.w((String)TAG, (String)("BitmapDrawable cannot decode " + filepath));
        }
        return drawable;
    }

    public static RoundedBitmapDrawable createRoundedBitmapDrawable(Resources res, InputStream is) {
        RoundedBitmapDrawable drawable = RoundedBitmapDrawable.createRoundedBitmapDrawable(res, BitmapFactory.decodeStream((InputStream)is));
        if (drawable.mBitmap == null) {
            Log.w((String)TAG, (String)("BitmapDrawable cannot decode " + is));
        }
        return drawable;
    }

    public final Paint getPaint() {
        return this.mPaint;
    }

    public final Bitmap getBitmap() {
        return this.mBitmap;
    }

    private void computeBitmapSize() {
        this.mBitmapWidth = this.mBitmap.getScaledWidth(this.mTargetDensity);
        this.mBitmapHeight = this.mBitmap.getScaledHeight(this.mTargetDensity);
    }

    public void setTargetDensity(Canvas canvas) {
        this.setTargetDensity(canvas.getDensity());
    }

    public void setTargetDensity(DisplayMetrics metrics) {
        this.setTargetDensity(metrics.densityDpi);
    }

    public void setTargetDensity(int density) {
        if (this.mTargetDensity != density) {
            int n = this.mTargetDensity = density == 0 ? 160 : density;
            if (this.mBitmap != null) {
                this.computeBitmapSize();
            }
            this.invalidateSelf();
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.mApplyGravity = true;
            this.invalidateSelf();
        }
    }

    public void setMipMap(boolean mipMap) {
        if (this.mBitmap != null) {
            BitmapCompat.setHasMipMap(this.mBitmap, mipMap);
            this.invalidateSelf();
        }
    }

    public boolean hasMipMap() {
        return this.mBitmap != null && BitmapCompat.hasMipMap(this.mBitmap);
    }

    public void setAntiAlias(boolean aa) {
        this.mPaint.setAntiAlias(aa);
        this.invalidateSelf();
    }

    public boolean hasAntiAlias() {
        return this.mPaint.isAntiAlias();
    }

    public void setFilterBitmap(boolean filter) {
        this.mPaint.setFilterBitmap(filter);
        this.invalidateSelf();
    }

    public void setDither(boolean dither) {
        this.mPaint.setDither(dither);
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        Bitmap bitmap = this.mBitmap;
        if (bitmap == null) {
            return;
        }
        Paint paint = this.mPaint;
        Shader shader = paint.getShader();
        if (shader == null) {
            if (this.mApplyGravity) {
                GravityCompat.apply(this.mGravity, this.mBitmapWidth, this.mBitmapHeight, this.getBounds(), this.mDstRect, 0);
                this.mDstRectF.set(this.mDstRect);
                this.mApplyGravity = false;
            }
            canvas.drawBitmap(bitmap, null, this.mDstRect, paint);
        } else {
            if (this.mApplyGravity) {
                this.copyBounds(this.mDstRect);
                this.mDstRectF.set(this.mDstRect);
                this.mApplyGravity = false;
            }
            canvas.drawRoundRect(this.mDstRectF, this.mCornerRadius, this.mCornerRadius, paint);
        }
    }

    public void setAlpha(int alpha) {
        int oldAlpha = this.mPaint.getAlpha();
        if (alpha != oldAlpha) {
            this.mPaint.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mPaint.getAlpha();
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
        this.invalidateSelf();
    }

    public ColorFilter getColorFilter() {
        return this.mPaint.getColorFilter();
    }

    public void setCornerRadius(float cornerRadius) {
        if (this.isGreaterThanZero(cornerRadius)) {
            this.mPaint.setShader((Shader)this.mBitmapShader);
        } else {
            this.mPaint.setShader(null);
        }
        this.mCornerRadius = cornerRadius;
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    public int getOpacity() {
        if (this.mGravity != 119) {
            return -3;
        }
        Bitmap bm = this.mBitmap;
        return bm == null || bm.hasAlpha() || this.mPaint.getAlpha() < 255 || this.isGreaterThanZero(this.mCornerRadius) ? -3 : -1;
    }

    private RoundedBitmapDrawable(Resources res, Bitmap bitmap) {
        if (res != null) {
            this.mTargetDensity = res.getDisplayMetrics().densityDpi;
        }
        this.mBitmap = bitmap;
        if (this.mBitmap != null) {
            this.computeBitmapSize();
            this.mBitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        } else {
            this.mBitmapHeight = -1;
            this.mBitmapWidth = -1;
        }
    }

    private boolean isGreaterThanZero(float toCompare) {
        return Float.compare(toCompare, 0.0f) > 0;
    }
}

