/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.RectF;
import com.androidplot.util.ValPixConverter;
import com.androidplot.xy.XYAxisType;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYStep;
import com.androidplot.xy.XYStepMode;

public class XYStepCalculator {
    public static XYStep getStep(XYPlot plot, XYAxisType axisType, RectF rect, Number minVal, Number maxVal) {
        XYStep step = null;
        switch (axisType) {
            case DOMAIN: {
                step = XYStepCalculator.getStep(plot.getDomainStepMode(), rect.width(), plot.getDomainStepValue(), minVal, maxVal);
                break;
            }
            case RANGE: {
                step = XYStepCalculator.getStep(plot.getRangeStepMode(), rect.height(), plot.getRangeStepValue(), minVal, maxVal);
            }
        }
        return step;
    }

    public static XYStep getStep(XYStepMode typeXY, float plotPixelSize, double stepValue, Number minVal, Number maxVal) {
        double stepVal = 0.0;
        float stepPix = 0.0f;
        float stepCount = 0.0f;
        switch (typeXY) {
            case INCREMENT_BY_VAL: {
                stepVal = stepValue;
                stepPix = (float)(stepValue / ValPixConverter.valPerPix(minVal.doubleValue(), maxVal.doubleValue(), plotPixelSize));
                stepCount = plotPixelSize / stepPix;
                break;
            }
            case INCREMENT_BY_PIXELS: {
                stepPix = new Double(stepValue).floatValue();
                stepCount = plotPixelSize / stepPix;
                stepVal = ValPixConverter.valPerPix(minVal.doubleValue(), maxVal.doubleValue(), plotPixelSize) * (double)stepPix;
                break;
            }
            case SUBDIVIDE: {
                stepCount = new Double(stepValue).floatValue();
                stepPix = plotPixelSize / (stepCount - 1.0f);
                stepVal = ValPixConverter.valPerPix(minVal.doubleValue(), maxVal.doubleValue(), plotPixelSize) * (double)stepPix;
            }
        }
        return new XYStep(stepCount, stepPix, stepVal);
    }
}

