/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.util.AttributeSet;
import com.androidplot.Plot;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.ui.DynamicTableModel;
import com.androidplot.ui.SizeLayoutType;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.TextOrientationType;
import com.androidplot.ui.XLayoutStyle;
import com.androidplot.ui.YLayoutStyle;
import com.androidplot.ui.widget.TextLabelWidget;
import com.androidplot.util.PixelUtils;
import com.androidplot.xy.BoundaryMode;
import com.androidplot.xy.RectRegion;
import com.androidplot.xy.XValueMarker;
import com.androidplot.xy.XYFramingModel;
import com.androidplot.xy.XYGraphWidget;
import com.androidplot.xy.XYLegendWidget;
import com.androidplot.xy.XYSeries;
import com.androidplot.xy.XYSeriesFormatter;
import com.androidplot.xy.XYSeriesRenderer;
import com.androidplot.xy.XYStepMode;
import com.androidplot.xy.YValueMarker;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

public class XYPlot
extends Plot<XYSeries, XYSeriesFormatter, XYSeriesRenderer> {
    private BoundaryMode domainOriginBoundaryMode;
    private BoundaryMode rangeOriginBoundaryMode;
    private XYLegendWidget legendWidget;
    private XYGraphWidget graphWidget;
    private TextLabelWidget domainLabelWidget;
    private TextLabelWidget rangeLabelWidget;
    private XYStepMode domainStepMode = XYStepMode.SUBDIVIDE;
    private double domainStepValue = 10.0;
    private XYStepMode rangeStepMode = XYStepMode.SUBDIVIDE;
    private double rangeStepValue = 10.0;
    private Number userMinX;
    private Number userMaxX;
    private Number userMinY;
    private Number userMaxY;
    private Number calculatedMinX;
    private Number calculatedMaxX;
    private Number calculatedMinY;
    private Number calculatedMaxY;
    private Number prevMinX;
    private Number prevMaxX;
    private Number prevMinY;
    private Number prevMaxY;
    private Number rangeTopMin = null;
    private Number rangeTopMax = null;
    private Number rangeBottomMin = null;
    private Number rangeBottomMax = null;
    private Number domainLeftMin = null;
    private Number domainLeftMax = null;
    private Number domainRightMin = null;
    private Number domainRightMax = null;
    private XYFramingModel domainFramingModel = XYFramingModel.EDGE;
    private XYFramingModel rangeFramingModel = XYFramingModel.EDGE;
    private Number userDomainOrigin;
    private Number userRangeOrigin;
    private Number calculatedDomainOrigin;
    private Number calculatedRangeOrigin;
    private Number domainOriginExtent = null;
    private Number rangeOriginExtent = null;
    private BoundaryMode domainUpperBoundaryMode = BoundaryMode.AUTO;
    private BoundaryMode domainLowerBoundaryMode = BoundaryMode.AUTO;
    private BoundaryMode rangeUpperBoundaryMode = BoundaryMode.AUTO;
    private BoundaryMode rangeLowerBoundaryMode = BoundaryMode.AUTO;
    private boolean drawDomainOriginEnabled = true;
    private boolean drawRangeOriginEnabled = true;
    private ArrayList<YValueMarker> yValueMarkers;
    private ArrayList<XValueMarker> xValueMarkers;
    private RectRegion defaultBounds;
    private static final int DEFAULT_LEGEND_WIDGET_H_DP = 10;
    private static final int DEFAULT_LEGEND_WIDGET_ICON_SIZE_DP = 7;
    private static final int DEFAULT_GRAPH_WIDGET_H_DP = 18;
    private static final int DEFAULT_GRAPH_WIDGET_W_DP = 10;
    private static final int DEFAULT_DOMAIN_LABEL_WIDGET_H_DP = 10;
    private static final int DEFAULT_DOMAIN_LABEL_WIDGET_W_DP = 80;
    private static final int DEFAULT_RANGE_LABEL_WIDGET_H_DP = 50;
    private static final int DEFAULT_RANGE_LABEL_WIDGET_W_DP = 10;
    private static final int DEFAULT_LEGEND_WIDGET_Y_OFFSET_DP = 0;
    private static final int DEFAULT_LEGEND_WIDGET_X_OFFSET_DP = 40;
    private static final int DEFAULT_GRAPH_WIDGET_Y_OFFSET_DP = 0;
    private static final int DEFAULT_GRAPH_WIDGET_X_OFFSET_DP = 0;
    private static final int DEFAULT_DOMAIN_LABEL_WIDGET_Y_OFFSET_DP = 0;
    private static final int DEFAULT_DOMAIN_LABEL_WIDGET_X_OFFSET_DP = 20;
    private static final int DEFAULT_RANGE_LABEL_WIDGET_Y_OFFSET_DP = 0;
    private static final int DEFAULT_RANGE_LABEL_WIDGET_X_OFFSET_DP = 0;
    private static final int DEFAULT_GRAPH_WIDGET_TOP_MARGIN_DP = 3;
    private static final int DEFAULT_GRAPH_WIDGET_RIGHT_MARGIN_DP = 3;
    private static final int DEFAULT_PLOT_LEFT_MARGIN_DP = 2;
    private static final int DEFAULT_PLOT_RIGHT_MARGIN_DP = 2;
    private static final int DEFAULT_PLOT_BOTTOM_MARGIN_DP = 2;

    public XYPlot(Context context, String title) {
        super(context, title);
    }

    public XYPlot(Context context, String title, Plot.RenderMode mode) {
        super(context, title, mode);
    }

    public XYPlot(Context context, AttributeSet attributes) {
        super(context, attributes);
    }

    public XYPlot(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void onPreInit() {
        this.legendWidget = new XYLegendWidget(this.getLayoutManager(), this, new SizeMetrics(PixelUtils.dpToPix(10.0f), SizeLayoutType.ABSOLUTE, 0.5f, SizeLayoutType.RELATIVE), new DynamicTableModel(0, 1), new SizeMetrics(PixelUtils.dpToPix(7.0f), SizeLayoutType.ABSOLUTE, PixelUtils.dpToPix(7.0f), SizeLayoutType.ABSOLUTE));
        this.graphWidget = new XYGraphWidget(this.getLayoutManager(), this, new SizeMetrics(PixelUtils.dpToPix(18.0f), SizeLayoutType.FILL, PixelUtils.dpToPix(10.0f), SizeLayoutType.FILL));
        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(-12303292);
        backgroundPaint.setStyle(Paint.Style.FILL);
        this.graphWidget.setBackgroundPaint(backgroundPaint);
        this.domainLabelWidget = new TextLabelWidget(this.getLayoutManager(), new SizeMetrics(PixelUtils.dpToPix(10.0f), SizeLayoutType.ABSOLUTE, PixelUtils.dpToPix(80.0f), SizeLayoutType.ABSOLUTE), TextOrientationType.HORIZONTAL);
        this.rangeLabelWidget = new TextLabelWidget(this.getLayoutManager(), new SizeMetrics(PixelUtils.dpToPix(50.0f), SizeLayoutType.ABSOLUTE, PixelUtils.dpToPix(10.0f), SizeLayoutType.ABSOLUTE), TextOrientationType.VERTICAL_ASCENDING);
        this.legendWidget.position(PixelUtils.dpToPix(40.0f), XLayoutStyle.ABSOLUTE_FROM_RIGHT, PixelUtils.dpToPix(0.0f), YLayoutStyle.ABSOLUTE_FROM_BOTTOM, AnchorPosition.RIGHT_BOTTOM);
        this.graphWidget.position(PixelUtils.dpToPix(0.0f), XLayoutStyle.ABSOLUTE_FROM_RIGHT, PixelUtils.dpToPix(0.0f), YLayoutStyle.ABSOLUTE_FROM_CENTER, AnchorPosition.RIGHT_MIDDLE);
        this.domainLabelWidget.position(PixelUtils.dpToPix(20.0f), XLayoutStyle.ABSOLUTE_FROM_LEFT, PixelUtils.dpToPix(0.0f), YLayoutStyle.ABSOLUTE_FROM_BOTTOM, AnchorPosition.LEFT_BOTTOM);
        this.rangeLabelWidget.position(PixelUtils.dpToPix(0.0f), XLayoutStyle.ABSOLUTE_FROM_LEFT, PixelUtils.dpToPix(0.0f), YLayoutStyle.ABSOLUTE_FROM_CENTER, AnchorPosition.LEFT_MIDDLE);
        this.getLayoutManager().moveToTop(this.getTitleWidget());
        this.getLayoutManager().moveToTop(this.getLegendWidget());
        this.graphWidget.setMarginTop(PixelUtils.dpToPix(3.0f));
        this.graphWidget.setMarginRight(PixelUtils.dpToPix(3.0f));
        this.getDomainLabelWidget().pack();
        this.getRangeLabelWidget().pack();
        this.setPlotMarginLeft(PixelUtils.dpToPix(2.0f));
        this.setPlotMarginRight(PixelUtils.dpToPix(2.0f));
        this.setPlotMarginBottom(PixelUtils.dpToPix(2.0f));
        this.xValueMarkers = new ArrayList();
        this.yValueMarkers = new ArrayList();
        this.setDefaultBounds(new RectRegion(-1, 1, -1, 1));
    }

    public void setGridPadding(float left, float top, float right, float bottom) {
        this.getGraphWidget().setGridPaddingTop(top);
        this.getGraphWidget().setGridPaddingBottom(bottom);
        this.getGraphWidget().setGridPaddingLeft(left);
        this.getGraphWidget().setGridPaddingRight(right);
    }

    @Override
    protected void notifyListenersBeforeDraw(Canvas canvas) {
        super.notifyListenersBeforeDraw(canvas);
        this.calculateMinMaxVals();
    }

    public boolean containsPoint(float x, float y) {
        if (this.getGraphWidget().getGridRect() != null) {
            return this.getGraphWidget().getGridRect().contains(x, y);
        }
        return false;
    }

    public boolean containsPoint(PointF point) {
        return this.containsPoint(point.x, point.y);
    }

    public void setCursorPosition(PointF point) {
        this.getGraphWidget().setCursorPosition(point);
    }

    public void setCursorPosition(float x, float y) {
        this.getGraphWidget().setCursorPosition(x, y);
    }

    public Number getYVal(PointF point) {
        return this.getGraphWidget().getYVal(point);
    }

    public Number getXVal(PointF point) {
        return this.getGraphWidget().getXVal(point);
    }

    private boolean isXValWithinView(double xVal) {
        return (this.userMinY == null || xVal >= this.userMinY.doubleValue()) && this.userMaxY == null || xVal <= this.userMaxY.doubleValue();
    }

    private boolean isPointVisible(Number x, Number y) {
        if (x == null || y == null) {
            return false;
        }
        return this.isValWithinRange(y.doubleValue(), this.userMinY, this.userMaxY) && this.isValWithinRange(x.doubleValue(), this.userMinX, this.userMaxX);
    }

    private boolean isValWithinRange(double val, Number min, Number max) {
        boolean isAboveMinThreshold = min == null || val >= min.doubleValue();
        boolean isBelowMaxThreshold = max == null || val <= max.doubleValue();
        return isAboveMinThreshold && isBelowMaxThreshold;
    }

    public void calculateMinMaxVals() {
        this.prevMinX = this.calculatedMinX;
        this.prevMaxX = this.calculatedMaxX;
        this.prevMinY = this.calculatedMinY;
        this.prevMaxY = this.calculatedMaxY;
        this.calculatedMinX = this.userMinX;
        this.calculatedMaxX = this.userMaxX;
        this.calculatedMinY = this.userMinY;
        this.calculatedMaxY = this.userMaxY;
        for (XYSeries series : this.getSeriesSet()) {
            for (int i = 0; i < series.size(); ++i) {
                Number thisY;
                Number thisX = series.getX(i);
                if (!this.isPointVisible(thisX, thisY = series.getY(i))) continue;
                if (this.userMinX == null && thisX != null && (this.calculatedMinX == null || thisX.doubleValue() < this.calculatedMinX.doubleValue())) {
                    this.calculatedMinX = thisX;
                }
                if (this.userMaxX == null && thisX != null && (this.calculatedMaxX == null || thisX.doubleValue() > this.calculatedMaxX.doubleValue())) {
                    this.calculatedMaxX = thisX;
                }
                if (this.userMinY == null && thisY != null && (this.calculatedMinY == null || thisY.doubleValue() < this.calculatedMinY.doubleValue())) {
                    this.calculatedMinY = thisY;
                }
                if (this.userMaxY != null || thisY == null || this.calculatedMaxY != null && !(thisY.doubleValue() > this.calculatedMaxY.doubleValue())) continue;
                this.calculatedMaxY = thisY;
            }
        }
        switch (this.domainFramingModel) {
            case ORIGIN: {
                this.updateDomainMinMaxForOriginModel();
                break;
            }
            case EDGE: {
                this.updateDomainMinMaxForEdgeModel();
                this.calculatedMinX = this.ApplyUserMinMax(this.calculatedMinX, this.domainLeftMin, this.domainLeftMax);
                this.calculatedMaxX = this.ApplyUserMinMax(this.calculatedMaxX, this.domainRightMin, this.domainRightMax);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Domain Framing Model not yet supported: " + (Object)((Object)this.domainFramingModel));
            }
        }
        switch (this.rangeFramingModel) {
            case ORIGIN: {
                this.updateRangeMinMaxForOriginModel();
                break;
            }
            case EDGE: {
                if (this.getSeriesSet().size() <= 0) break;
                this.updateRangeMinMaxForEdgeModel();
                this.calculatedMinY = this.ApplyUserMinMax(this.calculatedMinY, this.rangeBottomMin, this.rangeBottomMax);
                this.calculatedMaxY = this.ApplyUserMinMax(this.calculatedMaxY, this.rangeTopMin, this.rangeTopMax);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Range Framing Model not yet supported: " + (Object)((Object)this.domainFramingModel));
            }
        }
        this.calculatedDomainOrigin = this.userDomainOrigin != null ? (Number)this.userDomainOrigin : (Number)this.getCalculatedMinX();
        this.calculatedRangeOrigin = this.userRangeOrigin != null ? (Number)this.userRangeOrigin : (Number)this.getCalculatedMinY();
    }

    private void updateDomainMinMaxForEdgeModel() {
        switch (this.domainUpperBoundaryMode) {
            case FIXED: {
                break;
            }
            case AUTO: {
                break;
            }
            case GROW: {
                if (this.prevMaxX == null || this.calculatedMaxX.doubleValue() > this.prevMaxX.doubleValue()) break;
                this.calculatedMaxX = this.prevMaxX;
                break;
            }
            case SHRINNK: {
                if (this.prevMaxX == null || this.calculatedMaxX.doubleValue() < this.prevMaxX.doubleValue()) break;
                this.calculatedMaxX = this.prevMaxX;
                break;
            }
            default: {
                throw new UnsupportedOperationException("DomainUpperBoundaryMode not yet implemented: " + (Object)((Object)this.domainUpperBoundaryMode));
            }
        }
        switch (this.domainLowerBoundaryMode) {
            case FIXED: {
                break;
            }
            case AUTO: {
                break;
            }
            case GROW: {
                if (this.prevMinX == null || this.calculatedMinX.doubleValue() < this.prevMinX.doubleValue()) break;
                this.calculatedMinX = this.prevMinX;
                break;
            }
            case SHRINNK: {
                if (this.prevMinX == null || this.calculatedMinX.doubleValue() > this.prevMinX.doubleValue()) break;
                this.calculatedMinX = this.prevMinX;
                break;
            }
            default: {
                throw new UnsupportedOperationException("DomainLowerBoundaryMode not supported: " + (Object)((Object)this.domainLowerBoundaryMode));
            }
        }
    }

    public void updateRangeMinMaxForEdgeModel() {
        switch (this.rangeUpperBoundaryMode) {
            case FIXED: {
                break;
            }
            case AUTO: {
                break;
            }
            case GROW: {
                if (this.prevMaxY == null || this.calculatedMaxY.doubleValue() > this.prevMaxY.doubleValue()) break;
                this.calculatedMaxY = this.prevMaxY;
                break;
            }
            case SHRINNK: {
                if (this.prevMaxY == null || this.calculatedMaxY.doubleValue() < this.prevMaxY.doubleValue()) break;
                this.calculatedMaxY = this.prevMaxY;
                break;
            }
            default: {
                throw new UnsupportedOperationException("RangeUpperBoundaryMode not supported: " + (Object)((Object)this.rangeUpperBoundaryMode));
            }
        }
        switch (this.rangeLowerBoundaryMode) {
            case FIXED: {
                break;
            }
            case AUTO: {
                break;
            }
            case GROW: {
                if (this.prevMinY == null || this.calculatedMinY.doubleValue() < this.prevMinY.doubleValue()) break;
                this.calculatedMinY = this.prevMinY;
                break;
            }
            case SHRINNK: {
                if (this.prevMinY == null || this.calculatedMinY.doubleValue() > this.prevMinY.doubleValue()) break;
                this.calculatedMinY = this.prevMinY;
                break;
            }
            default: {
                throw new UnsupportedOperationException("RangeLowerBoundaryMode not supported: " + (Object)((Object)this.rangeLowerBoundaryMode));
            }
        }
    }

    private Number ApplyUserMinMax(Number value, Number min, Number max) {
        value = min == null || value == null || value.doubleValue() > min.doubleValue() ? (Number)value : (Number)min;
        value = max == null || value == null || value.doubleValue() < max.doubleValue() ? (Number)value : (Number)max;
        return value;
    }

    public void centerOnDomainOrigin(Number origin) {
        this.centerOnDomainOrigin(origin, null, BoundaryMode.AUTO);
    }

    public void centerOnDomainOrigin(Number origin, Number extent, BoundaryMode mode) {
        if (origin == null) {
            throw new NullPointerException("Origin param cannot be null.");
        }
        this.domainFramingModel = XYFramingModel.ORIGIN;
        this.setUserDomainOrigin(origin);
        this.domainOriginExtent = extent;
        this.domainOriginBoundaryMode = mode;
        if (this.domainOriginBoundaryMode == BoundaryMode.FIXED) {
            double domO = this.userDomainOrigin.doubleValue();
            double domE = this.domainOriginExtent.doubleValue();
            this.userMaxX = domO + domE;
            this.userMinX = domO - domE;
        } else {
            this.userMaxX = null;
            this.userMinX = null;
        }
    }

    public void centerOnRangeOrigin(Number origin) {
        this.centerOnRangeOrigin(origin, null, BoundaryMode.AUTO);
    }

    public void centerOnRangeOrigin(Number origin, Number extent, BoundaryMode mode) {
        if (origin == null) {
            throw new NullPointerException("Origin param cannot be null.");
        }
        this.rangeFramingModel = XYFramingModel.ORIGIN;
        this.setUserRangeOrigin(origin);
        this.rangeOriginExtent = extent;
        this.rangeOriginBoundaryMode = mode;
        if (this.rangeOriginBoundaryMode == BoundaryMode.FIXED) {
            double raO = this.userRangeOrigin.doubleValue();
            double raE = this.rangeOriginExtent.doubleValue();
            this.userMaxY = raO + raE;
            this.userMinY = raO - raE;
        } else {
            this.userMaxY = null;
            this.userMinY = null;
        }
    }

    private double distance(double x, double y) {
        if (x > y) {
            return x - y;
        }
        return y - x;
    }

    public void updateDomainMinMaxForOriginModel() {
        double minXDelta;
        double origin = this.userDomainOrigin.doubleValue();
        double maxXDelta = this.distance(this.calculatedMaxX.doubleValue(), origin);
        double delta = maxXDelta > (minXDelta = this.distance(this.calculatedMinX.doubleValue(), origin)) ? maxXDelta : minXDelta;
        double dlb = origin - delta;
        double dub = origin + delta;
        switch (this.domainOriginBoundaryMode) {
            case AUTO: {
                this.calculatedMinX = dlb;
                this.calculatedMaxX = dub;
                break;
            }
            case FIXED: {
                break;
            }
            case GROW: {
                this.calculatedMinX = this.prevMinX == null || dlb < this.prevMinX.doubleValue() ? (Number)dlb : (Number)this.prevMinX;
                if (this.prevMaxX == null || dub > this.prevMaxX.doubleValue()) {
                    this.calculatedMaxX = dub;
                    break;
                }
                this.calculatedMaxX = this.prevMaxX;
                break;
            }
            case SHRINNK: {
                this.calculatedMinX = this.prevMinX == null || dlb > this.prevMinX.doubleValue() ? (Number)dlb : (Number)this.prevMinX;
                if (this.prevMaxX == null || dub < this.prevMaxX.doubleValue()) {
                    this.calculatedMaxX = dub;
                    break;
                }
                this.calculatedMaxX = this.prevMaxX;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Domain Origin Boundary Mode not yet supported: " + (Object)((Object)this.domainOriginBoundaryMode));
            }
        }
    }

    public void updateRangeMinMaxForOriginModel() {
        switch (this.rangeOriginBoundaryMode) {
            case AUTO: {
                double origin = this.userRangeOrigin.doubleValue();
                double maxYDelta = this.distance(this.calculatedMaxY.doubleValue(), origin);
                double minYDelta = this.distance(this.calculatedMinY.doubleValue(), origin);
                if (maxYDelta > minYDelta) {
                    this.calculatedMinY = origin - maxYDelta;
                    this.calculatedMaxY = origin + maxYDelta;
                    break;
                }
                this.calculatedMinY = origin - minYDelta;
                this.calculatedMaxY = origin + minYDelta;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Range Origin Boundary Mode not yet supported: " + (Object)((Object)this.rangeOriginBoundaryMode));
            }
        }
    }

    public int getTicksPerRangeLabel() {
        return this.graphWidget.getTicksPerRangeLabel();
    }

    public void setTicksPerRangeLabel(int ticksPerRangeLabel) {
        this.graphWidget.setTicksPerRangeLabel(ticksPerRangeLabel);
    }

    public int getTicksPerDomainLabel() {
        return this.graphWidget.getTicksPerDomainLabel();
    }

    public void setTicksPerDomainLabel(int ticksPerDomainLabel) {
        this.graphWidget.setTicksPerDomainLabel(ticksPerDomainLabel);
    }

    public XYStepMode getDomainStepMode() {
        return this.domainStepMode;
    }

    public void setDomainStepMode(XYStepMode domainStepMode) {
        this.domainStepMode = domainStepMode;
    }

    public double getDomainStepValue() {
        return this.domainStepValue;
    }

    public void setDomainStepValue(double domainStepValue) {
        this.domainStepValue = domainStepValue;
    }

    public void setDomainStep(XYStepMode mode, double value) {
        this.setDomainStepMode(mode);
        this.setDomainStepValue(value);
    }

    public XYStepMode getRangeStepMode() {
        return this.rangeStepMode;
    }

    public void setRangeStepMode(XYStepMode rangeStepMode) {
        this.rangeStepMode = rangeStepMode;
    }

    public double getRangeStepValue() {
        return this.rangeStepValue;
    }

    public void setRangeStepValue(double rangeStepValue) {
        this.rangeStepValue = rangeStepValue;
    }

    public void setRangeStep(XYStepMode mode, double value) {
        this.setRangeStepMode(mode);
        this.setRangeStepValue(value);
    }

    public String getDomainLabel() {
        return this.getDomainLabelWidget().getText();
    }

    public void setDomainLabel(String domainLabel) {
        this.getDomainLabelWidget().setText(domainLabel);
    }

    public String getRangeLabel() {
        return this.getRangeLabelWidget().getText();
    }

    public void setRangeLabel(String rangeLabel) {
        this.getRangeLabelWidget().setText(rangeLabel);
    }

    public XYLegendWidget getLegendWidget() {
        return this.legendWidget;
    }

    public void setLegendWidget(XYLegendWidget legendWidget) {
        this.legendWidget = legendWidget;
    }

    public XYGraphWidget getGraphWidget() {
        return this.graphWidget;
    }

    public void setGraphWidget(XYGraphWidget graphWidget) {
        this.graphWidget = graphWidget;
    }

    public TextLabelWidget getDomainLabelWidget() {
        return this.domainLabelWidget;
    }

    public void setDomainLabelWidget(TextLabelWidget domainLabelWidget) {
        this.domainLabelWidget = domainLabelWidget;
    }

    public TextLabelWidget getRangeLabelWidget() {
        return this.rangeLabelWidget;
    }

    public void setRangeLabelWidget(TextLabelWidget rangeLabelWidget) {
        this.rangeLabelWidget = rangeLabelWidget;
    }

    public Format getRangeValueFormat() {
        return this.graphWidget.getRangeValueFormat();
    }

    public void setRangeValueFormat(Format rangeValueFormat) {
        this.graphWidget.setRangeValueFormat(rangeValueFormat);
    }

    public Format getDomainValueFormat() {
        return this.graphWidget.getDomainValueFormat();
    }

    public void setDomainValueFormat(Format domainValueFormat) {
        this.graphWidget.setDomainValueFormat(domainValueFormat);
    }

    public synchronized void setDomainBoundaries(Number lowerBoundary, Number upperBoundary, BoundaryMode mode) {
        this.setDomainBoundaries(lowerBoundary, mode, upperBoundary, mode);
    }

    public synchronized void setDomainBoundaries(Number lowerBoundary, BoundaryMode lowerBoundaryMode, Number upperBoundary, BoundaryMode upperBoundaryMode) {
        this.setDomainLowerBoundary(lowerBoundary, lowerBoundaryMode);
        this.setDomainUpperBoundary(upperBoundary, upperBoundaryMode);
    }

    public synchronized void setRangeBoundaries(Number lowerBoundary, Number upperBoundary, BoundaryMode mode) {
        this.setRangeBoundaries(lowerBoundary, mode, upperBoundary, mode);
    }

    public synchronized void setRangeBoundaries(Number lowerBoundary, BoundaryMode lowerBoundaryMode, Number upperBoundary, BoundaryMode upperBoundaryMode) {
        this.setRangeLowerBoundary(lowerBoundary, lowerBoundaryMode);
        this.setRangeUpperBoundary(upperBoundary, upperBoundaryMode);
    }

    protected synchronized void setDomainUpperBoundaryMode(BoundaryMode mode) {
        this.domainUpperBoundaryMode = mode;
    }

    protected synchronized void setUserMaxX(Number boundary) {
        this.userMaxX = boundary;
    }

    public synchronized void setDomainUpperBoundary(Number boundary, BoundaryMode mode) {
        this.setUserMaxX(mode == BoundaryMode.FIXED ? boundary : null);
        this.setDomainUpperBoundaryMode(mode);
        this.setDomainFramingModel(XYFramingModel.EDGE);
    }

    protected synchronized void setDomainLowerBoundaryMode(BoundaryMode mode) {
        this.domainLowerBoundaryMode = mode;
    }

    protected synchronized void setUserMinX(Number boundary) {
        this.userMinX = boundary;
    }

    public synchronized void setDomainLowerBoundary(Number boundary, BoundaryMode mode) {
        this.setUserMinX(mode == BoundaryMode.FIXED ? boundary : null);
        this.setDomainLowerBoundaryMode(mode);
        this.setDomainFramingModel(XYFramingModel.EDGE);
    }

    protected synchronized void setRangeUpperBoundaryMode(BoundaryMode mode) {
        this.rangeUpperBoundaryMode = mode;
    }

    protected synchronized void setUserMaxY(Number boundary) {
        this.userMaxY = boundary;
    }

    public synchronized void setRangeUpperBoundary(Number boundary, BoundaryMode mode) {
        this.setUserMaxY(mode == BoundaryMode.FIXED ? boundary : null);
        this.setRangeUpperBoundaryMode(mode);
        this.setRangeFramingModel(XYFramingModel.EDGE);
    }

    protected synchronized void setRangeLowerBoundaryMode(BoundaryMode mode) {
        this.rangeLowerBoundaryMode = mode;
    }

    protected synchronized void setUserMinY(Number boundary) {
        this.userMinY = boundary;
    }

    public synchronized void setRangeLowerBoundary(Number boundary, BoundaryMode mode) {
        this.setUserMinY(mode == BoundaryMode.FIXED ? boundary : null);
        this.setRangeLowerBoundaryMode(mode);
        this.setRangeFramingModel(XYFramingModel.EDGE);
    }

    private Number getUserMinX() {
        return this.userMinX;
    }

    private Number getUserMaxX() {
        return this.userMaxX;
    }

    private Number getUserMinY() {
        return this.userMinY;
    }

    private Number getUserMaxY() {
        return this.userMaxY;
    }

    public Number getDomainOrigin() {
        return this.calculatedDomainOrigin;
    }

    public Number getRangeOrigin() {
        return this.calculatedRangeOrigin;
    }

    protected BoundaryMode getDomainUpperBoundaryMode() {
        return this.domainUpperBoundaryMode;
    }

    protected BoundaryMode getDomainLowerBoundaryMode() {
        return this.domainLowerBoundaryMode;
    }

    protected BoundaryMode getRangeUpperBoundaryMode() {
        return this.rangeUpperBoundaryMode;
    }

    protected BoundaryMode getRangeLowerBoundaryMode() {
        return this.rangeLowerBoundaryMode;
    }

    public synchronized void setUserDomainOrigin(Number origin) {
        if (origin == null) {
            throw new NullPointerException("Origin value cannot be null.");
        }
        this.userDomainOrigin = origin;
    }

    public synchronized void setUserRangeOrigin(Number origin) {
        if (origin == null) {
            throw new NullPointerException("Origin value cannot be null.");
        }
        this.userRangeOrigin = origin;
    }

    public XYFramingModel getDomainFramingModel() {
        return this.domainFramingModel;
    }

    protected void setDomainFramingModel(XYFramingModel domainFramingModel) {
        this.domainFramingModel = domainFramingModel;
    }

    public XYFramingModel getRangeFramingModel() {
        return this.rangeFramingModel;
    }

    protected void setRangeFramingModel(XYFramingModel rangeFramingModel) {
        this.rangeFramingModel = rangeFramingModel;
    }

    public Number getCalculatedMinX() {
        return this.calculatedMinX != null ? (Number)this.calculatedMinX : (Number)this.getDefaultBounds().getMinX();
    }

    public Number getCalculatedMaxX() {
        return this.calculatedMaxX != null ? (Number)this.calculatedMaxX : (Number)this.getDefaultBounds().getMaxX();
    }

    public Number getCalculatedMinY() {
        return this.calculatedMinY != null ? (Number)this.calculatedMinY : (Number)this.getDefaultBounds().getMinY();
    }

    public Number getCalculatedMaxY() {
        return this.calculatedMaxY != null ? (Number)this.calculatedMaxY : (Number)this.getDefaultBounds().getMaxY();
    }

    public boolean isDrawDomainOriginEnabled() {
        return this.drawDomainOriginEnabled;
    }

    public void setDrawDomainOriginEnabled(boolean drawDomainOriginEnabled) {
        this.drawDomainOriginEnabled = drawDomainOriginEnabled;
    }

    public boolean isDrawRangeOriginEnabled() {
        return this.drawRangeOriginEnabled;
    }

    public void setDrawRangeOriginEnabled(boolean drawRangeOriginEnabled) {
        this.drawRangeOriginEnabled = drawRangeOriginEnabled;
    }

    public boolean addMarker(YValueMarker marker) {
        if (this.yValueMarkers.contains(marker)) {
            return false;
        }
        return this.yValueMarkers.add(marker);
    }

    public YValueMarker removeMarker(YValueMarker marker) {
        int markerIndex = this.yValueMarkers.indexOf(marker);
        if (markerIndex == -1) {
            return null;
        }
        return this.yValueMarkers.remove(markerIndex);
    }

    public int removeMarkers() {
        int removed = this.removeXMarkers();
        return removed += this.removeYMarkers();
    }

    public int removeYMarkers() {
        int numMarkersRemoved = this.yValueMarkers.size();
        this.yValueMarkers.clear();
        return numMarkersRemoved;
    }

    public boolean addMarker(XValueMarker marker) {
        return !this.xValueMarkers.contains(marker) && this.xValueMarkers.add(marker);
    }

    public XValueMarker removeMarker(XValueMarker marker) {
        int markerIndex = this.xValueMarkers.indexOf(marker);
        if (markerIndex == -1) {
            return null;
        }
        return this.xValueMarkers.remove(markerIndex);
    }

    public int removeXMarkers() {
        int numMarkersRemoved = this.xValueMarkers.size();
        this.xValueMarkers.clear();
        return numMarkersRemoved;
    }

    protected List<YValueMarker> getYValueMarkers() {
        return this.yValueMarkers;
    }

    protected List<XValueMarker> getXValueMarkers() {
        return this.xValueMarkers;
    }

    public RectRegion getDefaultBounds() {
        return this.defaultBounds;
    }

    public void setDefaultBounds(RectRegion defaultBounds) {
        this.defaultBounds = defaultBounds;
    }

    public Number getRangeTopMin() {
        return this.rangeTopMin;
    }

    public synchronized void setRangeTopMin(Number rangeTopMin) {
        this.rangeTopMin = rangeTopMin;
    }

    public Number getRangeTopMax() {
        return this.rangeTopMax;
    }

    public synchronized void setRangeTopMax(Number rangeTopMax) {
        this.rangeTopMax = rangeTopMax;
    }

    public Number getRangeBottomMin() {
        return this.rangeBottomMin;
    }

    public synchronized void setRangeBottomMin(Number rangeBottomMin) {
        this.rangeBottomMin = rangeBottomMin;
    }

    public Number getRangeBottomMax() {
        return this.rangeBottomMax;
    }

    public synchronized void setRangeBottomMax(Number rangeBottomMax) {
        this.rangeBottomMax = rangeBottomMax;
    }

    public Number getDomainLeftMin() {
        return this.domainLeftMin;
    }

    public synchronized void setDomainLeftMin(Number domainLeftMin) {
        this.domainLeftMin = domainLeftMin;
    }

    public Number getDomainLeftMax() {
        return this.domainLeftMax;
    }

    public synchronized void setDomainLeftMax(Number domainLeftMax) {
        this.domainLeftMax = domainLeftMax;
    }

    public Number getDomainRightMin() {
        return this.domainRightMin;
    }

    public synchronized void setDomainRightMin(Number domainRightMin) {
        this.domainRightMin = domainRightMin;
    }

    public Number getDomainRightMax() {
        return this.domainRightMax;
    }

    public synchronized void setDomainRightMax(Number domainRightMax) {
        this.domainRightMax = domainRightMax;
    }
}

