/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.androidplot.ui.LayoutManager;
import com.androidplot.ui.SeriesAndFormatterList;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.TableModel;
import com.androidplot.ui.widget.Widget;
import com.androidplot.util.FontUtils;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYRegionFormatter;
import com.androidplot.xy.XYSeries;
import com.androidplot.xy.XYSeriesFormatter;
import com.androidplot.xy.XYSeriesRenderer;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class XYLegendWidget
extends Widget {
    private XYPlot plot;
    private Paint textPaint = new Paint();
    private Paint iconBorderPaint;
    private TableModel tableModel;
    private boolean drawIconBackgroundEnabled = true;
    private boolean drawIconBorderEnabled = true;
    private SizeMetrics iconSizeMetrics;
    private static final RegionEntryComparator regionEntryComparator = new RegionEntryComparator();

    public XYLegendWidget(LayoutManager layoutManager, XYPlot plot, SizeMetrics widgetSizeMetrics, TableModel tableModel, SizeMetrics iconSizeMetrics) {
        super(layoutManager, widgetSizeMetrics);
        this.textPaint.setColor(-3355444);
        this.textPaint.setAntiAlias(true);
        this.iconBorderPaint = new Paint();
        this.iconBorderPaint.setStyle(Paint.Style.STROKE);
        this.plot = plot;
        this.setTableModel(tableModel);
        this.iconSizeMetrics = iconSizeMetrics;
    }

    public synchronized void setTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    private RectF getIconRect(RectF cellRect) {
        float cellRectCenterY = cellRect.top + cellRect.height() / 2.0f;
        RectF iconRect = this.iconSizeMetrics.getRectF(cellRect);
        float centeredIconOriginY = cellRectCenterY - iconRect.height() / 2.0f;
        iconRect.offsetTo(cellRect.left + 1.0f, centeredIconOriginY);
        return iconRect;
    }

    private static float getRectCenterY(RectF cellRect) {
        return cellRect.top + cellRect.height() / 2.0f;
    }

    private void beginDrawingCell(Canvas canvas, RectF iconRect) {
        Paint bgPaint = this.plot.getGraphWidget().getGridBackgroundPaint();
        if (this.drawIconBackgroundEnabled && bgPaint != null) {
            canvas.drawRect(iconRect, bgPaint);
        }
    }

    private void finishDrawingCell(Canvas canvas, RectF cellRect, RectF iconRect, String text) {
        Paint bgPaint = this.plot.getGraphWidget().getGridBackgroundPaint();
        if (this.drawIconBorderEnabled && bgPaint != null) {
            this.iconBorderPaint.setColor(bgPaint.getColor());
            canvas.drawRect(iconRect, this.iconBorderPaint);
        }
        float centeredTextOriginY = XYLegendWidget.getRectCenterY(cellRect) + FontUtils.getFontHeight(this.textPaint) / 2.0f;
        if (this.textPaint.getTextAlign().equals((Object)Paint.Align.RIGHT)) {
            canvas.drawText(text, iconRect.left - 2.0f, centeredTextOriginY, this.textPaint);
        } else {
            canvas.drawText(text, iconRect.right + 2.0f, centeredTextOriginY, this.textPaint);
        }
    }

    protected void drawRegionLegendIcon(Canvas canvas, RectF rect, XYRegionFormatter formatter) {
        canvas.drawRect(rect, formatter.getPaint());
    }

    private void drawRegionLegendCell(Canvas canvas, XYRegionFormatter formatter, RectF cellRect, String text) {
        RectF iconRect = this.getIconRect(cellRect);
        this.beginDrawingCell(canvas, iconRect);
        this.drawRegionLegendIcon(canvas, iconRect, formatter);
        this.finishDrawingCell(canvas, cellRect, iconRect, text);
    }

    private void drawSeriesLegendCell(Canvas canvas, XYSeriesRenderer renderer, XYSeriesFormatter formatter, RectF cellRect, String seriesTitle) {
        RectF iconRect = this.getIconRect(cellRect);
        this.beginDrawingCell(canvas, iconRect);
        renderer.drawSeriesLegendIcon(canvas, iconRect, formatter);
        this.finishDrawingCell(canvas, cellRect, iconRect, seriesTitle);
    }

    @Override
    protected synchronized void doOnDraw(Canvas canvas, RectF widgetRect) {
        RectF cellRect;
        if (this.plot.isEmpty()) {
            return;
        }
        TreeSet<Map.Entry<XYRegionFormatter, String>> sortedRegions = new TreeSet<Map.Entry<XYRegionFormatter, String>>(new RegionEntryComparator());
        int seriesCount = 0;
        for (XYSeriesRenderer renderer : this.plot.getRendererList()) {
            SeriesAndFormatterList sfl = this.plot.getSeriesAndFormatterListForRenderer(renderer.getClass());
            if (sfl != null) {
                seriesCount += sfl.size();
            }
            Hashtable<XYRegionFormatter, String> hashtable = renderer.getUniqueRegionFormatters();
            sortedRegions.addAll(hashtable.entrySet());
        }
        Iterator<RectF> it = this.tableModel.getIterator(widgetRect, seriesCount += sortedRegions.size());
        for (XYSeriesRenderer xYSeriesRenderer : this.plot.getRendererList()) {
            SeriesAndFormatterList sfl = this.plot.getSeriesAndFormatterListForRenderer(xYSeriesRenderer.getClass());
            if (sfl == null) continue;
            for (int i = 0; i < sfl.size() && it.hasNext(); ++i) {
                cellRect = it.next();
                XYSeriesFormatter formatter = (XYSeriesFormatter)sfl.getFormatter(i);
                this.drawSeriesLegendCell(canvas, xYSeriesRenderer, formatter, cellRect, ((XYSeries)sfl.getSeries(i)).getTitle());
            }
        }
        for (Map.Entry entry : sortedRegions) {
            if (!it.hasNext()) break;
            cellRect = it.next();
            XYRegionFormatter formatter = (XYRegionFormatter)entry.getKey();
            this.drawRegionLegendCell(canvas, formatter, cellRect, (String)entry.getValue());
        }
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Paint textPaint) {
        this.textPaint = textPaint;
    }

    public boolean isDrawIconBackgroundEnabled() {
        return this.drawIconBackgroundEnabled;
    }

    public void setDrawIconBackgroundEnabled(boolean drawIconBackgroundEnabled) {
        this.drawIconBackgroundEnabled = drawIconBackgroundEnabled;
    }

    public boolean isDrawIconBorderEnabled() {
        return this.drawIconBorderEnabled;
    }

    public void setDrawIconBorderEnabled(boolean drawIconBorderEnabled) {
        this.drawIconBorderEnabled = drawIconBorderEnabled;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public SizeMetrics getIconSizeMetrics() {
        return this.iconSizeMetrics;
    }

    public void setIconSizeMetrics(SizeMetrics iconSizeMetrics) {
        this.iconSizeMetrics = iconSizeMetrics;
    }

    private static enum CellType {
        SERIES,
        REGION;

    }

    private static class RegionEntryComparator
    implements Comparator<Map.Entry<XYRegionFormatter, String>> {
        private RegionEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<XYRegionFormatter, String> o1, Map.Entry<XYRegionFormatter, String> o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    }
}

