/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Paint;
import com.androidplot.util.PixelUtils;

public class PointLabelFormatter {
    private static final float DEFAULT_H_OFFSET_DP = 0.0f;
    private static final float DEFAULT_V_OFFSET_DP = -4.0f;
    private static final float DEFAULT_TEXT_SIZE_SP = 12.0f;
    private Paint textPaint;
    public float hOffset;
    public float vOffset;

    public PointLabelFormatter() {
        this(-1);
    }

    public PointLabelFormatter(int textColor) {
        this(textColor, PixelUtils.dpToPix(0.0f), PixelUtils.dpToPix(-4.0f));
    }

    public PointLabelFormatter(int textColor, float hOffset, float vOffset) {
        this.initTextPaint(textColor);
        this.hOffset = hOffset;
        this.vOffset = vOffset;
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Paint textPaint) {
        this.textPaint = textPaint;
    }

    protected void initTextPaint(Integer textColor) {
        if (textColor == null) {
            this.setTextPaint(null);
        } else {
            this.setTextPaint(new Paint());
            this.getTextPaint().setAntiAlias(true);
            this.getTextPaint().setColor(textColor.intValue());
            this.getTextPaint().setTextAlign(Paint.Align.CENTER);
            this.getTextPaint().setTextSize(PixelUtils.spToPix(12.0f));
        }
    }
}

