/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.util;

import android.graphics.PointF;
import android.graphics.RectF;

public class ValPixConverter {
    private static final int ZERO = 0;

    public static float valToPix(double val, double min, double max, float lengthPix, boolean flip) {
        if (lengthPix <= 0.0f) {
            throw new IllegalArgumentException("Length in pixels must be greater than 0.");
        }
        double range = ValPixConverter.range(min, max);
        double scale = (double)lengthPix / range;
        double raw = val - min;
        float pix = (float)(raw * scale);
        if (flip) {
            pix = lengthPix - pix;
        }
        return pix;
    }

    public static double range(double min, double max) {
        return max - min;
    }

    public static double valPerPix(double min, double max, float lengthPix) {
        double valRange = ValPixConverter.range(min, max);
        return valRange / (double)lengthPix;
    }

    public static double pixToVal(float pix, double min, double max, float lengthPix, boolean flip) {
        if (pix < 0.0f) {
            throw new IllegalArgumentException("pixel values cannot be negative.");
        }
        if (lengthPix <= 0.0f) {
            throw new IllegalArgumentException("Length in pixels must be greater than 0.");
        }
        float pMult = pix;
        if (flip) {
            pMult = lengthPix - pix;
        }
        double range = ValPixConverter.range(min, max);
        return range / (double)lengthPix * (double)pMult + min;
    }

    public static PointF valToPix(Number x, Number y, RectF plotArea, Number minX, Number maxX, Number minY, Number maxY) {
        float pixX = ValPixConverter.valToPix(x.doubleValue(), minX.doubleValue(), maxX.doubleValue(), plotArea.width(), false) + plotArea.left;
        float pixY = ValPixConverter.valToPix(y.doubleValue(), minY.doubleValue(), maxY.doubleValue(), plotArea.height(), true) + plotArea.top;
        return new PointF(pixX, pixY);
    }
}

