/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.util;

import android.util.Log;
import com.androidplot.Plot;
import java.util.Arrays;
import java.util.List;

public class Redrawer
implements Runnable {
    private static final String TAG = Redrawer.class.getName();
    private List<Plot> plots;
    private long sleepTime;
    private boolean keepRunning;
    private boolean keepAlive;

    public Redrawer(List<Plot> plots, float maxRefreshRate, boolean startImmediately) {
        this.plots = plots;
        this.setMaxRefreshRate(maxRefreshRate);
        new Thread(this).start();
        if (startImmediately) {
            this.run();
        }
    }

    public Redrawer(Plot plot, float maxRefreshRate, boolean startImmediately) {
        this(Arrays.asList(plot), maxRefreshRate, startImmediately);
    }

    public synchronized void pause() {
        this.keepRunning = false;
        this.notify();
        Log.d((String)TAG, (String)"Redrawer paused.");
    }

    public synchronized void start() {
        this.keepRunning = true;
        this.notify();
        Log.d((String)TAG, (String)"Redrawer started.");
    }

    public synchronized void finish() {
        this.keepRunning = false;
        this.keepAlive = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.keepAlive = true;
        try {
            while (this.keepAlive) {
                Object i$;
                if (this.keepRunning) {
                    for (Plot plot : this.plots) {
                        plot.redraw();
                    }
                    i$ = this;
                    synchronized (i$) {
                        this.wait(this.sleepTime);
                        continue;
                    }
                }
                i$ = this;
                synchronized (i$) {
                    this.wait();
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        finally {
            Log.d((String)TAG, (String)"Redrawer thread exited.");
        }
    }

    public void setMaxRefreshRate(float refreshRate) {
        this.sleepTime = (long)(1000.0f / refreshRate);
        Log.d((String)TAG, (String)("Set Redrawer refresh rate to " + refreshRate + "( " + this.sleepTime + " ms)"));
    }
}

