/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui.widget;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.ui.BoxModel;
import com.androidplot.ui.BoxModelable;
import com.androidplot.ui.LayoutManager;
import com.androidplot.ui.PositionMetrics;
import com.androidplot.ui.Resizable;
import com.androidplot.ui.SizeLayoutType;
import com.androidplot.ui.SizeMetric;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.XLayoutStyle;
import com.androidplot.ui.YLayoutStyle;
import com.androidplot.util.DisplayDimensions;
import com.androidplot.util.PixelUtils;

public abstract class Widget
implements BoxModelable,
Resizable {
    private Paint borderPaint;
    private Paint backgroundPaint;
    private boolean clippingEnabled = true;
    private BoxModel boxModel = new BoxModel();
    private SizeMetrics sizeMetrics;
    private DisplayDimensions plotDimensions = new DisplayDimensions();
    private DisplayDimensions widgetDimensions = new DisplayDimensions();
    private boolean isVisible = true;
    private PositionMetrics positionMetrics;
    private LayoutManager layoutManager;

    public Widget(LayoutManager layoutManager, SizeMetric heightMetric, SizeMetric widthMetric) {
        this(layoutManager, new SizeMetrics(heightMetric, widthMetric));
    }

    public Widget(LayoutManager layoutManager, SizeMetrics sizeMetrics) {
        this.layoutManager = layoutManager;
        SizeMetrics oldSize = this.sizeMetrics;
        this.setSize(sizeMetrics);
        this.onMetricsChanged(oldSize, sizeMetrics);
    }

    public DisplayDimensions getWidgetDimensions() {
        return this.widgetDimensions;
    }

    public AnchorPosition getAnchor() {
        return this.getPositionMetrics().getAnchor();
    }

    public void setAnchor(AnchorPosition anchor) {
        this.getPositionMetrics().setAnchor(anchor);
    }

    public void position(float x, XLayoutStyle xLayoutStyle, float y, YLayoutStyle yLayoutStyle) {
        this.position(x, xLayoutStyle, y, yLayoutStyle, AnchorPosition.LEFT_TOP);
    }

    public void position(float x, XLayoutStyle xLayoutStyle, float y, YLayoutStyle yLayoutStyle, AnchorPosition anchor) {
        this.setPositionMetrics(new PositionMetrics(x, xLayoutStyle, y, yLayoutStyle, anchor));
        this.layoutManager.addToTop(this);
    }

    protected void onMetricsChanged(SizeMetrics oldSize, SizeMetrics newSize) {
    }

    public void onPostInit() {
    }

    public boolean containsPoint(PointF point) {
        return this.widgetDimensions.canvasRect.contains(point.x, point.y);
    }

    public void setSize(SizeMetrics sizeMetrics) {
        this.sizeMetrics = sizeMetrics;
    }

    public void setWidth(float width) {
        this.sizeMetrics.getWidthMetric().setValue(width);
    }

    public void setWidth(float width, SizeLayoutType layoutType) {
        this.sizeMetrics.getWidthMetric().set(width, layoutType);
    }

    public void setHeight(float height) {
        this.sizeMetrics.getHeightMetric().setValue(height);
    }

    public void setHeight(float height, SizeLayoutType layoutType) {
        this.sizeMetrics.getHeightMetric().set(height, layoutType);
    }

    public SizeMetric getWidthMetric() {
        return this.sizeMetrics.getWidthMetric();
    }

    public SizeMetric getHeightMetric() {
        return this.sizeMetrics.getHeightMetric();
    }

    public float getWidthPix(float size) {
        return this.sizeMetrics.getWidthMetric().getPixelValue(size);
    }

    public float getHeightPix(float size) {
        return this.sizeMetrics.getHeightMetric().getPixelValue(size);
    }

    @Override
    public RectF getMarginatedRect(RectF widgetRect) {
        return this.boxModel.getMarginatedRect(widgetRect);
    }

    @Override
    public RectF getPaddedRect(RectF widgetMarginRect) {
        return this.boxModel.getPaddedRect(widgetMarginRect);
    }

    @Override
    public void setMarginRight(float marginRight) {
        this.boxModel.setMarginRight(marginRight);
    }

    @Override
    public void setMargins(float left, float top, float right, float bottom) {
        this.boxModel.setMargins(left, top, right, bottom);
    }

    @Override
    public void setPadding(float left, float top, float right, float bottom) {
        this.boxModel.setPadding(left, top, right, bottom);
    }

    @Override
    public float getMarginTop() {
        return this.boxModel.getMarginTop();
    }

    @Override
    public void setMarginTop(float marginTop) {
        this.boxModel.setMarginTop(marginTop);
    }

    @Override
    public float getMarginBottom() {
        return this.boxModel.getMarginBottom();
    }

    @Override
    public float getPaddingLeft() {
        return this.boxModel.getPaddingLeft();
    }

    @Override
    public void setPaddingLeft(float paddingLeft) {
        this.boxModel.setPaddingLeft(paddingLeft);
    }

    @Override
    public float getPaddingTop() {
        return this.boxModel.getPaddingTop();
    }

    @Override
    public void setPaddingTop(float paddingTop) {
        this.boxModel.setPaddingTop(paddingTop);
    }

    @Override
    public float getPaddingRight() {
        return this.boxModel.getPaddingRight();
    }

    @Override
    public void setPaddingRight(float paddingRight) {
        this.boxModel.setPaddingRight(paddingRight);
    }

    @Override
    public float getPaddingBottom() {
        return this.boxModel.getPaddingBottom();
    }

    @Override
    public void setPaddingBottom(float paddingBottom) {
        this.boxModel.setPaddingBottom(paddingBottom);
    }

    public void setMarginBottom(float marginBottom) {
        this.boxModel.setMarginBottom(marginBottom);
    }

    @Override
    public float getMarginLeft() {
        return this.boxModel.getMarginLeft();
    }

    @Override
    public void setMarginLeft(float marginLeft) {
        this.boxModel.setMarginLeft(marginLeft);
    }

    @Override
    public float getMarginRight() {
        return this.boxModel.getMarginRight();
    }

    public synchronized void refreshLayout() {
        if (this.positionMetrics == null) {
            return;
        }
        float elementWidth = this.getWidthPix(this.plotDimensions.paddedRect.width());
        float elementHeight = this.getHeightPix(this.plotDimensions.paddedRect.height());
        PointF coords = this.getElementCoordinates(elementHeight, elementWidth, this.plotDimensions.paddedRect, this.positionMetrics);
        RectF widgetRect = new RectF(coords.x, coords.y, coords.x + elementWidth, coords.y + elementHeight);
        RectF marginatedWidgetRect = this.getMarginatedRect(widgetRect);
        RectF paddedWidgetRect = this.getPaddedRect(marginatedWidgetRect);
        this.widgetDimensions = new DisplayDimensions(widgetRect, marginatedWidgetRect, paddedWidgetRect);
    }

    @Override
    public synchronized void layout(DisplayDimensions plotDimensions) {
        this.plotDimensions = plotDimensions;
        this.refreshLayout();
    }

    public PointF getElementCoordinates(float height, float width, RectF viewRect, PositionMetrics metrics) {
        float x = metrics.getXPositionMetric().getPixelValue(viewRect.width()) + viewRect.left;
        float y = metrics.getYPositionMetric().getPixelValue(viewRect.height()) + viewRect.top;
        PointF point = new PointF(x, y);
        return PixelUtils.sub(point, Widget.getAnchorOffset(width, height, metrics.getAnchor()));
    }

    public static PointF getAnchorOffset(float width, float height, AnchorPosition anchorPosition) {
        PointF point = new PointF();
        switch (anchorPosition) {
            case LEFT_TOP: {
                break;
            }
            case LEFT_MIDDLE: {
                point.set(0.0f, height / 2.0f);
                break;
            }
            case LEFT_BOTTOM: {
                point.set(0.0f, height);
                break;
            }
            case RIGHT_TOP: {
                point.set(width, 0.0f);
                break;
            }
            case RIGHT_BOTTOM: {
                point.set(width, height);
                break;
            }
            case RIGHT_MIDDLE: {
                point.set(width, height / 2.0f);
                break;
            }
            case TOP_MIDDLE: {
                point.set(width / 2.0f, 0.0f);
                break;
            }
            case BOTTOM_MIDDLE: {
                point.set(width / 2.0f, height);
                break;
            }
            case CENTER: {
                point.set(width / 2.0f, height / 2.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported anchor location: " + (Object)((Object)anchorPosition));
            }
        }
        return point;
    }

    public static PointF getAnchorCoordinates(RectF widgetRect, AnchorPosition anchorPosition) {
        return PixelUtils.add(new PointF(widgetRect.left, widgetRect.top), Widget.getAnchorOffset(widgetRect.width(), widgetRect.height(), anchorPosition));
    }

    public static PointF getAnchorCoordinates(float x, float y, float width, float height, AnchorPosition anchorPosition) {
        return Widget.getAnchorCoordinates(new RectF(x, y, x + width, y + height), anchorPosition);
    }

    public void draw(Canvas canvas, RectF widgetRect) throws PlotRenderException {
        if (this.isVisible()) {
            if (this.backgroundPaint != null) {
                this.drawBackground(canvas, this.widgetDimensions.canvasRect);
            }
            this.doOnDraw(canvas, this.widgetDimensions.paddedRect);
            if (this.borderPaint != null) {
                this.drawBorder(canvas, this.widgetDimensions.paddedRect);
            }
        }
    }

    protected void drawBorder(Canvas canvas, RectF paddedRect) {
        canvas.drawRect(paddedRect, this.borderPaint);
    }

    protected void drawBackground(Canvas canvas, RectF widgetRect) {
        canvas.drawRect(widgetRect, this.backgroundPaint);
    }

    protected abstract void doOnDraw(Canvas var1, RectF var2) throws PlotRenderException;

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint borderPaint) {
        this.borderPaint = borderPaint;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
    }

    public boolean isClippingEnabled() {
        return this.clippingEnabled;
    }

    public void setClippingEnabled(boolean clippingEnabled) {
        this.clippingEnabled = clippingEnabled;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public PositionMetrics getPositionMetrics() {
        return this.positionMetrics;
    }

    public void setPositionMetrics(PositionMetrics positionMetrics) {
        this.positionMetrics = positionMetrics;
    }
}

