/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui;

import com.androidplot.ui.PositionMetric;
import com.androidplot.ui.YLayoutStyle;

public class YPositionMetric
extends PositionMetric<YLayoutStyle> {
    public YPositionMetric(float value, YLayoutStyle layoutStyle) {
        super(value, layoutStyle);
    }

    @Override
    protected void validatePair(float value, YLayoutStyle layoutStyle) {
        switch (layoutStyle) {
            case ABSOLUTE_FROM_TOP: 
            case ABSOLUTE_FROM_BOTTOM: 
            case ABSOLUTE_FROM_CENTER: {
                YPositionMetric.validateValue(value, PositionMetric.LayoutMode.ABSOLUTE);
                break;
            }
            case RELATIVE_TO_TOP: 
            case RELATIVE_TO_BOTTOM: 
            case RELATIVE_TO_CENTER: {
                YPositionMetric.validateValue(value, PositionMetric.LayoutMode.RELATIVE);
            }
        }
    }

    @Override
    public float getPixelValue(float size) {
        switch ((YLayoutStyle)this.getLayoutType()) {
            case ABSOLUTE_FROM_TOP: {
                return this.getAbsolutePosition(size, PositionMetric.Origin.FROM_BEGINING);
            }
            case ABSOLUTE_FROM_BOTTOM: {
                return this.getAbsolutePosition(size, PositionMetric.Origin.FROM_END);
            }
            case ABSOLUTE_FROM_CENTER: {
                return this.getAbsolutePosition(size, PositionMetric.Origin.FROM_CENTER);
            }
            case RELATIVE_TO_TOP: {
                return this.getRelativePosition(size, PositionMetric.Origin.FROM_BEGINING);
            }
            case RELATIVE_TO_BOTTOM: {
                return this.getRelativePosition(size, PositionMetric.Origin.FROM_END);
            }
            case RELATIVE_TO_CENTER: {
                return this.getRelativePosition(size, PositionMetric.Origin.FROM_CENTER);
            }
        }
        throw new IllegalArgumentException("Unsupported LayoutType: " + this.getLayoutType());
    }

    @Override
    public void setLayoutType(YLayoutStyle layoutType) {
        super.setLayoutType(layoutType);
    }
}

