/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui;

import com.androidplot.ui.LayoutMetric;
import com.androidplot.ui.SizeLayoutType;

public class SizeMetric
extends LayoutMetric<SizeLayoutType> {
    public SizeMetric(float value, SizeLayoutType layoutType) {
        super(value, layoutType);
    }

    @Override
    protected void validatePair(float value, SizeLayoutType layoutType) {
        switch (layoutType) {
            case RELATIVE: {
                if (!(value < 0.0f) && !(value > 1.0f)) break;
                throw new IllegalArgumentException("SizeMetric Relative and Hybrid layout values must be within the range of 0 to 1.");
            }
        }
    }

    @Override
    public float getPixelValue(float size) {
        switch ((SizeLayoutType)((Object)this.getLayoutType())) {
            case ABSOLUTE: {
                return this.getValue();
            }
            case RELATIVE: {
                return this.getValue() * size;
            }
            case FILL: {
                return size - this.getValue();
            }
        }
        throw new IllegalArgumentException("Unsupported LayoutType: " + this.getLayoutType());
    }

    @Override
    public void setLayoutType(SizeLayoutType layoutType) {
        super.setLayoutType(layoutType);
    }
}

