/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.pie;

import android.graphics.Paint;
import com.androidplot.pie.PieChart;
import com.androidplot.pie.PieRenderer;
import com.androidplot.ui.Formatter;
import com.androidplot.ui.SeriesRenderer;

public class SegmentFormatter
extends Formatter<PieChart> {
    private static final int DEFAULT_FILL_COLOR = 0;
    private static final int DEFAULT_EDGE_COLOR = -16777216;
    private static final int DEFAULT_LABEL_COLOR = -1;
    private static final float DEFAULT_EDGE_THICKNESS = 3.0f;
    private static final float DEFAULT_LABEL_MARKER_THICKNESS = 3.0f;
    private static final float DEFAULT_LABEL_FONT_SIZE = 18.0f;
    private Paint innerEdgePaint;
    private Paint outerEdgePaint;
    private Paint radialEdgePaint;
    private Paint fillPaint;
    private Paint labelPaint;
    private Paint labelMarkerPaint;

    public SegmentFormatter() {
        this.setFillPaint(new Paint());
        this.setOuterEdgePaint(new Paint());
        this.getOuterEdgePaint().setStyle(Paint.Style.STROKE);
        this.getOuterEdgePaint().setStrokeWidth(3.0f);
        this.getOuterEdgePaint().setAntiAlias(true);
        this.setInnerEdgePaint(new Paint());
        this.getInnerEdgePaint().setStyle(Paint.Style.STROKE);
        this.getInnerEdgePaint().setStrokeWidth(3.0f);
        this.getInnerEdgePaint().setAntiAlias(true);
        this.setRadialEdgePaint(new Paint());
        this.getRadialEdgePaint().setStyle(Paint.Style.STROKE);
        this.getRadialEdgePaint().setStrokeWidth(3.0f);
        this.getRadialEdgePaint().setAntiAlias(true);
        this.setLabelPaint(new Paint());
        this.getLabelPaint().setColor(-1);
        this.getLabelPaint().setTextSize(18.0f);
        this.getLabelPaint().setAntiAlias(true);
        this.getLabelPaint().setTextAlign(Paint.Align.CENTER);
        this.setLabelMarkerPaint(new Paint());
        this.getLabelMarkerPaint().setColor(-1);
        this.getLabelMarkerPaint().setStrokeWidth(3.0f);
    }

    public SegmentFormatter(Integer fillColor) {
        this.setFillPaint(new Paint());
        this.setOuterEdgePaint(new Paint());
        this.getOuterEdgePaint().setStyle(Paint.Style.STROKE);
        this.getOuterEdgePaint().setStrokeWidth(3.0f);
        this.getOuterEdgePaint().setAntiAlias(true);
        this.setInnerEdgePaint(new Paint());
        this.getInnerEdgePaint().setStyle(Paint.Style.STROKE);
        this.getInnerEdgePaint().setStrokeWidth(3.0f);
        this.getInnerEdgePaint().setAntiAlias(true);
        this.setRadialEdgePaint(new Paint());
        this.getRadialEdgePaint().setStyle(Paint.Style.STROKE);
        this.getRadialEdgePaint().setStrokeWidth(3.0f);
        this.getRadialEdgePaint().setAntiAlias(true);
        this.setLabelPaint(new Paint());
        this.getLabelPaint().setColor(-1);
        this.getLabelPaint().setTextSize(18.0f);
        this.getLabelPaint().setAntiAlias(true);
        this.getLabelPaint().setTextAlign(Paint.Align.CENTER);
        this.setLabelMarkerPaint(new Paint());
        this.getLabelMarkerPaint().setColor(-1);
        this.getLabelMarkerPaint().setStrokeWidth(3.0f);
        if (fillColor != null) {
            this.getFillPaint().setColor(fillColor.intValue());
        } else {
            this.getFillPaint().setColor(0);
        }
    }

    public SegmentFormatter(Integer fillColor, Integer borderColor) {
        this(fillColor);
        this.getInnerEdgePaint().setColor(borderColor.intValue());
        this.getOuterEdgePaint().setColor(borderColor.intValue());
        this.getRadialEdgePaint().setColor(borderColor.intValue());
    }

    public SegmentFormatter(Integer fillColor, Integer outerEdgeColor, Integer innerEdgeColor, Integer radialEdgeColor) {
        this(fillColor);
        if (this.getOuterEdgePaint() != null) {
            this.getOuterEdgePaint().setColor(outerEdgeColor.intValue());
        } else {
            this.outerEdgePaint = new Paint();
            this.getOuterEdgePaint().setColor(-16777216);
        }
        if (this.getInnerEdgePaint() != null) {
            this.getInnerEdgePaint().setColor(innerEdgeColor.intValue());
        } else {
            this.outerEdgePaint = new Paint();
            this.getInnerEdgePaint().setColor(-16777216);
        }
        if (this.getRadialEdgePaint() != null) {
            this.getRadialEdgePaint().setColor(radialEdgeColor.intValue());
        } else {
            this.radialEdgePaint = new Paint();
            this.getRadialEdgePaint().setColor(-16777216);
        }
    }

    @Override
    public Class<? extends SeriesRenderer> getRendererClass() {
        return PieRenderer.class;
    }

    @Override
    public SeriesRenderer getRendererInstance(PieChart plot) {
        return new PieRenderer(plot);
    }

    public Paint getInnerEdgePaint() {
        return this.innerEdgePaint;
    }

    public void setInnerEdgePaint(Paint innerEdgePaint) {
        this.innerEdgePaint = innerEdgePaint;
    }

    public Paint getOuterEdgePaint() {
        return this.outerEdgePaint;
    }

    public void setOuterEdgePaint(Paint outerEdgePaint) {
        this.outerEdgePaint = outerEdgePaint;
    }

    public Paint getRadialEdgePaint() {
        return this.radialEdgePaint;
    }

    public void setRadialEdgePaint(Paint radialEdgePaint) {
        this.radialEdgePaint = radialEdgePaint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint labelPaint) {
        this.labelPaint = labelPaint;
    }

    public Paint getLabelMarkerPaint() {
        return this.labelMarkerPaint;
    }

    public void setLabelMarkerPaint(Paint labelMarkerPaint) {
        this.labelMarkerPaint = labelMarkerPaint;
    }
}

