/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.pie;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.pie.PieChart;
import com.androidplot.pie.Segment;
import com.androidplot.pie.SegmentFormatter;
import com.androidplot.ui.SeriesRenderer;
import java.util.Set;

public class PieRenderer
extends SeriesRenderer<PieChart, Segment, SegmentFormatter> {
    private float startDeg = 0.0f;
    private float endDeg = 360.0f;
    private float donutSize = 0.5f;
    private DonutMode donutMode = DonutMode.PERCENT;

    public PieRenderer(PieChart plot) {
        super(plot);
    }

    public float getRadius(RectF rect) {
        return rect.width() < rect.height() ? rect.width() / 2.0f : rect.height() / 2.0f;
    }

    @Override
    public void onRender(Canvas canvas, RectF plotArea) throws PlotRenderException {
        float radius = this.getRadius(plotArea);
        PointF origin = new PointF(plotArea.centerX(), plotArea.centerY());
        double[] values = this.getValues();
        double scale = this.calculateScale(values);
        float offset = this.startDeg;
        Set segments = ((PieChart)this.getPlot()).getSeriesSet();
        RectF rec = new RectF(origin.x - radius, origin.y - radius, origin.x + radius, origin.y + radius);
        int i = 0;
        for (Segment segment : segments) {
            float lastOffset = offset;
            float sweep = (float)(scale * values[i] * 360.0);
            offset += sweep;
            this.drawSegment(canvas, rec, segment, (SegmentFormatter)((PieChart)this.getPlot()).getFormatter(segment, this.getClass()), radius, lastOffset, sweep);
            ++i;
        }
    }

    protected void drawSegment(Canvas canvas, RectF bounds, Segment seg, SegmentFormatter f, float rad, float startAngle, float sweep) {
        float donutSizePx;
        canvas.save();
        float cx = bounds.centerX();
        float cy = bounds.centerY();
        switch (this.donutMode) {
            case PERCENT: {
                donutSizePx = this.donutSize * rad;
                break;
            }
            case PIXELS: {
                donutSizePx = this.donutSize > 0.0f ? this.donutSize : rad + this.donutSize;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented.");
            }
        }
        if (Math.abs(sweep - 360.0f) > Float.MIN_VALUE) {
            PointF r1Outer = this.calculateLineEnd(cx, cy, rad, startAngle);
            PointF r1Inner = this.calculateLineEnd(cx, cy, donutSizePx, startAngle);
            PointF r2Outer = this.calculateLineEnd(cx, cy, rad, startAngle + sweep);
            PointF r2Inner = this.calculateLineEnd(cx, cy, donutSizePx, startAngle + sweep);
            Path clip = new Path();
            clip.arcTo(new RectF(bounds.left - rad, bounds.top - rad, bounds.right + rad, bounds.bottom + rad), startAngle, sweep);
            clip.lineTo(cx, cy);
            clip.close();
            canvas.clipPath(clip);
            Path p = new Path();
            p.arcTo(bounds, startAngle, sweep);
            p.lineTo(r2Inner.x, r2Inner.y);
            p.arcTo(new RectF(cx - donutSizePx, cy - donutSizePx, cx + donutSizePx, cy + donutSizePx), startAngle + sweep, -sweep);
            p.close();
            canvas.drawPath(p, f.getFillPaint());
            canvas.drawLine(r1Inner.x, r1Inner.y, r1Outer.x, r1Outer.y, f.getRadialEdgePaint());
            canvas.drawLine(r2Inner.x, r2Inner.y, r2Outer.x, r2Outer.y, f.getRadialEdgePaint());
        } else {
            canvas.save(2);
            Path chart = new Path();
            chart.addCircle(cx, cy, rad, Path.Direction.CW);
            Path inside = new Path();
            inside.addCircle(cx, cy, donutSizePx, Path.Direction.CW);
            canvas.clipPath(inside, Region.Op.DIFFERENCE);
            canvas.drawPath(chart, f.getFillPaint());
            canvas.restore();
        }
        canvas.drawCircle(cx, cy, donutSizePx, f.getInnerEdgePaint());
        canvas.drawCircle(cx, cy, rad, f.getOuterEdgePaint());
        canvas.restore();
        PointF labelOrigin = this.calculateLineEnd(cx, cy, rad - (rad - donutSizePx) / 2.0f, startAngle + sweep / 2.0f);
        this.drawSegmentLabel(canvas, labelOrigin, seg, f);
    }

    protected void drawSegmentLabel(Canvas canvas, PointF origin, Segment seg, SegmentFormatter f) {
        canvas.drawText(seg.getTitle(), origin.x, origin.y, f.getLabelPaint());
    }

    @Override
    protected void doDrawLegendIcon(Canvas canvas, RectF rect, SegmentFormatter formatter) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    protected double calculateScale(double[] values) {
        double total = 0.0;
        for (int i = 0; i < values.length; ++i) {
            total += values[i];
        }
        return 1.0 / total;
    }

    protected double[] getValues() {
        Set segments = ((PieChart)this.getPlot()).getSeriesSet();
        double[] result = new double[segments.size()];
        int i = 0;
        for (Segment seg : ((PieChart)this.getPlot()).getSeriesSet()) {
            result[i] = seg.getValue().doubleValue();
            ++i;
        }
        return result;
    }

    protected PointF calculateLineEnd(float x, float y, float rad, float deg) {
        return this.calculateLineEnd(new PointF(x, y), rad, deg);
    }

    protected PointF calculateLineEnd(PointF origin, float rad, float deg) {
        double radians = (double)deg * Math.PI / 180.0;
        double x = (double)rad * Math.cos(radians);
        double y = (double)rad * Math.sin(radians);
        return new PointF(origin.x + (float)x, origin.y + (float)y);
    }

    public void setDonutSize(float size, DonutMode mode) {
        switch (mode) {
            case PERCENT: {
                if (!(size < 0.0f) && !(size > 1.0f)) break;
                throw new IllegalArgumentException("Size parameter must be between 0 and 1 when operating in PERCENT mode.");
            }
            case PIXELS: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented.");
            }
        }
        this.donutMode = mode;
        this.donutSize = size;
    }

    public Segment getContainingSegment(PointF point) {
        RectF plotArea = ((PieChart)this.getPlot()).getPieWidget().getWidgetDimensions().marginatedRect;
        PointF origin = new PointF(plotArea.centerX(), plotArea.centerY());
        float dy = point.y - origin.y;
        float dx = point.x - origin.x;
        double theta = Math.atan2(dy, dx);
        double angle = theta * 57.29577951308232;
        if (angle < 0.0) {
            angle += 360.0;
        }
        Set segments = ((PieChart)this.getPlot()).getSeriesSet();
        int i = 0;
        double[] values = this.getValues();
        double scale = this.calculateScale(values);
        float offset = this.startDeg;
        for (Segment segment : segments) {
            float lastOffset = offset;
            float sweep = (float)(scale * values[i] * 360.0);
            offset += sweep;
            if (angle >= (double)lastOffset && angle <= (double)offset) {
                return segment;
            }
            ++i;
        }
        return null;
    }

    public void setStartDeg(float deg) {
        this.startDeg = deg;
    }

    public float getStartDeg() {
        return this.startDeg;
    }

    public void setEndDeg(float deg) {
        this.endDeg = deg;
    }

    public float getEndDeg() {
        return this.endDeg;
    }

    public static enum DonutMode {
        PERCENT,
        DP,
        PIXELS;

    }
}

