# Privacy Policy

Below we describe our privacy policy. We have tried to make it as clear and concise as possible, but if anything is confusing or unclear please do not hesitate to contact us. You can reach out to us by [creating an issue](https://github.com/samotari/paynoway/issues/new) in this GitHub repository.

* [Data Collection And Usage](#data-collection-and-usage)
* [Device Permissions and Usage](#device-permissions-and-usage)
* [Information Retention And Deletion](#information-retention-and-deletion)
* [Updates To This Policy](#updates-to-this-policy)


## Data Collection And Usage

In general, the PayNoWay app collects the minimum amount of information necessary to function. Your information is stored in the app and is never stored remotely.

Below is a list of information you provide while using the app:

* __Payment addresses and payment requests__ - Required to create payment transactions.
* __WIF-encoded private key__ - Optionally provided by you, the user, or can be generated by the app.

Below is a list of information stored by the app during normal usage:

* __Transaction history__ - Miner fees paid, timestamps, transaction identifiers, raw transaction data.
* __Unspent transaction outputs__ - The current unspent transaction outputs (UTXO) for your currently configured WIF.


## Device Permissions and Usage

The PayNoWay app uses the minimum necessary number of permissions required. Below is a list of the permissions the app requires and why:

* __Camera__ - To scan QR codes containing information such as payment addresses, payment requests, and WIF-encoded private keys (optional, during configuration).
* __Flashlight__ - Can be optionally enabled or disabled while scanning QR codes with the device camera.
* __Access network state__ - For detecting if the device is offline. This helps provide feedback to you, the user, in case of temporary loss of network connectivity.
* __Internet__ - The app requires access to the internet to send HTTPS requests to various web service APIs. This is necessary to broadcast transactions, fetch minimum network fee rate, fetch transaction history for the currently configured WIF, fetch single transactions by txid, and to get the current fiat exchange rate.


## Information Retention And Deletion

All the information retained by the app is stored on your device and can be deleted at any time by simply uninstalling the app.


## Updates To This Policy

We may occasionally update this policy. If we make significant changes, we will note the changes in the app's release notes.
