/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

public class Permissions {
    public boolean ur;
    public boolean uw;
    public boolean ux;
    public boolean us;
    public boolean gr;
    public boolean gw;
    public boolean gx;
    public boolean gs;
    public boolean or;
    public boolean ow;
    public boolean ox;
    public boolean ot;
    public String user;
    public String group;

    public Permissions(String u, String g, String a) {
        this.Init(a);
        this.user = u;
        this.group = g;
    }

    public Permissions(String a) {
        if (a == null) {
            return;
        }
        this.Init(a);
        String[] aa = a.substring(10).split("\\s+");
        if (aa != null) {
            if (aa.length >= 3) {
                this.user = aa[1];
                this.group = aa[2];
            } else {
                this.user = aa[0];
                if (aa.length > 1) {
                    this.group = aa[1];
                }
            }
        }
    }

    private final void Init(String a) {
        this.ur = a.charAt(1) == 'r';
        this.uw = a.charAt(2) == 'w';
        char uxl = a.charAt(3);
        if (uxl == 'x') {
            this.ux = true;
            this.us = false;
        } else if (uxl == 's') {
            this.ux = true;
            this.us = true;
        } else if (uxl == 'S') {
            this.ux = false;
            this.us = true;
        } else {
            this.ux = false;
            this.us = false;
        }
        this.gr = a.charAt(4) == 'r';
        this.gw = a.charAt(5) == 'w';
        char gxl = a.charAt(6);
        if (gxl == 'x') {
            this.gx = true;
            this.gs = false;
        } else if (gxl == 's') {
            this.gx = true;
            this.gs = true;
        } else if (gxl == 'S') {
            this.gx = false;
            this.gs = true;
        } else {
            this.gx = false;
            this.gs = false;
        }
        this.or = a.charAt(7) == 'r';
        this.ow = a.charAt(8) == 'w';
        char otl = a.charAt(9);
        if (otl == 'x') {
            this.ox = true;
            this.ot = false;
        } else if (otl == 't') {
            this.ox = true;
            this.ot = true;
        } else if (otl == 'T') {
            this.ox = false;
            this.ot = true;
        } else {
            this.ox = false;
            this.ot = false;
        }
    }

    public String toString() {
        StringBuilder a = new StringBuilder(64);
        a.append("-");
        a.append(this.ur ? "r" : "-").append(this.uw ? "w" : "-").append(this.ux ? (this.us ? "s" : "x") : (this.us ? "S" : "-"));
        a.append(this.gr ? "r" : "-").append(this.gw ? "w" : "-").append(this.gx ? (this.us ? "s" : "x") : (this.us ? "S" : "-"));
        a.append(this.or ? "r" : "-").append(this.ow ? "w" : "-").append(this.ox ? (this.us ? "t" : "x") : (this.us ? "T" : "-"));
        a.append(" ").append(this.user).append(" ").append(this.group);
        return a.toString();
    }

    public final StringBuilder generateChmodString() {
        StringBuilder a = new StringBuilder(256);
        a.append('u').append(this.ur ? (char)'+' : '-').append('r').append(',');
        a.append('u').append(this.uw ? (char)'+' : '-').append('w').append(',');
        a.append('u').append(this.ux ? (char)'+' : '-').append('x').append(',');
        a.append('u').append(this.us ? (char)'+' : '-').append('s').append(',');
        a.append('g').append(this.gr ? (char)'+' : '-').append('r').append(',');
        a.append('g').append(this.gw ? (char)'+' : '-').append('w').append(',');
        a.append('g').append(this.gx ? (char)'+' : '-').append('x').append(',');
        a.append('g').append(this.gs ? (char)'+' : '-').append('s').append(',');
        a.append('o').append(this.or ? (char)'+' : '-').append('r').append(',');
        a.append('o').append(this.ow ? (char)'+' : '-').append('w').append(',');
        a.append('o').append(this.ox ? (char)'+' : '-').append('x').append(',');
        a.append(this.ot ? (char)'+' : '-').append('t');
        return a;
    }

    public final StringBuilder generateChmodString(Permissions np) {
        StringBuilder a = new StringBuilder(256);
        if (np.ur != this.ur) {
            a.append('u').append(np.ur ? (char)'+' : '-').append('r');
        }
        if (np.uw != this.uw) {
            if (a.length() > 0) {
                a.append(',');
            }
            a.append('u').append(np.uw ? (char)'+' : '-').append('w');
        }
        if (np.ux != this.ux) {
            if (a.length() > 0) {
                a.append(',');
            }
            a.append('u').append(np.ux ? (char)'+' : '-').append('x');
        }
        if (np.us != this.us) {
            if (a.length() > 0) {
                a.append(',');
            }
            a.append('u').append(np.us ? (char)'+' : '-').append('s');
        }
        if (np.gr != this.gr) {
            if (a.length() > 0) {
                a.append(',');
            }
            a.append('g').append(np.gr ? (char)'+' : '-').append('r');
        }
        if (np.gw != this.gw) {
            if (a.length() > 0) {
                a.append(',');
            }
            a.append('g').append(np.gw ? (char)'+' : '-').append('w');
        }
        if (np.gx != this.gx) {
            if (a.length() > 0) {
                a.append(',');
            }
            a.append('g').append(np.gx ? (char)'+' : '-').append('x');
        }
        if (np.gs != this.gs) {
            if (a.length() > 0) {
                a.append(',');
            }
            a.append('g').append(np.gs ? (char)'+' : '-').append('s');
        }
        if (np.or != this.or) {
            if (a.length() > 0) {
                a.append(',');
            }
            a.append('o').append(np.or ? (char)'+' : '-').append('r');
        }
        if (np.ow != this.ow) {
            if (a.length() > 0) {
                a.append(',');
            }
            a.append('o').append(np.ow ? (char)'+' : '-').append('w');
        }
        if (np.ox != this.ox) {
            if (a.length() > 0) {
                a.append(',');
            }
            a.append('o').append(np.ox ? (char)'+' : '-').append('x');
        }
        if (np.ot != this.ot) {
            if (a.length() > 0) {
                a.append(',');
            }
            a.append(np.ot ? (char)'+' : '-');
            a.append('t');
        }
        return a;
    }

    public final String generateChmodStringOct(boolean base_only) {
        int bits = 0;
        if (this.ur) {
            bits |= 0x100;
        }
        if (this.uw) {
            bits |= 0x80;
        }
        if (this.ux) {
            bits |= 0x40;
        }
        if (this.gr) {
            bits |= 0x20;
        }
        if (this.gw) {
            bits |= 0x10;
        }
        if (this.gx) {
            bits |= 8;
        }
        if (this.or) {
            bits |= 4;
        }
        if (this.ow) {
            bits |= 2;
        }
        if (this.ox) {
            bits |= 1;
        }
        if (!base_only) {
            if (this.us) {
                bits |= 0x800;
            }
            if (this.gs) {
                bits |= 0x400;
            }
            if (this.ot) {
                bits |= 0x200;
            }
        }
        return Integer.toOctalString(bits);
    }

    public final StringBuilder generateChownString() {
        StringBuilder a = new StringBuilder(256);
        a.append(this.user).append(".").append(this.group);
        return a;
    }

    public final StringBuilder generateChownString(Permissions np) {
        if (np.user == null || np.user.length() == 0) {
            return null;
        }
        if (np.group == null || np.group.length() == 0) {
            return null;
        }
        StringBuilder a = new StringBuilder(256);
        a.append(np.user).append(".").append(np.group);
        return a;
    }
}

