/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaScanTask
extends AsyncTask<Void, Void, Void> {
    private static final String TAG = "MediaScanTask";
    private Context ctx;
    private File folder;
    private boolean all = false;

    MediaScanTask(Context ctx, File folder, boolean all) {
        this.ctx = ctx;
        this.folder = folder;
        this.all = all;
    }

    protected Void doInBackground(Void ... params) {
        ArrayList<String> to_scan = new ArrayList<String>();
        this.collectFiles(this.folder, to_scan);
        if (to_scan.size() > 0) {
            String[] to_scan_a = new String[to_scan.size()];
            to_scan.toArray(to_scan_a);
            ForwardCompat.scanMedia(this.ctx, to_scan_a);
            Log.d((String)TAG, (String)"scanMedia() finished");
        }
        return null;
    }

    private void collectFiles(File folder, List<String> to_scan) {
        if (folder == null) {
            return;
        }
        for (File f : folder.listFiles()) {
            if (f == null) continue;
            try {
                if (f.isDirectory()) {
                    this.collectFiles(f, to_scan);
                    continue;
                }
                String ext = Utils.getFileExt(f.getName());
                String mime = Utils.getMimeByExt(ext);
                if (!this.all && (mime == null || !mime.startsWith("image/") && !mime.startsWith("audio/") && !mime.startsWith("video/"))) continue;
                to_scan.add(f.getAbsolutePath());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void scanMedia(Context ctx, File folder, boolean all) {
        MediaScanTask bg_scan = new MediaScanTask(ctx, folder, all);
        bg_scan.execute(new Void[0]);
    }
}

