/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@TargetApi(value=11)
public class MediaFile {
    private static final String TAG = "MediaFile";
    private static final String NO_MEDIA = ".nomedia";
    private static final String ALBUM_ART_URI = "content://media/external/audio/albumart";
    private static final String[] ALBUM_PROJECTION = new String[]{"_id", "album_id", "media_type"};
    private static final Uri FILES_URI = MediaStore.Files.getContentUri((String)"external");
    public static boolean SUPPORTED = FILES_URI != null;
    private final File file;
    private final Context context;
    private final ContentResolver contentResolver;

    private static File getExternalFilesDir(Context context) {
        if (Build.VERSION.SDK_INT < 8) {
            return null;
        }
        try {
            Method method = Context.class.getMethod("getExternalFilesDir", String.class);
            return (File)method.invoke((Object)context, new Object[]{null});
        }
        catch (SecurityException ex) {
            Log.d((String)TAG, (String)"Unexpected reflection error.", (Throwable)ex);
            return null;
        }
        catch (NoSuchMethodException ex) {
            Log.d((String)TAG, (String)"Unexpected reflection error.", (Throwable)ex);
            return null;
        }
        catch (IllegalArgumentException ex) {
            Log.d((String)TAG, (String)"Unexpected reflection error.", (Throwable)ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            Log.d((String)TAG, (String)"Unexpected reflection error.", (Throwable)ex);
            return null;
        }
        catch (InvocationTargetException ex) {
            Log.d((String)TAG, (String)"Unexpected reflection error.", (Throwable)ex);
            return null;
        }
    }

    public MediaFile(Context context, File file) {
        this.file = file;
        this.context = context;
        this.contentResolver = context.getContentResolver();
    }

    public boolean delete() throws IOException {
        String[] files;
        if (!SUPPORTED) {
            throw new IOException("MediaFile API not supported by device.");
        }
        if (!this.file.exists()) {
            return true;
        }
        boolean directory = this.file.isDirectory();
        if (directory && (files = this.file.list()) != null && files.length > 0) {
            return false;
        }
        String where = "_data=?";
        String[] selectionArgs = new String[]{this.file.getAbsolutePath()};
        this.contentResolver.delete(MediaStore.Files.getContentUri((String)"external"), where, selectionArgs);
        if (this.file.exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", this.file.getAbsolutePath());
            this.contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
            this.contentResolver.delete(FILES_URI, where, selectionArgs);
        }
        return !this.file.exists();
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTemporaryAlbumId() {
        Cursor cursor;
        block13: {
            int n;
            File temporaryTrack;
            try {
                temporaryTrack = this.installTemporaryTrack();
            }
            catch (IOException ex) {
                return 0;
            }
            String[] selectionArgs = new String[]{temporaryTrack.getAbsolutePath()};
            cursor = this.contentResolver.query(FILES_URI, ALBUM_PROJECTION, "_data=?", selectionArgs, null);
            if (cursor == null || !cursor.moveToFirst()) {
                if (cursor != null) {
                    cursor.close();
                    cursor = null;
                }
                ContentValues values = new ContentValues();
                values.put("_data", temporaryTrack.getAbsolutePath());
                values.put("title", "{MediaWrite Workaround}");
                values.put("_size", Long.valueOf(temporaryTrack.length()));
                values.put("mime_type", "audio/mpeg");
                values.put("is_music", Boolean.valueOf(true));
                this.contentResolver.insert(FILES_URI, values);
            }
            if ((cursor = this.contentResolver.query(FILES_URI, ALBUM_PROJECTION, "_data=?", selectionArgs, null)) == null) {
                return 0;
            }
            if (!cursor.moveToFirst()) {
                cursor.close();
                return 0;
            }
            int id2 = cursor.getInt(0);
            int albumId = cursor.getInt(1);
            int mediaType = cursor.getInt(2);
            cursor.close();
            ContentValues values = new ContentValues();
            boolean updateRequired = false;
            if (albumId == 0) {
                values.put("album_id", Integer.valueOf(13371337));
                updateRequired = true;
            }
            if (mediaType != 2) {
                values.put("media_type", Integer.valueOf(2));
                updateRequired = true;
            }
            if (updateRequired) {
                this.contentResolver.update(FILES_URI, values, "_id=" + id2, null);
            }
            if ((cursor = this.contentResolver.query(FILES_URI, ALBUM_PROJECTION, "_data=?", selectionArgs, null)) == null) {
                return 0;
            }
            try {
                if (cursor.moveToFirst()) break block13;
                n = 0;
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                cursor.close();
                throw throwable;
            }
            cursor.close();
            return n;
        }
        int n = cursor.getInt(1);
        Object var11_14 = null;
        cursor.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File installTemporaryTrack() throws IOException {
        File externalFilesDir = MediaFile.getExternalFilesDir(this.context);
        if (externalFilesDir == null) {
            return null;
        }
        File temporaryTrack = new File(externalFilesDir, "temptrack.mp3");
        if (!temporaryTrack.exists()) {
            FileOutputStream out;
            block14: {
                InputStream in = null;
                out = null;
                try {
                    int bytesRead;
                    in = this.context.getResources().openRawResource(2131099648);
                    out = new FileOutputStream(temporaryTrack);
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, bytesRead);
                    }
                    Object var8_7 = null;
                    if (in == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            return null;
                        }
                    }
                    if (out != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException ex) {
                            return null;
                        }
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException ex) {
                    return null;
                }
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    return null;
                }
            }
        }
        return temporaryTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdir() throws IOException {
        MediaFile tmpMediaFile2;
        if (this.file.exists()) {
            return this.file.isDirectory();
        }
        File tmpFile = new File(this.file, ".MediaWriteTemp");
        int albumId = this.getTemporaryAlbumId();
        if (albumId == 0) {
            throw new IOException("Fail");
        }
        Uri albumUri = Uri.parse((String)("content://media/external/audio/albumart/" + albumId));
        ContentValues values = new ContentValues();
        values.put("_data", tmpFile.getAbsolutePath());
        if (this.contentResolver.update(albumUri, values, null, null) == 0) {
            values.put("album_id", Integer.valueOf(albumId));
            this.contentResolver.insert(Uri.parse((String)ALBUM_ART_URI), values);
        }
        try {
            ParcelFileDescriptor fd = this.contentResolver.openFileDescriptor(albumUri, "r");
            fd.close();
            Object var7_6 = null;
            tmpMediaFile2 = new MediaFile(this.context, tmpFile);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            MediaFile tmpMediaFile2 = new MediaFile(this.context, tmpFile);
            tmpMediaFile2.delete();
            throw throwable;
        }
        tmpMediaFile2.delete();
        return this.file.exists();
    }

    public OutputStream write(long size) throws IOException {
        if (!SUPPORTED) {
            throw new IOException("MediaFile API not supported by device.");
        }
        if (NO_MEDIA.equals(this.file.getName().trim())) {
            throw new IOException("Unable to create .nomedia file via media content provider API.");
        }
        if (this.file.exists() && this.file.isDirectory()) {
            throw new IOException("File exists and is a directory.");
        }
        String where = "_data=?";
        String[] selectionArgs = new String[]{this.file.getAbsolutePath()};
        this.contentResolver.delete(FILES_URI, where, selectionArgs);
        ContentValues values = new ContentValues();
        values.put("_data", this.file.getAbsolutePath());
        values.put("_size", Long.valueOf(size));
        Uri uri = this.contentResolver.insert(FILES_URI, values);
        if (uri == null) {
            throw new IOException("Internal error.");
        }
        return this.contentResolver.openOutputStream(uri);
    }
}

