/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.widget.ListView;
import java.io.File;

public class ForwardCompat {
    @TargetApi(value=9)
    public static void disableOverScroll(View view) {
        view.setOverScrollMode(2);
    }

    @TargetApi(value=9)
    public static void setFullPermissions(File file) {
        file.setWritable(true, false);
        file.setReadable(true, false);
    }

    @TargetApi(value=8)
    public static void smoothScrollToPosition(ListView flv, int pos) {
        flv.smoothScrollToPosition(pos);
    }

    @TargetApi(value=9)
    public static Drawable getLogo(PackageManager pm, ApplicationInfo pai) {
        return pai.logo == 0 ? null : pm.getApplicationLogo(pai);
    }

    @TargetApi(value=8)
    public static void scanMedia(final Context ctx, String[] to_scan_a) {
        MediaScannerConnection.scanFile((Context)ctx, (String[])to_scan_a, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

            public void onScanCompleted(String path, Uri uri) {
                File f = new File(path);
                if (f.isFile() && f.length() == 0L && ctx.getContentResolver().delete(uri, null, null) > 0) {
                    Log.w((String)"scanMedia()", (String)("Deleteing " + path));
                    f.delete();
                }
            }
        });
    }

    @TargetApi(value=8)
    public static File getExternalFilesDir(Context ctx) {
        return ctx.getExternalFilesDir(null);
    }

    @TargetApi(value=8)
    public static String toBase64(byte[] in) {
        return Base64.encodeToString((byte[])in, (int)0);
    }

    @TargetApi(value=8)
    public static byte[] fromBase64(String in) {
        return Base64.decode((String)in, (int)0);
    }

    @TargetApi(value=8)
    public static String getPath(PubPathType ppt) {
        String pps = null;
        switch (ppt) {
            case DOWNLOADS: {
                pps = Environment.DIRECTORY_DOWNLOADS;
                break;
            }
            case DCIM: {
                pps = Environment.DIRECTORY_DCIM;
                break;
            }
            case PICTURES: {
                pps = Environment.DIRECTORY_PICTURES;
                break;
            }
            case MUSIC: {
                pps = Environment.DIRECTORY_MUSIC;
                break;
            }
            case MOVIES: {
                pps = Environment.DIRECTORY_MOVIES;
            }
        }
        return Environment.getExternalStoragePublicDirectory((String)pps).getAbsolutePath();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PubPathType {
        DOWNLOADS,
        DCIM,
        PICTURES,
        MUSIC,
        MOVIES;

    }
}

