/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.net.Uri;
import android.util.Log;
import com.ghostsq.commander.utils.LsItem;
import com.ghostsq.commander.utils.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class FTP {
    private static final String TAG = "FTP";
    private static final int BLOCK_SIZE = 100000;
    private static final boolean PRINT_DEBUG_INFO = true;
    private StringBuffer debugBuf = new StringBuffer();
    private String host = null;
    private Socket cmndSocket = null;
    private OutputStream outputStream = null;
    private BufferedInputStream inputStream = null;
    private ServerSocket serverSocket = null;
    private Socket dataSocket = null;
    private InputStream inDataStream = null;
    private boolean loggedIn = false;
    private boolean allowActive = false;
    private boolean ipv6 = false;
    private Charset charset = null;
    public static final int WAS_IN = 1;
    public static final int LOGGED_IN = 2;
    public static final int NO_CONNECT = -1;
    public static final int NO_LOGIN = -2;
    public static final int NO_WHERE = -3;

    private final boolean sendCommand(String cmd) {
        try {
            if (this.outputStream == null || this.cmndSocket == null || !this.cmndSocket.isConnected()) {
                return false;
            }
            String out = cmd.startsWith("PASS") ? "PASS ***" : cmd;
            this.debugPrint(">>> " + out);
            String cmd_rn = cmd + "\r\n";
            byte[] bytes = null;
            if (this.charset != null) {
                try {
                    bytes = cmd_rn.getBytes(this.charset.name());
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)("Not supported: " + this.charset));
                }
            }
            if (bytes == null) {
                bytes = cmd_rn.getBytes();
            }
            this.outputStream.write(bytes);
            return true;
        }
        catch (IOException e) {
            this.debugPrint("connection broken");
            Log.e((String)TAG, (String)"", (Throwable)e);
            return false;
        }
    }

    public final void debugPrint(String message) {
        if (!Utils.str(message)) {
            return;
        }
        Log.v((String)TAG, (String)message);
        this.debugBuf.append(message);
        this.debugBuf.append("\n");
    }

    private final boolean isPositivePreliminary(int response) {
        return response >= 100 && response < 200;
    }

    private final boolean isPositiveComplete(int response) {
        return response >= 200 && response < 300;
    }

    private final boolean isPositiveIntermediate(int response) {
        return response >= 300 && response < 400;
    }

    private final boolean isNegative(int response) {
        return response >= 400;
    }

    private final boolean waitForPositiveResponse() throws InterruptedException {
        String response = null;
        try {
            int code;
            do {
                Thread.sleep(100L);
                response = this.getReplyLine();
                if (response == null) {
                    return false;
                }
                code = this.getReplyCode(response);
                if (this.isPositiveComplete(code)) {
                    return true;
                }
                if (this.isNegative(code)) {
                    return false;
                }
                if (this.isPositiveIntermediate(code)) {
                    return true;
                }
                Thread.sleep(400L);
            } while (this.isPositivePreliminary(code));
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)("Exception " + (response == null ? "" : " on response '" + response + "'" + "\n")), (Throwable)e);
        }
        return false;
    }

    private final int getReplyCode(String reply) {
        try {
            return reply == null ? -1 : Integer.parseInt(reply.substring(0, 3));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private final void flushReply() {
        try {
            while (this.inputStream.available() > 0) {
                this.inputStream.read();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
    }

    private final String getReplyLine() {
        return this.getLine(true);
    }

    private final String getLine() {
        return this.getLine(false);
    }

    private final String getLine(boolean skip_to_code_line) {
        try {
            int i;
            if (this.inputStream == null) {
                this.debugPrint("No Connection");
                return null;
            }
            int buf_sz = 1024;
            byte[] buf = new byte[1024];
            block2: do {
                int b;
                int cnt = 0;
                do {
                    if (cnt++ >= 200) {
                        Log.e((String)TAG, (String)("The server did not respond. " + this.inputStream.toString()));
                        return null;
                    }
                    Thread.sleep(100L);
                } while (this.inputStream != null && this.inputStream.available() == 0);
                for (i = 0; i < 1024 && (b = this.inputStream.read()) >= 0; ++i) {
                    if (b == 13 || b == 10) {
                        buf[i] = 0;
                        continue block2;
                    }
                    buf[i] = (byte)b;
                }
            } while ((buf[0] == 0 || skip_to_code_line) && (!Character.isDigit(buf[0]) || !Character.isDigit(buf[1]) || !Character.isDigit(buf[2]) || buf[3] != 32 && buf[3] != 45));
            String reply = this.charset != null ? new String(buf, 0, i, this.charset.name()) : new String(buf, 0, i);
            this.debugPrint("<<< " + reply);
            return reply;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            this.disconnect(true);
            return null;
        }
    }

    public final synchronized boolean connect(String host_, int port) throws UnknownHostException, IOException, InterruptedException {
        this.host = host_;
        this.cmndSocket = new Socket(this.host, port);
        InetAddress ia = this.cmndSocket.getInetAddress();
        this.ipv6 = ia instanceof Inet6Address;
        this.outputStream = this.cmndSocket.getOutputStream();
        this.inputStream = new BufferedInputStream(this.cmndSocket.getInputStream(), 256);
        if (!this.waitForPositiveResponse()) {
            this.disconnect(true);
            return false;
        }
        return true;
    }

    public final void disconnect(boolean brutal) {
        try {
            if (!brutal && this.loggedIn) {
                this.logout(true);
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.cmndSocket != null) {
                this.cmndSocket.close();
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            if (this.dataSocket != null) {
                this.dataSocket.close();
            }
            if (this.inDataStream != null) {
                this.inDataStream.close();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
        this.outputStream = null;
        this.inputStream = null;
        this.cmndSocket = null;
        this.serverSocket = null;
        this.dataSocket = null;
        this.inDataStream = null;
    }

    public final synchronized int connectAndLogin(Uri u, String user, String pass, boolean cwd) throws UnknownHostException, IOException, InterruptedException {
        String host;
        if (this.isLoggedIn()) {
            String path;
            if (cwd && (path = u.getPath()) != null) {
                this.setCurrentDir(path);
            }
            return 1;
        }
        int port = u.getPort();
        if (port == -1) {
            port = 21;
        }
        if (this.connect(host = u.getHost(), port)) {
            if (this.login(user, pass)) {
                if (cwd) {
                    this.mbSwitchToUTF8();
                    String path = u.getPath();
                    if (!Utils.str(path)) {
                        path = File.separator;
                    }
                    if (!(this.setCurrentDir(path) || "..".equals(path) || this.makeDir(path) && this.setCurrentDir(path))) {
                        return -3;
                    }
                }
                return 2;
            }
            this.disconnect(false);
            Log.w((String)TAG, (String)"Invalid credentials.");
            return -2;
        }
        return -1;
    }

    public final void setActiveMode(boolean a) {
        this.allowActive = a;
    }

    public final boolean getActiveMode() {
        return this.allowActive;
    }

    public void setCharset(Charset charset_) {
        this.charset = charset_;
    }

    public Charset getCharset() {
        return this.charset;
    }

    private final void mbSwitchToUTF8() {
        try {
            if (this.charset != null && !this.charset.equals(Charset.defaultCharset())) {
                return;
            }
            if (!this.isFeature("UTF8")) {
                return;
            }
            this.executeCommand("OPTS UTF8 ON");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final boolean isFeature(String feat_name) {
        String feat;
        this.sendCommand("FEAT");
        String pwd_answer = this.getReplyLine();
        if (!this.isPositiveComplete(this.getReplyCode(pwd_answer))) {
            return false;
        }
        boolean supported = false;
        while ((feat = this.getLine()) != null && this.getReplyCode(feat) <= 0) {
            if (!feat_name.equalsIgnoreCase(feat.trim())) continue;
            supported = true;
        }
        return supported;
    }

    private final synchronized boolean executeCommand(String command) throws InterruptedException {
        this.sendCommand(command);
        return this.waitForPositiveResponse();
    }

    private boolean announcePort(ServerSocket serverSocket) throws IOException, InterruptedException {
        int localport = serverSocket.getLocalPort();
        String port_command = null;
        if (this.ipv6) {
            InetAddress la = this.cmndSocket.getLocalAddress();
            port_command = "EPRT |2|" + la.getHostAddress() + "|" + localport + "|";
        } else {
            byte[] addrbytes = this.cmndSocket.getLocalAddress().getAddress();
            short[] addrshorts = new short[4];
            for (int i = 0; i <= 3; ++i) {
                addrshorts[i] = addrbytes[i];
                if (addrshorts[i] >= 0) continue;
                int n = i;
                addrshorts[n] = (short)(addrshorts[n] + 256);
            }
            port_command = "PORT " + addrshorts[0] + "," + addrshorts[1] + "," + addrshorts[2] + "," + addrshorts[3] + "," + ((localport & 0xFF00) >> 8) + "," + (localport & 0xFF);
        }
        if (this.executeCommand(port_command)) {
            return true;
        }
        Log.e((String)TAG, (String)"Active mode failed");
        return false;
    }

    private final int parsePassiveResponse(String s, byte[] addr) {
        try {
            StringTokenizer addr_tokenizer;
            if (s == null || s.length() < 4) {
                return -1;
            }
            if (!this.isPositiveComplete(Integer.parseInt(s.substring(0, 3)))) {
                return -1;
            }
            int opt = s.indexOf(40);
            int cpt = s.indexOf(41);
            if (cpt < opt) {
                return -1;
            }
            if (opt == -1 && cpt == -1) {
                String addr_str = s.replaceFirst("\\d{3}\\s[^\\d]+", "");
                addr_tokenizer = new StringTokenizer(addr_str, ",");
            } else {
                String in = s.substring(opt + 1, cpt);
                if (this.ipv6) {
                    String[] ss = in.split("\\|");
                    return Integer.parseInt(ss[3]);
                }
                addr_tokenizer = new StringTokenizer(in, ",");
            }
            int a = 0;
            int b = 0;
            for (int i = 0; i < 6; ++i) {
                short n = Short.parseShort(addr_tokenizer.nextToken());
                if (i < 4) {
                    addr[i] = (byte)n;
                } else {
                    if (i == 4) {
                        a = n;
                    }
                    if (i == 5) {
                        b = n;
                    }
                }
                if (!addr_tokenizer.hasMoreTokens()) break;
            }
            return a * 256 + b;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)("Exception while parsing the string '" + s + "'"), (Throwable)e);
            return -1;
        }
    }

    private final synchronized Socket executeDataCommand(String commands) {
        try {
            if (commands == null || commands.length() == 0) {
                return null;
            }
            Socket data_socket = null;
            if (this.allowActive) {
                this.serverSocket = new ServerSocket(0);
                if (!this.announcePort(this.serverSocket)) {
                    this.allowActive = false;
                    this.executeCommand("ABOR");
                }
            }
            if (!this.allowActive) {
                this.flushReply();
                this.serverSocket = null;
                String pasv_command = this.ipv6 ? "EPSV" : "PASV";
                this.sendCommand(pasv_command);
                byte[] addr = new byte[4];
                int server_port = this.parsePassiveResponse(this.getReplyLine(), addr);
                if (server_port < 0) {
                    this.debugPrint("Can't negotiate the " + pasv_command);
                    return null;
                }
                data_socket = this.ipv6 ? new Socket(this.host, server_port) : new Socket(InetAddress.getByAddress(addr), server_port);
                if (!data_socket.isConnected()) {
                    Log.e((String)TAG, (String)"Can't open PASV data socket");
                    return null;
                }
            }
            String[] cmds = commands.split("\n");
            for (int i = 0; i < cmds.length; ++i) {
                this.sendCommand(cmds[i]);
                if (!this.isNegative(this.getReplyCode(this.getReplyLine()))) continue;
                Log.e((String)TAG, (String)("Executing " + cmds[i] + " failed"));
                return null;
            }
            if (data_socket == null && this.serverSocket != null) {
                Log.i((String)TAG, (String)"Awaiting the data connection to PORT");
                data_socket = this.serverSocket.accept();
            }
            if (data_socket == null || !data_socket.isConnected()) {
                this.debugPrint("Can't establish data connection for " + commands);
                return null;
            }
            return data_socket;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception on executing data command '" + commands + "'"), (Throwable)e);
            return null;
        }
    }

    private final boolean cleanUpDataCommand(boolean wait_reps) throws InterruptedException {
        try {
            if (this.dataSocket != null) {
                this.dataSocket.close();
            }
            this.dataSocket = null;
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            this.serverSocket = null;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
        return wait_reps ? this.waitForPositiveResponse() : true;
    }

    public final synchronized void clearLog() {
        this.debugBuf.setLength(0);
    }

    public final synchronized String getLog() {
        return this.debugBuf.toString();
    }

    public final boolean isLoggedIn() {
        if (this.cmndSocket == null || !this.cmndSocket.isConnected()) {
            this.loggedIn = false;
        }
        return this.loggedIn;
    }

    public final synchronized boolean login(String username, String password) throws IOException, InterruptedException {
        if (!this.executeCommand("USER " + username)) {
            return false;
        }
        this.loggedIn = this.executeCommand("PASS " + password);
        return this.loggedIn;
    }

    public final boolean logout(boolean quit) throws IOException, InterruptedException {
        boolean quit_res = quit ? this.executeCommand("QUIT") : false;
        this.loggedIn = false;
        return quit_res;
    }

    public final void heartBeat() throws InterruptedException {
        this.executeCommand("NOOP");
    }

    public final synchronized boolean rename(String from, String to) throws InterruptedException {
        if (!this.executeCommand("RNFR " + from)) {
            return false;
        }
        return this.executeCommand("RNTO " + to);
    }

    public final synchronized boolean site(String cmd) throws InterruptedException {
        return this.executeCommand("SITE " + cmd);
    }

    public final synchronized OutputStream prepStore(String fn) {
        this.dataSocket = null;
        try {
            if (!this.isLoggedIn()) {
                return null;
            }
            this.executeCommand("TYPE I");
            this.dataSocket = this.executeDataCommand("STOR " + fn);
            if (this.dataSocket != null) {
                return this.dataSocket.getOutputStream();
            }
        }
        catch (Exception e) {
            this.debugPrint(e.getLocalizedMessage());
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean store(String fn, InputStream in, ProgressSink report_to) throws InterruptedException {
        boolean bl;
        block12: {
            boolean bl2;
            block11: {
                boolean bl3;
                boolean bl4;
                block8: {
                    try {
                        try {
                            OutputStream out;
                            block9: {
                                int last_n;
                                block10: {
                                    out = this.prepStore(fn);
                                    if (out == null) {
                                        Log.e((String)TAG, (String)"data socket does not give up the output stream to upload a file");
                                        bl4 = false;
                                        Object var10_8 = null;
                                        bl3 = this.dataSocket != null;
                                        break block8;
                                    }
                                    byte[] buf = new byte[100000];
                                    int n = 0;
                                    last_n = 0;
                                    do {
                                        if ((n = in.read(buf)) < 0) {
                                            if (report_to == null) break block9;
                                            break block10;
                                        }
                                        out.write(buf, 0, n);
                                        last_n = n;
                                    } while (report_to == null || report_to.completed(n, false));
                                    out.close();
                                    Log.w((String)TAG, (String)("Deleting incompleted file" + fn));
                                    this.delete(fn);
                                    bl2 = false;
                                    break block11;
                                }
                                report_to.completed(last_n, true);
                            }
                            out.close();
                            bl = true;
                            break block12;
                        }
                        catch (Exception e) {
                            this.debugPrint(e.getLocalizedMessage());
                            Log.e((String)TAG, (String)"", (Throwable)e);
                            Object var10_11 = null;
                            this.cleanUpDataCommand(this.dataSocket != null);
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        this.cleanUpDataCommand(this.dataSocket != null);
                        throw throwable;
                    }
                }
                this.cleanUpDataCommand(bl3);
                return bl4;
            }
            Object var10_9 = null;
            this.cleanUpDataCommand(this.dataSocket != null);
            return bl2;
        }
        Object var10_10 = null;
        this.cleanUpDataCommand(this.dataSocket != null);
        return bl;
    }

    public final synchronized InputStream prepRetr(String fn, long skip) throws InterruptedException {
        this.dataSocket = null;
        try {
            if (!this.isLoggedIn()) {
                return null;
            }
            this.executeCommand("TYPE I");
            String retr_cmd = (skip > 0L ? "REST " + skip + "\n" : "") + "RETR " + fn;
            this.dataSocket = this.executeDataCommand(retr_cmd);
            if (this.dataSocket != null) {
                return this.dataSocket.getInputStream();
            }
        }
        catch (IOException e) {
            this.debugPrint(e.getLocalizedMessage());
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
        this.cleanUpDataCommand(this.dataSocket != null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean retrieve(String fn, OutputStream out, ProgressSink report_to) throws InterruptedException {
        block28: {
            block24: {
                block27: {
                    block23: {
                        in = this.prepRetr(fn, 0L);
                        if (in == null) {
                            return false;
                        }
                        try {
                            try {
                                block21: {
                                    block22: {
                                        buf = new byte[100000];
                                        n = 0;
                                        last_n = 0;
                                        do {
                                            if ((n = in.read(buf)) < 0) {
                                                if (report_to == null) break block21;
                                                break block22;
                                            }
                                            out.write(buf, 0, n);
                                            last_n = n;
                                        } while (report_to == null || report_to.completed(n, false));
                                        this.executeCommand("ABOR");
                                        var8_9 = false;
                                        var10_11 = null;
                                        break block23;
                                    }
                                    report_to.completed(last_n, true);
                                }
                                var8_10 = true;
                                break block24;
                            }
                            catch (IOException e) {
                                this.debugPrint(e.getLocalizedMessage());
                                Log.e((String)"FTP", (String)"", (Throwable)e);
                                var10_13 = null;
                                try {
                                    if (in != null) {
                                        in.close();
                                    }
                                    if (out != null) {
                                        out.close();
                                    }
                                }
                                catch (IOException e) {
                                    Log.e((String)"FTP", (String)"Exception on streams closing (finnaly section)", (Throwable)e);
                                }
                                this.cleanUpDataCommand(this.dataSocket != null);
                                return false;
                            }
                        }
                        catch (Throwable var9_19) {
                            block26: {
                                var10_14 = null;
                                ** try [egrp 2[TRYBLOCK] [6 : 151->172)] { 
lbl52:
                                // 1 sources

                                if (in != null) {
                                    in.close();
                                }
                                if (out != null) {
                                    out.close();
                                }
                                break block26;
lbl57:
                                // 1 sources

                                catch (IOException e) {
                                    Log.e((String)"FTP", (String)"Exception on streams closing (finnaly section)", (Throwable)e);
                                }
                            }
                            this.cleanUpDataCommand(this.dataSocket != null);
                            throw var9_19;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 151->172)] { 
lbl66:
                    // 1 sources

                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    break block27;
lbl71:
                    // 1 sources

                    catch (IOException e) {
                        Log.e((String)"FTP", (String)"Exception on streams closing (finnaly section)", (Throwable)e);
                    }
                }
                this.cleanUpDataCommand(this.dataSocket != null);
                return var8_9;
            }
            var10_12 = null;
            ** try [egrp 2[TRYBLOCK] [6 : 151->172)] { 
lbl81:
            // 1 sources

            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            break block28;
lbl86:
            // 1 sources

            catch (IOException e) {
                Log.e((String)"FTP", (String)"Exception on streams closing (finnaly section)", (Throwable)e);
            }
        }
        this.cleanUpDataCommand(this.dataSocket != null);
        return var8_10;
    }

    public final boolean setCurrentDir(String dir) throws InterruptedException {
        if (!Utils.str(dir)) {
            dir = "/";
        }
        return this.executeCommand(dir.compareTo("..") == 0 ? "CDUP" : "CWD " + dir);
    }

    public final synchronized String getCurrentDir() {
        this.sendCommand("PWD");
        String pwd_answer = this.getReplyLine();
        if (!this.isPositiveComplete(this.getReplyCode(pwd_answer))) {
            return null;
        }
        String[] parts = pwd_answer.split("\"");
        if (parts.length < 2) {
            return null;
        }
        return parts[1];
    }

    public final boolean makeDir(String dir) throws InterruptedException {
        return this.executeCommand("MKD " + dir);
    }

    public final boolean rmDir(String dir) throws InterruptedException {
        return this.executeCommand("RMD " + dir);
    }

    public final boolean delete(String name) throws InterruptedException {
        return this.executeCommand("DELE " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final LsItem[] getDirList(String path, boolean force_hidden) throws InterruptedException {
        ArrayList<LsItem> array2;
        block19: {
            block18: {
                LsItem[] lsItemArray;
                block17: {
                    boolean bl;
                    LsItem[] lsItemArray2;
                    block16: {
                        if (!this.isLoggedIn()) {
                            return null;
                        }
                        String cur_dir = null;
                        if (path != null && path.length() > 0) {
                            cur_dir = this.getCurrentDir();
                            if (cur_dir == null) {
                                return null;
                            }
                            this.setCurrentDir(path);
                        }
                        this.executeCommand("TYPE A");
                        array2 = null;
                        try {
                            try {
                                String cmd = "LIST";
                                if (force_hidden) {
                                    cmd = cmd + " -a";
                                }
                                this.dataSocket = this.executeDataCommand(cmd);
                                if (this.dataSocket == null) {
                                    lsItemArray2 = null;
                                    Object var14_10 = null;
                                    bl = this.dataSocket != null;
                                    break block16;
                                }
                                this.inDataStream = this.dataSocket.getInputStream();
                                if (this.inDataStream == null) {
                                    this.debugPrint("data socket does not give up the input stream");
                                    lsItemArray = null;
                                    break block17;
                                }
                                InputStreamReader isr = null;
                                if (this.charset != null) {
                                    isr = new InputStreamReader(this.inDataStream, this.charset);
                                }
                                if (isr == null) {
                                    isr = new InputStreamReader(this.inDataStream);
                                }
                                BufferedReader dataReader = new BufferedReader(isr, 4096);
                                array2 = new ArrayList<LsItem>();
                                String dot = ".";
                                String dotdot = "..";
                                while (true) {
                                    String dir_line;
                                    if ((dir_line = dataReader.readLine()) == null) {
                                        this.inDataStream.close();
                                        if (cur_dir != null) {
                                            break;
                                        }
                                        break block18;
                                    }
                                    LsItem item = new LsItem(dir_line);
                                    String name = item.getName();
                                    if (!item.isValid() || "..".equals(name) || ".".equals(name)) continue;
                                    array2.add(item);
                                }
                                this.setCurrentDir(cur_dir);
                                break block18;
                            }
                            catch (Exception e) {
                                this.debugPrint(e.getLocalizedMessage());
                                Object var14_13 = null;
                                this.cleanUpDataCommand(this.dataSocket != null);
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_14 = null;
                            this.cleanUpDataCommand(this.dataSocket != null);
                            throw throwable;
                        }
                    }
                    this.cleanUpDataCommand(bl);
                    return lsItemArray2;
                }
                Object var14_11 = null;
                this.cleanUpDataCommand(this.dataSocket != null);
                return lsItemArray;
            }
            Object var14_12 = null;
            this.cleanUpDataCommand(this.dataSocket != null);
        }
        if (array2 != null) {
            LsItem[] result = new LsItem[array2.size()];
            return array2.toArray(result);
        }
        return null;
    }

    public static interface ProgressSink {
        public boolean completed(long var1, boolean var3) throws InterruptedException;
    }
}

