/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.auth.UsernamePasswordCredentials;

public class Credentials
extends UsernamePasswordCredentials
implements Parcelable {
    private static String TAG = "GC.Credentials";
    private static String seed = "5hO@%#O7&!H3#R";
    private static byte[] rawKey = null;
    public static String pwScreen = "***";
    public static String KEY = "CRD";
    public static final Parcelable.Creator<Credentials> CREATOR = new Parcelable.Creator<Credentials>(){

        public Credentials createFromParcel(Parcel in) {
            String un = in.readString();
            String pw = "";
            try {
                pw = new String(Credentials.decrypt(Credentials.getRawKey(seed), in.createByteArray()));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"on password decryption", (Throwable)e);
            }
            return new Credentials(un, pw);
        }

        public Credentials[] newArray(int size) {
            return new Credentials[size];
        }
    };

    public Credentials(String usernamePassword) {
        super(usernamePassword);
    }

    public Credentials(String userName, String password) {
        super(userName, password);
    }

    public Credentials(Credentials c) {
        super(c.getUserName(), c.getPassword());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int f) {
        byte[] enc_pw = null;
        try {
            enc_pw = Credentials.encrypt(Credentials.getRawKey(seed), this.getPassword().getBytes());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"on password encryption", (Throwable)e);
        }
        dest.writeString(this.getUserName());
        dest.writeByteArray(enc_pw);
    }

    private static byte[] getRawKey(String seed) throws Exception {
        boolean primary = Credentials.seed.equals(seed);
        if (primary && rawKey != null) {
            return rawKey;
        }
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG", "Crypto");
        sr.setSeed(seed.getBytes());
        kgen.init(128, sr);
        SecretKey skey = kgen.generateKey();
        byte[] raw2 = skey.getEncoded();
        if (primary) {
            rawKey = raw2;
        }
        return raw2;
    }

    public static Credentials createFromEncriptedString(String s) {
        return Credentials.createFromEncriptedString(s, null);
    }

    public static Credentials createFromEncriptedString(String s, String seed_) {
        try {
            boolean base64 = true;
            if (seed_ == null) {
                seed_ = seed;
                base64 = false;
            }
            return new Credentials(Credentials.decrypt(seed_, s, base64));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"on creating from an encrypted string", (Throwable)e);
            return null;
        }
    }

    public String exportToEncriptedString() {
        return this.exportToEncriptedString(null);
    }

    public String exportToEncriptedString(String seed_) {
        try {
            boolean base64 = true;
            if (seed_ == null) {
                seed_ = seed;
                base64 = false;
            }
            return Credentials.encrypt(seed_, this.getUserName() + ":" + this.getPassword(), base64);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypt(String encrypted) throws Exception {
        return Credentials.decrypt(seed, encrypted, false);
    }

    public static String encrypt(String seed, String cleartext, boolean base64out) throws Exception {
        byte[] rawKey = Credentials.getRawKey(seed);
        byte[] result = Credentials.encrypt(rawKey, cleartext.getBytes());
        if (base64out) {
            return ForwardCompat.toBase64(result);
        }
        return Utils.toHexString(result, null);
    }

    public static String decrypt(String seed, String encrypted, boolean base64in) throws Exception {
        byte[] rawKey = Credentials.getRawKey(seed);
        byte[] enc = base64in ? ForwardCompat.fromBase64(encrypted) : Utils.hexStringToBytes(encrypted);
        byte[] result = Credentials.decrypt(rawKey, enc);
        return new String(result);
    }

    private static byte[] encrypt(byte[] raw2, byte[] clear) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw2, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(clear);
        return encrypted;
    }

    private static byte[] decrypt(byte[] raw2, byte[] encrypted) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw2, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, skeySpec);
        byte[] decrypted = cipher.doFinal(encrypted);
        return decrypted;
    }
}

