/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.root;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.CheckBox;
import android.widget.EditText;
import com.ghostsq.commander.TextViewer;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.root.EditRootPermissions;
import com.ghostsq.commander.root.ExecEngine;
import com.ghostsq.commander.root.MountsListEngine;
import com.ghostsq.commander.root.RemountEngine;
import com.ghostsq.commander.utils.LsItem;
import com.ghostsq.commander.utils.Permissions;
import com.ghostsq.commander.utils.Utils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class RootAdapter
extends CommanderAdapterBase {
    private static final String TAG = "RootAdapter";
    public static final String DEFAULT_LOC = "root:";
    private static final int CHMOD_CMD = 36793;
    private static final int CMD_CMD = 39716;
    private Uri uri = null;
    private LsItem[] items = null;
    private int attempts = 0;
    private MountsListEngine systemMountReader;
    private String systemMountMode;
    private static final String SYSTEM_PATH = "/system";
    private ContentEngine contentEngine;
    private File tmp_f;
    private File dst_f;

    public RootAdapter(Context ctx_) {
        super(ctx_, 256);
    }

    public String getScheme() {
        return "root";
    }

    public int setMode(int mask, int val) {
        if ((mask & 1) == 0) {
            return super.setMode(mask, val);
        }
        return this.mode;
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case REAL: 
            case SZ: 
            case MOUNT: 
            case REMOUNT: {
                return true;
            }
        }
        return super.hasFeature(feature);
    }

    protected void onReadComplete() {
        block7: {
            try {
                MountsListEngine.MountItem[] mounts;
                this.attempts = 0;
                if (this.reader instanceof ListEngine) {
                    ListEngine list_engine = (ListEngine)this.reader;
                    this.items = list_engine.getItems();
                    this.uri = list_engine.getUri();
                    this.numItems = this.items != null ? this.items.length + 1 : 1;
                    this.notifyDataSetChanged();
                    String path = this.uri.getPath();
                    if (path != null && path.startsWith(SYSTEM_PATH)) {
                        this.systemMountReader = new MountsListEngine(this.commander.getContext(), (Handler)this.readerHandler, false);
                        this.systemMountReader.start();
                    }
                    break block7;
                }
                if (this.systemMountReader == null || (mounts = this.systemMountReader.getItems()) == null) break block7;
                boolean remount = this.systemMountReader.toRemount();
                this.systemMountReader = null;
                for (MountsListEngine.MountItem m : mounts) {
                    String mp = m.getMountPoint();
                    if (!SYSTEM_PATH.equals(mp)) continue;
                    if (remount) {
                        RemountEngine re = new RemountEngine(this.commander.getContext(), this.simpleHandler, m);
                        re.start();
                    } else {
                        this.systemMountMode = m.getMode();
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        if (this.uri != null) {
            if (this.systemMountMode != null) {
                String path = this.uri.getPath();
                try {
                    return this.uri.buildUpon().fragment(path != null && path.startsWith(SYSTEM_PATH) ? this.systemMountMode : null).build().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.uri.buildUpon().fragment(" ").build().toString();
        }
        return "";
    }

    public Uri getUri() {
        return this.uri;
    }

    public void setUri(Uri uri_) {
        this.uri = uri_;
    }

    public boolean readSource(Uri tmp_uri, String pass_back_on_done) {
        try {
            if (tmp_uri == null) {
                tmp_uri = this.uri;
            }
            if (tmp_uri == null) {
                return false;
            }
            this.uri = tmp_uri;
            if (this.reader != null) {
                if (this.attempts++ < 2) {
                    this.commander.showInfo("Busy...");
                    return false;
                }
                if (this.reader.reqStop()) {
                    Thread.sleep(500L);
                    if (this.reader.isAlive()) {
                        Log.e((String)TAG, (String)"Busy!");
                        return false;
                    }
                }
            }
            this.notify(-1);
            this.reader = new ListEngine(this.commander.getContext(), this.readerHandler, tmp_uri, pass_back_on_done);
            this.reader.start();
            return true;
        }
        catch (Exception e) {
            this.commander.showError("Exception: " + e);
            e.printStackTrace();
            this.notify("Fail", -2);
            return false;
        }
    }

    public void reqItemsSize(SparseBooleanArray cis) {
        if (this.uri == null) {
            return;
        }
        try {
            LsItem[] s_items = this.bitsToItems(cis);
            if (s_items != null && s_items.length > 0) {
                String path = Utils.mbAddSl(this.uri.getPath());
                StringBuilder sb = new StringBuilder(128);
                sb.append("stat ");
                for (int i = 0; i < s_items.length; ++i) {
                    sb.append(" ").append(ExecEngine.prepFileName(path + s_items[i].getName()));
                }
                sb.append(" ; df");
                ExecEngine ee = new ExecEngine(this.ctx, null, sb.toString(), true, 500);
                ee.setHandler(new Handler(){

                    public void handleMessage(Message msg) {
                        try {
                            Intent in = new Intent(RootAdapter.this.ctx, TextViewer.class);
                            in.setData(Uri.parse((String)"string:"));
                            if (msg.obj instanceof Bundle) {
                                in.putExtra("string", ((Bundle)msg.obj).getString("STRING"));
                            }
                            RootAdapter.this.commander.issue(in, 0);
                        }
                        catch (Exception e) {
                            Log.e((String)RootAdapter.TAG, null, (Throwable)e);
                        }
                    }
                });
                ee.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        try {
            LsItem[] subItems = this.bitsToItems(cis);
            if (subItems != null) {
                Engines.IReciever recipient = null;
                String to_path = null;
                if (to instanceof FSAdapter || to instanceof RootAdapter) {
                    Uri to_uri = to.getUri();
                    if (to_uri != null) {
                        to_path = to_uri.getPath();
                    }
                    to = null;
                } else {
                    to_path = this.createTempDir();
                    recipient = to.getReceiver();
                }
                if (to_path != null) {
                    this.notify(-1);
                    this.commander.startEngine(new CopyFromEngine(this.commander.getContext(), subItems, to_path, move, recipient));
                    return true;
                }
            }
            this.notify("Failed to proceed.", -2);
        }
        catch (Exception e) {
            this.commander.showError("Exception: " + e);
        }
        return false;
    }

    public boolean createFile(String fileURI) {
        this.notify("Operation is not supported.", -2);
        return false;
    }

    public void createFolder(String new_name) {
        if (this.uri == null) {
            return;
        }
        MkDirEngine mde = new MkDirEngine(this.commander.getContext(), this.simpleHandler, new_name);
        mde.start();
    }

    public boolean deleteItems(SparseBooleanArray cis) {
        try {
            LsItem[] subItems = this.bitsToItems(cis);
            if (subItems != null) {
                this.notify(-1);
                this.commander.startEngine(new DelEngine(this.commander.getContext(), subItems));
                return true;
            }
        }
        catch (Exception e) {
            this.commander.showError("Exception: " + e);
        }
        return false;
    }

    public Uri getItemUri(int position) {
        if (this.uri == null) {
            return null;
        }
        return this.uri.buildUpon().appendEncodedPath(this.getItemName(position, false)).build();
    }

    public String getItemName(int position, boolean full) {
        if (this.items != null && position > 0 && position <= this.items.length) {
            if (full) {
                Uri item_uri = this.getItemUri(position);
                if (item_uri != null) {
                    return item_uri.toString();
                }
            } else {
                return this.items[position - 1].getName();
            }
        }
        return null;
    }

    public void openItem(int position) {
        if (position == 0) {
            String path;
            int len_;
            if (this.uri != null && this.parentLink != SLS && (len_ = (path = this.uri.getPath()).length() - 1) > 0) {
                if (path.charAt(len_) == SLC) {
                    path = path.substring(0, len_);
                }
                if ((path = path.substring(0, path.lastIndexOf(SLC))).length() == 0) {
                    path = SLS;
                }
                this.commander.Navigate(this.uri.buildUpon().path(path).build(), null, this.uri.getLastPathSegment());
            }
            return;
        }
        if (this.items == null || position < 0 || position > this.items.length) {
            return;
        }
        LsItem item = this.items[position - 1];
        if (item.isDirectory()) {
            String cur = this.uri.getPath();
            if (cur == null || cur.length() == 0) {
                cur = SLS;
            } else if (cur.charAt(cur.length() - 1) != SLC) {
                cur = cur + SLS;
            }
            this.commander.Navigate(this.uri.buildUpon().appendEncodedPath(item.getName()).build(), null, null);
        } else {
            new CmdDialog(this.ctx, item, this);
        }
    }

    public boolean receiveItems(String[] full_names, int move_mode) {
        try {
            if (full_names == null || full_names.length == 0) {
                this.notify("Nothing to copy", -2);
                return false;
            }
            this.notify(-1);
            this.commander.startEngine(new CopyToEngine(this.commander.getContext(), full_names, (move_mode & 1) != 0, this.uri.getPath(), false));
            return true;
        }
        catch (Exception e) {
            this.notify("Exception: " + e, -2);
            return false;
        }
    }

    public boolean renameItem(int position, String newName, boolean copy) {
        if (position <= 0 || position > this.items.length) {
            return false;
        }
        try {
            LsItem from = this.items[position - 1];
            String[] a = new String[]{this.uri.getPath() + SLS + from.getName()};
            String to = this.uri.getPath() + SLS + newName;
            this.notify(-1);
            if (copy) {
                return false;
            }
            this.commander.startEngine(new CopyToEngine(this.commander.getContext(), a, true, to, true));
            return true;
        }
        catch (Exception e) {
            this.notify("Exception: " + e, -2);
            return false;
        }
    }

    public Object getItem(int position) {
        CommanderAdapter.Item item = new CommanderAdapter.Item();
        item.name = "???";
        if (position == 0) {
            item.name = this.parentLink;
        } else if (this.items != null && position > 0 && position <= this.items.length) {
            LsItem curItem = this.items[position - 1];
            item.dir = curItem.isDirectory();
            item.name = item.dir ? SLS + curItem.getName() : curItem.getName();
            String lnk = curItem.getLinkTarget();
            if (lnk != null) {
                item.name = item.name + " -> " + lnk;
                item.icon_id = item.dir ? 2130837514 : 2130837527;
            }
            item.size = curItem.isDirectory() ? -1L : curItem.length();
            item.date = curItem.getDate();
            item.attr = curItem.getAttr();
            if (".apk".equals(Utils.getFileExt(item.name))) {
                try {
                    PackageManager pm = this.ctx.getPackageManager();
                    String path = Utils.mbAddSl(this.uri.getPath());
                    PackageInfo info = pm.getPackageArchiveInfo(path + item.name, 0);
                    item.setIcon(info != null ? pm.getApplicationIcon(info.packageName) : pm.getDefaultActivityIcon());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return item;
    }

    protected int getPredictedAttributesLength() {
        return 28;
    }

    private final LsItem[] bitsToItems(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                ++counter;
            }
            LsItem[] subItems = new LsItem[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                int k;
                if (!cis.valueAt(i) || (k = cis.keyAt(i)) <= 0) continue;
                subItems[j++] = this.items[k - 1];
            }
            return subItems;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("bitsToNames()'s Exception: " + e));
            return null;
        }
    }

    public void populateContextMenu(ContextMenu menu2, AdapterView.AdapterContextMenuInfo acmi, int num) {
        try {
            if (acmi.position > 0) {
                menu2.add(0, 36793, 0, 2131362076);
            }
            menu2.add(0, 39716, 0, (CharSequence)this.commander.getContext().getString(2131362160));
            super.populateContextMenu(menu2, acmi, num);
        }
        catch (Exception e) {
            Log.e((String)TAG, null, (Throwable)e);
        }
    }

    public void doIt(int command_id, SparseBooleanArray cis) {
        try {
            if (36793 == command_id || 39716 == command_id) {
                boolean selected_one;
                LsItem[] items_todo = this.bitsToItems(cis);
                boolean bl = selected_one = items_todo != null && items_todo.length > 0 && items_todo[0] != null;
                if (36793 == command_id) {
                    if (selected_one) {
                        Intent i = new Intent(this.ctx, EditRootPermissions.class);
                        i.putExtra("perm", items_todo[0].getAttr());
                        i.putExtra("path", Utils.mbAddSl(this.uri.getPath()) + items_todo[0].getName());
                        this.commander.issue(i, 695);
                    } else {
                        this.commander.showError(this.commander.getContext().getString(2131362038));
                    }
                } else if (39716 == command_id) {
                    new CmdDialog(this.commander.getContext(), selected_one ? items_todo[0] : null, this);
                }
            } else if (2131230749 == command_id) {
                if (this.reader != null && this.reader.isAlive()) {
                    this.commander.showError(this.commander.getContext().getString(2131362034));
                    return;
                }
                this.systemMountReader = new MountsListEngine(this.commander.getContext(), (Handler)this.readerHandler, true);
                this.systemMountReader.start();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Can't do the command " + command_id), (Throwable)e);
        }
    }

    public void execute(String command, boolean bb) {
        this.commander.startEngine(new ExecEngine(this.commander.getContext(), this.uri.getPath(), command, bb, 500));
    }

    public final String getBusyBoxPath() {
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this.ctx);
        return sharedPref.getString("busybox_path", "busybox") + " ";
    }

    public void executeToViewer(String command, boolean bb) {
        ExecEngine ee = new ExecEngine(this.ctx, this.uri.getPath(), command, bb, 500);
        ee.setHandler(new Handler(){

            public void handleMessage(Message msg) {
                try {
                    String str = ((Bundle)msg.obj).getString("STRING");
                    if (!Utils.str(str)) {
                        msg.obj = "";
                        RootAdapter.this.commander.notifyMe(msg);
                    } else {
                        Intent in = new Intent(RootAdapter.this.ctx, TextViewer.class);
                        in.setData(Uri.parse((String)"string:"));
                        in.putExtra("string", str);
                        RootAdapter.this.commander.issue(in, 0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        ee.start();
    }

    protected void reSort() {
        if (this.items == null || this.items.length < 1) {
            return;
        }
        LsItem lsItem = this.items[0];
        lsItem.getClass();
        LsItem.LsItemPropComparator comp = lsItem.new LsItem.LsItemPropComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
        Arrays.sort(this.items, comp);
    }

    public CommanderAdapter.Item getItem(Uri u) {
        try {
            ExecEngine ee = new ExecEngine(null, null, "ls -l -d " + u.getPath(), false, 100);
            ee.start();
            StringBuilder sb = null;
            for (int i = 0; i < 10; ++i) {
                sb = ee.getResult();
            }
            if (sb == null) {
                return null;
            }
            LsItem ls_item = new LsItem(sb.toString());
            CommanderAdapter.Item item = new CommanderAdapter.Item(ls_item.getName());
            item.size = ls_item.length();
            item.date = ls_item.getDate();
            item.dir = ls_item.isDirectory();
            return item;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public InputStream getContent(Uri u) {
        try {
            if (u == null) {
                return null;
            }
            String path = u.getPath();
            this.contentEngine = new ContentEngine(path);
            this.contentEngine.start();
            InputStream is = this.contentEngine.getInput();
            if (is == null) {
                this.contentEngine.close();
            }
            return is;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)u.toString(), (Throwable)e);
            return null;
        }
    }

    public OutputStream saveContent(Uri u) {
        try {
            if (u == null) {
                return null;
            }
            String path = u.getPath();
            this.dst_f = new File(path);
            File root_f = this.ctx.getDir("root", 0);
            if (root_f == null) {
                return null;
            }
            this.tmp_f = new File(root_f, this.dst_f.getName());
            return new FileOutputStream(this.tmp_f);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)u.toString(), (Throwable)e);
            return null;
        }
    }

    public void closeStream(Closeable s) {
        if (s instanceof FileOutputStream) {
            if (this.tmp_f == null || this.dst_f == null) {
                return;
            }
            CopyToEngine cte = new CopyToEngine(this.ctx, new String[]{this.tmp_f.getAbsolutePath()}, true, this.dst_f.getParent(), true);
            cte.setPermByDest();
            cte.start();
            return;
        }
        if (this.contentEngine != null) {
            this.contentEngine.close();
            this.contentEngine = null;
        }
    }

    class ContentEngine
    extends Thread {
        private String file_path;
        private InputStream is = null;
        private OutputStream os = null;
        private boolean open_done = false;
        private boolean may_close = false;

        ContentEngine(String file_path_) {
            this.file_path = file_path_;
        }

        protected final String getSuPath() {
            SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)RootAdapter.this.ctx);
            return sharedPref.getString("su_path", "su");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block29: {
                BufferedReader ebr;
                OutputStreamWriter osw;
                block28: {
                    String err_str;
                    this.setName("ContentEngine");
                    osw = null;
                    ebr = null;
                    Process process = Runtime.getRuntime().exec(this.getSuPath());
                    this.os = process.getOutputStream();
                    ebr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    osw = new OutputStreamWriter(this.os);
                    this.is = process.getInputStream();
                    osw.write("cat " + ExecEngine.prepFileName(this.file_path) + "\n");
                    osw.flush();
                    for (int i = 0; i < 5; ++i) {
                        Thread.sleep(10L);
                        if (this.is.available() > 0) break;
                    }
                    boolean empty = this.is.available() <= 0;
                    ContentEngine contentEngine = this;
                    synchronized (contentEngine) {
                        this.open_done = true;
                    }
                    for (int i = 0; i < 4; ++i) {
                        ContentEngine contentEngine2 = this;
                        synchronized (contentEngine2) {
                            this.wait(500L);
                            if (empty) {
                                break;
                            }
                            if (this.may_close) {
                                break;
                            }
                            continue;
                        }
                    }
                    osw.write("exit\n");
                    osw.flush();
                    process.waitFor();
                    if (process.exitValue() != 0) {
                        Log.e((String)RootAdapter.TAG, (String)("Exit code " + process.exitValue()));
                    }
                    if (!ebr.ready() || (err_str = ebr.readLine()).trim().length() <= 0) break block28;
                    Log.e((String)RootAdapter.TAG, (String)("Error:\n" + err_str));
                }
                Object var9_12 = null;
                try {
                    if (osw != null) {
                        osw.close();
                    }
                    if (ebr != null) {
                        ebr.close();
                    }
                    if (this.is != null) {
                        this.is.close();
                    }
                    break block29;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                break block29;
                {
                    catch (Exception e) {
                        Log.e((String)RootAdapter.TAG, null, (Throwable)e);
                        Object var9_13 = null;
                        try {
                            if (osw != null) {
                                osw.close();
                            }
                            if (ebr != null) {
                                ebr.close();
                            }
                            if (this.is != null) {
                                this.is.close();
                            }
                            break block29;
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    try {
                        if (osw != null) {
                            osw.close();
                        }
                        if (ebr != null) {
                            ebr.close();
                        }
                        if (this.is != null) {
                            this.is.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }

        public synchronized boolean waitUntilOpen() {
            try {
                for (int i = 0; i < 50; ++i) {
                    if (this.open_done) {
                        return true;
                    }
                    this.wait(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }

        public InputStream getInput() {
            return this.waitUntilOpen() ? this.is : null;
        }

        public OutputStream getOutput() {
            return this.waitUntilOpen() ? this.os : null;
        }

        public synchronized void close() {
            this.may_close = true;
            this.notify();
        }
    }

    class CmdDialog
    implements DialogInterface.OnClickListener {
        private LsItem item;
        private RootAdapter owner;
        private EditText ctv;
        private CheckBox bbc;

        CmdDialog(Context c, LsItem item_, RootAdapter owner_) {
            try {
                if (RootAdapter.this.uri == null) {
                    return;
                }
                this.owner = owner_;
                this.item = item_;
                LayoutInflater factory = LayoutInflater.from((Context)c);
                View cdv = factory.inflate(2130903043, null);
                if (cdv != null) {
                    this.bbc = (CheckBox)cdv.findViewById(2131230790);
                    this.ctv = (EditText)cdv.findViewById(2131230789);
                    this.ctv.setText((CharSequence)(this.item != null ? this.item.getName() : ""));
                    new AlertDialog.Builder(c).setTitle((CharSequence)"Run Command").setView(cdv).setPositiveButton(2131361916, (DialogInterface.OnClickListener)this).setNegativeButton(2131361917, (DialogInterface.OnClickListener)this).show();
                }
            }
            catch (Exception e) {
                Log.e((String)RootAdapter.TAG, (String)"CmdDialog()", (Throwable)e);
            }
        }

        public void onClick(DialogInterface idialog, int whichButton) {
            if (whichButton == -1) {
                this.owner.executeToViewer(this.ctv.getText().toString(), this.bbc.isChecked());
            }
            idialog.dismiss();
        }
    }

    class CopyToEngine
    extends ExecEngine {
        private String[] src_full_names;
        private String dest;
        private boolean move;
        private boolean quiet;
        private boolean permByDest;
        private int counter;

        CopyToEngine(Context ctx, String[] list, boolean move_, String dest_, boolean quiet_) {
            super(ctx);
            this.move = false;
            this.permByDest = false;
            this.counter = 0;
            this.src_full_names = list;
            this.dest = dest_;
            this.move = move_;
            this.quiet = quiet_;
        }

        public final void setPermByDest() {
            this.permByDest = true;
        }

        public void run() {
            if (!this.execute()) {
                this.counter = 0;
            }
            if (this.quiet) {
                if (this.noErrors()) {
                    File df = new File(this.dest);
                    this.sendRefrReq(df.getName());
                } else {
                    this.sendResult(null);
                }
            } else {
                this.sendResult(this.counter > 0 ? Utils.getOpReport(RootAdapter.this.commander.getContext(), this.counter, this.move ? 2131362005 : 2131362004) : "");
            }
        }

        protected boolean cmdDialog(OutputStreamWriter os, BufferedReader is, BufferedReader es) {
            try {
                String cmd = this.move ? " mv" : " cp -a";
                String esc_dest = CopyToEngine.prepFileName(this.dest);
                int num = this.src_full_names.length;
                double conv = 100.0 / (double)num;
                for (int i = 0; i < num; ++i) {
                    String full_name = this.src_full_names[i];
                    if (full_name == null) continue;
                    File src_file = new File(full_name);
                    File dst_file = new File(this.dest, src_file.getName());
                    String esc_dst_fn = CopyToEngine.prepFileName(dst_file.getAbsolutePath());
                    String esc_src_fn = CopyToEngine.prepFileName(full_name);
                    LsItem probe_item = null;
                    if (this.permByDest || !this.move) {
                        String probe_fn = this.permByDest ? esc_dst_fn : esc_src_fn;
                        String ls_cmd = "ls -l " + probe_fn;
                        this.outCmd(false, ls_cmd, os);
                        String str = null;
                        while (is.ready()) {
                            str = is.readLine();
                            if (str == null || str.trim().length() <= 0) continue;
                            Log.v((String)this.TAG, (String)(">>>" + str));
                        }
                        if (str != null) {
                            probe_item = new LsItem(str);
                        }
                    }
                    String to_exec = cmd + " " + esc_src_fn + " " + esc_dest;
                    this.outCmd(true, to_exec, os);
                    if (this.procError(es)) {
                        return false;
                    }
                    if (probe_item != null) {
                        Permissions src_p = new Permissions(probe_item.getAttr());
                        String chown_cmd = "chown " + src_p.generateChownString().append(" ").append(esc_dst_fn).toString();
                        this.outCmd(false, chown_cmd, os);
                        String chmod_cmd = "chmod " + src_p.generateChmodString().append(" ").append(esc_dst_fn).toString();
                        this.outCmd(true, chmod_cmd, os);
                    }
                    if (!this.quiet) {
                        this.sendProgress(full_name + "   ", (int)((double)i * conv));
                    }
                    ++this.counter;
                }
                return true;
            }
            catch (Exception e) {
                this.error(e.getMessage());
                return false;
            }
        }
    }

    class DelEngine
    extends ExecEngine {
        private String src_base_path;
        private LsItem[] mList;
        private int counter;

        DelEngine(Context ctx, LsItem[] list) {
            super(ctx);
            this.counter = 0;
            this.mList = list;
            this.src_base_path = RootAdapter.this.uri.getPath();
            if (this.src_base_path == null || this.src_base_path.length() == 0) {
                this.src_base_path = CommanderAdapterBase.SLS;
            } else if (this.src_base_path.charAt(this.src_base_path.length() - 1) != CommanderAdapterBase.SLC) {
                this.src_base_path = this.src_base_path + CommanderAdapterBase.SLS;
            }
        }

        public void run() {
            if (!this.execute()) {
                this.counter = 0;
            }
            this.sendResult(this.counter > 0 ? Utils.getOpReport(RootAdapter.this.commander.getContext(), this.counter, 2131362006) : "");
        }

        protected boolean cmdDialog(OutputStreamWriter os, BufferedReader is, BufferedReader es) {
            try {
                int num = this.mList.length;
                double conv = 100.0 / (double)num;
                for (int i = 0; i < num; ++i) {
                    LsItem f = this.mList[i];
                    String full_name = this.src_base_path + f.getName();
                    this.sendProgress("Deleting " + full_name, (int)((double)this.counter * conv));
                    String to_exec = "rm " + (f.isDirectory() ? "-r " : "") + DelEngine.prepFileName(full_name);
                    this.outCmd(false, to_exec, os);
                    if (this.procError(es)) {
                        return false;
                    }
                    ++this.counter;
                }
                return true;
            }
            catch (Exception e) {
                this.error(e.getMessage());
                return false;
            }
        }
    }

    class MkDirEngine
    extends ExecEngine {
        String new_name;
        String full_name;

        MkDirEngine(Context ctx, Handler h, String new_name_) {
            super(ctx);
            this.setHandler(h);
            this.new_name = new_name_;
            this.full_name = RootAdapter.this.uri.getPath() + CommanderAdapterBase.SLS + this.new_name;
        }

        public void run() {
            try {
                String cmd = "mkdir " + ExecEngine.prepFileName(this.full_name);
                this.execute(cmd, true, 100);
            }
            catch (Exception e) {
                this.error("Exception: " + e);
            }
            if (this.noErrors()) {
                this.sendRefrReq(this.new_name);
            } else {
                this.sendResult(RootAdapter.this.ctx.getString(2131361993, new Object[]{this.full_name}));
            }
        }
    }

    class CopyFromEngine
    extends ExecEngine {
        private int counter;
        private LsItem[] list;
        private String dest_folder;
        private boolean move;
        private String src_base_path;
        private String uid;

        CopyFromEngine(Context ctx, LsItem[] list_, String dest, boolean move_, Engines.IReciever recipient_) {
            super(ctx);
            this.counter = 0;
            this.recipient = recipient_;
            this.list = list_;
            this.dest_folder = dest;
            this.move = move_;
            this.src_base_path = RootAdapter.this.uri.getPath();
            if (this.src_base_path == null || this.src_base_path.length() == 0) {
                this.src_base_path = CommanderAdapterBase.SLS;
            } else if (this.src_base_path.charAt(this.src_base_path.length() - 1) != CommanderAdapterBase.SLC) {
                this.src_base_path = this.src_base_path + CommanderAdapterBase.SLS;
            }
            if (this.recipient != null) {
                try {
                    ApplicationInfo ai;
                    PackageManager pm = ctx.getPackageManager();
                    if (pm != null && (ai = pm.getApplicationInfo(ctx.getPackageName(), 0)) != null) {
                        this.uid = "" + ai.uid;
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }

        public void run() {
            try {
                boolean ok = this.execute();
                if (this.counter > 0 && this.recipient != null) {
                    File temp_dir = new File(this.dest_folder);
                    File[] temp_content = temp_dir.listFiles();
                    String[] paths = new String[temp_content.length];
                    for (int i = 0; i < temp_content.length; ++i) {
                        paths[i] = temp_content[i].getAbsolutePath();
                    }
                    this.sendReceiveReq(paths);
                    return;
                }
                if (!ok) {
                    this.counter = 0;
                }
            }
            catch (Exception e) {
                this.error("Exception: " + e);
            }
            this.sendResult(this.counter > 0 ? Utils.getOpReport(RootAdapter.this.commander.getContext(), this.counter, this.move ? 2131362005 : 2131362004) : "");
        }

        protected boolean cmdDialog(OutputStreamWriter os, BufferedReader is, BufferedReader es) {
            try {
                int num = this.list.length;
                double conv = 100.0 / (double)num;
                String esc_dest = ExecEngine.prepFileName(this.dest_folder);
                for (int i = 0; i < num; ++i) {
                    LsItem f = this.list[i];
                    if (f == null) continue;
                    String file_name = f.getName();
                    String full_name = this.src_base_path + file_name;
                    String cmd = this.move ? " mv -f" : (f.isDirectory() ? " cp -a" : " cp -p");
                    String to_exec = cmd + " " + ExecEngine.prepFileName(full_name) + " " + esc_dest;
                    this.outCmd(true, to_exec, os);
                    if (this.procError(es)) {
                        return false;
                    }
                    try {
                        File dst_file = new File(this.dest_folder, f.getName());
                        String dst_path = ExecEngine.prepFileName(dst_file.getAbsolutePath());
                        Permissions perm = this.uid != null ? new Permissions(this.uid, this.uid, "-rw-rw----") : new Permissions(f.getAttr());
                        String chown_cmd = "chown " + perm.generateChownString().append(" ").append(dst_path).toString();
                        this.outCmd(this.uid != null, chown_cmd, os);
                        String chmod_cmd = "chmod " + perm.generateChmodString().append(" ").append(dst_path).toString();
                        this.outCmd(true, chmod_cmd, os);
                        this.procError(es);
                    }
                    catch (Exception e) {
                        Log.w((String)this.TAG, (String)"chmod/chown failed", (Throwable)e);
                    }
                    this.sendProgress("'" + file_name + "'", (int)((double)i * conv));
                    ++this.counter;
                }
                return true;
            }
            catch (Exception e) {
                this.error(e.getMessage());
                return false;
            }
        }
    }

    class ListEngine
    extends ExecEngine {
        private LsItem[] items_tmp;
        private String pass_back_on_done;
        private Uri src;
        private ArrayList<LsItem> array;
        private static final String EOL = "_EOL_";

        ListEngine(Context ctx, Handler h, Uri src_, String pass_back_on_done_) {
            super(ctx);
            this.setHandler(h);
            this.src = src_;
            this.pass_back_on_done = pass_back_on_done_;
        }

        public LsItem[] getItems() {
            return this.items_tmp;
        }

        public Uri getUri() {
            return this.src;
        }

        public void run() {
            String msg = null;
            if (!this.getList(true)) {
                Log.w((String)this.TAG, (String)"su failed. let's try just sh");
                this.errMsg = null;
                msg = RootAdapter.this.commander.getContext().getString(2131362185);
                if (!this.getList(false)) {
                    this.error(RootAdapter.this.commander.getContext().getString(2131361994, new Object[]{this.src.getPath()}));
                }
            }
            this.doneReading(msg, this.pass_back_on_done);
        }

        private boolean getList(boolean su) {
            String path;
            if (!su) {
                this.sh = "sh";
            }
            if ((path = this.src.getPath()) == null) {
                path = CommanderAdapterBase.SLS;
                this.src = this.src.buildUpon().encodedPath(path).build();
            } else {
                path = Utils.mbAddSl(path);
            }
            RootAdapter.this.parentLink = path == null || path.length() == 0 || path.equals(CommanderAdapterBase.SLS) ? CommanderAdapterBase.SLS : "..";
            this.array = new ArrayList();
            String to_execute = "ls " + ((RootAdapter.this.mode & 8) != 8 ? "-a " : "") + "-l " + ExecEngine.prepFileName(path) + " ; echo " + EOL;
            if (!this.execute(to_execute, false, su ? 5000 : 500)) {
                return false;
            }
            if (!this.isStopReq()) {
                int sz = this.array != null ? this.array.size() : 0;
                this.items_tmp = new LsItem[sz];
                if (sz > 0) {
                    this.array.toArray(this.items_tmp);
                    LsItem lsItem = this.items_tmp[0];
                    lsItem.getClass();
                    LsItem.LsItemPropComparator comp = lsItem.new LsItem.LsItemPropComparator(RootAdapter.this.mode & 0x30, (RootAdapter.this.mode & 0x80) != 0, RootAdapter.this.ascending);
                    Arrays.sort(this.items_tmp, comp);
                }
                return true;
            }
            return false;
        }

        protected void procInput(BufferedReader br) throws IOException, Exception {
            String ln;
            while (br.ready() && !this.isStopReq() && (ln = br.readLine()) != null && !ln.startsWith(EOL)) {
                LsItem item = new LsItem(ln);
                if (!item.isValid() || "..".equals(item.getName()) || ".".equals(item.getName())) continue;
                String link_target = item.getLinkTarget();
                if (Utils.str(link_target)) {
                    try {
                        File ltf = new File(link_target);
                        if (ltf.isDirectory()) {
                            item.setDirectory();
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                this.array.add(item);
            }
        }
    }
}

