/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.root;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.root.ExecEngine;
import com.ghostsq.commander.root.MountsListEngine;
import com.ghostsq.commander.root.RemountEngine;

public class MountAdapter
extends CommanderAdapterBase {
    public static final String TAG = "MountAdapter";
    public static final String DEFAULT_LOC = "mount:";
    public Uri uri = null;
    private int attempts = 0;
    public MountsListEngine.MountItem[] items = null;

    public MountAdapter(Context ctx_) {
        super(ctx_, 770);
    }

    public String getScheme() {
        return "mount";
    }

    public int setMode(int mask, int val) {
        if ((mask & 0x303) == 0) {
            return super.setMode(mask, val);
        }
        return this.mode;
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case F1: 
            case F7: 
            case F9: 
            case F10: 
            case EQ: 
            case TGL: 
            case HOME: 
            case MENU: 
            case FAVS: 
            case SDCARD: 
            case ROOT: 
            case SOFTKBD: {
                return true;
            }
        }
        return false;
    }

    protected void onReadComplete() {
        this.attempts = 0;
        if (this.reader instanceof MountsListEngine) {
            MountsListEngine list_engine = (MountsListEngine)this.reader;
            this.items = list_engine.getItems();
            this.numItems = this.items != null ? this.items.length + 1 : 0;
            this.notifyDataSetChanged();
        }
    }

    public String toString() {
        return this.uri != null ? this.uri.toString() : "";
    }

    public Uri getUri() {
        return Uri.parse((String)DEFAULT_LOC);
    }

    public void setUri(Uri uri) {
    }

    public void populateContextMenu(ContextMenu menu2, AdapterView.AdapterContextMenuInfo acmi, int num) {
        if (num <= 1) {
            menu2.add(0, 903, 0, (CharSequence)this.s(2131361835));
        }
    }

    public boolean readSource(Uri tmp_uri, String pass_back_on_done) {
        try {
            if (tmp_uri != null) {
                this.uri = tmp_uri;
            }
            if (this.uri == null) {
                return false;
            }
            if (this.reader != null) {
                Log.w((String)TAG, (String)("Busy " + this.attempts));
                if (this.attempts++ < 2) {
                    this.commander.showInfo(this.s(2131362034));
                    return false;
                }
                if (this.reader.reqStop()) {
                    Thread.sleep(500L);
                    if (this.reader.isAlive()) {
                        Log.e((String)TAG, (String)"Busy!");
                        return false;
                    }
                }
            }
            this.notify(-1);
            this.reader = new MountsListEngine(this.commander.getContext(), (Handler)this.readerHandler, pass_back_on_done);
            this.reader.start();
            return true;
        }
        catch (Exception e) {
            this.commander.showError("Exception: " + e);
            e.printStackTrace();
            this.notify(this.s(2131361904), -2);
            return false;
        }
    }

    public void reqItemsSize(SparseBooleanArray cis) {
        this.notify(this.s(2131362037), -2);
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        this.notify(this.s(2131362037), -2);
        return false;
    }

    public boolean createFile(String fileURI) {
        this.notify(this.s(2131362037), -2);
        return false;
    }

    public void createFolder(String dev_mp_pair) {
        CreateEngine ce = new CreateEngine(this.commander.getContext(), this.simpleHandler, dev_mp_pair);
        ce.start();
    }

    public boolean deleteItems(SparseBooleanArray cis) {
        this.notify(this.s(2131362037), -2);
        return false;
    }

    public String getItemName(int position, boolean full) {
        if (position == 0) {
            return SLS;
        }
        if (this.items != null && position > 0 && position <= this.items.length) {
            return this.items[position - 1].getName();
        }
        return null;
    }

    public void openItem(int position) {
        try {
            if (position == 0) {
                this.commander.Navigate(Uri.parse((String)"root:"), null, null);
                return;
            }
            if (this.items == null || position < 0 || position > this.items.length) {
                return;
            }
            MountsListEngine.MountItem item = this.items[position - 1];
            RemountEngine re = new RemountEngine(this.commander.getContext(), this.simpleHandler, item);
            re.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean receiveItems(String[] full_names, int move_mode) {
        this.notify(this.s(2131362037), -2);
        return false;
    }

    public boolean renameItem(int position, String newName, boolean c) {
        this.notify(this.s(2131362037), -2);
        return false;
    }

    public Object getItem(int position) {
        CommanderAdapter.Item item = new CommanderAdapter.Item();
        if (position == 0) {
            item = new CommanderAdapter.Item();
            item.name = this.parentLink;
            item.dir = true;
            item.icon_id = 2130837524;
        } else {
            MountsListEngine.MountItem curItem;
            item.name = "???";
            if (this.items != null && position > 0 && position <= this.items.length && (curItem = this.items[position - 1]) != null) {
                String mp = curItem.getMountPoint();
                if (mp != null) {
                    item.icon_id = mp.contains("/system") || mp.contains("/data") ? 2130837533 : (mp.contains("/sdcard") ? 2130837534 : (mp.contains("/asec") ? 2130837505 : 2130837528));
                }
                item.dir = false;
                item.name = curItem.getName();
                item.size = -1L;
                item.sel = false;
                item.date = null;
                item.attr = curItem.getRest();
            }
        }
        return item;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        CommanderAdapter.Item item = (CommanderAdapter.Item)this.getItem(position);
        if (item == null) {
            return null;
        }
        return this.getView(convertView, parent, item);
    }

    class CreateEngine
    extends ExecEngine {
        String pair;

        CreateEngine(Context ctx, Handler h, String pair_) {
            super(ctx);
            this.setHandler(h);
            this.pair = pair_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            String string2;
            String cmd = null;
            try {
                try {
                    cmd = "mount " + this.pair;
                    this.execute(cmd, true, 1500);
                }
                catch (Exception e) {
                    Log.e((String)this.TAG, (String)"mount, ", (Throwable)e);
                    this.error("Exception: " + e);
                    Object var4_3 = null;
                    super.run();
                    this.sendResult(this.errMsg != null ? (cmd == null ? "" : "Were tried to execute: '" + cmd + "'") : null);
                    return;
                }
                Object var4_2 = null;
                super.run();
                string2 = this.errMsg != null ? (cmd == null ? "" : "Were tried to execute: '" + cmd + "'") : null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                super.run();
                this.sendResult(this.errMsg != null ? (cmd == null ? "" : "Were tried to execute: '" + cmd + "'") : null);
                throw throwable;
            }
            this.sendResult(string2);
        }
    }
}

