/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.provider.MediaStore;
import android.util.Log;
import android.util.SparseArray;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.utils.MnfUtils;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;

class ThumbnailsThread
extends Thread {
    private static final String TAG = "ThumbnailsThread";
    private static final int NOTIFY_THUMBNAIL_CHANGED = 653;
    private CommanderAdapterBase owner;
    private ContentResolver cr;
    private Handler thread_handler;
    private String base_path;
    private CommanderAdapter.Item[] list;
    private BitmapFactory.Options options;
    private Resources res;
    private byte[] buf;
    private int thumb_sz;
    private static final int apk_h = ".apk".hashCode();
    private static final int[] ext_h = new int[]{".jpg".hashCode(), ".JPG".hashCode(), ".jpeg".hashCode(), ".JPEG".hashCode(), ".png".hashCode(), ".PNG".hashCode(), ".gif".hashCode(), ".GIF".hashCode(), apk_h};
    public static final SparseArray<Thumbnail> thumbnailCache = new SparseArray();

    ThumbnailsThread(CommanderAdapterBase owner, Handler thread_handler, String base_path, CommanderAdapter.Item[] list) {
        this.owner = owner;
        this.setName(this.getClass().getName());
        this.thread_handler = thread_handler;
        this.base_path = base_path;
        this.list = list;
        this.buf = new byte[102400];
        this.cr = owner.ctx.getContentResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.list == null) {
                return;
            }
            this.setPriority(1);
            this.thumb_sz = this.owner.getImgWidth();
            this.options = new BitmapFactory.Options();
            this.res = this.owner.ctx.getResources();
            int fails_count = 0;
            boolean visible_only = this.list.length > 100;
            for (int a = 0; a < 2; ++a) {
                boolean succeeded = true;
                boolean need_update = false;
                boolean proc_visible = false;
                boolean proc_invisible = false;
                int processed = 0;
                for (int i = 0; i < this.list.length; ++i) {
                    String ext;
                    String fn;
                    visible_only = visible_only || fails_count > 1;
                    int n = -1;
                    while (true) {
                        for (int j = 0; j < this.list.length; ++j) {
                            if (this.list[j].need_thumb) {
                                n = j;
                                proc_visible = true;
                                break;
                            }
                            this.list[j].remThumbnailIfOld(visible_only ? 10000 : 60000);
                        }
                        if (!visible_only || proc_visible) break;
                        CommanderAdapterBase j = this.owner;
                        synchronized (j) {
                            this.owner.wait();
                        }
                    }
                    boolean bl = proc_invisible = n < 0;
                    if (proc_invisible) {
                        n = i;
                    } else {
                        --i;
                    }
                    if (!proc_visible) {
                        ThumbnailsThread.yield();
                        ThumbnailsThread.sleep(10L);
                    }
                    CommanderAdapter.Item f = this.list[n];
                    f.need_thumb = false;
                    if (f.isThumbNail()) continue;
                    if (f.name.indexOf(47) >= 0) {
                        fn = f.name;
                    } else if (Utils.str(this.base_path)) {
                        fn = Utils.mbAddSl(this.base_path) + f.name;
                    } else {
                        if (!(f.origin instanceof File)) continue;
                        fn = ((File)f.origin).getAbsolutePath();
                    }
                    if (!new File(fn).exists()) continue;
                    int fn_h = (fn + " " + f.size).hashCode();
                    Thumbnail cached = null;
                    SparseArray<Thumbnail> sparseArray = thumbnailCache;
                    synchronized (sparseArray) {
                        cached = (Thumbnail)thumbnailCache.get(fn_h);
                    }
                    if (cached != null) {
                        f.setThumbNail(cached.srd.get());
                        f.attr = cached.getResInfo();
                    }
                    if ((ext = Utils.getFileExt(fn)) == null) continue;
                    if (ext.equals(".apk")) {
                        f.thumb_is_icon = true;
                    }
                    if (!f.isThumbNail()) {
                        int ext_hash = ext.hashCode();
                        int ht_sz = ext_h.length;
                        boolean not_img = true;
                        for (int j = 0; j < ht_sz; ++j) {
                            if (ext_hash != ext_h[j]) continue;
                            not_img = false;
                            break;
                        }
                        if (not_img) {
                            f.no_thumb = true;
                            f.setThumbNail(null);
                            continue;
                        }
                        Thumbnail t = null;
                        if (ext_hash == apk_h) {
                            t = this.getApkIcon(fn);
                            f.thumb_is_icon = true;
                        } else {
                            t = this.createThumbnail(fn, f, ext_hash);
                        }
                        if (t != null) {
                            f.setThumbNail(t.srd.get());
                            f.attr = t.getResInfo();
                            SparseArray<Thumbnail> sparseArray2 = thumbnailCache;
                            synchronized (sparseArray2) {
                                thumbnailCache.put(fn_h, (Object)t);
                            }
                        } else {
                            succeeded = false;
                            if (fails_count++ > 10) {
                                Log.e((String)TAG, (String)"To many fails, give up");
                                return;
                            }
                        }
                    }
                    need_update = true;
                    if (!f.isThumbNail() || processed++ <= 3 && (!proc_visible || !proc_invisible)) continue;
                    Message msg = this.thread_handler.obtainMessage(653);
                    msg.sendToTarget();
                    ThumbnailsThread.yield();
                    proc_visible = false;
                    need_update = false;
                    processed = 0;
                }
                if (need_update) {
                    Message msg = this.thread_handler.obtainMessage(653);
                    msg.sendToTarget();
                }
                if (!succeeded) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Thumbnail createThumbnail(String fn, CommanderAdapter.Item f, int h) {
        String func_name = "createThubnail()";
        int img_w = 0;
        int img_h = 0;
        try {
            Cursor cursor = null;
            try {
                String[] th_proj = new String[]{"_id", "width", "height", "image_id"};
                if (f.origin instanceof Uri) {
                    cursor = MediaStore.Images.Thumbnails.queryMiniThumbnails((ContentResolver)this.cr, (Uri)((Uri)f.origin), (int)1, (String[])th_proj);
                } else {
                    String where;
                    boolean SDK16UP = Build.VERSION.SDK_INT >= 16;
                    String[] proj_id = new String[]{"_id"};
                    String[] proj_wh = new String[]{"_id"};
                    String[] proj = SDK16UP ? proj_wh : proj_id;
                    cursor = this.cr.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, proj, where = "_data = '" + fn + "'", null, null);
                    if (cursor != null && cursor.getCount() > 0) {
                        cursor.moveToPosition(0);
                        long id2 = cursor.getLong(0);
                        if (SDK16UP) {
                            img_w = cursor.getInt(1);
                            img_h = cursor.getInt(2);
                        }
                        cursor.close();
                        cursor = MediaStore.Images.Thumbnails.queryMiniThumbnail((ContentResolver)this.cr, (long)id2, (int)1, (String[])th_proj);
                    }
                }
                if (cursor != null && cursor.getCount() > 0) {
                    cursor.moveToPosition(0);
                    Uri tcu = ContentUris.withAppendedId((Uri)MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, (long)cursor.getLong(0));
                    int tw = cursor.getInt(1);
                    int th = cursor.getInt(2);
                    InputStream in = this.cr.openInputStream(tcu);
                    if (tw <= 0 || th <= 0) {
                        this.options.inSampleSize = 4;
                    } else {
                        int b;
                        int greatest = Math.max(tw, th);
                        int factor = greatest / this.thumb_sz;
                        for (b = 0x8000000; b > 0 && b > factor; b >>= 1) {
                        }
                        this.options.inSampleSize = b;
                    }
                    this.options.inJustDecodeBounds = false;
                    this.options.inTempStorage = this.buf;
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)this.options);
                    if (bitmap != null) {
                        BitmapDrawable drawable2 = new BitmapDrawable(this.res, bitmap);
                        Thumbnail thb = new Thumbnail((Drawable)drawable2, img_w, img_h);
                        f.setThumbNail((Drawable)drawable2);
                        in.close();
                        Thumbnail thumbnail = thb;
                        return thumbnail;
                    }
                }
            }
            catch (Exception e) {
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.options.inSampleSize = 1;
            this.options.inJustDecodeBounds = true;
            this.options.outWidth = 0;
            this.options.outHeight = 0;
            this.options.inTempStorage = this.buf;
            FileInputStream fis = new FileInputStream(fn);
            BitmapFactory.decodeStream((InputStream)fis, null, (BitmapFactory.Options)this.options);
            img_w = this.options.outWidth;
            img_h = this.options.outHeight;
            if (img_w <= 0 || img_h <= 0) {
                Log.w((String)TAG, (String)"failed to get an image bounds");
            } else {
                int b;
                int greatest = Math.max(this.options.outWidth, this.options.outHeight);
                int factor = greatest / this.thumb_sz;
                for (b = 0x8000000; b > 0 && b >= factor; b >>= 1) {
                }
                this.options.inSampleSize = b;
                this.options.inJustDecodeBounds = false;
                Bitmap bitmap = BitmapFactory.decodeFile((String)fn, (BitmapFactory.Options)this.options);
                if (bitmap != null) {
                    BitmapDrawable drawable3 = new BitmapDrawable(this.res, bitmap);
                    Thumbnail thb = new Thumbnail((Drawable)drawable3, img_w, img_h);
                    f.setThumbNail((Drawable)drawable3);
                    fis.close();
                    return thb;
                }
            }
            fis.close();
            Log.e((String)TAG, (String)("createThubnail() failed for " + fn));
            return null;
        }
        catch (RuntimeException rte) {
            Log.e((String)TAG, (String)"createThubnail()", (Throwable)rte);
            return null;
        }
        catch (FileNotFoundException fne) {
            Log.e((String)TAG, (String)"createThubnail()", (Throwable)fne);
            return null;
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)"createThubnail()", (Throwable)ioe);
            return null;
        }
        catch (Error err) {
            Log.e((String)TAG, (String)"createThubnail()", (Throwable)err);
        }
        return null;
    }

    private final Thumbnail getApkIcon(String fn) {
        try {
            Drawable icon = null;
            PackageManager pm = this.owner.ctx.getPackageManager();
            PackageInfo info = pm.getPackageArchiveInfo(fn, 0);
            if (info != null) {
                try {
                    icon = pm.getApplicationIcon(info.packageName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (icon != null) {
                    return new Thumbnail(icon);
                }
            }
            try {
                PackageInfo packageInfo = this.owner.ctx.getPackageManager().getPackageArchiveInfo(fn, 1);
                if (packageInfo != null) {
                    ApplicationInfo appInfo = packageInfo.applicationInfo;
                    if (Build.VERSION.SDK_INT >= 8) {
                        appInfo.sourceDir = fn;
                        appInfo.publicSourceDir = fn;
                    }
                    icon = appInfo.loadIcon(this.owner.ctx.getPackageManager());
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("File: " + fn), (Throwable)e);
            }
            if (icon != null) {
                return new Thumbnail(icon);
            }
            MnfUtils mnfu = new MnfUtils(fn);
            icon = mnfu.extractIcon();
            if (icon != null) {
                return new Thumbnail(icon);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private class Thumbnail {
        public SoftReference<Drawable> srd;
        public int h;
        public int w;

        Thumbnail(Drawable d) {
            this(d, 0, 0);
        }

        Thumbnail(Drawable d, int w, int h) {
            this.srd = new SoftReference<Drawable>(d);
            this.h = h;
            this.w = w;
        }

        public final String getResInfo() {
            return this.h == 0 ? null : "" + this.w + "x" + this.h;
        }
    }
}

