/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.utils.Utils;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemComparator
implements Comparator<CommanderAdapter.Item> {
    int type;
    boolean case_ignore;
    boolean ascending;

    public ItemComparator(int type_, boolean case_ignore_, boolean ascending_) {
        this.type = type_;
        this.case_ignore = case_ignore_ && (type_ == 48 || type_ == 0);
        this.ascending = ascending_;
    }

    @Override
    public int compare(CommanderAdapter.Item f1, CommanderAdapter.Item f2) {
        boolean f1IsDir = f1.dir;
        boolean f2IsDir = f2.dir;
        if (f1IsDir != f2IsDir) {
            return f1IsDir ? -1 : 1;
        }
        int ext_cmp = 0;
        switch (this.type) {
            case 48: {
                ext_cmp = this.case_ignore ? Utils.getFileExt(f1.name).compareToIgnoreCase(Utils.getFileExt(f2.name)) : Utils.getFileExt(f1.name).compareTo(Utils.getFileExt(f2.name));
                break;
            }
            case 16: {
                ext_cmp = f1.size - f2.size < 0L ? -1 : 1;
                break;
            }
            case 32: {
                ext_cmp = f1.date.compareTo(f2.date);
            }
        }
        if (ext_cmp == 0) {
            ext_cmp = this.case_ignore ? f1.name.compareToIgnoreCase(f2.name) : f1.name.compareTo(f2.name);
        }
        return this.ascending ? ext_cmp : -ext_cmp;
    }
}

