/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.ContentAdapter;
import com.ghostsq.commander.adapters.MSAdapter;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class HomeAdapter
extends CommanderAdapterBase {
    private static final String TAG = "HomeAdapter";
    public static final String DEFAULT_LOC = "home:";
    private static final int FORGET_CMD = 4945;
    private static final int PREFS_CMD = 4342;
    private boolean root = false;
    private final int[] FAVS = new int[]{2131361838, 2131361852, 2130837512};
    private final int[] LOCAL = new int[]{2131361839, 2131361853, 2130837515};
    private final int[] EXTERNAL = new int[]{2131361840, 2131361854, 2130837543};
    private final int[] MEDIA = new int[]{2131361841, 2131361855, 2130837529};
    private final int[] FTP = new int[]{2131361842, 2131361856, 2130837516};
    private final int[] PLUGINS = new int[]{2131361845, 2131361859, 2130837532};
    private final int[] ROOT = new int[]{2131361846, 2131361860, 2130837533};
    private final int[] MOUNT = new int[]{2131361847, 2131361861, 2130837528};
    private final int[] APPS = new int[]{2131361849, 2131361862, 2130837505};
    private final int[] EXIT = new int[]{2131361850, 2131361863, 2130837511};
    private CommanderAdapter.Item[] items = null;

    private CommanderAdapter.Item makeItem(int[] mode, String scheme) {
        CommanderAdapter.Item item = new CommanderAdapter.Item();
        item.name = this.s(mode[0]);
        item.attr = this.s(mode[1]);
        item.icon_id = mode[2];
        item.origin = scheme;
        return item;
    }

    public HomeAdapter(Context ctx_) {
        super(ctx_, 770);
        this.setCount(this.getNumItems());
    }

    public String getScheme() {
        return "home";
    }

    public int setMode(int mask, int val) {
        if ((mask & 0x303) == 0) {
            super.setMode(mask, val);
        }
        this.mode &= 0xFFFFDFFF;
        if ((mask & 0x400) != 0) {
            this.root = (this.mode & 0x400) != 0;
            this.setCount(this.getNumItems());
            this.notifyDataSetChanged();
        }
        return this.mode;
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case MOUNT: {
                return true;
            }
            case HOME: 
            case SORTING: {
                return false;
            }
        }
        return super.hasFeature(feature);
    }

    public String toString() {
        return DEFAULT_LOC;
    }

    public Uri getUri() {
        return Uri.parse((String)this.toString());
    }

    public void setUri(Uri uri) {
    }

    public boolean readSource(Uri tmp_uri, String pbod) {
        try {
            this.items = null;
            ArrayList<CommanderAdapter.Item> ia = new ArrayList<CommanderAdapter.Item>();
            Utils.changeLanguage(this.ctx);
            ia.add(this.makeItem(this.FAVS, "favs"));
            ia.add(this.makeItem(this.LOCAL, "fs"));
            if (Build.VERSION.SDK_INT >= 11) {
                Map<String, String> env = System.getenv();
                String sec_storage = env.get("SECONDARY_STORAGE");
                String expt_ms_path = null;
                if (Utils.str(sec_storage)) {
                    String[] ss = sec_storage.split(":");
                    ia.add(this.makeItem(this.EXTERNAL, ss[0]));
                    File ext_fd = new File(ss[0]);
                    String[] dir_list = ext_fd.list();
                    expt_ms_path = dir_list != null && dir_list.length > 0 ? "ms:" + ss[0] : "ms:" + Environment.getExternalStorageDirectory().getAbsolutePath();
                } else {
                    expt_ms_path = "ms:" + Environment.getExternalStorageDirectory().getAbsolutePath();
                }
                ia.add(this.makeItem(this.MEDIA, expt_ms_path));
            }
            ia.add(this.makeItem(this.FTP, "ftp"));
            Utils.changeLanguage(this.ctx);
            String ghost_commander = "com.ghostsq.commander";
            int scheme_pos = "com.ghostsq.commander".length() + 1;
            PackageManager pm = this.ctx.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo("com.ghostsq.commander", 0);
            String[] ghosts = pm.getPackagesForUid(ai.uid);
            if (ghosts != null && ghosts.length > 1) {
                Arrays.sort(ghosts, new Comparator<String>(){

                    @Override
                    public int compare(String i1, String i2) {
                        if (i1.indexOf("sftp") > 0) {
                            return -1;
                        }
                        if (i1.indexOf("samba") > 0) {
                            return i2.indexOf("sftp") > 0 ? 1 : -1;
                        }
                        return 0;
                    }
                });
                for (String pkgn : ghosts) {
                    if ("com.ghostsq.commander".equals(pkgn)) continue;
                    ApplicationInfo pai = null;
                    Resources pre = null;
                    try {
                        pai = pm.getApplicationInfo(pkgn, 0);
                        if (pai == null) continue;
                        pre = pm.getResourcesForApplication(pai);
                        if (pre == null) {
                        }
                    }
                    catch (Exception e) {}
                    continue;
                    Log.d((String)TAG, (String)pkgn);
                    CommanderAdapter.Item item = new CommanderAdapter.Item();
                    ia.add(item);
                    String scheme = pkgn.substring(scheme_pos);
                    if ("samba".equals(scheme)) {
                        item.name = this.s(2131361844);
                        item.attr = this.s(2131361858);
                        item.icon_id = 2130837537;
                    } else if ("sftp".equals(scheme)) {
                        item.name = this.s(2131361843);
                        item.attr = this.s(2131361857);
                        item.icon_id = 2130837536;
                    } else {
                        int cp;
                        String descr;
                        Utils.changeLanguage(this.ctx, pre);
                        if (pai.descriptionRes != 0 && Utils.str(descr = pre.getString(pai.descriptionRes)) && (cp = descr.indexOf(58)) > 0) {
                            item.name = descr.substring(0, cp);
                            item.attr = descr.substring(cp + 1);
                        }
                        if (!Utils.str(item.name)) {
                            item.name = pre.getString(pai.labelRes);
                        }
                        Drawable logo = null;
                        if (Build.VERSION.SDK_INT >= 9) {
                            logo = ForwardCompat.getLogo(pm, pai);
                        }
                        item.setIcon(logo != null ? logo : pm.getApplicationIcon(pai));
                        item.dir = true;
                    }
                    item.origin = scheme;
                }
            }
            ia.add(this.makeItem(this.PLUGINS, "pl"));
            if (this.root) {
                ia.add(this.makeItem(this.ROOT, "root"));
                ia.add(this.makeItem(this.MOUNT, "mount"));
            }
            ia.add(this.makeItem(this.APPS, "apps"));
            ia.add(this.makeItem(this.EXIT, "exit"));
            this.items = new CommanderAdapter.Item[ia.size()];
            ia.toArray(this.items);
            this.setCount(this.getNumItems());
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        this.notify(pbod);
        return true;
    }

    public void reqItemsSize(SparseBooleanArray cis) {
        this.notErr();
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        return this.notErr();
    }

    public boolean createFile(String fileURI) {
        return this.notErr();
    }

    public void createFolder(String new_name) {
        this.notErr();
    }

    public boolean deleteItems(SparseBooleanArray cis) {
        return this.notErr();
    }

    public void openItem(int position) {
        String scheme;
        CommanderAdapter.Item item = (CommanderAdapter.Item)this.getItem(position);
        String uri_s = null;
        if ("ftp".equals(item.origin)) {
            this.commander.dispatchCommand(4501);
            return;
        }
        if ("sftp".equals(item.origin)) {
            this.commander.dispatchCommand(2450);
            return;
        }
        if ("samba".equals(item.origin)) {
            this.commander.dispatchCommand(2751);
            return;
        }
        if ("pl".equals(item.origin)) {
            Intent i = new Intent("android.intent.action.VIEW");
            i.setData(Uri.parse((String)this.s(2131362208)));
            this.commander.issue(i, 0);
            return;
        }
        if ("exit".equals(item.origin)) {
            this.commander.dispatchCommand(2131230915);
            return;
        }
        uri_s = "fs".equals(item.origin) ? Environment.getExternalStorageDirectory().getAbsolutePath() : ((scheme = (String)item.origin).indexOf(47) >= 0 ? scheme : item.origin + ":");
        if (Utils.str(uri_s)) {
            this.commander.Navigate(Uri.parse((String)uri_s), null, null);
        }
    }

    public boolean receiveItems(String[] full_names, int move_mode) {
        return this.notErr();
    }

    public boolean renameItem(int position, String newName, boolean c) {
        return this.notErr();
    }

    private int getNumItems() {
        return this.items == null ? 0 : this.items.length;
    }

    public String getItemName(int position, boolean full) {
        return this.items != null ? "" : this.items[position].name;
    }

    public Object getItem(int position) {
        return this.items[position];
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        CommanderAdapter.Item item = (CommanderAdapter.Item)this.getItem(position);
        if (item == null) {
            return null;
        }
        return this.getView(convertView, parent, item);
    }

    public void populateContextMenu(ContextMenu menu2, AdapterView.AdapterContextMenuInfo acmi, int num) {
        String schema;
        CommanderAdapter.Item item = (CommanderAdapter.Item)this.getItem(acmi.position);
        if (item == null) {
            return;
        }
        String string2 = schema = item.origin instanceof String ? (String)item.origin : null;
        if (!Utils.str(schema)) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 11 && schema.startsWith("ms:")) {
            MSAdapter.populateHomeContextMenu(this.ctx, menu2);
            ContentAdapter.populateHomeContextMenu(this.ctx, menu2);
        }
        if (item.dir) {
            File plugin_prefs_f = this.getPluginPrefsFile((String)item.origin);
            if (plugin_prefs_f.exists()) {
                menu2.add(0, 4945, 0, 2131361851);
            }
            Intent intent = this.getPluginPrefIntent((String)item.origin);
            PackageManager packageManager = this.ctx.getPackageManager();
            List list = packageManager.queryIntentActivities(intent, 65536);
            if (list.size() > 0) {
                menu2.add(0, 4342, 0, 2131361882);
            }
        }
    }

    private final File getPluginPrefsFile(String schema) {
        File shared_prefs_f = new File(this.ctx.getFilesDir().getParentFile(), "shared_prefs");
        File plugin_prefs_f = new File(shared_prefs_f, schema + ".xml");
        return plugin_prefs_f;
    }

    private final Intent getPluginPrefIntent(String plugin_name) {
        String package_n = "com.ghostsq.commander." + plugin_name;
        String class_n = package_n + ".Prefs";
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(package_n, class_n));
        return intent;
    }

    public void doIt(int command_id, SparseBooleanArray cis) {
        try {
            String schema;
            CommanderAdapter.Item item = this.bitsToItem(cis);
            if (item == null) {
                return;
            }
            String string2 = schema = item.origin instanceof String ? (String)item.origin : null;
            if (!Utils.str(schema)) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 11 && schema.startsWith("ms:")) {
                String fragment = MSAdapter.getFragment(command_id);
                if (fragment != null) {
                    this.commander.Navigate(Uri.parse((String)(schema + "#" + fragment)), null, null);
                    return;
                }
                Uri content_uri = ContentAdapter.getUri(command_id);
                if (content_uri != null) {
                    this.commander.Navigate(content_uri, null, null);
                    return;
                }
            }
            if (item.dir) {
                if (4945 == command_id) {
                    File plugin_prefs_f = this.getPluginPrefsFile(schema);
                    if (plugin_prefs_f.exists()) {
                        plugin_prefs_f.delete();
                        this.commander.dispatchCommand(2131230915);
                    }
                    return;
                }
                if (4342 == command_id) {
                    Intent intent = this.getPluginPrefIntent(schema);
                    Log.d((String)TAG, (String)"Starting Activity");
                    this.commander.issue(intent, 0);
                    return;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("" + command_id), (Throwable)e);
        }
    }

    private final CommanderAdapter.Item bitsToItem(SparseBooleanArray cis) {
        try {
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                return this.items[cis.keyAt(i)];
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
        return null;
    }
}

