/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Context;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.format.Formatter;
import android.util.Log;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.FTPAdapter;
import com.ghostsq.commander.utils.FTP;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.LsItem;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;

public final class FTPEngines {

    public static class CalcSizesEngine
    extends FTPEngine {
        private int num = 0;
        private int dirs = 0;
        private int depth = 0;
        private LsItem[] list;

        CalcSizesEngine(Commander c, FTPAdapter.FTPCredentials crd_, Uri uri_, LsItem[] list_, boolean active, Charset cs) {
            super(c.getContext(), crd_, uri_, active, cs);
            this.list = list_;
        }

        public void run() {
            try {
                LsItem f;
                if (this.crd == null || this.crd.isNotSet()) {
                    this.crd = new FTPAdapter.FTPCredentials(this.uri.getUserInfo());
                }
                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                    this.error(this.ctx.getString(2131362062));
                    this.sendResult("");
                    return;
                }
                this.sendProgress();
                long total = this.getSizes(this.list, "");
                StringBuffer result = new StringBuffer();
                if (this.list.length == 1) {
                    f = this.list[0];
                    if (f.isDirectory()) {
                        result.append(this.ctx.getString(Utils.RR.sz_folder.r(), new Object[]{f.getName(), this.num}));
                        if (this.dirs > 0) {
                            result.append(this.ctx.getString(Utils.RR.sz_dirnum.r(), new Object[]{this.dirs, this.dirs > 1 ? this.ctx.getString(Utils.RR.sz_dirsfx_p.r()) : this.ctx.getString(Utils.RR.sz_dirsfx_s.r())}));
                        }
                    } else {
                        result.append(this.ctx.getString(Utils.RR.sz_file.r(), new Object[]{f.getName()}));
                    }
                } else {
                    result.append(this.ctx.getString(Utils.RR.sz_files.r(), new Object[]{this.num}));
                    if (this.dirs > 0) {
                        result.append(this.ctx.getString(Utils.RR.sz_dirnum.r(), new Object[]{this.dirs, this.dirs > 1 ? this.ctx.getString(Utils.RR.sz_dirsfx_p.r()) : this.ctx.getString(Utils.RR.sz_dirsfx_s.r())}));
                    }
                }
                if (total > 0L) {
                    result.append(this.ctx.getString(Utils.RR.sz_Nbytes.r(), new Object[]{Formatter.formatFileSize((Context)this.ctx, (long)total).trim()}));
                }
                if (total > 1024L) {
                    result.append(this.ctx.getString(Utils.RR.sz_bytes.r(), new Object[]{total}));
                }
                if (this.list.length == 1) {
                    f = this.list[0];
                    result.append(this.ctx.getString(Utils.RR.sz_lastmod.r()));
                    result.append(" ");
                    result.append("<small>");
                    result.append(Utils.formatDate(f.getDate(), this.ctx));
                    result.append("</small>");
                }
                this.sendReport(result.toString());
                super.run();
            }
            catch (InterruptedException e) {
                this.sendResult(this.ctx.getString(2131361990));
            }
            catch (Exception e) {
                this.error(this.ctx.getString(2131361905) + e.getLocalizedMessage());
                e.printStackTrace();
            }
            super.run();
        }

        protected final long getSizes(LsItem[] list, String path) throws Exception {
            long total = 0L;
            try {
                for (int i = 0; i < list.length; ++i) {
                    if (this.stop || this.isInterrupted()) {
                        this.error(this.ctx.getString(2131361972));
                        break;
                    }
                    LsItem f = list[i];
                    if (f == null) continue;
                    String pathName = path + f.getName();
                    if (f.isDirectory()) {
                        ++this.dirs;
                        if (this.depth++ > 20) {
                            throw new Exception(this.ctx.getString(2131361974));
                        }
                        LsItem[] subItems = this.ftp.getDirList(pathName, true);
                        --this.depth;
                        if (subItems == null) {
                            this.error("Failed to get the file list of the subfolder '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog());
                        } else {
                            total += this.getSizes(subItems, pathName + File.separator);
                            if (this.errMsg == null) continue;
                        }
                        break;
                    }
                    total += f.length();
                    ++this.num;
                }
            }
            catch (RuntimeException e) {
                this.error("Runtime Exception: " + e.getMessage());
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
            return total;
        }
    }

    static class ChmodEngine
    extends FTPEngine {
        private String chmod;

        ChmodEngine(Context ctx_, Uri uri_, String chmod_, Charset cs) {
            super(ctx_, null, uri_, false, cs);
            this.chmod = chmod_;
        }

        public void run() {
            try {
                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                    this.error(this.ctx.getString(2131362062));
                    this.sendResult("");
                    return;
                }
                if (!this.ftp.site(this.chmod)) {
                    this.error(this.ctx.getString(2131361905) + this.ftp.getLog());
                }
                this.sendResult("");
                super.run();
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
        }
    }

    static class RenEngine
    extends FTPEngine {
        private String oldName;
        private String newName;

        RenEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, String oldName_, String newName_, boolean active, Charset cs) {
            super(ctx_, crd_, uri_, active, cs);
            this.oldName = oldName_;
            this.newName = newName_;
        }

        public void run() {
            try {
                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                    this.error(this.ctx.getString(2131362062));
                    this.sendResult("");
                    return;
                }
                if (!this.ftp.rename(this.oldName, this.newName)) {
                    this.error(this.ctx.getString(2131361905) + this.ftp.getLog());
                }
                this.sendResult("");
                super.run();
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
        }
    }

    static class DelEngine
    extends FTPEngine {
        LsItem[] mList;

        DelEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, LsItem[] list, boolean active, Charset cs) {
            super(ctx_, crd_, uri_, active, cs);
            this.mList = list;
        }

        public void run() {
            try {
                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                    this.error(this.ctx.getString(2131362062));
                    this.sendResult("");
                    return;
                }
                int total = this.delFiles(this.mList, "");
                this.sendResult(Utils.getOpReport(this.ctx, total, 2131362006));
                super.run();
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
        }

        private final int delFiles(LsItem[] list, String path) {
            int counter = 0;
            try {
                for (int i = 0; i < list.length; ++i) {
                    if (this.stop || this.isInterrupted()) {
                        this.error(this.ctx.getString(2131361972));
                        break;
                    }
                    LsItem f = list[i];
                    if (f == null) continue;
                    String pathName = path + f.getName();
                    if (f.isDirectory()) {
                        LsItem[] subItems = this.ftp.getDirList(pathName, true);
                        counter += this.delFiles(subItems, pathName + File.separator);
                        if (this.errMsg != null) break;
                        this.ftp.clearLog();
                        if (!this.ftp.rmDir(pathName)) {
                            this.error("Failed to remove folder '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog());
                            break;
                        }
                    } else {
                        this.sendProgress(this.ctx.getString(2131361979, new Object[]{pathName}), i * 100 / list.length);
                        this.ftp.clearLog();
                        if (!this.ftp.delete(pathName)) {
                            this.error("Failed to delete file '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog());
                            break;
                        }
                    }
                    ++counter;
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"delFiles()", (Throwable)e);
                this.error(e.getLocalizedMessage());
            }
            return counter;
        }
    }

    public static class CopyToEngine
    extends CopyEngine {
        private File[] mList;
        private int basePathLen;
        private boolean move = false;
        private boolean del_src_dir = false;

        CopyToEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, File[] list, boolean move_, boolean del_src_dir_, boolean active, Charset cs) {
            super(ctx_, crd_, uri_, active, cs);
            this.mList = list;
            this.basePathLen = list[0].getParent().length();
            if (this.basePathLen > 1) {
                ++this.basePathLen;
            }
            this.move = move_;
            this.del_src_dir = del_src_dir_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block8: {
                block7: {
                    block6: {
                        try {
                            try {
                                File src_dir;
                                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                                    this.error(this.ctx.getString(2131362062));
                                    this.sendResult("");
                                    Object var4_1 = null;
                                    break block6;
                                }
                                this.wifiLock.acquire();
                                int total = this.copyFiles(this.mList);
                                this.wifiLock.release();
                                if (this.del_src_dir && (src_dir = this.mList[0].getParentFile()) != null) {
                                    src_dir.delete();
                                }
                                this.sendResult(Utils.getOpReport(this.ctx, total, 2131362008));
                                break block7;
                            }
                            catch (Exception e) {
                                this.error(e.getLocalizedMessage());
                                Object var4_3 = null;
                                super.run();
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            super.run();
                            throw throwable;
                        }
                    }
                    super.run();
                    return;
                }
                Object var4_2 = null;
                super.run();
                return;
            }
            this.sendResult("");
        }

        private final int copyFiles(File[] list) throws InterruptedException {
            if (list == null) {
                return 0;
            }
            int counter = 0;
            try {
                for (int i = 0; i < list.length; ++i) {
                    if (this.stop || this.isInterrupted()) {
                        this.error(this.ctx.getString(2131361972));
                        break;
                    }
                    File f = list[i];
                    if (f == null || !f.exists()) continue;
                    if (f.isFile()) {
                        String pathName = f.getAbsolutePath();
                        int pnl = pathName.length();
                        this.progressMessage = this.ctx.getString(2131361986, new Object[]{pnl > 36 ? "\u2026" + pathName.substring(pnl - 36) : pathName});
                        this.sendProgress(this.progressMessage, 0);
                        String fn = f.getAbsolutePath().substring(this.basePathLen);
                        FileInputStream in = new FileInputStream(f);
                        this.setCurFileLength(f.length());
                        this.ftp.clearLog();
                        if (!this.ftp.store(fn, in, this)) {
                            this.error(this.ctx.getString(2131362060, new Object[]{f.getName(), this.ftp.getLog()}));
                            break;
                        }
                        this.progressMessage = "";
                    } else if (f.isDirectory()) {
                        this.ftp.clearLog();
                        String toCreate = f.getAbsolutePath().substring(this.basePathLen);
                        if (!this.ftp.makeDir(toCreate)) {
                            this.error(this.ctx.getString(2131362061, new Object[]{toCreate, this.ftp.getLog()}));
                            break;
                        }
                        counter += this.copyFiles(f.listFiles());
                        if (this.errMsg != null) break;
                    }
                    ++counter;
                    if (!this.move || f.delete()) continue;
                    this.error(this.ctx.getString(2131362002, new Object[]{f.getCanonicalPath()}));
                    break;
                }
            }
            catch (IOException e) {
                this.error("IOException: " + e.getMessage());
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
            return counter;
        }
    }

    public static class CopyFromEngine
    extends CopyEngine {
        private LsItem[] mList;
        private File dest_folder;
        private boolean move;
        private Commander commander;

        CopyFromEngine(Commander c, FTPAdapter.FTPCredentials crd_, Uri uri_, LsItem[] list, File dest, boolean move_, Engines.IReciever recipient_, boolean active, Charset cs) {
            super(c.getContext(), crd_, uri_, active, cs);
            this.commander = c;
            this.mList = list;
            this.dest_folder = dest;
            this.move = move_;
            this.recipient = recipient_;
        }

        public void run() {
            try {
                if (this.crd == null || this.crd.isNotSet()) {
                    this.crd = new FTPAdapter.FTPCredentials(this.uri.getUserInfo());
                }
                if (this.ftp.connectAndLogin(this.uri, this.crd.getUserName(), this.crd.getPassword(), true) < 0) {
                    this.error(this.ctx.getString(2131362062));
                    this.sendResult("");
                    return;
                }
                this.wifiLock.acquire();
                int total = this.copyFiles(this.mList, "");
                this.wifiLock.release();
                if (this.recipient != null) {
                    this.sendReceiveReq(this.dest_folder);
                    return;
                }
                this.sendResult(Utils.getOpReport(this.ctx, total, 2131362007));
            }
            catch (InterruptedException e) {
                this.sendResult(this.ctx.getString(2131361990));
            }
            catch (Exception e) {
                this.error(this.ctx.getString(2131361905) + e.getLocalizedMessage());
                e.printStackTrace();
            }
            super.run();
        }

        private final int copyFiles(LsItem[] list, String path) throws InterruptedException {
            int counter = 0;
            try {
                for (int i = 0; i < list.length; ++i) {
                    Date ftp_file_date;
                    if (this.stop || this.isInterrupted()) {
                        this.error(this.ctx.getString(2131361972));
                        break;
                    }
                    LsItem f = list[i];
                    if (f == null) continue;
                    String pathName = path + f.getName();
                    File dest = new File(this.dest_folder, pathName);
                    if (f.isDirectory()) {
                        if (!(dest.mkdir() || dest.exists() && dest.isDirectory())) {
                            this.errMsg = "Can't create folder \"" + dest.getCanonicalPath() + "\"";
                            break;
                        }
                        LsItem[] subItems = this.ftp.getDirList(pathName, true);
                        if (subItems == null) {
                            this.errMsg = "Failed to get the file list of the subfolder '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog();
                            break;
                        }
                        counter += this.copyFiles(subItems, pathName + File.separator);
                        if (this.errMsg != null) break;
                        if (this.move && !this.ftp.rmDir(pathName)) {
                            this.errMsg = "Failed to remove folder '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog();
                            break;
                        }
                    } else {
                        if (dest.exists()) {
                            int res = this.askOnFileExist(this.ctx.getString(2131361995, new Object[]{dest.getAbsolutePath()}), this.commander);
                            if (res == 1) break;
                            if (res == 4) continue;
                            if (res == 2 && !dest.delete()) {
                                this.error(this.ctx.getString(2131362002, new Object[]{dest.getAbsoluteFile()}));
                                break;
                            }
                        }
                        int pnl = pathName.length();
                        this.progressMessage = this.ctx.getString(2131361985, new Object[]{pnl > 36 ? "\u2026" + pathName.substring(pnl - 36) : pathName});
                        this.sendProgress(this.progressMessage, 0);
                        this.setCurFileLength(f.length());
                        FileOutputStream out = new FileOutputStream(dest);
                        this.ftp.clearLog();
                        if (!this.ftp.retrieve(pathName, out, this)) {
                            this.error("Can't download file '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog());
                            dest.delete();
                            break;
                        }
                        if (this.move && !this.ftp.delete(pathName)) {
                            this.error("Can't delete file '" + pathName + "'.\n FTP log:\n\n" + this.ftp.getLog());
                            break;
                        }
                        this.progressMessage = "";
                    }
                    if ((ftp_file_date = f.getDate()) != null) {
                        dest.setLastModified(ftp_file_date.getTime());
                    }
                    int GINGERBREAD = 9;
                    if (Build.VERSION.SDK_INT >= 9) {
                        ForwardCompat.setFullPermissions(dest);
                    }
                    ++counter;
                }
            }
            catch (RuntimeException e) {
                this.error("Runtime Exception: " + e.getMessage());
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
            catch (IOException e) {
                this.error("Input-Output Exception: " + e.getMessage());
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
            return counter;
        }
    }

    private static abstract class CopyEngine
    extends FTPEngine
    implements FTP.ProgressSink {
        private long startTime = System.currentTimeMillis();
        private long curFileLen = 0L;
        private long curFileDone = 0L;
        private long secDone = 0L;
        protected WifiManager.WifiLock wifiLock;
        protected String progressMessage = null;

        CopyEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, boolean active, Charset cs) {
            super(ctx_, crd_, uri_, active, cs);
            WifiManager manager = (WifiManager)this.ctx.getSystemService("wifi");
            this.wifiLock = manager.createWifiLock(Build.VERSION.SDK_INT >= 12 ? 3 : 1, this.TAG);
            this.wifiLock.setReferenceCounted(false);
        }

        protected void setCurFileLength(long len) {
            this.curFileDone = 0L;
            this.curFileLen = len;
        }

        public boolean completed(long size, boolean done) throws InterruptedException {
            if (this.curFileLen > 0L) {
                this.curFileDone += size;
                this.secDone += size;
                long cur_time = System.currentTimeMillis();
                long time_delta = cur_time - this.startTime;
                if (done || time_delta > 1000L) {
                    int speed = (int)(1000L * this.secDone / time_delta);
                    this.sendProgress(this.progressMessage, (int)(this.curFileDone * 100L / this.curFileLen), -1, speed);
                    this.startTime = cur_time;
                    this.secDone = 0L;
                }
            }
            if (this.isStopReq()) {
                this.error(this.ctx.getString(2131361990));
                return false;
            }
            Thread.sleep(1L);
            return true;
        }
    }

    private static abstract class FTPEngine
    extends Engine {
        protected Context ctx;
        protected FTPAdapter.FTPCredentials crd;
        protected FTP ftp;
        protected Uri uri;

        FTPEngine(Context ctx_, FTPAdapter.FTPCredentials crd_, Uri uri_, boolean active, Charset cs) {
            this.ctx = ctx_;
            this.crd = crd_;
            this.uri = uri_;
            if (this.crd == null) {
                this.crd = new FTPAdapter.FTPCredentials(this.uri.getUserInfo());
            }
            this.ftp = new FTP();
            this.ftp.setActiveMode(active);
            this.ftp.setCharset(cs);
        }
    }
}

