/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.os.StatFs;
import android.provider.MediaStore;
import android.text.format.Formatter;
import android.util.Log;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Date;

public final class FSEngines {
    private static final String TAG = "FSEngines";

    public static class CopyEngine
    extends CalcSizesEngine {
        private String mDest;
        private int counter = 0;
        private long totalBytes = 0L;
        private double conv;
        private File[] fList = null;
        private boolean move;
        private boolean del_src_dir;
        private boolean destIsFullName;
        private byte[] buf;
        private static final int BUFSZ = 524288;
        private PowerManager.WakeLock wakeLock;
        private ArrayList<String> to_scan;

        CopyEngine(CommanderAdapterBase cab, File[] list, String dest, int move_mode, boolean dest_is_full_name) {
            super(cab, null);
            this.setName(".CopyEngine");
            this.fList = list;
            this.mDest = dest;
            this.move = (move_mode & 1) != 0;
            this.del_src_dir = (move_mode & 2) != 0;
            this.destIsFullName = dest_is_full_name;
            this.buf = new byte[524288];
            PowerManager pm = (PowerManager)cab.ctx.getSystemService("power");
            this.wakeLock = pm.newWakeLock(1, this.TAG);
            if (Build.VERSION.SDK_INT >= 8) {
                this.to_scan = new ArrayList();
            }
        }

        public void run() {
            this.sendProgress(this.cab.ctx.getString(2131361976), 0, 0);
            try {
                int l = this.fList.length;
                FileItem[] x_list = new FileItem[l];
                File src_dir_f = null;
                boolean in_same_src = true;
                for (int j = 0; j < l; ++j) {
                    x_list[j] = new FileItem(this.fList[j]);
                    if (!in_same_src) continue;
                    File parent_f = this.fList[j].getParentFile();
                    if (src_dir_f == null) {
                        src_dir_f = parent_f;
                        continue;
                    }
                    in_same_src = src_dir_f.equals(parent_f);
                }
                this.wakeLock.acquire();
                long sum = this.getSizes(x_list);
                this.conv = 100.0 / (double)sum;
                int num = this.copyFiles(this.fList, this.mDest, this.destIsFullName);
                if (this.del_src_dir && in_same_src && src_dir_f != null) {
                    File[] to_delete = new File[]{src_dir_f};
                    DeleteEngine de = new DeleteEngine(this.cab, to_delete);
                    de.start();
                }
                this.wakeLock.release();
                String report = Utils.getOpReport(this.cab.ctx, num, this.move && !this.del_src_dir ? 2131362005 : 2131362004);
                this.sendResult(report);
                if (this.to_scan != null && this.to_scan.size() > 0) {
                    String[] to_scan_a = new String[this.to_scan.size()];
                    this.to_scan.toArray(to_scan_a);
                    ForwardCompat.scanMedia(this.cab.ctx, to_scan_a);
                }
            }
            catch (Exception e) {
                this.sendProgress(e.getMessage(), -7);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final int copyFiles(File[] list, String dest, boolean dest_is_full_name) throws InterruptedException {
            file = null;
            i = 0;
            while (i < list.length) {
                block75: {
                    existed = false;
                    is = null;
                    os = null;
                    outFile = null;
                    file = list[i];
                    if (file == null) {
                        this.error(this.cab.ctx.getString(2131361992));
                        return this.counter;
                    }
                    uri = file.getAbsolutePath();
                    try {
                        block82: {
                            block87: {
                                block83: {
                                    block85: {
                                        block86: {
                                            block84: {
                                                block77: {
                                                    block81: {
                                                        block80: {
                                                            block79: {
                                                                block78: {
                                                                    block76: {
                                                                        if (!this.isStopReq()) break block76;
                                                                        this.error(this.cab.ctx.getString(2131361990));
                                                                        var32_38 = null;
                                                                        ** GOTO lbl-1000
                                                                    }
                                                                    last_modified = file.lastModified();
                                                                    fn = file.getName();
                                                                    outFile = dest_is_full_name != false ? new File(dest) : new File(dest, fn);
                                                                    out_dir_path = new File(dest).getCanonicalPath();
                                                                    if (!file.isDirectory()) break block77;
                                                                    if (!out_dir_path.startsWith(file.getCanonicalPath())) break block78;
                                                                    this.error(this.cab.ctx.getString(2131361973, new Object[]{file.getName()}));
                                                                    ** GOTO lbl280
                                                                }
                                                                if (this.depth++ <= 40) break block79;
                                                                this.error(this.cab.ctx.getString(2131361974));
                                                                ** GOTO lbl298
                                                            }
                                                            if (!outFile.exists() && !outFile.mkdir()) break block80;
                                                            this.copyFiles(file.listFiles(), outFile.getAbsolutePath(), false);
                                                            if (this.errMsg == null) break block81;
                                                            ** GOTO lbl316
                                                        }
                                                        this.error(this.cab.ctx.getString(2131361993, new Object[]{outFile.getAbsolutePath()}));
                                                    }
                                                    --this.depth;
                                                    ++this.counter;
                                                    break block82;
                                                }
                                                existed = outFile.exists();
                                                if (!existed) break block83;
                                                res = this.askOnFileExist(this.cab.ctx.getString(2131361995, new Object[]{outFile.getAbsolutePath()}), this.cab.commander);
                                                if (res != 4) break block84;
                                                ** GOTO lbl334
                                            }
                                            if (res != 2) break block85;
                                            if (!outFile.equals(file)) break block86;
                                            ** GOTO lbl350
                                        }
                                        outFile.delete();
                                    }
                                    if (res != 1) break block83;
                                    ** GOTO lbl366
                                }
                                if (!this.move) break block87;
                                len = file.length();
                                if (!file.renameTo(outFile)) break block87;
                                ++this.counter;
                                this.totalBytes += len;
                                so_far = (int)((double)this.totalBytes * this.conv);
                                this.sendProgress(outFile.getName() + " " + this.cab.ctx.getString(2131362005), so_far, 0);
                                ** GOTO lbl384
                            }
                            is = new FileInputStream(file);
                            os = new FileOutputStream(outFile);
                            copied = 0L;
                            size = file.length();
                            start_time = 0L;
                            speed = 0;
                            so_far = (int)((double)this.totalBytes * this.conv);
                            sz_s = Utils.getHumanSize(size);
                            fnl = fn.length();
                            rep_s = this.cab.ctx.getString(2131361977, new Object[]{fnl > 36 ? "\u2026" + fn.substring(fnl - 36) : fn});
                            n = 0;
                            nn = 0L;
                            while (true) {
                                block88: {
                                    if (nn == 0L) {
                                        start_time = System.currentTimeMillis();
                                        this.sendProgress(rep_s + this.sizeOfsize(copied, sz_s), so_far, (int)((double)this.totalBytes * this.conv), speed);
                                    }
                                    if ((n = is.read(this.buf)) < 0) {
                                        time_delta = System.currentTimeMillis() - start_time;
                                        if (time_delta <= 0L) break;
                                        speed = (int)(1000L * nn / time_delta);
                                        this.sendProgress(rep_s + this.sizeOfsize(copied, sz_s), so_far, (int)((double)this.totalBytes * this.conv), speed);
                                        break;
                                    }
                                    os.write(this.buf, 0, n);
                                    nn += (long)n;
                                    copied += (long)n;
                                    this.totalBytes += (long)n;
                                    if (!this.isStopReq()) break block88;
                                    Log.d((String)this.TAG, (String)"Interrupted!");
                                    this.error(this.cab.ctx.getString(2131361990));
                                    time_delta = this.counter;
                                    ** GOTO lbl400
                                }
                                time_delta = System.currentTimeMillis() - start_time;
                                if (time_delta <= 1000L) continue;
                                speed = (int)(1000L * nn / time_delta);
                                nn = 0L;
                            }
                            is.close();
                            os.close();
                            is = null;
                            os = null;
                            if (i >= list.length - 1) {
                                this.sendProgress(this.cab.ctx.getString(2131361978, new Object[]{fn}) + this.sizeOfsize(copied, sz_s), (int)((double)this.totalBytes * this.conv));
                            }
                            if (this.to_scan != null && (mime = Utils.getMimeByExt(ext = Utils.getFileExt(outFile.getName()))) != null && (mime.startsWith("image/") || mime.startsWith("audio/") || mime.startsWith("video/"))) {
                                this.to_scan.add(outFile.getAbsolutePath());
                            }
                            ++this.counter;
                        }
                        if (this.move) {
                            file.delete();
                        }
                        outFile.setLastModified(last_modified);
                        GINGERBREAD = 9;
                        if (Build.VERSION.SDK_INT >= 9) {
                            ForwardCompat.setFullPermissions(outFile);
                        }
                        ** GOTO lbl418
                    }
                    catch (SecurityException e) {
                        Log.e((String)this.TAG, (String)"", (Throwable)e);
                        this.error(this.cab.ctx.getString(2131361996, new Object[]{e.getMessage()}));
                        var32_38 = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                            if (os != null) {
                                os.close();
                            }
                            if (!this.move && this.errMsg != null && outFile != null && !existed) {
                                Log.i((String)this.TAG, (String)"Deleting failed output file");
                                outFile.delete();
                            }
                        }
                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                        }
                        break block75;
                    }
                    catch (FileNotFoundException e) {
                        Log.e((String)this.TAG, (String)"", (Throwable)e);
                        this.error(this.cab.ctx.getString(2131361997, new Object[]{e.getMessage()}));
                        var32_38 = null;
                        ** try [egrp 2[TRYBLOCK] [66 : 1416->1479)] { 
lbl165:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (!this.move && this.errMsg != null && outFile != null && !existed) {
                            Log.i((String)this.TAG, (String)"Deleting failed output file");
                            outFile.delete();
                        }
                        break block75;
lbl176:
                        // 1 sources

                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                        }
                        break block75;
                    }
                    catch (ClosedByInterruptException e) {
                        Log.e((String)this.TAG, (String)"", (Throwable)e);
                        this.error(this.cab.ctx.getString(2131361990));
                        var32_38 = null;
                        ** try [egrp 2[TRYBLOCK] [66 : 1416->1479)] { 
lbl186:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (!this.move && this.errMsg != null && outFile != null && !existed) {
                            Log.i((String)this.TAG, (String)"Deleting failed output file");
                            outFile.delete();
                        }
                        break block75;
lbl197:
                        // 1 sources

                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                        }
                        break block75;
                    }
                    catch (IOException e) {
                        Log.e((String)this.TAG, (String)"", (Throwable)e);
                        msg = e.getMessage();
                        this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, msg != null ? msg : ""}));
                        var32_38 = null;
                        ** try [egrp 2[TRYBLOCK] [66 : 1416->1479)] { 
lbl208:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (!this.move && this.errMsg != null && outFile != null && !existed) {
                            Log.i((String)this.TAG, (String)"Deleting failed output file");
                            outFile.delete();
                        }
                        break block75;
lbl219:
                        // 1 sources

                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                        }
                        break block75;
                    }
                    catch (RuntimeException e) {
                        Log.e((String)this.TAG, (String)"", (Throwable)e);
                        this.error(this.cab.ctx.getString(2131361999, new Object[]{uri, e.getMessage()}));
                        var32_38 = null;
                        ** try [egrp 2[TRYBLOCK] [66 : 1416->1479)] { 
lbl229:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (!this.move && this.errMsg != null && outFile != null && !existed) {
                            Log.i((String)this.TAG, (String)"Deleting failed output file");
                            outFile.delete();
                        }
                        break block75;
lbl240:
                        // 1 sources

                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                        }
                        break block75;
                    }
                    {
                        catch (Throwable var31_40) {
                            var32_38 = null;
                            ** try [egrp 2[TRYBLOCK] [66 : 1416->1479)] { 
lbl247:
                            // 1 sources

                            if (is != null) {
                                is.close();
                            }
                            if (os != null) {
                                os.close();
                            }
                            if (this.move != false) throw var31_40;
                            if (this.errMsg == null) throw var31_40;
                            if (outFile == null) throw var31_40;
                            if (existed != false) throw var31_40;
                            Log.i((String)this.TAG, (String)"Deleting failed output file");
                            outFile.delete();
                            throw var31_40;
lbl260:
                            // 1 sources

                            catch (IOException e) {
                                this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                            }
                            throw var31_40;
                        }
lbl-1000:
                        // 1 sources

                        try {}
                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (this.move != false) return this.counter;
                        if (this.errMsg == null) return this.counter;
                        if (outFile == null) return this.counter;
                        if (existed != false) return this.counter;
                        Log.i((String)this.TAG, (String)"Deleting failed output file");
                        outFile.delete();
                        return this.counter;
lbl280:
                        // 1 sources

                        var32_38 = null;
                        try {}
                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (this.move != false) return this.counter;
                        if (this.errMsg == null) return this.counter;
                        if (outFile == null) return this.counter;
                        if (existed != false) return this.counter;
                        Log.i((String)this.TAG, (String)"Deleting failed output file");
                        outFile.delete();
                        return this.counter;
lbl298:
                        // 1 sources

                        var32_38 = null;
                        try {}
                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (this.move != false) return this.counter;
                        if (this.errMsg == null) return this.counter;
                        if (outFile == null) return this.counter;
                        if (existed != false) return this.counter;
                        Log.i((String)this.TAG, (String)"Deleting failed output file");
                        outFile.delete();
                        return this.counter;
lbl316:
                        // 1 sources

                        var32_38 = null;
                        try {}
                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (this.move != false) return this.counter;
                        if (this.errMsg == null) return this.counter;
                        if (outFile == null) return this.counter;
                        if (existed != false) return this.counter;
                        Log.i((String)this.TAG, (String)"Deleting failed output file");
                        outFile.delete();
                        return this.counter;
lbl334:
                        // 1 sources

                        var32_38 = null;
                        ** try [egrp 2[TRYBLOCK] [66 : 1416->1479)] { 
lbl336:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (!this.move && this.errMsg != null && outFile != null && !existed) {
                            Log.i((String)this.TAG, (String)"Deleting failed output file");
                            outFile.delete();
                        }
lbl347:
                        // 1 sources

                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                        }
lbl350:
                        // 1 sources

                        var32_38 = null;
                        ** try [egrp 2[TRYBLOCK] [66 : 1416->1479)] { 
lbl352:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (!this.move && this.errMsg != null && outFile != null && !existed) {
                            Log.i((String)this.TAG, (String)"Deleting failed output file");
                            outFile.delete();
                        }
lbl363:
                        // 1 sources

                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                        }
lbl366:
                        // 1 sources

                        var32_38 = null;
                        try {}
                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                            return this.counter;
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (this.move != false) return this.counter;
                        if (this.errMsg == null) return this.counter;
                        if (outFile == null) return this.counter;
                        if (existed != false) return this.counter;
                        Log.i((String)this.TAG, (String)"Deleting failed output file");
                        outFile.delete();
                        return this.counter;
lbl384:
                        // 1 sources

                        var32_38 = null;
                        ** try [egrp 2[TRYBLOCK] [66 : 1416->1479)] { 
lbl386:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (!this.move && this.errMsg != null && outFile != null && !existed) {
                            Log.i((String)this.TAG, (String)"Deleting failed output file");
                            outFile.delete();
                        }
lbl397:
                        // 1 sources

                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                        }
lbl400:
                        // 1 sources

                        var32_38 = null;
                        ** try [egrp 2[TRYBLOCK] [66 : 1416->1479)] { 
lbl402:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (this.move != false) return time_delta;
                        if (this.errMsg == null) return time_delta;
                        if (outFile == null) return time_delta;
                        if (existed != false) return time_delta;
                        Log.i((String)this.TAG, (String)"Deleting failed output file");
                        outFile.delete();
                        return time_delta;
lbl415:
                        // 1 sources

                        catch (IOException e) {
                            this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                        }
                        return time_delta;
lbl418:
                        // 1 sources

                        var32_38 = null;
                        ** try [egrp 2[TRYBLOCK] [66 : 1416->1479)] { 
lbl420:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (!this.move && this.errMsg != null && outFile != null && !existed) {
                            Log.i((String)this.TAG, (String)"Deleting failed output file");
                            outFile.delete();
                        }
lbl431:
                        // 1 sources

                        catch (IOException e) {}
                        this.error(this.cab.ctx.getString(2131361998, new Object[]{uri, e.getMessage()}));
                    }
                }
                ++i;
            }
            return this.counter;
        }
    }

    public static class DeleteEngine
    extends Engine {
        private CommanderAdapterBase cab;
        private File[] mList;

        DeleteEngine(CommanderAdapterBase cab, FileItem[] list) {
            this(cab, new File[list.length]);
            for (int i = 0; i < list.length; ++i) {
                this.mList[i] = list[i].f();
            }
        }

        DeleteEngine(CommanderAdapterBase cab, File[] list) {
            this.setName(".DeleteEngine");
            this.cab = cab;
            this.mList = list;
        }

        public void run() {
            try {
                this.cab.Init(null);
                int cnt = this.deleteFiles(this.mList);
                this.sendResult(Utils.getOpReport(this.cab.ctx, cnt, 2131362006));
            }
            catch (Exception e) {
                this.sendProgress(e.getMessage(), -7);
            }
        }

        private final int deleteFiles(File[] l) throws Exception {
            if (l == null) {
                return 0;
            }
            int cnt = 0;
            int num = l.length;
            double conv = 100.0 / (double)num;
            for (int i = 0; i < num; ++i) {
                DeleteEngine.sleep(1L);
                if (this.isStopReq()) {
                    throw new Exception(this.cab.s(2131361990));
                }
                File f = l[i];
                this.sendProgress(this.cab.ctx.getString(2131361979, new Object[]{f.getName()}), (int)((double)cnt * conv));
                if (f.isDirectory()) {
                    cnt += this.deleteFiles(f.listFiles());
                }
                if (f.delete()) {
                    ++cnt;
                } else {
                    this.error(this.cab.ctx.getString(2131362002, new Object[]{f.getName()}));
                    break;
                }
                String ext = Utils.getFileExt(f.getName());
                String mime = Utils.getMimeByExt(ext);
                if (mime == null) continue;
                Uri content_uri = null;
                if (mime.startsWith("image/")) {
                    content_uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                }
                if (mime.startsWith("audio/")) {
                    content_uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                if (mime.startsWith("video/")) {
                    content_uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                }
                if (content_uri == null) continue;
                ContentResolver cr = this.cab.ctx.getContentResolver();
                cr.delete(content_uri, "_data=?", new String[]{f.getAbsolutePath()});
            }
            return cnt;
        }
    }

    public static class AskEngine
    extends Engine {
        private FSAdapter fsa;
        private String msg;
        private File from;
        private File to;

        AskEngine(FSAdapter fsa, Handler h_, String msg_, File from_, File to_) {
            super.setHandler(h_);
            this.fsa = fsa;
            this.msg = msg_;
            this.from = from_;
            this.to = to_;
        }

        public void run() {
            try {
                int resolution = this.askOnFileExist(this.msg, this.fsa.commander);
                if ((resolution & 2) != 0 && this.to.delete() && this.from.renameTo(this.to)) {
                    this.sendResult("ok");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static class CalcSizesEngine
    extends Engine {
        private FileItem[] mList;
        protected CommanderAdapterBase cab;
        protected int num = 0;
        protected int dirs = 0;
        protected int depth = 0;

        CalcSizesEngine(CommanderAdapterBase cab, FileItem[] list) {
            this.cab = cab;
            this.mList = list;
            this.setName(".CalcSizesEngine");
        }

        public void run() {
            try {
                this.cab.Init(null);
                Context c = this.cab.ctx;
                StringBuffer result = new StringBuffer();
                if (this.mList != null && this.mList.length > 0) {
                    FileItem item;
                    this.sendProgress();
                    long sum = this.getSizes(this.mList);
                    if (sum < 0L) {
                        this.sendProgress("Interrupted", -2);
                        return;
                    }
                    if ((this.cab.mode & 0x30) == 16) {
                        this.cab.reSort();
                    }
                    if (this.mList.length == 1) {
                        item = this.mList[0];
                        if (item.dir) {
                            result.append(c.getString(2131362024, new Object[]{item.name, this.num}));
                            if (this.dirs > 0) {
                                result.append(c.getString(2131362025, new Object[]{this.dirs, this.dirs > 1 ? c.getString(2131362027) : c.getString(2131362026)}));
                            }
                        } else {
                            result.append(c.getString(2131362028, new Object[]{item.name}));
                        }
                    } else {
                        result.append(c.getString(2131362029, new Object[]{this.num}));
                    }
                    if (sum > 0L) {
                        result.append(c.getString(2131362030, new Object[]{Formatter.formatFileSize((Context)this.cab.ctx, (long)sum).trim()}));
                    }
                    if (sum > 1024L) {
                        result.append(c.getString(2131362031, new Object[]{sum}));
                    }
                    if (this.mList.length == 1) {
                        item = this.mList[0];
                        result.append(c.getString(2131362032));
                        result.append("&#xA0;");
                        String date_s = Utils.formatDate(item.date, this.cab.ctx);
                        result.append(date_s);
                        File f = item.f();
                        if (f.isFile()) {
                            String[] hashes;
                            String ext = Utils.getFileExt(item.name);
                            String mime = Utils.getMimeByExt(ext);
                            result.append("\n");
                            if (mime != null && !"*/*".equals(mime)) {
                                result.append("\n<b>MIME:</b>\n&#xA0;<small>" + mime + "</small>");
                            }
                            if ((hashes = Utils.getHash(f, new String[]{"MD5", "SHA-1"})) != null) {
                                result.append("\n<b>MD5:</b>\n&#xA0;<small>" + hashes[0] + "</small>");
                                result.append("\n<b>SHA-1:</b>\n&#xA0;<small>" + hashes[1] + "</small>");
                            }
                        }
                    }
                    result.append("\n\n<hr/>");
                }
                StatFs stat = new StatFs(this.cab.toString());
                long block_size = stat.getBlockSize();
                result.append(c.getString(2131362033, new Object[]{Formatter.formatFileSize((Context)this.cab.ctx, (long)((long)stat.getBlockCount() * block_size)), Formatter.formatFileSize((Context)this.cab.ctx, (long)((long)stat.getAvailableBlocks() * block_size))}));
                String str = result.toString();
                this.sendReport(str);
            }
            catch (Exception e) {
                this.sendProgress(e.getMessage(), -2);
            }
        }

        protected final long getSizes(FileItem[] list) throws Exception {
            long count = 0L;
            for (int i = 0; i < list.length; ++i) {
                if (this.isStopReq()) {
                    return -1L;
                }
                FileItem f = list[i];
                if (f.dir) {
                    ++this.dirs;
                    if (this.depth++ > 20) {
                        throw new Exception(this.cab.s(2131361974));
                    }
                    File[] subfiles = f.f().listFiles();
                    if (subfiles != null) {
                        int l = subfiles.length;
                        FileItem[] subfiles_ex = new FileItem[l];
                        for (int j = 0; j < l; ++j) {
                            subfiles_ex[j] = new FileItem(subfiles[j]);
                        }
                        long sz = this.getSizes(subfiles_ex);
                        if (sz < 0L) {
                            return -1L;
                        }
                        f.size = sz;
                        count += f.size;
                    }
                    --this.depth;
                    continue;
                }
                ++this.num;
                count += f.size;
            }
            return count;
        }
    }

    public static class FileItem
    extends CommanderAdapter.Item {
        public FileItem(String name) {
            this(new File(name));
        }

        public FileItem(File f) {
            this.origin = f;
            this.dir = f.isDirectory();
            if (this.dir) {
                this.name = File.separator + f.getName();
            } else {
                this.name = f.getName();
                this.size = f.length();
            }
            long msFileDate = f.lastModified();
            if (msFileDate != 0L) {
                this.date = new Date(msFileDate);
            }
        }

        public final File f() {
            return this.origin != null ? (File)this.origin : null;
        }
    }
}

