/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.widget.AdapterView;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.FSEngines;
import com.ghostsq.commander.adapters.ItemComparator;
import com.ghostsq.commander.adapters.MediaScanEngine;
import com.ghostsq.commander.adapters.ThumbnailsThread;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;

public class FSAdapter
extends CommanderAdapterBase
implements Engines.IReciever {
    private static final String TAG = "FSAdapter";
    private String dirName = null;
    protected FSEngines.FileItem[] items = null;
    ThumbnailsThread tht = null;

    public FSAdapter(Context ctx_) {
        super(ctx_);
    }

    public String getScheme() {
        return "";
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case FS: 
            case LOCAL: 
            case REAL: 
            case SF4: 
            case SEARCH: 
            case SEND: {
                return true;
            }
        }
        return super.hasFeature(feature);
    }

    public String toString() {
        return Utils.mbAddSl(this.dirName);
    }

    public Uri getUri() {
        try {
            return Uri.parse((String)Utils.escapePath(this.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setUri(Uri uri) {
        this.dirName = Utils.mbAddSl(uri.toString());
    }

    public boolean readSource(Uri d, String pass_back_on_done) {
        try {
            File dir;
            String dir_name;
            File[] files_;
            block5: {
                String parent_path;
                files_ = null;
                dir_name = null;
                dir = null;
                String err_msg = null;
                do {
                    if ((dir_name = d != null ? d.getPath() : this.dirName) == null) {
                        this.notify(this.s(2131361960) + ": " + (d == null ? "null" : d.toString()), -2);
                        Log.e((String)TAG, (String)"Unable to obtain folder of the folder name");
                        return false;
                    }
                    dir = new File(dir_name);
                    files_ = dir.listFiles();
                    if (files_ != null) break block5;
                    if (err_msg != null) continue;
                    err_msg = this.ctx.getString(2131362183, new Object[]{dir_name});
                } while (dir != null && (parent_path = dir.getParent()) != null && (d = Uri.parse((String)parent_path)) != null);
                this.notify(this.s(2131361960), -2);
                Log.e((String)TAG, (String)("Wrong folder '" + dir_name + "'"));
                return false;
            }
            this.dirName = dir_name;
            this.items = this.filesToItems(files_);
            this.parentLink = dir.getParent() == null ? SLS : "..";
            this.notifyDataSetChanged();
            this.startThumbnailCreation();
            this.notify(pass_back_on_done);
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"readSource() excception", (Throwable)e);
        }
        catch (OutOfMemoryError err) {
            Log.e((String)TAG, (String)"Out Of Memory", (Throwable)err);
            this.notify(this.s(2131361991), -2);
        }
        return false;
    }

    protected void startThumbnailCreation() {
        if (this.thumbnail_size_perc > 0) {
            if (this.tht != null) {
                this.tht.interrupt();
            }
            this.tht = new ThumbnailsThread(this, new Handler(){

                public void handleMessage(Message msg) {
                    FSAdapter.this.notifyDataSetChanged();
                }
            }, this.dirName, this.items);
            this.tht.start();
        }
    }

    protected FSEngines.FileItem[] filesToItems(File[] files_) {
        boolean hide;
        int num_files;
        int num = num_files = files_.length;
        boolean bl = hide = (this.mode & 8) == 8;
        if (hide) {
            int cnt = 0;
            for (int i = 0; i < num_files; ++i) {
                if (files_[i].isHidden()) continue;
                ++cnt;
            }
            num = cnt;
        }
        FSEngines.FileItem[] items_ = new FSEngines.FileItem[num];
        int j = 0;
        for (int i = 0; i < num_files; ++i) {
            if (hide && files_[i].isHidden()) continue;
            FSEngines.FileItem file_ex = new FSEngines.FileItem(files_[i]);
            items_[j++] = file_ex;
        }
        this.reSort(items_);
        return items_;
    }

    public void populateContextMenu(ContextMenu menu2, AdapterView.AdapterContextMenuInfo acmi, int num) {
        try {
            if (acmi.position != 0) {
                CommanderAdapter.Item item = (CommanderAdapter.Item)this.getItem(acmi.position);
                if (!item.dir && ".zip".equals(Utils.getFileExt(item.name))) {
                    menu2.add(0, 2131230756, 0, 2131361897);
                    menu2.add(0, 2131230757, 0, 2131361902);
                }
                if (item.dir && num == 1 && Build.VERSION.SDK_INT >= 8) {
                    menu2.add(0, 2131230759, 0, 2131361837);
                }
            }
            super.populateContextMenu(menu2, acmi, num);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
    }

    public void doIt(int command_id, SparseBooleanArray cis) {
        if (2131230759 == command_id) {
            FSEngines.FileItem[] list = this.bitsToFilesEx(cis);
            if (list == null || list.length == 0) {
                return;
            }
            MediaScanEngine mse = new MediaScanEngine(this.ctx, list[0].f().getAbsoluteFile(), false);
            mse.setHandler(new CommanderAdapterBase.SimpleHandler());
            this.commander.startEngine(mse);
        }
    }

    public void openItem(int position) {
        if (position == 0) {
            if (this.parentLink == SLS) {
                this.commander.Navigate(Uri.parse((String)"home:"), null, null);
            } else {
                if (this.dirName == null) {
                    return;
                }
                File cur_dir_file = new File(this.dirName);
                String parent_dir = cur_dir_file.getParent();
                this.commander.Navigate(Uri.parse((String)Utils.escapePath(parent_dir != null ? parent_dir : DEFAULT_DIR)), null, cur_dir_file.getName());
            }
        } else {
            File file = this.items[position - 1].f();
            if (file == null) {
                return;
            }
            Uri open_uri = Uri.parse((String)Utils.escapePath(file.getAbsolutePath()));
            if (file.isDirectory()) {
                this.commander.Navigate(open_uri, null, null);
            } else {
                this.commander.Open(open_uri, null);
            }
        }
    }

    public Uri getItemUri(int position) {
        try {
            String item_name = this.getItemName(position, true);
            return Uri.parse((String)Utils.escapePath(item_name));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("No item in the position " + position));
            return null;
        }
    }

    public String getItemName(int position, boolean full) {
        if (position < 0 || this.items == null || position > this.items.length) {
            return position == 0 ? this.parentLink : null;
        }
        if (full) {
            return position == 0 ? new File(this.dirName).getParent() : this.items[position - 1].f().getAbsolutePath();
        }
        if (position == 0) {
            return this.parentLink;
        }
        String name = this.items[position - 1].name;
        if (name != null) {
            return name.replace("/", "");
        }
        return null;
    }

    public void reqItemsSize(SparseBooleanArray cis) {
        try {
            FSEngines.FileItem[] list = this.bitsToFilesEx(cis);
            this.notify(-1);
            this.commander.startEngine(new FSEngines.CalcSizesEngine(this, list));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean renameItem(int position, String newName, boolean copy) {
        if (position <= 0) return false;
        if (position > this.items.length) {
            return false;
        }
        try {
            if (copy) {
                String dest_name;
                this.notify(-1);
                File[] list = new File[]{this.items[position - 1].f()};
                if (newName.indexOf(SLC) < 0) {
                    dest_name = this.dirName;
                    if (dest_name.charAt(dest_name.length() - 1) != SLC) {
                        dest_name = dest_name + SLS;
                    }
                    dest_name = dest_name + newName;
                } else {
                    dest_name = newName;
                }
                this.commander.startEngine(new FSEngines.CopyEngine(this, list, dest_name, 0, true));
                return true;
            }
            boolean ok = false;
            File f = this.items[position - 1].f();
            File new_file = new File(this.dirName, newName);
            if (new_file.exists()) {
                String new_ap;
                if (f.equals(new_file)) {
                    this.commander.showError(this.s(2131361956));
                    return false;
                }
                String old_ap = f.getAbsolutePath();
                if (!old_ap.equalsIgnoreCase(new_ap = new_file.getAbsolutePath())) {
                    FSEngines.AskEngine ae = new FSEngines.AskEngine(this, this.simpleHandler, this.ctx.getString(2131361995, new Object[]{newName}), f, new_file);
                    this.commander.startEngine(ae);
                    return true;
                }
                File tmp_file = new File(this.dirName, newName + "_TMP_");
                ok = f.renameTo(tmp_file);
                ok = tmp_file.renameTo(new_file);
            } else {
                ok = f.renameTo(new_file);
            }
            if (ok) {
                this.notifyRefr(newName);
                return ok;
            }
            this.notify(this.s(2131362040), -2);
            return ok;
        }
        catch (SecurityException e) {
            this.commander.showError(this.ctx.getString(2131361996, new Object[]{e.getMessage()}));
            return false;
        }
    }

    public CommanderAdapter.Item getItem(Uri u) {
        try {
            File f = new File(u.getPath());
            if (f.exists()) {
                CommanderAdapter.Item item = new CommanderAdapter.Item(f.getName());
                item.size = f.length();
                item.date = new Date(f.lastModified());
                item.dir = f.isDirectory();
                return item;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream getContent(Uri u, long skip) {
        try {
            String path = u.getPath();
            File f = new File(path);
            if (f.exists() && f.isFile()) {
                FileInputStream fis = new FileInputStream(f);
                if (skip > 0L) {
                    fis.skip(skip);
                }
                return fis;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public OutputStream saveContent(Uri u) {
        if (u != null) {
            File f = new File(u.getPath());
            try {
                return new FileOutputStream(f);
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)u.getPath(), (Throwable)e);
            }
        }
        return null;
    }

    public boolean createFile(String fileURI) {
        try {
            File f = new File(fileURI);
            boolean ok = f.createNewFile();
            this.notify(null, ok ? -4 : -2);
            return ok;
        }
        catch (Exception e) {
            this.commander.showError(this.ctx.getString(2131362001, new Object[]{fileURI, e.getMessage()}));
            return false;
        }
    }

    public void createFolder(String new_name) {
        try {
            if (new File(this.dirName, new_name).mkdir()) {
                this.notifyRefr(new_name);
                return;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"createFolder", (Throwable)e);
        }
        this.notify(this.ctx.getString(2131361993, new Object[]{new_name}), -2);
    }

    public boolean deleteItems(SparseBooleanArray cis) {
        try {
            FSEngines.FileItem[] list = this.bitsToFilesEx(cis);
            if (list != null) {
                this.notify(-1);
                this.commander.startEngine(new FSEngines.DeleteEngine((CommanderAdapterBase)this, list));
            }
        }
        catch (Exception e) {
            this.notify(e.getMessage(), -2);
        }
        return false;
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        boolean ok = to.receiveItems(this.bitsToNames(cis), move ? 1 : 0);
        if (!ok) {
            this.notify(-2);
        }
        return ok;
    }

    public boolean receiveItems(String[] uris, int move_mode) {
        try {
            if (uris == null || uris.length == 0) {
                return false;
            }
            File dest_file = new File(this.dirName);
            if (dest_file.exists() ? !dest_file.isDirectory() : !dest_file.mkdirs()) {
                return false;
            }
            File[] list = Utils.getListOfFiles(uris);
            if (list != null) {
                this.notify(-1);
                this.commander.startEngine(new FSEngines.CopyEngine(this, list, this.dirName, move_mode, false));
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void prepareToDestroy() {
        super.prepareToDestroy();
        if (this.tht != null) {
            this.tht.interrupt();
        }
        this.items = null;
    }

    private final FSEngines.FileItem[] bitsToFilesEx(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i) || cis.keyAt(i) <= 0) continue;
                ++counter;
            }
            FSEngines.FileItem[] res = new FSEngines.FileItem[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                int k;
                if (!cis.valueAt(i) || (k = cis.keyAt(i)) <= 0) continue;
                res[j++] = this.items[k - 1];
            }
            return res;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"bitsToFilesEx()", (Throwable)e);
            return null;
        }
    }

    public final File[] bitsToFiles(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i) || cis.keyAt(i) <= 0) continue;
                ++counter;
            }
            File[] res = new File[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                int k;
                if (!cis.valueAt(i) || (k = cis.keyAt(i)) <= 0) continue;
                res[j++] = this.items[k - 1].f();
            }
            return res;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"bitsToFiles()", (Throwable)e);
            return null;
        }
    }

    protected int getPredictedAttributesLength() {
        return 10;
    }

    public int getCount() {
        if (this.items == null) {
            return 1;
        }
        return this.items.length + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getItem(int position) {
        CommanderAdapter.Item item = null;
        if (position == 0) {
            item = new CommanderAdapter.Item();
            item.name = this.parentLink;
            item.dir = true;
        } else if (this.items != null && position <= this.items.length) {
            FSEngines.FileItem[] fileItemArray = this.items;
            synchronized (this.items) {
                try {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return this.items[position - 1];
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("getItem(" + position + ")"), (Throwable)e);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
        } else {
            item = new CommanderAdapter.Item();
            item.name = "???";
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reSort() {
        if (this.items == null) {
            return;
        }
        FSEngines.FileItem[] fileItemArray = this.items;
        synchronized (this.items) {
            this.reSort(this.items);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void reSort(FSEngines.FileItem[] items_) {
        if (items_ == null) {
            return;
        }
        ItemComparator comp = new ItemComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
        Arrays.sort(items_, comp);
    }

    public Engines.IReciever getReceiver() {
        return this;
    }
}

