/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.SeekBar;

public class RGBPickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
CompoundButton.OnCheckedChangeListener,
SeekBar.OnSeekBarChangeListener {
    private static final String TAG = "RGB";
    private ResultSink colorChangeSink;
    private int curColor;
    private int defColor;
    private CheckBox dccb;
    private View sliders;
    private SeekBar r_seek;
    private SeekBar g_seek;
    private SeekBar b_seek;
    private View preview;

    RGBPickerDialog(Context context, ResultSink sink, int color2, int def_color) {
        super(context);
        this.colorChangeSink = sink;
        this.curColor = color2;
        this.defColor = def_color;
        Context c = this.getContext();
        this.setTitle(c.getString(2131362149));
        LayoutInflater factory = LayoutInflater.from((Context)c);
        this.setView(factory.inflate(2130903051, null));
        this.setButton(-1, c.getString(2131361916), this);
        this.setButton(-2, c.getString(2131361917), this);
    }

    protected void onCreate(Bundle savedInstanceState) {
        View dcv;
        super.onCreate(savedInstanceState);
        this.sliders = this.findViewById(2131230835);
        this.r_seek = (SeekBar)this.findViewById(2131230838);
        this.r_seek = (SeekBar)this.findViewById(2131230838);
        this.g_seek = (SeekBar)this.findViewById(2131230841);
        this.b_seek = (SeekBar)this.findViewById(2131230844);
        if (this.r_seek != null) {
            this.r_seek.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
            this.r_seek.setProgress(Color.red((int)this.curColor));
        }
        if (this.g_seek != null) {
            this.g_seek.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
            this.g_seek.setProgress(Color.green((int)this.curColor));
        }
        if (this.b_seek != null) {
            this.b_seek.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
            this.b_seek.setProgress(Color.blue((int)this.curColor));
        }
        this.preview = this.findViewById(2131230845);
        if (this.preview != null) {
            this.preview.setBackgroundColor(this.curColor);
        }
        if (this.defColor != 0 && (dcv = this.findViewById(2131230834)) != null) {
            dcv.setVisibility(0);
            this.dccb = (CheckBox)dcv;
            this.dccb.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
            this.dccb.setChecked(this.curColor == 0);
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (isChecked) {
            this.curColor = 0;
            this.sliders.setVisibility(8);
        } else {
            if (this.curColor == 0) {
                this.curColor = this.defColor;
                this.r_seek.setProgress(Color.red((int)this.curColor));
                this.g_seek.setProgress(Color.green((int)this.curColor));
                this.b_seek.setProgress(Color.blue((int)this.curColor));
            }
            this.preview.setBackgroundColor(this.curColor);
            this.sliders.setVisibility(0);
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (!fromUser) {
            return;
        }
        int id2 = seekBar.getId();
        switch (id2) {
            case 2131230838: {
                this.curColor = Color.rgb((int)progress, (int)Color.green((int)this.curColor), (int)Color.blue((int)this.curColor));
                break;
            }
            case 2131230841: {
                this.curColor = Color.rgb((int)Color.red((int)this.curColor), (int)progress, (int)Color.blue((int)this.curColor));
                break;
            }
            case 2131230844: {
                this.curColor = Color.rgb((int)Color.red((int)this.curColor), (int)Color.green((int)this.curColor), (int)progress);
            }
        }
        this.preview.setBackgroundColor(this.curColor);
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1 && this.colorChangeSink != null) {
            this.colorChangeSink.colorChanged(this.curColor);
        }
        this.dismiss();
    }

    public static interface ResultSink {
        public void colorChanged(int var1);
    }
}

